/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.ReaderSlice;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.util.Bits;

final class MultiBits
implements Bits {
    private final Bits[] subs;
    private final int[] starts;
    private final boolean defaultValue;

    public MultiBits(Bits[] subs, int[] starts2, boolean defaultValue) {
        assert (starts2.length == 1 + subs.length);
        this.subs = subs;
        this.starts = starts2;
        this.defaultValue = defaultValue;
    }

    private boolean checkLength(int reader, int doc2) {
        int length2 = this.starts[1 + reader] - this.starts[reader];
        assert (doc2 - this.starts[reader] < length2) : "doc=" + doc2 + " reader=" + reader + " starts[reader]=" + this.starts[reader] + " length=" + length2;
        return true;
    }

    @Override
    public boolean get(int doc2) {
        int reader = ReaderUtil.subIndex(doc2, this.starts);
        assert (reader != -1);
        Bits bits2 = this.subs[reader];
        if (bits2 == null) {
            return this.defaultValue;
        }
        assert (this.checkLength(reader, doc2));
        return bits2.get(doc2 - this.starts[reader]);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.subs.length + " subs: ");
        for (int i = 0; i < this.subs.length; ++i) {
            if (i != 0) {
                b.append("; ");
            }
            if (this.subs[i] == null) {
                b.append("s=" + this.starts[i] + " l=null");
                continue;
            }
            b.append("s=" + this.starts[i] + " l=" + this.subs[i].length() + " b=" + this.subs[i]);
        }
        b.append(" end=" + this.starts[this.subs.length]);
        return b.toString();
    }

    public SubResult getMatchingSub(ReaderSlice slice2) {
        int reader = ReaderUtil.subIndex(slice2.start, this.starts);
        assert (reader != -1);
        assert (reader < this.subs.length) : "slice=" + slice2 + " starts[-1]=" + this.starts[this.starts.length - 1];
        SubResult subResult = new SubResult();
        if (this.starts[reader] == slice2.start && this.starts[1 + reader] == slice2.start + slice2.length) {
            subResult.matches = true;
            subResult.result = this.subs[reader];
        } else {
            subResult.matches = false;
        }
        return subResult;
    }

    @Override
    public int length() {
        return this.starts[this.starts.length - 1];
    }

    public static final class SubResult {
        public boolean matches;
        public Bits result;
    }
}

