/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.List;
import org.apache.lucene.index.FieldTermIterator;
import org.apache.lucene.index.PrefixCodedTerms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

class MergedPrefixCodedTermsIterator
extends FieldTermIterator {
    final TermMergeQueue termQueue;
    final FieldMergeQueue fieldQueue;
    String field;

    public MergedPrefixCodedTermsIterator(List<PrefixCodedTerms> termsList) {
        this.fieldQueue = new FieldMergeQueue(termsList.size());
        for (PrefixCodedTerms terms : termsList) {
            PrefixCodedTerms.TermIterator iter2 = terms.iterator();
            iter2.next();
            if (iter2.field == null) continue;
            this.fieldQueue.add(iter2);
        }
        this.termQueue = new TermMergeQueue(termsList.size());
    }

    @Override
    public BytesRef next() {
        if (this.termQueue.size() == 0) {
            if (this.fieldQueue.size() == 0) {
                this.field = null;
                return null;
            }
            PrefixCodedTerms.TermIterator top = (PrefixCodedTerms.TermIterator)this.fieldQueue.pop();
            this.termQueue.add(top);
            this.field = top.field;
            assert (this.field != null);
            while (this.fieldQueue.size() != 0 && ((PrefixCodedTerms.TermIterator)this.fieldQueue.top()).field.equals(top.field)) {
                PrefixCodedTerms.TermIterator iter2 = (PrefixCodedTerms.TermIterator)this.fieldQueue.pop();
                assert (iter2.field.equals(this.field));
                iter2.field = this.field;
                this.termQueue.add(iter2);
            }
            return ((PrefixCodedTerms.TermIterator)this.termQueue.top()).bytes;
        }
        PrefixCodedTerms.TermIterator top = (PrefixCodedTerms.TermIterator)this.termQueue.top();
        if (top.next() == null) {
            this.termQueue.pop();
        } else if (top.field() != this.field) {
            this.termQueue.pop();
            this.fieldQueue.add(top);
        } else {
            this.termQueue.updateTop();
        }
        if (this.termQueue.size() == 0) {
            return this.next();
        }
        return ((PrefixCodedTerms.TermIterator)this.termQueue.top()).bytes;
    }

    @Override
    public String field() {
        return this.field;
    }

    @Override
    public long delGen() {
        return ((PrefixCodedTerms.TermIterator)this.termQueue.top()).delGen();
    }

    private static class FieldMergeQueue
    extends PriorityQueue<PrefixCodedTerms.TermIterator> {
        FieldMergeQueue(int size2) {
            super(size2);
        }

        @Override
        protected boolean lessThan(PrefixCodedTerms.TermIterator a, PrefixCodedTerms.TermIterator b) {
            return a.field.compareTo(b.field) < 0;
        }
    }

    private static class TermMergeQueue
    extends PriorityQueue<PrefixCodedTerms.TermIterator> {
        TermMergeQueue(int size2) {
            super(size2);
        }

        @Override
        protected boolean lessThan(PrefixCodedTerms.TermIterator a, PrefixCodedTerms.TermIterator b) {
            int cmp = a.bytes.compareTo(b.bytes);
            if (cmp < 0) {
                return true;
            }
            if (cmp > 0) {
                return false;
            }
            return a.delGen() > b.delGen();
        }
    }
}

