/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MultiPostingsEnum;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.util.BytesRef;

final class MappingMultiPostingsEnum
extends PostingsEnum {
    private MultiPostingsEnum.EnumWithSlice[] subs;
    int numSubs;
    int upto;
    MergeState.DocMap currentMap;
    PostingsEnum current;
    int currentBase;
    int doc = -1;
    private MergeState mergeState;
    MultiPostingsEnum multiDocsAndPositionsEnum;
    final String field;

    public MappingMultiPostingsEnum(String field2, MergeState mergeState) {
        this.field = field2;
        this.mergeState = mergeState;
    }

    MappingMultiPostingsEnum reset(MultiPostingsEnum postingsEnum) {
        this.numSubs = postingsEnum.getNumSubs();
        this.subs = postingsEnum.getSubs();
        this.upto = -1;
        this.doc = -1;
        this.current = null;
        this.multiDocsAndPositionsEnum = postingsEnum;
        return this;
    }

    public int getNumSubs() {
        return this.numSubs;
    }

    public MultiPostingsEnum.EnumWithSlice[] getSubs() {
        return this.subs;
    }

    @Override
    public int freq() throws IOException {
        return this.current.freq();
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int advance(int target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nextDoc() throws IOException {
        while (true) {
            int doc2;
            if (this.current == null) {
                if (this.upto == this.numSubs - 1) {
                    this.doc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                ++this.upto;
                int reader = this.subs[this.upto].slice.readerIndex;
                this.current = this.subs[this.upto].postingsEnum;
                this.currentBase = this.mergeState.docBase[reader];
                this.currentMap = this.mergeState.docMaps[reader];
            }
            if ((doc2 = this.current.nextDoc()) != Integer.MAX_VALUE) {
                if ((doc2 = this.currentMap.get(doc2)) == -1) continue;
                this.doc = this.currentBase + doc2;
                return this.doc;
            }
            this.current = null;
        }
    }

    @Override
    public int nextPosition() throws IOException {
        int pos = this.current.nextPosition();
        if (pos < 0) {
            throw new CorruptIndexException("position=" + pos + " is negative, field=\"" + this.field + " doc=" + this.doc, this.mergeState.fieldsProducers[this.upto].toString());
        }
        if (pos > 0x7FFFFF7F) {
            throw new CorruptIndexException("position=" + pos + " is too large (> IndexWriter.MAX_POSITION=" + 0x7FFFFF7F + "), field=\"" + this.field + "\" doc=" + this.doc, this.mergeState.fieldsProducers[this.upto].toString());
        }
        return pos;
    }

    @Override
    public int startOffset() throws IOException {
        return this.current.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.current.endOffset();
    }

    @Override
    public BytesRef getPayload() throws IOException {
        return this.current.getPayload();
    }

    @Override
    public long cost() {
        long cost = 0L;
        for (MultiPostingsEnum.EnumWithSlice enumWithSlice : this.subs) {
            cost += enumWithSlice.postingsEnum.cost();
        }
        return cost;
    }
}

