/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.AbortingException;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeRateLimiter;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TwoPhaseCommit;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.LockValidatingDirectoryWrapper;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.store.RateLimitedIndexOutput;
import org.apache.lucene.store.SleepingLockWrapper;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CloseableThreadLocal;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.ThreadInterruptedException;
import org.apache.lucene.util.Version;

public class IndexWriter
implements Closeable,
TwoPhaseCommit,
Accountable {
    public static final int MAX_DOCS = 0x7FFFFF7F;
    public static final int MAX_POSITION = 0x7FFFFF7F;
    private static int actualMaxDocs = 0x7FFFFF7F;
    boolean enableTestPoints;
    private static final int UNBOUNDED_MAX_MERGE_SEGMENTS = -1;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final String SOURCE = "source";
    public static final String SOURCE_MERGE = "merge";
    public static final String SOURCE_FLUSH = "flush";
    public static final String SOURCE_ADDINDEXES_READERS = "addIndexes(CodecReader...)";
    public static final int MAX_TERM_LENGTH = 32766;
    volatile Throwable tragedy;
    private final Directory directoryOrig;
    private final Directory directory;
    private final Directory mergeDirectory;
    private final Analyzer analyzer;
    private final AtomicLong changeCount;
    private volatile long lastCommitChangeCount;
    private List<SegmentCommitInfo> rollbackSegments;
    volatile SegmentInfos pendingCommit;
    volatile long pendingCommitChangeCount;
    private Collection<String> filesToCommit;
    final SegmentInfos segmentInfos;
    final FieldInfos.FieldNumbers globalFieldNumberMap;
    private final DocumentsWriter docWriter;
    private final Queue<Event> eventQueue;
    final IndexFileDeleter deleter;
    private Map<SegmentCommitInfo, Boolean> segmentsToMerge;
    private int mergeMaxNumSegments;
    private Lock writeLock;
    private volatile boolean closed;
    private volatile boolean closing;
    private HashSet<SegmentCommitInfo> mergingSegments;
    private final MergeScheduler mergeScheduler;
    private LinkedList<MergePolicy.OneMerge> pendingMerges;
    private Set<MergePolicy.OneMerge> runningMerges;
    private List<MergePolicy.OneMerge> mergeExceptions;
    private long mergeGen;
    private boolean stopMerges;
    private boolean didMessageState;
    final AtomicInteger flushCount;
    final AtomicInteger flushDeletesCount;
    final ReaderPool readerPool;
    final BufferedUpdatesStream bufferedUpdatesStream;
    private volatile boolean poolReaders;
    private final LiveIndexWriterConfig config;
    private long startCommitTime;
    final AtomicLong pendingNumDocs;
    final CloseableThreadLocal<MergeRateLimiter> rateLimiters;
    final Codec codec;
    final InfoStream infoStream;
    private final Object commitLock;
    private final Object fullFlushLock;
    private boolean keepFullyDeletedSegments;

    static void setMaxDocs(int maxDocs) {
        if (maxDocs > 0x7FFFFF7F) {
            throw new IllegalArgumentException("maxDocs must be <= IndexWriter.MAX_DOCS=2147483519; got: " + maxDocs);
        }
        actualMaxDocs = maxDocs;
    }

    static int getActualMaxDocs() {
        return actualMaxDocs;
    }

    DirectoryReader getReader() throws IOException {
        return this.getReader(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DirectoryReader getReader(boolean applyAllDeletes) throws IOException {
        this.ensureOpen();
        long tStart = System.currentTimeMillis();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "flush at getReader");
        }
        this.poolReaders = true;
        DirectoryReader r = null;
        this.doBeforeFlush();
        boolean anyChanges = false;
        boolean success2 = false;
        try {
            boolean success = false;
            Object object = this.fullFlushLock;
            synchronized (object) {
                try {
                    anyChanges = this.docWriter.flushAllThreads();
                    if (!anyChanges) {
                        this.flushCount.incrementAndGet();
                    }
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        anyChanges |= this.maybeApplyDeletes(applyAllDeletes);
                        r = StandardDirectoryReader.open(this, this.segmentInfos, applyAllDeletes);
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "return reader version=" + r.getVersion() + " reader=" + r);
                        }
                    }
                    success = true;
                }
                finally {
                    this.docWriter.finishFullFlush(this, success);
                    if (success) {
                        this.processEvents(false, true);
                        this.doAfterFlush();
                    } else if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "hit exception during NRT reader");
                    }
                }
            }
            if (anyChanges) {
                this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
            }
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "getReader took " + (System.currentTimeMillis() - tStart) + " msec");
            }
            if (success2 = true) return r;
        }
        catch (VirtualMachineError | AbortingException tragedy) {
            DirectoryReader directoryReader;
            try {
                this.tragicEvent(tragedy, "getReader");
                directoryReader = null;
                if (success2) return directoryReader;
            }
            catch (Throwable throwable) {
                if (success2) throw throwable;
                IOUtils.closeWhileHandlingException(r);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(r);
            return directoryReader;
        }
        IOUtils.closeWhileHandlingException(r);
        return r;
    }

    @Override
    public final long ramBytesUsed() {
        this.ensureOpen();
        return this.docWriter.ramBytesUsed();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public int numDeletedDocs(SegmentCommitInfo info2) {
        this.ensureOpen(false);
        int delCount = info2.getDelCount();
        ReadersAndUpdates rld = this.readerPool.get(info2, false);
        if (rld != null) {
            delCount += rld.getPendingDeleteCount();
        }
        return delCount;
    }

    protected final void ensureOpen(boolean failIfClosing) throws AlreadyClosedException {
        if (this.closed || failIfClosing && this.closing) {
            throw new AlreadyClosedException("this IndexWriter is closed", this.tragedy);
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        this.ensureOpen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter(Directory d, IndexWriterConfig conf) throws IOException {
        block33: {
            block34: {
                this.enableTestPoints = false;
                this.changeCount = new AtomicLong();
                this.segmentsToMerge = new HashMap<SegmentCommitInfo, Boolean>();
                this.mergingSegments = new HashSet();
                this.pendingMerges = new LinkedList();
                this.runningMerges = new HashSet<MergePolicy.OneMerge>();
                this.mergeExceptions = new ArrayList<MergePolicy.OneMerge>();
                this.flushCount = new AtomicInteger();
                this.flushDeletesCount = new AtomicInteger();
                this.readerPool = new ReaderPool();
                this.pendingNumDocs = new AtomicLong();
                this.rateLimiters = new CloseableThreadLocal();
                this.commitLock = new Object();
                this.fullFlushLock = new Object();
                conf.setIndexWriter(this);
                this.config = conf;
                this.infoStream = this.config.getInfoStream();
                long timeout = this.config.getWriteLockTimeout();
                Directory lockDir = timeout == 0L ? d : new SleepingLockWrapper(d, timeout);
                this.writeLock = lockDir.obtainLock(WRITE_LOCK_NAME);
                boolean success = false;
                try {
                    Object lastSegmentsFile;
                    this.directoryOrig = d;
                    this.directory = new LockValidatingDirectoryWrapper(d, this.writeLock);
                    this.mergeDirectory = this.addMergeRateLimiters(this.directory);
                    this.analyzer = this.config.getAnalyzer();
                    this.mergeScheduler = this.config.getMergeScheduler();
                    this.mergeScheduler.setInfoStream(this.infoStream);
                    this.codec = this.config.getCodec();
                    this.bufferedUpdatesStream = new BufferedUpdatesStream(this.infoStream);
                    this.poolReaders = this.config.getReaderPooling();
                    IndexWriterConfig.OpenMode mode = this.config.getOpenMode();
                    boolean create = mode == IndexWriterConfig.OpenMode.CREATE ? true : (mode == IndexWriterConfig.OpenMode.APPEND ? false : !DirectoryReader.indexExists(this.directory));
                    boolean initialIndexExists = true;
                    Object[] files2 = this.directory.listAll();
                    IndexCommit commit = this.config.getIndexCommit();
                    StandardDirectoryReader reader = commit == null ? null : commit.getReader();
                    if (create) {
                        if (this.config.getIndexCommit() != null) {
                            if (mode == IndexWriterConfig.OpenMode.CREATE) {
                                throw new IllegalArgumentException("cannot use IndexWriterConfig.setIndexCommit() with OpenMode.CREATE");
                            }
                            throw new IllegalArgumentException("cannot use IndexWriterConfig.setIndexCommit() when index has no commit");
                        }
                        SegmentInfos sis = null;
                        try {
                            sis = SegmentInfos.readLatestCommit(this.directory);
                            sis.clear();
                        }
                        catch (IOException e) {
                            initialIndexExists = false;
                            sis = new SegmentInfos();
                        }
                        this.segmentInfos = sis;
                        this.rollbackSegments = this.segmentInfos.createBackupSegmentInfos();
                        this.changed();
                    } else if (reader != null) {
                        SegmentInfos lastCommit;
                        if (reader.directory() != commit.getDirectory()) {
                            throw new IllegalArgumentException("IndexCommit's reader must have the same directory as the IndexCommit");
                        }
                        if (reader.directory() != this.directoryOrig) {
                            throw new IllegalArgumentException("IndexCommit's reader must have the same directory passed to IndexWriter");
                        }
                        if (reader.segmentInfos.getLastGeneration() == 0L) {
                            throw new IllegalArgumentException("index must already have an initial commit to open from reader");
                        }
                        this.segmentInfos = reader.segmentInfos.clone();
                        try {
                            lastCommit = SegmentInfos.readCommit(this.directoryOrig, this.segmentInfos.getSegmentsFileName());
                        }
                        catch (IOException ioe) {
                            throw new IllegalArgumentException("the provided reader is stale: its prior commit file \"" + this.segmentInfos.getSegmentsFileName() + "\" is missing from index");
                        }
                        if (reader.writer != null) {
                            assert (reader.writer.closed);
                            this.segmentInfos.updateGenerationVersionAndCounter(reader.writer.segmentInfos);
                            lastCommit.updateGenerationVersionAndCounter(reader.writer.segmentInfos);
                        }
                        this.rollbackSegments = lastCommit.createBackupSegmentInfos();
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "init from reader " + reader);
                            this.messageState();
                        }
                    } else {
                        lastSegmentsFile = SegmentInfos.getLastCommitSegmentsFileName((String[])files2);
                        if (lastSegmentsFile == null) {
                            throw new IndexNotFoundException("no segments* file found in " + this.directory + ": files: " + Arrays.toString(files2));
                        }
                        this.segmentInfos = SegmentInfos.readCommit(this.directoryOrig, (String)lastSegmentsFile);
                        if (commit != null) {
                            if (commit.getDirectory() != this.directoryOrig) {
                                throw new IllegalArgumentException("IndexCommit's directory doesn't match my directory, expected=" + this.directoryOrig + ", got=" + commit.getDirectory());
                            }
                            SegmentInfos oldInfos = SegmentInfos.readCommit(this.directoryOrig, commit.getSegmentsFileName());
                            this.segmentInfos.replace(oldInfos);
                            this.changed();
                            if (this.infoStream.isEnabled("IW")) {
                                this.infoStream.message("IW", "init: loaded commit \"" + commit.getSegmentsFileName() + "\"");
                            }
                        }
                        this.rollbackSegments = this.segmentInfos.createBackupSegmentInfos();
                    }
                    this.pendingNumDocs.set(this.segmentInfos.totalMaxDoc());
                    this.globalFieldNumberMap = this.getFieldNumberMap();
                    this.config.getFlushPolicy().init(this.config);
                    this.docWriter = new DocumentsWriter(this, this.config, this.directoryOrig, this.directory);
                    this.eventQueue = this.docWriter.eventQueue();
                    lastSegmentsFile = this;
                    synchronized (lastSegmentsFile) {
                        this.deleter = new IndexFileDeleter((String[])files2, this.directoryOrig, this.directory, this.config.getIndexDeletionPolicy(), this.segmentInfos, this.infoStream, this, initialIndexExists, reader != null);
                        assert (create || this.filesExist(this.segmentInfos));
                    }
                    if (this.deleter.startingCommitDeleted) {
                        this.changed();
                    }
                    if (reader != null) {
                        List<LeafReaderContext> leaves2 = reader.leaves();
                        assert (this.segmentInfos.size() == leaves2.size());
                        for (int i = 0; i < leaves2.size(); ++i) {
                            LeafReaderContext leaf = leaves2.get(i);
                            SegmentReader segReader = (SegmentReader)leaf.reader();
                            SegmentReader newReader = new SegmentReader(this.segmentInfos.info(i), segReader, segReader.getLiveDocs(), segReader.numDocs());
                            this.readerPool.readerMap.put(newReader.getSegmentInfo(), new ReadersAndUpdates(this, newReader));
                        }
                        this.segmentInfos.changed();
                        this.changed();
                    }
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "init: create=" + create);
                        this.messageState();
                    }
                    if (success = true) break block33;
                    if (!this.infoStream.isEnabled("IW")) break block34;
                    this.infoStream.message("IW", "init: hit exception on init; releasing write lock");
                }
                catch (Throwable throwable) {
                    if (!success) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "init: hit exception on init; releasing write lock");
                        }
                        IOUtils.closeWhileHandlingException(this.writeLock);
                        this.writeLock = null;
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException(this.writeLock);
            this.writeLock = null;
        }
    }

    static FieldInfos readFieldInfos(SegmentCommitInfo si) throws IOException {
        Codec codec = si.info.getCodec();
        FieldInfosFormat reader = codec.fieldInfosFormat();
        if (si.hasFieldUpdates()) {
            String segmentSuffix = Long.toString(si.getFieldInfosGen(), 36);
            return reader.read(si.info.dir, si.info, segmentSuffix, IOContext.READONCE);
        }
        if (si.info.getUseCompoundFile()) {
            try (Directory cfs = codec.compoundFormat().getCompoundReader(si.info.dir, si.info, IOContext.DEFAULT);){
                FieldInfos fieldInfos = reader.read(cfs, si.info, "", IOContext.READONCE);
                return fieldInfos;
            }
        }
        return reader.read(si.info.dir, si.info, "", IOContext.READONCE);
    }

    private FieldInfos.FieldNumbers getFieldNumberMap() throws IOException {
        FieldInfos.FieldNumbers map2 = new FieldInfos.FieldNumbers();
        for (SegmentCommitInfo info2 : this.segmentInfos) {
            FieldInfos fis = IndexWriter.readFieldInfos(info2);
            for (FieldInfo fi : fis) {
                map2.addOrGet(fi.name, fi.number, fi.getDocValuesType());
            }
        }
        return map2;
    }

    public LiveIndexWriterConfig getConfig() {
        this.ensureOpen(false);
        return this.config;
    }

    private void messageState() {
        if (this.infoStream.isEnabled("IW") && !this.didMessageState) {
            this.didMessageState = true;
            this.infoStream.message("IW", "\ndir=" + this.directoryOrig + "\n" + "index=" + this.segString() + "\n" + "version=" + Version.LATEST.toString() + "\n" + this.config.toString());
            this.infoStream.message("IW", "MMapDirectory.UNMAP_SUPPORTED=" + MMapDirectory.UNMAP_SUPPORTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() throws IOException {
        if (this.pendingCommit != null) {
            throw new IllegalStateException("cannot close: prepareCommit was already called with no corresponding call to commit");
        }
        if (this.shouldClose(true)) {
            boolean success = false;
            try {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "now flush at close");
                }
                this.flush(true, true);
                this.waitForMerges();
                this.commitInternal(this.config.getMergePolicy());
                this.rollbackInternal();
                success = true;
            }
            finally {
                if (!success) {
                    try {
                        this.rollbackInternal();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.config.getCommitOnClose()) {
            this.shutdown();
        } else {
            this.rollback();
        }
    }

    private synchronized boolean shouldClose(boolean waitForClose) {
        while (!this.closed) {
            if (!this.closing) {
                this.closing = true;
                return true;
            }
            if (!waitForClose) {
                return false;
            }
            this.doWait();
        }
        return false;
    }

    public Directory getDirectory() {
        return this.directoryOrig;
    }

    public Analyzer getAnalyzer() {
        this.ensureOpen();
        return this.analyzer;
    }

    public synchronized int maxDoc() {
        this.ensureOpen();
        return this.docWriter.getNumDocs() + this.segmentInfos.totalMaxDoc();
    }

    public synchronized int numDocs() {
        this.ensureOpen();
        int count2 = this.docWriter.getNumDocs();
        for (SegmentCommitInfo info2 : this.segmentInfos) {
            count2 += info2.info.maxDoc() - this.numDeletedDocs(info2);
        }
        return count2;
    }

    public synchronized boolean hasDeletions() {
        this.ensureOpen();
        if (this.bufferedUpdatesStream.any()) {
            return true;
        }
        if (this.docWriter.anyDeletions()) {
            return true;
        }
        if (this.readerPool.anyPendingDeletes()) {
            return true;
        }
        for (SegmentCommitInfo info2 : this.segmentInfos) {
            if (!info2.hasDeletions()) continue;
            return true;
        }
        return false;
    }

    public void addDocument(Iterable<? extends IndexableField> doc2) throws IOException {
        this.updateDocument(null, doc2);
    }

    public void addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        this.updateDocuments(null, docs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        this.ensureOpen();
        try {
            boolean success = false;
            try {
                if (this.docWriter.updateDocuments(docs, this.analyzer, delTerm)) {
                    this.processEvents(true, false);
                }
                success = true;
            }
            finally {
                if (!success && this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception updating document");
                }
            }
        }
        catch (VirtualMachineError | AbortingException tragedy) {
            this.tragicEvent(tragedy, "updateDocuments");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean tryDeleteDocument(IndexReader readerIn, int docID) throws IOException {
        ReadersAndUpdates rld;
        LeafReader reader;
        if (readerIn instanceof LeafReader) {
            reader = (LeafReader)readerIn;
        } else {
            List<LeafReaderContext> leaves2 = readerIn.leaves();
            int subIndex = ReaderUtil.subIndex(docID, leaves2);
            reader = leaves2.get(subIndex).reader();
            assert ((docID -= leaves2.get((int)subIndex).docBase) >= 0);
            assert (docID < reader.maxDoc());
        }
        if (!(reader instanceof SegmentReader)) {
            throw new IllegalArgumentException("the reader must be a SegmentReader or composite reader containing only SegmentReaders");
        }
        SegmentCommitInfo info2 = ((SegmentReader)reader).getSegmentInfo();
        if (this.segmentInfos.indexOf(info2) != -1 && (rld = this.readerPool.get(info2, false)) != null) {
            BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
            synchronized (bufferedUpdatesStream) {
                rld.initWritableLiveDocs();
                if (rld.delete(docID)) {
                    int fullDelCount = rld.info.getDelCount() + rld.getPendingDeleteCount();
                    if (fullDelCount == rld.info.info.maxDoc() && !this.mergingSegments.contains(rld.info)) {
                        this.segmentInfos.remove(rld.info);
                        this.readerPool.drop(rld.info);
                        this.checkpoint();
                    }
                    this.changed();
                }
                return true;
            }
        }
        return false;
    }

    public void deleteDocuments(Term ... terms) throws IOException {
        this.ensureOpen();
        try {
            if (this.docWriter.deleteTerms(terms)) {
                this.processEvents(true, false);
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "deleteDocuments(Term..)");
        }
    }

    public void deleteDocuments(Query ... queries) throws IOException {
        this.ensureOpen();
        for (Query query : queries) {
            if (query.getClass() != MatchAllDocsQuery.class) continue;
            this.deleteAll();
            return;
        }
        try {
            if (this.docWriter.deleteQueries(queries)) {
                this.processEvents(true, false);
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "deleteDocuments(Query..)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDocument(Term term, Iterable<? extends IndexableField> doc2) throws IOException {
        this.ensureOpen();
        try {
            boolean success = false;
            try {
                if (this.docWriter.updateDocument(doc2, this.analyzer, term)) {
                    this.processEvents(true, false);
                }
                success = true;
            }
            finally {
                if (!success && this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception updating document");
                }
            }
        }
        catch (VirtualMachineError | AbortingException tragedy) {
            this.tragicEvent(tragedy, "updateDocument");
        }
    }

    public void updateNumericDocValue(Term term, String field2, long value) throws IOException {
        this.ensureOpen();
        if (!this.globalFieldNumberMap.contains(field2, DocValuesType.NUMERIC)) {
            throw new IllegalArgumentException("can only update existing numeric-docvalues fields!");
        }
        try {
            if (this.docWriter.updateDocValues(new DocValuesUpdate.NumericDocValuesUpdate(term, field2, value))) {
                this.processEvents(true, false);
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "updateNumericDocValue");
        }
    }

    public void updateBinaryDocValue(Term term, String field2, BytesRef value) throws IOException {
        this.ensureOpen();
        if (value == null) {
            throw new IllegalArgumentException("cannot update a field to a null value: " + field2);
        }
        if (!this.globalFieldNumberMap.contains(field2, DocValuesType.BINARY)) {
            throw new IllegalArgumentException("can only update existing binary-docvalues fields!");
        }
        try {
            if (this.docWriter.updateDocValues(new DocValuesUpdate.BinaryDocValuesUpdate(term, field2, value))) {
                this.processEvents(true, false);
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "updateBinaryDocValue");
        }
    }

    public void updateDocValues(Term term, Field ... updates) throws IOException {
        this.ensureOpen();
        DocValuesUpdate[] dvUpdates = new DocValuesUpdate[updates.length];
        block6: for (int i = 0; i < updates.length; ++i) {
            Field f = updates[i];
            DocValuesType dvType = f.fieldType().docValuesType();
            if (dvType == null) {
                throw new NullPointerException("DocValuesType cannot be null (field: \"" + f.name() + "\")");
            }
            if (dvType == DocValuesType.NONE) {
                throw new IllegalArgumentException("can only update NUMERIC or BINARY fields! field=" + f.name());
            }
            if (!this.globalFieldNumberMap.contains(f.name(), dvType)) {
                throw new IllegalArgumentException("can only update existing docvalues fields! field=" + f.name() + ", type=" + (Object)((Object)dvType));
            }
            switch (dvType) {
                case NUMERIC: {
                    dvUpdates[i] = new DocValuesUpdate.NumericDocValuesUpdate(term, f.name(), (Long)f.numericValue());
                    continue block6;
                }
                case BINARY: {
                    dvUpdates[i] = new DocValuesUpdate.BinaryDocValuesUpdate(term, f.name(), f.binaryValue());
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("can only update NUMERIC or BINARY fields: field=" + f.name() + ", type=" + (Object)((Object)dvType));
                }
            }
        }
        try {
            if (this.docWriter.updateDocValues(dvUpdates)) {
                this.processEvents(true, false);
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "updateDocValues");
        }
    }

    final synchronized int getSegmentCount() {
        return this.segmentInfos.size();
    }

    final synchronized int getNumBufferedDocuments() {
        return this.docWriter.getNumDocs();
    }

    final synchronized Collection<String> getIndexFileNames() throws IOException {
        return this.segmentInfos.files(true);
    }

    final synchronized int maxDoc(int i) {
        if (i >= 0 && i < this.segmentInfos.size()) {
            return this.segmentInfos.info((int)i).info.maxDoc();
        }
        return -1;
    }

    final int getFlushCount() {
        return this.flushCount.get();
    }

    final int getFlushDeletesCount() {
        return this.flushDeletesCount.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String newSegmentName() {
        SegmentInfos segmentInfos = this.segmentInfos;
        synchronized (segmentInfos) {
            this.changeCount.incrementAndGet();
            this.segmentInfos.changed();
            return "_" + Integer.toString(this.segmentInfos.counter++, 36);
        }
    }

    public void forceMerge(int maxNumSegments) throws IOException {
        this.forceMerge(maxNumSegments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMerge(int maxNumSegments, boolean doWait) throws IOException {
        this.ensureOpen();
        if (maxNumSegments < 1) {
            throw new IllegalArgumentException("maxNumSegments must be >= 1; got " + maxNumSegments);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "forceMerge: index now " + this.segString());
            this.infoStream.message("IW", "now flush at forceMerge");
        }
        this.flush(true, true);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.resetMergeExceptions();
            this.segmentsToMerge.clear();
            for (SegmentCommitInfo info2 : this.segmentInfos) {
                this.segmentsToMerge.put(info2, Boolean.TRUE);
            }
            this.mergeMaxNumSegments = maxNumSegments;
            for (MergePolicy.OneMerge merge : this.pendingMerges) {
                merge.maxNumSegments = maxNumSegments;
                this.segmentsToMerge.put(merge.info, Boolean.TRUE);
            }
            for (MergePolicy.OneMerge merge : this.runningMerges) {
                merge.maxNumSegments = maxNumSegments;
                this.segmentsToMerge.put(merge.info, Boolean.TRUE);
            }
        }
        this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.EXPLICIT, maxNumSegments);
        if (doWait) {
            indexWriter = this;
            synchronized (indexWriter) {
                while (true) {
                    if (this.tragedy != null) {
                        throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete forceMerge", this.tragedy);
                    }
                    if (this.mergeExceptions.size() > 0) {
                        int size2 = this.mergeExceptions.size();
                        for (int i = 0; i < size2; ++i) {
                            MergePolicy.OneMerge merge = this.mergeExceptions.get(i);
                            if (merge.maxNumSegments == -1) continue;
                            throw new IOException("background merge hit exception: " + merge.segString(), merge.getException());
                        }
                    }
                    if (!this.maxNumSegmentsMergesPending()) break;
                    this.doWait();
                }
            }
            this.ensureOpen();
        }
    }

    private synchronized boolean maxNumSegmentsMergesPending() {
        for (MergePolicy.OneMerge merge : this.pendingMerges) {
            if (merge.maxNumSegments == -1) continue;
            return true;
        }
        for (MergePolicy.OneMerge merge : this.runningMerges) {
            if (merge.maxNumSegments == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMergeDeletes(boolean doWait) throws IOException {
        MergePolicy.MergeSpecification spec;
        this.ensureOpen();
        this.flush(true, true);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "forceMergeDeletes: index now " + this.segString());
        }
        MergePolicy mergePolicy = this.config.getMergePolicy();
        boolean newMergesFound = false;
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            spec = mergePolicy.findForcedDeletesMerges(this.segmentInfos, this);
            boolean bl = newMergesFound = spec != null;
            if (newMergesFound) {
                int numMerges = spec.merges.size();
                for (int i = 0; i < numMerges; ++i) {
                    this.registerMerge(spec.merges.get(i));
                }
            }
        }
        this.mergeScheduler.merge(this, MergeTrigger.EXPLICIT, newMergesFound);
        if (spec != null && doWait) {
            int numMerges = spec.merges.size();
            IndexWriter indexWriter2 = this;
            synchronized (indexWriter2) {
                boolean running = true;
                while (running) {
                    if (this.tragedy != null) {
                        throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete forceMergeDeletes", this.tragedy);
                    }
                    running = false;
                    for (int i = 0; i < numMerges; ++i) {
                        Throwable t;
                        MergePolicy.OneMerge merge = spec.merges.get(i);
                        if (this.pendingMerges.contains(merge) || this.runningMerges.contains(merge)) {
                            running = true;
                        }
                        if ((t = merge.getException()) == null) continue;
                        throw new IOException("background merge hit exception: " + merge.segString(), t);
                    }
                    if (!running) continue;
                    this.doWait();
                }
            }
        }
    }

    public void forceMergeDeletes() throws IOException {
        this.forceMergeDeletes(true);
    }

    public final void maybeMerge() throws IOException {
        this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.EXPLICIT, -1);
    }

    private final void maybeMerge(MergePolicy mergePolicy, MergeTrigger trigger, int maxNumSegments) throws IOException {
        this.ensureOpen(false);
        boolean newMergesFound = this.updatePendingMerges(mergePolicy, trigger, maxNumSegments);
        this.mergeScheduler.merge(this, trigger, newMergesFound);
    }

    private synchronized boolean updatePendingMerges(MergePolicy mergePolicy, MergeTrigger trigger, int maxNumSegments) throws IOException {
        int i;
        int numMerges;
        MergePolicy.MergeSpecification spec;
        this.messageState();
        assert (maxNumSegments == -1 || maxNumSegments > 0);
        assert (trigger != null);
        if (this.stopMerges) {
            return false;
        }
        if (this.tragedy != null) {
            return false;
        }
        boolean newMergesFound = false;
        if (maxNumSegments != -1) {
            assert (trigger == MergeTrigger.EXPLICIT || trigger == MergeTrigger.MERGE_FINISHED) : "Expected EXPLICT or MERGE_FINISHED as trigger even with maxNumSegments set but was: " + trigger.name();
            spec = mergePolicy.findForcedMerges(this.segmentInfos, maxNumSegments, Collections.unmodifiableMap(this.segmentsToMerge), this);
            boolean bl = newMergesFound = spec != null;
            if (newMergesFound) {
                numMerges = spec.merges.size();
                for (i = 0; i < numMerges; ++i) {
                    MergePolicy.OneMerge merge = spec.merges.get(i);
                    merge.maxNumSegments = maxNumSegments;
                }
            }
        } else {
            spec = mergePolicy.findMerges(trigger, this.segmentInfos, this);
        }
        boolean bl = newMergesFound = spec != null;
        if (newMergesFound) {
            numMerges = spec.merges.size();
            for (i = 0; i < numMerges; ++i) {
                this.registerMerge(spec.merges.get(i));
            }
        }
        return newMergesFound;
    }

    public synchronized Collection<SegmentCommitInfo> getMergingSegments() {
        return this.mergingSegments;
    }

    public synchronized MergePolicy.OneMerge getNextMerge() {
        if (this.pendingMerges.size() == 0) {
            return null;
        }
        MergePolicy.OneMerge merge = this.pendingMerges.removeFirst();
        this.runningMerges.add(merge);
        return merge;
    }

    public synchronized boolean hasPendingMerges() {
        return this.pendingMerges.size() != 0;
    }

    @Override
    public void rollback() throws IOException {
        if (this.shouldClose(true)) {
            this.rollbackInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackInternal() throws IOException {
        Object object = this.commitLock;
        synchronized (object) {
            this.rollbackInternalNoCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackInternalNoCommit() throws IOException {
        IndexWriter indexWriter;
        boolean success;
        block38: {
            success = false;
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "rollback");
            }
            try {
                this.abortMerges();
                this.rateLimiters.close();
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "rollback: done finish merges");
                }
                this.mergeScheduler.close();
                this.bufferedUpdatesStream.clear();
                this.docWriter.close();
                this.docWriter.abort(this);
                indexWriter = this;
                synchronized (indexWriter) {
                    if (this.pendingCommit != null) {
                        this.pendingCommit.rollbackCommit(this.directory);
                        try {
                            this.deleter.decRef(this.pendingCommit);
                        }
                        finally {
                            this.pendingCommit = null;
                            this.notifyAll();
                        }
                    }
                    this.readerPool.dropAll(false);
                    this.segmentInfos.rollbackSegmentInfos(this.rollbackSegments);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "rollback: infos=" + this.segString(this.segmentInfos));
                    }
                    this.testPoint("rollback before checkpoint");
                    if (this.tragedy == null) {
                        this.deleter.checkpoint(this.segmentInfos, false);
                        this.deleter.refresh();
                        this.deleter.close();
                    }
                    this.lastCommitChangeCount = this.changeCount.get();
                    this.closed = true;
                    IOUtils.close(this.writeLock);
                    this.writeLock = null;
                }
                success = true;
                if (success) break block38;
            }
            catch (VirtualMachineError tragedy) {
                block39: {
                    try {
                        this.tragicEvent(tragedy, "rollbackInternal");
                        if (success) break block39;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            IOUtils.closeWhileHandlingException(this.mergeScheduler);
                        }
                        IndexWriter indexWriter2 = this;
                        synchronized (indexWriter2) {
                            if (!success) {
                                if (this.pendingCommit != null) {
                                    try {
                                        this.pendingCommit.rollbackCommit(this.directory);
                                        this.deleter.decRef(this.pendingCommit);
                                    }
                                    catch (Throwable t) {
                                        // empty catch block
                                    }
                                    this.pendingCommit = null;
                                }
                                IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                                this.writeLock = null;
                            }
                            this.closed = true;
                            this.closing = false;
                            this.notifyAll();
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException(this.mergeScheduler);
                }
                IndexWriter indexWriter3 = this;
                synchronized (indexWriter3) {
                    if (!success) {
                        if (this.pendingCommit != null) {
                            try {
                                this.pendingCommit.rollbackCommit(this.directory);
                                this.deleter.decRef(this.pendingCommit);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            this.pendingCommit = null;
                        }
                        IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                        this.writeLock = null;
                    }
                    this.closed = true;
                    this.closing = false;
                    this.notifyAll();
                }
            }
            IOUtils.closeWhileHandlingException(this.mergeScheduler);
        }
        indexWriter = this;
        synchronized (indexWriter) {
            if (!success) {
                if (this.pendingCommit != null) {
                    try {
                        this.pendingCommit.rollbackCommit(this.directory);
                        this.deleter.decRef(this.pendingCommit);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.pendingCommit = null;
                }
                IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                this.writeLock = null;
            }
            this.closed = true;
            this.closing = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAll() throws IOException {
        this.ensureOpen();
        boolean success = false;
        try {
            Object object = this.fullFlushLock;
            synchronized (object) {
                long abortedDocCount = this.docWriter.lockAndAbortAll(this);
                this.pendingNumDocs.addAndGet(-abortedDocCount);
                this.processEvents(false, true);
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    try {
                        this.abortMerges();
                        this.stopMerges = false;
                        this.pendingNumDocs.addAndGet(-this.segmentInfos.totalMaxDoc());
                        this.segmentInfos.clear();
                        this.deleter.checkpoint(this.segmentInfos, false);
                        this.readerPool.dropAll(false);
                        this.changeCount.incrementAndGet();
                        this.segmentInfos.changed();
                        this.globalFieldNumberMap.clear();
                        success = true;
                    }
                    finally {
                        this.docWriter.unlockAllAfterAbortAll(this);
                        if (!success && this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during deleteAll");
                        }
                    }
                }
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "deleteAll");
        }
    }

    private synchronized void abortMerges() {
        this.stopMerges = true;
        for (MergePolicy.OneMerge merge : this.pendingMerges) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now abort pending merge " + this.segString(merge.segments));
            }
            merge.rateLimiter.setAbort();
            this.mergeFinish(merge);
        }
        this.pendingMerges.clear();
        for (MergePolicy.OneMerge merge : this.runningMerges) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now abort running merge " + this.segString(merge.segments));
            }
            merge.rateLimiter.setAbort();
        }
        while (this.runningMerges.size() != 0) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now wait for " + this.runningMerges.size() + " running merge/s to abort");
            }
            this.doWait();
        }
        this.notifyAll();
        assert (0 == this.mergingSegments.size());
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "all running merges have aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForMerges() throws IOException {
        this.mergeScheduler.merge(this, MergeTrigger.CLOSING, false);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "waitForMerges");
            }
            while (this.pendingMerges.size() > 0 || this.runningMerges.size() > 0) {
                this.doWait();
            }
            assert (0 == this.mergingSegments.size());
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "waitForMerges done");
            }
        }
    }

    synchronized void checkpoint() throws IOException {
        this.changed();
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    synchronized void checkpointNoSIS() throws IOException {
        this.changeCount.incrementAndGet();
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    synchronized void changed() {
        this.changeCount.incrementAndGet();
        this.segmentInfos.changed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void publishFrozenUpdates(FrozenBufferedUpdates packet) {
        assert (packet != null && packet.any());
        BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
        synchronized (bufferedUpdatesStream) {
            this.bufferedUpdatesStream.push(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publishFlushedSegment(SegmentCommitInfo newSegment, FrozenBufferedUpdates packet, FrozenBufferedUpdates globalPacket) throws IOException {
        try {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.ensureOpen(false);
                BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
                synchronized (bufferedUpdatesStream) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "publishFlushedSegment");
                    }
                    if (globalPacket != null && globalPacket.any()) {
                        this.bufferedUpdatesStream.push(globalPacket);
                    }
                    long nextGen = packet != null && packet.any() ? this.bufferedUpdatesStream.push(packet) : this.bufferedUpdatesStream.getNextGen();
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "publish sets newSegment delGen=" + nextGen + " seg=" + this.segString(newSegment));
                    }
                    newSegment.setBufferedDeletesGen(nextGen);
                    this.segmentInfos.add(newSegment);
                    this.checkpoint();
                }
            }
        }
        finally {
            this.flushCount.incrementAndGet();
            this.doAfterFlush();
        }
    }

    private synchronized void resetMergeExceptions() {
        this.mergeExceptions = new ArrayList<MergePolicy.OneMerge>();
        ++this.mergeGen;
    }

    private void noDupDirs(Directory ... dirs2) {
        HashSet<Directory> dups = new HashSet<Directory>();
        for (int i = 0; i < dirs2.length; ++i) {
            if (dups.contains(dirs2[i])) {
                throw new IllegalArgumentException("Directory " + dirs2[i] + " appears more than once");
            }
            if (dirs2[i] == this.directoryOrig) {
                throw new IllegalArgumentException("Cannot add directory to itself");
            }
            dups.add(dirs2[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Lock> acquireWriteLocks(Directory ... dirs2) throws IOException {
        ArrayList<Lock> locks = new ArrayList<Lock>(dirs2.length);
        for (int i = 0; i < dirs2.length; ++i) {
            boolean success = false;
            try {
                Lock lock = dirs2[i].obtainLock(WRITE_LOCK_NAME);
                locks.add(lock);
                success = true;
                continue;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(locks);
                }
            }
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexes(Directory ... dirs2) throws IOException {
        this.ensureOpen();
        this.noDupDirs(dirs2);
        List<Lock> locks = this.acquireWriteLocks(dirs2);
        boolean successTop = false;
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "flush at addIndexes(Directory...)");
            }
            this.flush(false, true);
            ArrayList<SegmentCommitInfo> infos = new ArrayList<SegmentCommitInfo>();
            long totalMaxDoc = 0L;
            ArrayList<SegmentInfos> commits = new ArrayList<SegmentInfos>(dirs2.length);
            for (Directory dir : dirs2) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "addIndexes: process directory " + dir);
                }
                SegmentInfos sis = SegmentInfos.readLatestCommit(dir);
                totalMaxDoc += (long)sis.totalMaxDoc();
                commits.add(sis);
            }
            this.testReserveDocs(totalMaxDoc);
            boolean success = false;
            try {
                for (SegmentInfos sis : commits) {
                    for (SegmentCommitInfo info2 : sis) {
                        assert (!infos.contains(info2)) : "dup info dir=" + info2.info.dir + " name=" + info2.info.name;
                        String newSegName = this.newSegmentName();
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "addIndexes: process segment origName=" + info2.info.name + " newName=" + newSegName + " info=" + info2);
                        }
                        IOContext context = new IOContext(new FlushInfo(info2.info.maxDoc(), info2.sizeInBytes()));
                        FieldInfos fis = IndexWriter.readFieldInfos(info2);
                        for (FieldInfo fi : fis) {
                            this.globalFieldNumberMap.addOrGet(fi.name, fi.number, fi.getDocValuesType());
                        }
                        infos.add(this.copySegmentAsIs(info2, newSegName, context));
                    }
                }
                success = true;
            }
            finally {
                if (!success) {
                    for (SegmentCommitInfo sipc : infos) {
                        this.deleteNewFiles(sipc.files());
                    }
                }
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                success = false;
                try {
                    this.ensureOpen();
                    this.reserveDocs(totalMaxDoc);
                    success = true;
                }
                finally {
                    if (!success) {
                        for (SegmentCommitInfo sipc : infos) {
                            this.deleteNewFiles(sipc.files());
                        }
                    }
                }
                this.segmentInfos.addAll(infos);
                this.checkpoint();
            }
            successTop = true;
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "addIndexes(Directory...)");
        }
        finally {
            if (successTop) {
                IOUtils.close(locks);
            } else {
                IOUtils.closeWhileHandlingException(locks);
            }
        }
        this.maybeMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexes(CodecReader ... readers) throws IOException {
        this.ensureOpen();
        long numDocs = 0L;
        try {
            boolean useCompoundFile;
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "flush at addIndexes(CodecReader...)");
            }
            this.flush(false, true);
            String mergedName = this.newSegmentName();
            for (CodecReader leaf : readers) {
                numDocs += (long)leaf.numDocs();
            }
            this.testReserveDocs(numDocs);
            IOContext context = new IOContext(new MergeInfo((int)numDocs, -1L, false, -1));
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(this.directory);
            SegmentInfo info2 = new SegmentInfo(this.directoryOrig, Version.LATEST, mergedName, -1, false, this.codec, Collections.emptyMap(), StringHelper.randomId(), new HashMap<String, String>());
            SegmentMerger merger = new SegmentMerger(Arrays.asList(readers), info2, this.infoStream, trackingDir, this.globalFieldNumberMap, context);
            this.rateLimiters.set(new MergeRateLimiter(null));
            if (!merger.shouldMerge()) {
                return;
            }
            merger.merge();
            SegmentCommitInfo infoPerCommit = new SegmentCommitInfo(info2, 0, -1L, -1L, -1L);
            info2.setFiles(new HashSet<String>(trackingDir.getCreatedFiles()));
            trackingDir.getCreatedFiles().clear();
            IndexWriter.setDiagnostics(info2, SOURCE_ADDINDEXES_READERS);
            MergePolicy mergePolicy = this.config.getMergePolicy();
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.stopMerges) {
                    this.deleteNewFiles(infoPerCommit.files());
                    return;
                }
                this.ensureOpen();
                useCompoundFile = mergePolicy.useCompoundFile(this.segmentInfos, infoPerCommit, this);
            }
            if (useCompoundFile) {
                Collection<String> filesToDelete = infoPerCommit.files();
                TrackingDirectoryWrapper trackingCFSDir = new TrackingDirectoryWrapper(this.mergeDirectory);
                try {
                    this.createCompoundFile(this.infoStream, trackingCFSDir, info2, context);
                }
                finally {
                    this.deleteNewFiles(filesToDelete);
                }
                info2.setUseCompoundFile(true);
            }
            this.codec.segmentInfoFormat().write(trackingDir, info2, context);
            info2.addFiles(trackingDir.getCreatedFiles());
            indexWriter = this;
            synchronized (indexWriter) {
                if (this.stopMerges) {
                    this.deleteNewFiles(infoPerCommit.files());
                    return;
                }
                this.ensureOpen();
                this.reserveDocs(numDocs);
                this.segmentInfos.add(infoPerCommit);
                this.checkpoint();
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, SOURCE_ADDINDEXES_READERS);
        }
        this.maybeMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentCommitInfo copySegmentAsIs(SegmentCommitInfo info2, String segName, IOContext context) throws IOException {
        SegmentInfo newInfo = new SegmentInfo(this.directoryOrig, info2.info.getVersion(), segName, info2.info.maxDoc(), info2.info.getUseCompoundFile(), info2.info.getCodec(), info2.info.getDiagnostics(), info2.info.getId(), info2.info.getAttributes());
        SegmentCommitInfo newInfoPerCommit = new SegmentCommitInfo(newInfo, info2.getDelCount(), info2.getDelGen(), info2.getFieldInfosGen(), info2.getDocValuesGen());
        newInfo.setFiles(info2.files());
        boolean success = false;
        HashSet<String> copiedFiles = new HashSet<String>();
        try {
            for (String file : info2.files()) {
                String newFileName = newInfo.namedForThisSegment(file);
                assert (!IndexWriter.slowFileExists(this.directory, newFileName)) : "file \"" + newFileName + "\" already exists; newInfo.files=" + newInfo.files();
                this.directory.copyFrom(info2.info.dir, file, newFileName, context);
                copiedFiles.add(newFileName);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.deleteNewFiles(copiedFiles);
            }
        }
        assert (copiedFiles.equals(newInfoPerCommit.files()));
        return newInfoPerCommit;
    }

    protected void doAfterFlush() throws IOException {
    }

    protected void doBeforeFlush() throws IOException {
    }

    @Override
    public final void prepareCommit() throws IOException {
        this.ensureOpen();
        this.prepareCommitInternal(this.config.getMergePolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareCommitInternal(MergePolicy mergePolicy) throws IOException {
        this.startCommitTime = System.nanoTime();
        Object object = this.commitLock;
        synchronized (object) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "prepareCommit: flush");
                this.infoStream.message("IW", "  index before flush " + this.segString());
            }
            if (this.tragedy != null) {
                throw new IllegalStateException("this writer hit an unrecoverable error; cannot commit", this.tragedy);
            }
            if (this.pendingCommit != null) {
                throw new IllegalStateException("prepareCommit was already called with no corresponding call to commit");
            }
            this.doBeforeFlush();
            this.testPoint("startDoFlush");
            SegmentInfos toCommit = null;
            boolean anySegmentsFlushed = false;
            try {
                Object object2 = this.fullFlushLock;
                synchronized (object2) {
                    boolean flushSuccess = false;
                    boolean success = false;
                    try {
                        anySegmentsFlushed = this.docWriter.flushAllThreads();
                        if (!anySegmentsFlushed) {
                            this.flushCount.incrementAndGet();
                        }
                        this.processEvents(false, true);
                        flushSuccess = true;
                        IndexWriter indexWriter = this;
                        synchronized (indexWriter) {
                            this.maybeApplyDeletes(true);
                            this.readerPool.commit(this.segmentInfos);
                            if (this.changeCount.get() != this.lastCommitChangeCount) {
                                this.changeCount.incrementAndGet();
                                this.segmentInfos.changed();
                            }
                            toCommit = this.segmentInfos.clone();
                            this.pendingCommitChangeCount = this.changeCount.get();
                            this.filesToCommit = toCommit.files(false);
                            this.deleter.incRef(this.filesToCommit);
                        }
                        success = true;
                    }
                    finally {
                        if (!success && this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during prepareCommit");
                        }
                        this.docWriter.finishFullFlush(this, flushSuccess);
                        this.doAfterFlush();
                    }
                }
            }
            catch (VirtualMachineError | AbortingException tragedy) {
                this.tragicEvent(tragedy, "prepareCommit");
            }
            boolean success = false;
            try {
                if (anySegmentsFlushed) {
                    this.maybeMerge(mergePolicy, MergeTrigger.FULL_FLUSH, -1);
                }
                this.startCommit(toCommit);
                success = true;
            }
            finally {
                if (!success) {
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        if (this.filesToCommit != null) {
                            this.deleter.decRefWhileHandlingException(this.filesToCommit);
                            this.filesToCommit = null;
                        }
                    }
                }
            }
        }
    }

    public final synchronized void setCommitData(Map<String, String> commitUserData) {
        this.segmentInfos.setUserData(new HashMap<String, String>(commitUserData));
        this.changeCount.incrementAndGet();
    }

    public final synchronized Map<String, String> getCommitData() {
        return this.segmentInfos.getUserData();
    }

    @Override
    public final void commit() throws IOException {
        this.ensureOpen();
        this.commitInternal(this.config.getMergePolicy());
    }

    public final boolean hasUncommittedChanges() {
        return this.changeCount.get() != this.lastCommitChangeCount || this.docWriter.anyChanges() || this.bufferedUpdatesStream.any();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void commitInternal(MergePolicy mergePolicy) throws IOException {
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commit: start");
        }
        Object object = this.commitLock;
        synchronized (object) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commit: enter lock");
            }
            if (this.pendingCommit == null) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: now prepare");
                }
                this.prepareCommitInternal(mergePolicy);
            } else if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commit: already prepared");
            }
            this.finishCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void finishCommit() throws IOException {
        boolean commitCompleted = false;
        boolean finished = false;
        String committedSegmentsFileName = null;
        try {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.ensureOpen(false);
                if (this.tragedy != null) {
                    throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete commit", this.tragedy);
                }
                if (this.pendingCommit != null) {
                    try {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "commit: pendingCommit != null");
                        }
                        committedSegmentsFileName = this.pendingCommit.finishCommit(this.directory);
                        commitCompleted = true;
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "commit: done writing segments file \"" + committedSegmentsFileName + "\"");
                        }
                        this.deleter.checkpoint(this.pendingCommit, true);
                        this.segmentInfos.updateGeneration(this.pendingCommit);
                        this.lastCommitChangeCount = this.pendingCommitChangeCount;
                        this.rollbackSegments = this.pendingCommit.createBackupSegmentInfos();
                        finished = true;
                    }
                    finally {
                        this.notifyAll();
                        try {
                            if (finished) {
                                this.deleter.decRef(this.filesToCommit);
                            } else if (!commitCompleted) {
                                this.deleter.decRefWhileHandlingException(this.filesToCommit);
                            }
                        }
                        finally {
                            this.pendingCommit = null;
                            this.filesToCommit = null;
                        }
                    }
                }
                assert (this.filesToCommit == null);
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: pendingCommit == null; skip");
                }
            }
        }
        catch (Throwable t) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception during finishCommit: " + t.getMessage());
            }
            if (commitCompleted) {
                this.tragicEvent(t, "finishCommit");
            }
            IOUtils.reThrow(t);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", String.format(Locale.ROOT, "commit: took %.1f msec", (double)(System.nanoTime() - this.startCommitTime) / 1000000.0));
            this.infoStream.message("IW", "commit: done");
        }
    }

    boolean holdsFullFlushLock() {
        return Thread.holdsLock(this.fullFlushLock);
    }

    public final void flush() throws IOException {
        this.flush(true, true);
    }

    final void flush(boolean triggerMerge, boolean applyAllDeletes) throws IOException {
        this.ensureOpen(false);
        if (this.doFlush(applyAllDeletes) && triggerMerge) {
            this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush(boolean applyAllDeletes) throws IOException {
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot flush", this.tragedy);
        }
        this.doBeforeFlush();
        this.testPoint("startDoFlush");
        boolean success = false;
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "  start flush: applyAllDeletes=" + applyAllDeletes);
                this.infoStream.message("IW", "  index before flush " + this.segString());
            }
            boolean anyChanges = false;
            Object object = this.fullFlushLock;
            synchronized (object) {
                boolean flushSuccess = false;
                try {
                    anyChanges = this.docWriter.flushAllThreads();
                    if (!anyChanges) {
                        this.flushCount.incrementAndGet();
                    }
                    flushSuccess = true;
                }
                finally {
                    this.docWriter.finishFullFlush(this, flushSuccess);
                    this.processEvents(false, true);
                }
            }
            object = this;
            synchronized (object) {
                try {
                    this.doAfterFlush();
                    success = true;
                    boolean bl = anyChanges |= this.maybeApplyDeletes(applyAllDeletes);
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (VirtualMachineError | AbortingException tragedy) {
                        this.tragicEvent(tragedy, "doFlush");
                        boolean bl = false;
                        return bl;
                    }
                }
            }
        }
        finally {
            if (!success && this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception during flush");
            }
        }
    }

    final synchronized boolean maybeApplyDeletes(boolean applyAllDeletes) throws IOException {
        if (applyAllDeletes) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "apply all deletes during flush");
            }
            return this.applyAllDeletesAndUpdates();
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "don't apply deletes now delTermCount=" + this.bufferedUpdatesStream.numTerms() + " bytesUsed=" + this.bufferedUpdatesStream.ramBytesUsed());
        }
        return false;
    }

    final synchronized boolean applyAllDeletesAndUpdates() throws IOException {
        this.flushDeletesCount.incrementAndGet();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "now apply all deletes for all segments maxDoc=" + (this.docWriter.getNumDocs() + this.segmentInfos.totalMaxDoc()));
        }
        BufferedUpdatesStream.ApplyDeletesResult result2 = this.bufferedUpdatesStream.applyDeletesAndUpdates(this.readerPool, this.segmentInfos.asList());
        if (result2.anyDeletes) {
            this.checkpoint();
        }
        if (!this.keepFullyDeletedSegments && result2.allDeleted != null) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "drop 100% deleted segments: " + this.segString(result2.allDeleted));
            }
            for (SegmentCommitInfo info2 : result2.allDeleted) {
                if (this.mergingSegments.contains(info2)) continue;
                this.segmentInfos.remove(info2);
                this.pendingNumDocs.addAndGet(-info2.info.maxDoc());
                this.readerPool.drop(info2);
            }
            this.checkpoint();
        }
        this.bufferedUpdatesStream.prune(this.segmentInfos);
        return result2.anyDeletes;
    }

    DocumentsWriter getDocsWriter() {
        return this.docWriter;
    }

    public final synchronized int numRamDocs() {
        this.ensureOpen();
        return this.docWriter.getNumDocs();
    }

    private synchronized void ensureValidMerge(MergePolicy.OneMerge merge) {
        for (SegmentCommitInfo info2 : merge.segments) {
            if (this.segmentInfos.contains(info2)) continue;
            throw new MergePolicy.MergeException("MergePolicy selected a segment (" + info2.info.name + ") that is not in the current index " + this.segString(), this.directoryOrig);
        }
    }

    private void skipDeletedDoc(DocValuesFieldUpdates.Iterator[] updatesIters, int deletedDoc) {
        for (DocValuesFieldUpdates.Iterator iter2 : updatesIters) {
            if (iter2.doc() == deletedDoc) {
                iter2.nextDoc();
            }
            assert (iter2.doc() > deletedDoc) : "updateDoc=" + iter2.doc() + " deletedDoc=" + deletedDoc;
        }
    }

    private void maybeApplyMergedDVUpdates(MergePolicy.OneMerge merge, MergeState mergeState, int docUpto, MergedDeletesAndUpdates holder, String[] mergingFields, DocValuesFieldUpdates[] dvFieldUpdates, DocValuesFieldUpdates.Iterator[] updatesIters, int curDoc) throws IOException {
        int newDoc = -1;
        for (int idx = 0; idx < mergingFields.length; ++idx) {
            DocValuesFieldUpdates.Iterator updatesIter = updatesIters[idx];
            if (updatesIter.doc() == curDoc) {
                if (holder.mergedDeletesAndUpdates == null) {
                    holder.init(this.readerPool, merge, mergeState, false);
                }
                if (newDoc == -1) {
                    newDoc = holder.docMap.map(docUpto);
                }
                DocValuesFieldUpdates dvUpdates = dvFieldUpdates[idx];
                dvUpdates.add(newDoc, updatesIter.value());
                updatesIter.nextDoc();
                continue;
            }
            assert (updatesIter.doc() > curDoc) : "field=" + mergingFields[idx] + " updateDoc=" + updatesIter.doc() + " curDoc=" + curDoc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ReadersAndUpdates commitMergedDeletesAndUpdates(MergePolicy.OneMerge merge, MergeState mergeState) throws IOException {
        this.testPoint("startCommitMergeDeletes");
        List<SegmentCommitInfo> sourceSegments = merge.segments;
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commitMergeDeletes " + this.segString(merge.segments));
        }
        int docUpto = 0;
        long minGen = Long.MAX_VALUE;
        MergedDeletesAndUpdates holder = new MergedDeletesAndUpdates();
        DocValuesFieldUpdates.Container mergedDVUpdates = new DocValuesFieldUpdates.Container();
        for (int i = 0; i < sourceSegments.size(); ++i) {
            int j;
            DocValuesFieldUpdates[] dvFieldUpdates;
            DocValuesFieldUpdates.Iterator[] updatesIters;
            String[] mergingFields;
            SegmentCommitInfo info2 = sourceSegments.get(i);
            minGen = Math.min(info2.getBufferedDeletesGen(), minGen);
            int maxDoc = info2.info.maxDoc();
            Bits prevLiveDocs = merge.readers.get(i).getLiveDocs();
            ReadersAndUpdates rld = this.readerPool.get(info2, false);
            assert (rld != null) : "seg=" + info2.info.name;
            Bits currentLiveDocs = rld.getLiveDocs();
            Map<String, DocValuesFieldUpdates> mergingFieldUpdates = rld.getMergingFieldUpdates();
            if (mergingFieldUpdates.isEmpty()) {
                mergingFields = null;
                updatesIters = null;
                dvFieldUpdates = null;
            } else {
                mergingFields = new String[mergingFieldUpdates.size()];
                dvFieldUpdates = new DocValuesFieldUpdates[mergingFieldUpdates.size()];
                updatesIters = new DocValuesFieldUpdates.Iterator[mergingFieldUpdates.size()];
                int idx = 0;
                for (Map.Entry<String, DocValuesFieldUpdates> e : mergingFieldUpdates.entrySet()) {
                    String field2 = e.getKey();
                    DocValuesFieldUpdates updates = e.getValue();
                    mergingFields[idx] = field2;
                    dvFieldUpdates[idx] = mergedDVUpdates.getUpdates(field2, updates.type);
                    if (dvFieldUpdates[idx] == null) {
                        dvFieldUpdates[idx] = mergedDVUpdates.newUpdates(field2, updates.type, mergeState.segmentInfo.maxDoc());
                    }
                    updatesIters[idx] = updates.iterator();
                    updatesIters[idx].nextDoc();
                    ++idx;
                }
            }
            if (prevLiveDocs != null) {
                assert (currentLiveDocs != null);
                assert (prevLiveDocs.length() == maxDoc);
                assert (currentLiveDocs.length() == maxDoc);
                if (currentLiveDocs != prevLiveDocs) {
                    for (j = 0; j < maxDoc; ++j) {
                        if (!prevLiveDocs.get(j)) {
                            assert (!currentLiveDocs.get(j));
                            continue;
                        }
                        if (!currentLiveDocs.get(j)) {
                            if (holder.mergedDeletesAndUpdates == null || !holder.initializedWritableLiveDocs) {
                                holder.init(this.readerPool, merge, mergeState, true);
                            }
                            holder.mergedDeletesAndUpdates.delete(holder.docMap.map(docUpto));
                            if (mergingFields != null) {
                                this.skipDeletedDoc(updatesIters, j);
                            }
                        } else if (mergingFields != null) {
                            this.maybeApplyMergedDVUpdates(merge, mergeState, docUpto, holder, mergingFields, dvFieldUpdates, updatesIters, j);
                        }
                        ++docUpto;
                    }
                    continue;
                }
                if (mergingFields != null) {
                    for (j = 0; j < maxDoc; ++j) {
                        if (prevLiveDocs.get(j)) {
                            this.maybeApplyMergedDVUpdates(merge, mergeState, docUpto, holder, mergingFields, dvFieldUpdates, updatesIters, j);
                            ++docUpto;
                            continue;
                        }
                        this.skipDeletedDoc(updatesIters, j);
                    }
                    continue;
                }
                docUpto += info2.info.maxDoc() - info2.getDelCount() - rld.getPendingDeleteCount();
                continue;
            }
            if (currentLiveDocs != null) {
                assert (currentLiveDocs.length() == maxDoc);
                for (j = 0; j < maxDoc; ++j) {
                    if (!currentLiveDocs.get(j)) {
                        if (holder.mergedDeletesAndUpdates == null || !holder.initializedWritableLiveDocs) {
                            holder.init(this.readerPool, merge, mergeState, true);
                        }
                        holder.mergedDeletesAndUpdates.delete(holder.docMap.map(docUpto));
                        if (mergingFields != null) {
                            this.skipDeletedDoc(updatesIters, j);
                        }
                    } else if (mergingFields != null) {
                        this.maybeApplyMergedDVUpdates(merge, mergeState, docUpto, holder, mergingFields, dvFieldUpdates, updatesIters, j);
                    }
                    ++docUpto;
                }
                continue;
            }
            if (mergingFields != null) {
                for (j = 0; j < maxDoc; ++j) {
                    this.maybeApplyMergedDVUpdates(merge, mergeState, docUpto, holder, mergingFields, dvFieldUpdates, updatesIters, j);
                    ++docUpto;
                }
                continue;
            }
            docUpto += info2.info.maxDoc();
        }
        assert (docUpto == merge.info.info.maxDoc());
        if (mergedDVUpdates.any()) {
            boolean success = false;
            try {
                holder.mergedDeletesAndUpdates.writeFieldUpdates(this.directory, mergedDVUpdates);
                success = true;
            }
            finally {
                if (!success) {
                    holder.mergedDeletesAndUpdates.dropChanges();
                    this.readerPool.drop(merge.info);
                }
            }
        }
        if (this.infoStream.isEnabled("IW")) {
            if (holder.mergedDeletesAndUpdates == null) {
                this.infoStream.message("IW", "no new deletes or field updates since merge started");
            } else {
                String msg = holder.mergedDeletesAndUpdates.getPendingDeleteCount() + " new deletes";
                if (mergedDVUpdates.any()) {
                    msg = msg + " and " + mergedDVUpdates.size() + " new field updates";
                }
                msg = msg + " since merge started";
                this.infoStream.message("IW", msg);
            }
        }
        merge.info.setBufferedDeletesGen(minGen);
        return holder.mergedDeletesAndUpdates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean commitMerge(MergePolicy.OneMerge merge, MergeState mergeState) throws IOException {
        boolean dropSegment;
        boolean allDeleted;
        ReadersAndUpdates mergedUpdates;
        this.testPoint("startCommitMerge");
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete merge", this.tragedy);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commitMerge: " + this.segString(merge.segments) + " index=" + this.segString());
        }
        assert (merge.registerDone);
        if (merge.rateLimiter.getAbort()) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commitMerge: skip: it was aborted");
            }
            this.readerPool.drop(merge.info);
            this.deleteNewFiles(merge.info.files());
            return false;
        }
        ReadersAndUpdates readersAndUpdates = mergedUpdates = merge.info.info.maxDoc() == 0 ? null : this.commitMergedDeletesAndUpdates(merge, mergeState);
        assert (!this.segmentInfos.contains(merge.info));
        boolean bl = allDeleted = merge.segments.size() == 0 || merge.info.info.maxDoc() == 0 || mergedUpdates != null && mergedUpdates.getPendingDeleteCount() == merge.info.info.maxDoc();
        if (this.infoStream.isEnabled("IW") && allDeleted) {
            this.infoStream.message("IW", "merged segment " + merge.info + " is 100% deleted" + (this.keepFullyDeletedSegments ? "" : "; skipping insert"));
        }
        boolean bl2 = dropSegment = allDeleted && !this.keepFullyDeletedSegments;
        assert (merge.segments.size() > 0 || dropSegment);
        assert (merge.info.info.maxDoc() != 0 || this.keepFullyDeletedSegments || dropSegment);
        if (mergedUpdates != null) {
            boolean success = false;
            try {
                if (dropSegment) {
                    mergedUpdates.dropChanges();
                }
                this.readerPool.release(mergedUpdates, false);
                success = true;
            }
            finally {
                if (!success) {
                    mergedUpdates.dropChanges();
                    this.readerPool.drop(merge.info);
                }
            }
        }
        this.segmentInfos.applyMergeChanges(merge, dropSegment);
        int delDocCount = merge.totalMaxDoc - merge.info.info.maxDoc();
        assert (delDocCount >= 0);
        this.pendingNumDocs.addAndGet(-delDocCount);
        if (dropSegment) {
            assert (!this.segmentInfos.contains(merge.info));
            this.readerPool.drop(merge.info);
            this.deleteNewFiles(merge.info.files());
        }
        boolean success = false;
        try {
            this.closeMergeReaders(merge, false);
            success = true;
        }
        finally {
            if (success) {
                this.checkpoint();
            } else {
                try {
                    this.checkpoint();
                }
                catch (Throwable t) {}
            }
        }
        this.deleter.deletePendingFiles();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "after commitMerge: " + this.segString());
        }
        if (merge.maxNumSegments != -1 && !dropSegment && !this.segmentsToMerge.containsKey(merge.info)) {
            this.segmentsToMerge.put(merge.info, Boolean.FALSE);
        }
        return true;
    }

    private final void handleMergeException(Throwable t, MergePolicy.OneMerge merge) throws IOException {
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "handleMergeException: merge=" + this.segString(merge.segments) + " exc=" + t);
        }
        merge.setException(t);
        this.addMergeException(merge);
        if (t instanceof MergePolicy.MergeAbortedException) {
            if (merge.isExternal) {
                throw (MergePolicy.MergeAbortedException)t;
            }
        } else {
            IOUtils.reThrow(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(MergePolicy.OneMerge merge) throws IOException {
        boolean success = false;
        this.rateLimiters.set(merge.rateLimiter);
        long t0 = System.currentTimeMillis();
        MergePolicy mergePolicy = this.config.getMergePolicy();
        try {
            try {
                try {
                    this.mergeInit(merge);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "now merge\n  merge=" + this.segString(merge.segments) + "\n  index=" + this.segString());
                    }
                    this.mergeMiddle(merge, mergePolicy);
                    this.mergeSuccess(merge);
                    success = true;
                }
                catch (Throwable t) {
                    this.handleMergeException(t, merge);
                }
            }
            finally {
                IndexWriter t = this;
                synchronized (t) {
                    this.mergeFinish(merge);
                    if (!success) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during merge");
                        }
                    } else if (!(merge.rateLimiter.getAbort() || merge.maxNumSegments == -1 && (this.closed || this.closing))) {
                        this.updatePendingMerges(mergePolicy, MergeTrigger.MERGE_FINISHED, merge.maxNumSegments);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.tragicEvent(t, SOURCE_MERGE);
        }
        if (merge.info != null && !merge.rateLimiter.getAbort() && this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merge time " + (System.currentTimeMillis() - t0) + " msec for " + merge.info.info.maxDoc() + " docs");
        }
    }

    void mergeSuccess(MergePolicy.OneMerge merge) {
    }

    final synchronized boolean registerMerge(MergePolicy.OneMerge merge) throws IOException {
        if (merge.registerDone) {
            return true;
        }
        assert (merge.segments.size() > 0);
        if (this.stopMerges) {
            merge.rateLimiter.setAbort();
            throw new MergePolicy.MergeAbortedException("merge is aborted: " + this.segString(merge.segments));
        }
        boolean isExternal = false;
        for (SegmentCommitInfo info2 : merge.segments) {
            if (this.mergingSegments.contains(info2)) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "reject merge " + this.segString(merge.segments) + ": segment " + this.segString(info2) + " is already marked for merge");
                }
                return false;
            }
            if (!this.segmentInfos.contains(info2)) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "reject merge " + this.segString(merge.segments) + ": segment " + this.segString(info2) + " does not exist in live infos");
                }
                return false;
            }
            if (info2.info.dir != this.directoryOrig) {
                isExternal = true;
            }
            if (!this.segmentsToMerge.containsKey(info2)) continue;
            merge.maxNumSegments = this.mergeMaxNumSegments;
        }
        this.ensureValidMerge(merge);
        this.pendingMerges.add(merge);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "add merge to pendingMerges: " + this.segString(merge.segments) + " [total " + this.pendingMerges.size() + " pending]");
        }
        merge.mergeGen = this.mergeGen;
        merge.isExternal = isExternal;
        if (this.infoStream.isEnabled("IW")) {
            StringBuilder builder = new StringBuilder("registerMerge merging= [");
            for (SegmentCommitInfo info3 : this.mergingSegments) {
                builder.append(info3.info.name).append(", ");
            }
            builder.append("]");
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", builder.toString());
            }
        }
        for (SegmentCommitInfo info2 : merge.segments) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "registerMerge info=" + this.segString(info2));
            }
            this.mergingSegments.add(info2);
        }
        assert (merge.estimatedMergeBytes == 0L);
        assert (merge.totalMergeBytes == 0L);
        for (SegmentCommitInfo info2 : merge.segments) {
            if (info2.info.maxDoc() <= 0) continue;
            int delCount = this.numDeletedDocs(info2);
            assert (delCount <= info2.info.maxDoc());
            double delRatio = (double)delCount / (double)info2.info.maxDoc();
            merge.estimatedMergeBytes = (long)((double)merge.estimatedMergeBytes + (double)info2.sizeInBytes() * (1.0 - delRatio));
            merge.totalMergeBytes += info2.sizeInBytes();
        }
        merge.registerDone = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void mergeInit(MergePolicy.OneMerge merge) throws IOException {
        boolean success = false;
        try {
            this._mergeInit(merge);
            success = true;
        }
        finally {
            if (!success) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception in mergeInit");
                }
                this.mergeFinish(merge);
            }
        }
    }

    private synchronized void _mergeInit(MergePolicy.OneMerge merge) throws IOException {
        this.testPoint("startMergeInit");
        assert (merge.registerDone);
        assert (merge.maxNumSegments == -1 || merge.maxNumSegments > 0);
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot merge", this.tragedy);
        }
        if (merge.info != null) {
            return;
        }
        if (merge.rateLimiter.getAbort()) {
            return;
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "now apply deletes for " + merge.segments.size() + " merging segments");
        }
        BufferedUpdatesStream.ApplyDeletesResult result2 = this.bufferedUpdatesStream.applyDeletesAndUpdates(this.readerPool, merge.segments);
        if (result2.anyDeletes) {
            this.checkpoint();
        }
        if (!this.keepFullyDeletedSegments && result2.allDeleted != null) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "drop 100% deleted segments: " + result2.allDeleted);
            }
            for (SegmentCommitInfo info2 : result2.allDeleted) {
                this.segmentInfos.remove(info2);
                this.pendingNumDocs.addAndGet(-info2.info.maxDoc());
                if (merge.segments.contains(info2)) {
                    this.mergingSegments.remove(info2);
                    merge.segments.remove(info2);
                }
                this.readerPool.drop(info2);
            }
            this.checkpoint();
        }
        String mergeSegmentName = this.newSegmentName();
        SegmentInfo si = new SegmentInfo(this.directoryOrig, Version.LATEST, mergeSegmentName, -1, false, this.codec, Collections.emptyMap(), StringHelper.randomId(), new HashMap<String, String>());
        HashMap<String, String> details2 = new HashMap<String, String>();
        details2.put("mergeMaxNumSegments", "" + merge.maxNumSegments);
        details2.put("mergeFactor", Integer.toString(merge.segments.size()));
        IndexWriter.setDiagnostics(si, SOURCE_MERGE, details2);
        merge.setMergeInfo(new SegmentCommitInfo(si, 0, -1L, -1L, -1L));
        this.bufferedUpdatesStream.prune(this.segmentInfos);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merge seg=" + merge.info.info.name + " " + this.segString(merge.segments));
        }
    }

    static void setDiagnostics(SegmentInfo info2, String source) {
        IndexWriter.setDiagnostics(info2, source, null);
    }

    private static void setDiagnostics(SegmentInfo info2, String source, Map<String, String> details2) {
        HashMap<String, String> diagnostics = new HashMap<String, String>();
        diagnostics.put(SOURCE, source);
        diagnostics.put("lucene.version", Version.LATEST.toString());
        diagnostics.put("os", Constants.OS_NAME);
        diagnostics.put("os.arch", Constants.OS_ARCH);
        diagnostics.put("os.version", Constants.OS_VERSION);
        diagnostics.put("java.version", Constants.JAVA_VERSION);
        diagnostics.put("java.vendor", Constants.JAVA_VENDOR);
        diagnostics.put("java.runtime.version", System.getProperty("java.runtime.version", "undefined"));
        diagnostics.put("java.vm.version", System.getProperty("java.vm.version", "undefined"));
        diagnostics.put("timestamp", Long.toString(new Date().getTime()));
        if (details2 != null) {
            diagnostics.putAll(details2);
        }
        info2.setDiagnostics(diagnostics);
    }

    final synchronized void mergeFinish(MergePolicy.OneMerge merge) {
        this.notifyAll();
        if (merge.registerDone) {
            List<SegmentCommitInfo> sourceSegments = merge.segments;
            for (SegmentCommitInfo info2 : sourceSegments) {
                this.mergingSegments.remove(info2);
            }
            merge.registerDone = false;
        }
        this.runningMerges.remove(merge);
    }

    private final synchronized void closeMergeReaders(MergePolicy.OneMerge merge, boolean suppressExceptions) throws IOException {
        Throwable th;
        block11: {
            int numSegments = merge.readers.size();
            th = null;
            boolean drop2 = !suppressExceptions;
            for (int i = 0; i < numSegments; ++i) {
                block10: {
                    SegmentReader sr = merge.readers.get(i);
                    if (sr == null) continue;
                    try {
                        ReadersAndUpdates rld = this.readerPool.get(sr.getSegmentInfo(), false);
                        assert (rld != null);
                        if (drop2) {
                            rld.dropChanges();
                        } else {
                            rld.dropMergingUpdates();
                        }
                        rld.release(sr);
                        this.readerPool.release(rld);
                        if (drop2) {
                            this.readerPool.drop(rld.info);
                        }
                    }
                    catch (Throwable t) {
                        if (th != null) break block10;
                        th = t;
                    }
                }
                merge.readers.set(i, null);
            }
            try {
                merge.mergeFinished();
            }
            catch (Throwable t) {
                if (th != null) break block11;
                th = t;
            }
        }
        if (!suppressExceptions) {
            IOUtils.reThrow(th);
        }
    }

    /*
     * Exception decompiling
     */
    private int mergeMiddle(MergePolicy.OneMerge merge, MergePolicy mergePolicy) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[MONITOR]], but top level block is 9[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    synchronized void addMergeException(MergePolicy.OneMerge merge) {
        assert (merge.getException() != null);
        if (!this.mergeExceptions.contains(merge) && this.mergeGen == merge.mergeGen) {
            this.mergeExceptions.add(merge);
        }
    }

    final int getBufferedDeleteTermsSize() {
        return this.docWriter.getBufferedDeleteTermsSize();
    }

    final int getNumBufferedDeleteTerms() {
        return this.docWriter.getNumBufferedDeleteTerms();
    }

    synchronized SegmentCommitInfo newestSegment() {
        return this.segmentInfos.size() > 0 ? this.segmentInfos.info(this.segmentInfos.size() - 1) : null;
    }

    synchronized String segString() {
        return this.segString(this.segmentInfos);
    }

    synchronized String segString(Iterable<SegmentCommitInfo> infos) {
        StringBuilder buffer = new StringBuilder();
        for (SegmentCommitInfo info2 : infos) {
            if (buffer.length() > 0) {
                buffer.append(' ');
            }
            buffer.append(this.segString(info2));
        }
        return buffer.toString();
    }

    synchronized String segString(SegmentCommitInfo info2) {
        return info2.toString(this.numDeletedDocs(info2) - info2.getDelCount());
    }

    private synchronized void doWait() {
        try {
            this.wait(1000L);
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException(ie);
        }
    }

    void setKeepFullyDeletedSegments(boolean v) {
        this.keepFullyDeletedSegments = v;
    }

    boolean getKeepFullyDeletedSegments() {
        return this.keepFullyDeletedSegments;
    }

    private boolean filesExist(SegmentInfos toSync) throws IOException {
        Collection<String> files2 = toSync.files(false);
        for (String fileName : files2) {
            assert (IndexWriter.slowFileExists(this.directory, fileName)) : "file " + fileName + " does not exist; files=" + Arrays.toString(this.directory.listAll());
            assert (this.deleter.exists(fileName)) : "IndexFileDeleter doesn't know about file " + fileName;
        }
        return true;
    }

    synchronized SegmentInfos toLiveInfos(SegmentInfos sis) {
        SegmentInfos newSIS = new SegmentInfos();
        HashMap<SegmentCommitInfo, SegmentCommitInfo> liveSIS = new HashMap<SegmentCommitInfo, SegmentCommitInfo>();
        for (SegmentCommitInfo info2 : this.segmentInfos) {
            liveSIS.put(info2, info2);
        }
        for (SegmentCommitInfo info2 : sis) {
            SegmentCommitInfo liveInfo = (SegmentCommitInfo)liveSIS.get(info2);
            if (liveInfo != null) {
                info2 = liveInfo;
            }
            newSIS.add(info2);
        }
        return newSIS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCommit(SegmentInfos toSync) throws IOException {
        this.testPoint("startStartCommit");
        assert (this.pendingCommit == null);
        if (this.tragedy != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot commit", this.tragedy);
        }
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "startCommit(): start");
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.lastCommitChangeCount > this.changeCount.get()) {
                    throw new IllegalStateException("lastCommitChangeCount=" + this.lastCommitChangeCount + ",changeCount=" + this.changeCount);
                }
                if (this.pendingCommitChangeCount == this.lastCommitChangeCount) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "  skip startCommit(): no changes pending");
                    }
                    try {
                        this.deleter.decRef(this.filesToCommit);
                    }
                    finally {
                        this.filesToCommit = null;
                    }
                    return;
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "startCommit index=" + this.segString(this.toLiveInfos(toSync)) + " changeCount=" + this.changeCount);
                }
                assert (this.filesExist(toSync));
            }
            this.testPoint("midStartCommit");
            boolean pendingCommitSet = false;
            try {
                Collection<String> filesToSync;
                this.testPoint("midStartCommit2");
                IndexWriter indexWriter2 = this;
                synchronized (indexWriter2) {
                    assert (this.pendingCommit == null);
                    assert (this.segmentInfos.getGeneration() == toSync.getGeneration());
                    toSync.prepareCommit(this.directory);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "startCommit: wrote pending segments file \"" + IndexFileNames.fileNameFromGeneration("pending_segments", "", toSync.getGeneration()) + "\"");
                    }
                    pendingCommitSet = true;
                    this.pendingCommit = toSync;
                }
                boolean success = false;
                try {
                    filesToSync = toSync.files(false);
                    this.directory.sync(filesToSync);
                    success = true;
                }
                finally {
                    if (!success) {
                        pendingCommitSet = false;
                        this.pendingCommit = null;
                        toSync.rollbackCommit(this.directory);
                    }
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "done all syncs: " + filesToSync);
                }
                this.testPoint("midStartCommitSuccess");
            }
            finally {
                IndexWriter indexWriter3 = this;
                synchronized (indexWriter3) {
                    this.segmentInfos.updateGeneration(toSync);
                    if (!pendingCommitSet) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception committing segments file");
                        }
                        this.deleter.decRefWhileHandlingException(this.filesToCommit);
                        this.filesToCommit = null;
                    }
                }
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "startCommit");
        }
        this.testPoint("finishStartCommit");
    }

    @Deprecated
    public static boolean isLocked(Directory directory) throws IOException {
        try {
            directory.obtainLock(WRITE_LOCK_NAME).close();
            return false;
        }
        catch (LockObtainFailedException failed2) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tragicEvent(Throwable tragedy, String location) throws IOException {
        if (tragedy instanceof AbortingException) {
            tragedy = tragedy.getCause();
        }
        assert (!(tragedy instanceof MergePolicy.MergeAbortedException));
        assert (!Thread.holdsLock(this));
        assert (tragedy != null);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "hit tragic " + tragedy.getClass().getSimpleName() + " inside " + location);
        }
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            if (this.tragedy != null) {
                IOUtils.reThrow(tragedy);
            }
            this.tragedy = tragedy;
        }
        if (this.shouldClose(false)) {
            this.rollbackInternal();
        }
        IOUtils.reThrow(tragedy);
    }

    public Throwable getTragicException() {
        return this.tragedy;
    }

    public boolean isOpen() {
        return !this.closing && !this.closed;
    }

    private final void testPoint(String message) {
        if (this.enableTestPoints) {
            assert (this.infoStream.isEnabled("TP"));
            this.infoStream.message("TP", message);
        }
    }

    synchronized boolean nrtIsCurrent(SegmentInfos infos) {
        boolean isCurrent;
        this.ensureOpen();
        boolean bl = isCurrent = infos.version == this.segmentInfos.version && !this.docWriter.anyChanges() && !this.bufferedUpdatesStream.any();
        if (this.infoStream.isEnabled("IW") && !isCurrent) {
            this.infoStream.message("IW", "nrtIsCurrent: infoVersion matches: " + (infos.version == this.segmentInfos.version) + "; DW changes: " + this.docWriter.anyChanges() + "; BD changes: " + this.bufferedUpdatesStream.any());
        }
        return isCurrent;
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void deleteUnusedFiles() throws IOException {
        this.ensureOpen(false);
        this.deleter.deletePendingFiles();
        this.deleter.revisitPolicy();
    }

    private synchronized void deletePendingFiles() throws IOException {
        this.deleter.deletePendingFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void createCompoundFile(InfoStream infoStream, TrackingDirectoryWrapper directory, SegmentInfo info2, IOContext context) throws IOException {
        if (!directory.getCreatedFiles().isEmpty()) {
            throw new IllegalStateException("pass a clean trackingdir for CFS creation");
        }
        if (infoStream.isEnabled("IW")) {
            infoStream.message("IW", "create compound file");
        }
        boolean success = false;
        try {
            info2.getCodec().compoundFormat().write(directory, info2, context);
            success = true;
        }
        finally {
            if (!success) {
                this.deleteNewFiles(directory.getCreatedFiles());
            }
        }
        info2.setFiles(new HashSet<String>(directory.getCreatedFiles()));
    }

    final synchronized void deleteNewFiles(Collection<String> files2) throws IOException {
        this.deleter.deleteNewFiles(files2);
    }

    final synchronized void flushFailed(SegmentInfo info2) throws IOException {
        Set<String> files2;
        try {
            files2 = info2.files();
        }
        catch (IllegalStateException ise) {
            files2 = null;
        }
        if (files2 != null) {
            this.deleter.deleteNewFiles(files2);
        }
    }

    final int purge(boolean forced) throws IOException {
        return this.docWriter.purgeBuffer(this, forced);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void applyDeletesAndPurge(boolean forcePurge) throws IOException {
        try {
            this.purge(forcePurge);
        }
        finally {
            if (this.applyAllDeletesAndUpdates()) {
                this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.SEGMENT_FLUSH, -1);
            }
            this.flushCount.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void doAfterSegmentFlushed(boolean triggerMerge, boolean forcePurge) throws IOException {
        try {
            this.purge(forcePurge);
        }
        finally {
            if (triggerMerge) {
                this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.SEGMENT_FLUSH, -1);
            }
        }
    }

    synchronized void incRefDeleter(SegmentInfos segmentInfos) throws IOException {
        this.ensureOpen();
        this.deleter.incRef(segmentInfos, false);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "incRefDeleter for NRT reader version=" + segmentInfos.getVersion() + " segments=" + this.segString(segmentInfos));
        }
    }

    synchronized void decRefDeleter(SegmentInfos segmentInfos) throws IOException {
        this.ensureOpen();
        this.deleter.decRef(segmentInfos);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "decRefDeleter for NRT reader version=" + segmentInfos.getVersion() + " segments=" + this.segString(segmentInfos));
        }
    }

    private boolean processEvents(boolean triggerMerge, boolean forcePurge) throws IOException {
        return this.processEvents(this.eventQueue, triggerMerge, forcePurge);
    }

    private boolean processEvents(Queue<Event> queue, boolean triggerMerge, boolean forcePurge) throws IOException {
        boolean processed = false;
        if (this.tragedy == null) {
            Event event;
            while ((event = queue.poll()) != null) {
                processed = true;
                event.process(this, triggerMerge, forcePurge);
            }
        }
        return processed;
    }

    static boolean slowFileExists(Directory dir, String fileName) throws IOException {
        try {
            dir.openInput(fileName, IOContext.DEFAULT).close();
            return true;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return false;
        }
    }

    private void reserveDocs(long addedNumDocs) {
        assert (addedNumDocs >= 0L);
        if (this.pendingNumDocs.addAndGet(addedNumDocs) > (long)actualMaxDocs) {
            this.pendingNumDocs.addAndGet(-addedNumDocs);
            this.tooManyDocs(addedNumDocs);
        }
    }

    private void testReserveDocs(long addedNumDocs) {
        assert (addedNumDocs >= 0L);
        if (this.pendingNumDocs.get() + addedNumDocs > (long)actualMaxDocs) {
            this.tooManyDocs(addedNumDocs);
        }
    }

    private void tooManyDocs(long addedNumDocs) {
        assert (addedNumDocs >= 0L);
        throw new IllegalArgumentException("number of documents in the index cannot exceed " + actualMaxDocs + " (current document count is " + this.pendingNumDocs.get() + "; added numDocs is " + addedNumDocs + ")");
    }

    private Directory addMergeRateLimiters(Directory in2) {
        return new FilterDirectory(in2){

            @Override
            public IndexOutput createOutput(String name2, IOContext context) throws IOException {
                this.ensureOpen();
                IndexWriter.this.ensureOpen(false);
                assert (context.context == IOContext.Context.MERGE) : "got context=" + (Object)((Object)context.context);
                MergeRateLimiter rateLimiter = IndexWriter.this.rateLimiters.get();
                assert (rateLimiter != null);
                return new RateLimitedIndexOutput(rateLimiter, this.in.createOutput(name2, context));
            }
        };
    }

    static interface Event {
        public void process(IndexWriter var1, boolean var2, boolean var3) throws IOException;
    }

    public static abstract class IndexReaderWarmer {
        protected IndexReaderWarmer() {
        }

        public abstract void warm(LeafReader var1) throws IOException;
    }

    private static class MergedDeletesAndUpdates {
        ReadersAndUpdates mergedDeletesAndUpdates = null;
        MergePolicy.DocMap docMap = null;
        boolean initializedWritableLiveDocs = false;

        MergedDeletesAndUpdates() {
        }

        final void init(ReaderPool readerPool, MergePolicy.OneMerge merge, MergeState mergeState, boolean initWritableLiveDocs) throws IOException {
            if (this.mergedDeletesAndUpdates == null) {
                this.mergedDeletesAndUpdates = readerPool.get(merge.info, true);
                this.docMap = merge.getDocMap(mergeState);
                assert (this.docMap.isConsistent(merge.info.info.maxDoc()));
            }
            if (initWritableLiveDocs && !this.initializedWritableLiveDocs) {
                this.mergedDeletesAndUpdates.initWritableLiveDocs();
                this.initializedWritableLiveDocs = true;
            }
        }
    }

    class ReaderPool
    implements Closeable {
        private final Map<SegmentCommitInfo, ReadersAndUpdates> readerMap = new HashMap<SegmentCommitInfo, ReadersAndUpdates>();

        ReaderPool() {
        }

        public synchronized boolean infoIsLive(SegmentCommitInfo info2) {
            int idx = IndexWriter.this.segmentInfos.indexOf(info2);
            assert (idx != -1) : "info=" + info2 + " isn't live";
            assert (IndexWriter.this.segmentInfos.info(idx) == info2) : "info=" + info2 + " doesn't match live info in segmentInfos";
            return true;
        }

        public synchronized void drop(SegmentCommitInfo info2) throws IOException {
            ReadersAndUpdates rld = this.readerMap.get(info2);
            if (rld != null) {
                assert (info2 == rld.info);
                this.readerMap.remove(info2);
                rld.dropReaders();
            }
        }

        public synchronized boolean anyPendingDeletes() {
            for (ReadersAndUpdates rld : this.readerMap.values()) {
                if (rld.getPendingDeleteCount() == 0) continue;
                return true;
            }
            return false;
        }

        public synchronized void release(ReadersAndUpdates rld) throws IOException {
            this.release(rld, true);
        }

        public synchronized void release(ReadersAndUpdates rld, boolean assertInfoLive) throws IOException {
            rld.decRef();
            assert (rld.refCount() >= 1);
            if (!IndexWriter.this.poolReaders && rld.refCount() == 1) {
                if (rld.writeLiveDocs(IndexWriter.this.directory)) {
                    assert (!assertInfoLive || this.infoIsLive(rld.info));
                    IndexWriter.this.checkpointNoSIS();
                }
                rld.dropReaders();
                this.readerMap.remove(rld.info);
            }
        }

        @Override
        public void close() throws IOException {
            this.dropAll(false);
        }

        synchronized void dropAll(boolean doSave) throws IOException {
            Throwable priorE = null;
            Iterator<Map.Entry<SegmentCommitInfo, ReadersAndUpdates>> it = this.readerMap.entrySet().iterator();
            while (it.hasNext()) {
                ReadersAndUpdates rld;
                block10: {
                    rld = it.next().getValue();
                    try {
                        if (doSave && rld.writeLiveDocs(IndexWriter.this.directory)) {
                            assert (this.infoIsLive(rld.info));
                            IndexWriter.this.checkpointNoSIS();
                        }
                    }
                    catch (Throwable t) {
                        if (doSave) {
                            IOUtils.reThrow(t);
                        }
                        if (priorE != null) break block10;
                        priorE = t;
                    }
                }
                it.remove();
                try {
                    rld.dropReaders();
                }
                catch (Throwable t) {
                    if (doSave) {
                        IOUtils.reThrow(t);
                        continue;
                    }
                    if (priorE != null) continue;
                    priorE = t;
                }
            }
            assert (this.readerMap.size() == 0);
            IOUtils.reThrow(priorE);
        }

        public synchronized void commit(SegmentInfos infos) throws IOException {
            for (SegmentCommitInfo info2 : infos) {
                ReadersAndUpdates rld = this.readerMap.get(info2);
                if (rld == null) continue;
                assert (rld.info == info2);
                if (!rld.writeLiveDocs(IndexWriter.this.directory)) continue;
                assert (this.infoIsLive(info2));
                IndexWriter.this.checkpointNoSIS();
            }
        }

        public synchronized ReadersAndUpdates get(SegmentCommitInfo info2, boolean create) {
            IndexWriter.this.ensureOpen(false);
            assert (info2.info.dir == IndexWriter.this.directoryOrig) : "info.dir=" + info2.info.dir + " vs " + IndexWriter.access$200(IndexWriter.this);
            ReadersAndUpdates rld = this.readerMap.get(info2);
            if (rld == null) {
                if (!create) {
                    return null;
                }
                rld = new ReadersAndUpdates(IndexWriter.this, info2);
                this.readerMap.put(info2, rld);
            } else assert (rld.info == info2) : "rld.info=" + rld.info + " info=" + info2 + " isLive?=" + this.infoIsLive(rld.info) + " vs " + this.infoIsLive(info2);
            if (create) {
                rld.incRef();
            }
            assert (this.noDups());
            return rld;
        }

        private boolean noDups() {
            HashSet<String> seen = new HashSet<String>();
            for (SegmentCommitInfo info2 : this.readerMap.keySet()) {
                assert (!seen.contains(info2.info.name));
                seen.add(info2.info.name);
            }
            return true;
        }
    }
}

