/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.CompositeReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;

public final class CompositeReaderContext
extends IndexReaderContext {
    private final List<IndexReaderContext> children;
    private final List<LeafReaderContext> leaves;
    private final CompositeReader reader;

    static CompositeReaderContext create(CompositeReader reader) {
        return new Builder(reader).build();
    }

    CompositeReaderContext(CompositeReaderContext parent2, CompositeReader reader, int ordInParent, int docbaseInParent, List<IndexReaderContext> children2) {
        this(parent2, reader, ordInParent, docbaseInParent, children2, null);
    }

    CompositeReaderContext(CompositeReader reader, List<IndexReaderContext> children2, List<LeafReaderContext> leaves2) {
        this(null, reader, 0, 0, children2, leaves2);
    }

    private CompositeReaderContext(CompositeReaderContext parent2, CompositeReader reader, int ordInParent, int docbaseInParent, List<IndexReaderContext> children2, List<LeafReaderContext> leaves2) {
        super(parent2, ordInParent, docbaseInParent);
        this.children = Collections.unmodifiableList(children2);
        this.leaves = leaves2 == null ? null : Collections.unmodifiableList(leaves2);
        this.reader = reader;
    }

    @Override
    public List<LeafReaderContext> leaves() throws UnsupportedOperationException {
        if (!this.isTopLevel) {
            throw new UnsupportedOperationException("This is not a top-level context.");
        }
        assert (this.leaves != null);
        return this.leaves;
    }

    @Override
    public List<IndexReaderContext> children() {
        return this.children;
    }

    @Override
    public CompositeReader reader() {
        return this.reader;
    }

    private static final class Builder {
        private final CompositeReader reader;
        private final List<LeafReaderContext> leaves = new ArrayList<LeafReaderContext>();
        private int leafDocBase = 0;

        public Builder(CompositeReader reader) {
            this.reader = reader;
        }

        public CompositeReaderContext build() {
            return (CompositeReaderContext)this.build(null, this.reader, 0, 0);
        }

        private IndexReaderContext build(CompositeReaderContext parent2, IndexReader reader, int ord, int docBase) {
            if (reader instanceof LeafReader) {
                LeafReader ar = (LeafReader)reader;
                LeafReaderContext atomic = new LeafReaderContext(parent2, ar, ord, docBase, this.leaves.size(), this.leafDocBase);
                this.leaves.add(atomic);
                this.leafDocBase += reader.maxDoc();
                return atomic;
            }
            CompositeReader cr = (CompositeReader)reader;
            List<? extends IndexReader> sequentialSubReaders = cr.getSequentialSubReaders();
            List<IndexReaderContext> children2 = Arrays.asList(new IndexReaderContext[sequentialSubReaders.size()]);
            CompositeReaderContext newParent = parent2 == null ? new CompositeReaderContext(cr, children2, this.leaves) : new CompositeReaderContext(parent2, cr, ord, docBase, children2);
            int newDocBase = 0;
            int c = sequentialSubReaders.size();
            for (int i = 0; i < c; ++i) {
                IndexReader r = sequentialSubReaders.get(i);
                children2.set(i, this.build(newParent, r, i, newDocBase));
                newDocBase += r.maxDoc();
            }
            assert (newDocBase == cr.maxDoc());
            return newParent;
        }
    }
}

