/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.RamUsageEstimator;

class BufferedUpdates {
    static final int BYTES_PER_DEL_TERM = 9 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 7 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 40;
    static final int BYTES_PER_DEL_DOCID = 2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4;
    static final int BYTES_PER_DEL_QUERY = 5 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 2 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 8 + 24;
    static final int BYTES_PER_NUMERIC_FIELD_ENTRY = 7 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 3 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 20 + 4;
    static final int BYTES_PER_NUMERIC_UPDATE_ENTRY = 7 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4;
    static final int BYTES_PER_BINARY_FIELD_ENTRY = 7 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + 3 * RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + 20 + 4;
    static final int BYTES_PER_BINARY_UPDATE_ENTRY = 7 * RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 4;
    final AtomicInteger numTermDeletes = new AtomicInteger();
    final AtomicInteger numNumericUpdates = new AtomicInteger();
    final AtomicInteger numBinaryUpdates = new AtomicInteger();
    final Map<Term, Integer> terms = new HashMap<Term, Integer>();
    final Map<Query, Integer> queries = new HashMap<Query, Integer>();
    final List<Integer> docIDs = new ArrayList<Integer>();
    final Map<String, LinkedHashMap<Term, DocValuesUpdate.NumericDocValuesUpdate>> numericUpdates = new HashMap<String, LinkedHashMap<Term, DocValuesUpdate.NumericDocValuesUpdate>>();
    final Map<String, LinkedHashMap<Term, DocValuesUpdate.BinaryDocValuesUpdate>> binaryUpdates = new HashMap<String, LinkedHashMap<Term, DocValuesUpdate.BinaryDocValuesUpdate>>();
    public static final Integer MAX_INT = Integer.MAX_VALUE;
    final AtomicLong bytesUsed = new AtomicLong();
    private static final boolean VERBOSE_DELETES = false;
    long gen;

    public String toString() {
        String s2 = "gen=" + this.gen;
        if (this.numTermDeletes.get() != 0) {
            s2 = s2 + " " + this.numTermDeletes.get() + " deleted terms (unique count=" + this.terms.size() + ")";
        }
        if (this.queries.size() != 0) {
            s2 = s2 + " " + this.queries.size() + " deleted queries";
        }
        if (this.docIDs.size() != 0) {
            s2 = s2 + " " + this.docIDs.size() + " deleted docIDs";
        }
        if (this.numNumericUpdates.get() != 0) {
            s2 = s2 + " " + this.numNumericUpdates.get() + " numeric updates (unique count=" + this.numericUpdates.size() + ")";
        }
        if (this.numBinaryUpdates.get() != 0) {
            s2 = s2 + " " + this.numBinaryUpdates.get() + " binary updates (unique count=" + this.binaryUpdates.size() + ")";
        }
        if (this.bytesUsed.get() != 0L) {
            s2 = s2 + " bytesUsed=" + this.bytesUsed.get();
        }
        return s2;
    }

    public void addQuery(Query query, int docIDUpto) {
        Integer current = this.queries.put(query, docIDUpto);
        if (current == null) {
            this.bytesUsed.addAndGet(BYTES_PER_DEL_QUERY);
        }
    }

    public void addDocID(int docID) {
        this.docIDs.add(docID);
        this.bytesUsed.addAndGet(BYTES_PER_DEL_DOCID);
    }

    public void addTerm(Term term, int docIDUpto) {
        Integer current = this.terms.get(term);
        if (current != null && docIDUpto < current) {
            return;
        }
        this.terms.put(term, docIDUpto);
        this.numTermDeletes.incrementAndGet();
        if (current == null) {
            this.bytesUsed.addAndGet(BYTES_PER_DEL_TERM + term.bytes.length + 2 * term.field().length());
        }
    }

    public void addNumericUpdate(DocValuesUpdate.NumericDocValuesUpdate update2, int docIDUpto) {
        DocValuesUpdate.NumericDocValuesUpdate current;
        LinkedHashMap<Term, DocValuesUpdate.NumericDocValuesUpdate> fieldUpdates = this.numericUpdates.get(update2.field);
        if (fieldUpdates == null) {
            fieldUpdates = new LinkedHashMap();
            this.numericUpdates.put(update2.field, fieldUpdates);
            this.bytesUsed.addAndGet(BYTES_PER_NUMERIC_FIELD_ENTRY);
        }
        if ((current = fieldUpdates.get(update2.term)) != null && docIDUpto < current.docIDUpto) {
            return;
        }
        update2.docIDUpto = docIDUpto;
        if (current != null) {
            fieldUpdates.remove(update2.term);
        }
        fieldUpdates.put(update2.term, update2);
        this.numNumericUpdates.incrementAndGet();
        if (current == null) {
            this.bytesUsed.addAndGet(BYTES_PER_NUMERIC_UPDATE_ENTRY + update2.sizeInBytes());
        }
    }

    public void addBinaryUpdate(DocValuesUpdate.BinaryDocValuesUpdate update2, int docIDUpto) {
        DocValuesUpdate.BinaryDocValuesUpdate current;
        LinkedHashMap<Term, DocValuesUpdate.BinaryDocValuesUpdate> fieldUpdates = this.binaryUpdates.get(update2.field);
        if (fieldUpdates == null) {
            fieldUpdates = new LinkedHashMap();
            this.binaryUpdates.put(update2.field, fieldUpdates);
            this.bytesUsed.addAndGet(BYTES_PER_BINARY_FIELD_ENTRY);
        }
        if ((current = fieldUpdates.get(update2.term)) != null && docIDUpto < current.docIDUpto) {
            return;
        }
        update2.docIDUpto = docIDUpto;
        if (current != null) {
            fieldUpdates.remove(update2.term);
        }
        fieldUpdates.put(update2.term, update2);
        this.numBinaryUpdates.incrementAndGet();
        if (current == null) {
            this.bytesUsed.addAndGet(BYTES_PER_BINARY_UPDATE_ENTRY + update2.sizeInBytes());
        }
    }

    void clear() {
        this.terms.clear();
        this.queries.clear();
        this.docIDs.clear();
        this.numericUpdates.clear();
        this.binaryUpdates.clear();
        this.numTermDeletes.set(0);
        this.numNumericUpdates.set(0);
        this.numBinaryUpdates.set(0);
        this.bytesUsed.set(0L);
    }

    boolean any() {
        return this.terms.size() > 0 || this.docIDs.size() > 0 || this.queries.size() > 0 || this.numericUpdates.size() > 0 || this.binaryUpdates.size() > 0;
    }
}

