/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;

public class FieldType
implements IndexableFieldType {
    private boolean stored;
    private boolean tokenized = true;
    private boolean storeTermVectors;
    private boolean storeTermVectorOffsets;
    private boolean storeTermVectorPositions;
    private boolean storeTermVectorPayloads;
    private boolean omitNorms;
    private IndexOptions indexOptions = IndexOptions.NONE;
    private NumericType numericType;
    private boolean frozen;
    private int numericPrecisionStep = 16;
    private DocValuesType docValuesType = DocValuesType.NONE;

    public FieldType(FieldType ref) {
        this.stored = ref.stored();
        this.tokenized = ref.tokenized();
        this.storeTermVectors = ref.storeTermVectors();
        this.storeTermVectorOffsets = ref.storeTermVectorOffsets();
        this.storeTermVectorPositions = ref.storeTermVectorPositions();
        this.storeTermVectorPayloads = ref.storeTermVectorPayloads();
        this.omitNorms = ref.omitNorms();
        this.indexOptions = ref.indexOptions();
        this.numericType = ref.numericType();
        this.numericPrecisionStep = ref.numericPrecisionStep();
        this.docValuesType = ref.docValuesType();
    }

    public FieldType() {
    }

    protected void checkIfFrozen() {
        if (this.frozen) {
            throw new IllegalStateException("this FieldType is already frozen and cannot be changed");
        }
    }

    public void freeze() {
        this.frozen = true;
    }

    @Override
    public boolean stored() {
        return this.stored;
    }

    public void setStored(boolean value) {
        this.checkIfFrozen();
        this.stored = value;
    }

    @Override
    public boolean tokenized() {
        return this.tokenized;
    }

    public void setTokenized(boolean value) {
        this.checkIfFrozen();
        this.tokenized = value;
    }

    @Override
    public boolean storeTermVectors() {
        return this.storeTermVectors;
    }

    public void setStoreTermVectors(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectors = value;
    }

    @Override
    public boolean storeTermVectorOffsets() {
        return this.storeTermVectorOffsets;
    }

    public void setStoreTermVectorOffsets(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorOffsets = value;
    }

    @Override
    public boolean storeTermVectorPositions() {
        return this.storeTermVectorPositions;
    }

    public void setStoreTermVectorPositions(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorPositions = value;
    }

    @Override
    public boolean storeTermVectorPayloads() {
        return this.storeTermVectorPayloads;
    }

    public void setStoreTermVectorPayloads(boolean value) {
        this.checkIfFrozen();
        this.storeTermVectorPayloads = value;
    }

    @Override
    public boolean omitNorms() {
        return this.omitNorms;
    }

    public void setOmitNorms(boolean value) {
        this.checkIfFrozen();
        this.omitNorms = value;
    }

    @Override
    public IndexOptions indexOptions() {
        return this.indexOptions;
    }

    public void setIndexOptions(IndexOptions value) {
        this.checkIfFrozen();
        if (value == null) {
            throw new NullPointerException("IndexOptions cannot be null");
        }
        this.indexOptions = value;
    }

    public void setNumericType(NumericType type) {
        this.checkIfFrozen();
        this.numericType = type;
    }

    public NumericType numericType() {
        return this.numericType;
    }

    public void setNumericPrecisionStep(int precisionStep) {
        this.checkIfFrozen();
        if (precisionStep < 1) {
            throw new IllegalArgumentException("precisionStep must be >= 1 (got " + precisionStep + ")");
        }
        this.numericPrecisionStep = precisionStep;
    }

    public int numericPrecisionStep() {
        return this.numericPrecisionStep;
    }

    public final String toString() {
        StringBuilder result2 = new StringBuilder();
        if (this.stored()) {
            result2.append("stored");
        }
        if (this.indexOptions != IndexOptions.NONE) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("indexed");
            if (this.tokenized()) {
                result2.append(",tokenized");
            }
            if (this.storeTermVectors()) {
                result2.append(",termVector");
            }
            if (this.storeTermVectorOffsets()) {
                result2.append(",termVectorOffsets");
            }
            if (this.storeTermVectorPositions()) {
                result2.append(",termVectorPosition");
            }
            if (this.storeTermVectorPayloads()) {
                result2.append(",termVectorPayloads");
            }
            if (this.omitNorms()) {
                result2.append(",omitNorms");
            }
            if (this.indexOptions != IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) {
                result2.append(",indexOptions=");
                result2.append((Object)this.indexOptions);
            }
            if (this.numericType != null) {
                result2.append(",numericType=");
                result2.append((Object)this.numericType);
                result2.append(",numericPrecisionStep=");
                result2.append(this.numericPrecisionStep);
            }
        }
        if (this.docValuesType != DocValuesType.NONE) {
            if (result2.length() > 0) {
                result2.append(",");
            }
            result2.append("docValuesType=");
            result2.append((Object)this.docValuesType);
        }
        return result2.toString();
    }

    @Override
    public DocValuesType docValuesType() {
        return this.docValuesType;
    }

    public void setDocValuesType(DocValuesType type) {
        this.checkIfFrozen();
        if (type == null) {
            throw new NullPointerException("DocValuesType cannot be null");
        }
        this.docValuesType = type;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.docValuesType == null ? 0 : this.docValuesType.hashCode());
        result2 = 31 * result2 + this.indexOptions.hashCode();
        result2 = 31 * result2 + this.numericPrecisionStep;
        result2 = 31 * result2 + (this.numericType == null ? 0 : this.numericType.hashCode());
        result2 = 31 * result2 + (this.omitNorms ? 1231 : 1237);
        result2 = 31 * result2 + (this.storeTermVectorOffsets ? 1231 : 1237);
        result2 = 31 * result2 + (this.storeTermVectorPayloads ? 1231 : 1237);
        result2 = 31 * result2 + (this.storeTermVectorPositions ? 1231 : 1237);
        result2 = 31 * result2 + (this.storeTermVectors ? 1231 : 1237);
        result2 = 31 * result2 + (this.stored ? 1231 : 1237);
        result2 = 31 * result2 + (this.tokenized ? 1231 : 1237);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldType other2 = (FieldType)obj;
        if (this.docValuesType != other2.docValuesType) {
            return false;
        }
        if (this.indexOptions != other2.indexOptions) {
            return false;
        }
        if (this.numericPrecisionStep != other2.numericPrecisionStep) {
            return false;
        }
        if (this.numericType != other2.numericType) {
            return false;
        }
        if (this.omitNorms != other2.omitNorms) {
            return false;
        }
        if (this.storeTermVectorOffsets != other2.storeTermVectorOffsets) {
            return false;
        }
        if (this.storeTermVectorPayloads != other2.storeTermVectorPayloads) {
            return false;
        }
        if (this.storeTermVectorPositions != other2.storeTermVectorPositions) {
            return false;
        }
        if (this.storeTermVectors != other2.storeTermVectors) {
            return false;
        }
        if (this.stored != other2.stored) {
            return false;
        }
        return this.tokenized == other2.tokenized;
    }

    public static enum NumericType {
        INT,
        LONG,
        FLOAT,
        DOUBLE;

    }
}

