/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

public final class Document
implements Iterable<IndexableField> {
    private final List<IndexableField> fields = new ArrayList<IndexableField>();
    private static final String[] NO_STRINGS = new String[0];

    @Override
    public Iterator<IndexableField> iterator() {
        return this.fields.iterator();
    }

    public final void add(IndexableField field2) {
        this.fields.add(field2);
    }

    public final void removeField(String name2) {
        Iterator<IndexableField> it = this.fields.iterator();
        while (it.hasNext()) {
            IndexableField field2 = it.next();
            if (!field2.name().equals(name2)) continue;
            it.remove();
            return;
        }
    }

    public final void removeFields(String name2) {
        Iterator<IndexableField> it = this.fields.iterator();
        while (it.hasNext()) {
            IndexableField field2 = it.next();
            if (!field2.name().equals(name2)) continue;
            it.remove();
        }
    }

    public final BytesRef[] getBinaryValues(String name2) {
        ArrayList<BytesRef> result2 = new ArrayList<BytesRef>();
        for (IndexableField field2 : this.fields) {
            BytesRef bytes2;
            if (!field2.name().equals(name2) || (bytes2 = field2.binaryValue()) == null) continue;
            result2.add(bytes2);
        }
        return result2.toArray(new BytesRef[result2.size()]);
    }

    public final BytesRef getBinaryValue(String name2) {
        for (IndexableField field2 : this.fields) {
            BytesRef bytes2;
            if (!field2.name().equals(name2) || (bytes2 = field2.binaryValue()) == null) continue;
            return bytes2;
        }
        return null;
    }

    public final IndexableField getField(String name2) {
        for (IndexableField field2 : this.fields) {
            if (!field2.name().equals(name2)) continue;
            return field2;
        }
        return null;
    }

    public IndexableField[] getFields(String name2) {
        ArrayList<IndexableField> result2 = new ArrayList<IndexableField>();
        for (IndexableField field2 : this.fields) {
            if (!field2.name().equals(name2)) continue;
            result2.add(field2);
        }
        return result2.toArray(new IndexableField[result2.size()]);
    }

    public final List<IndexableField> getFields() {
        return this.fields;
    }

    public final String[] getValues(String name2) {
        ArrayList<String> result2 = new ArrayList<String>();
        for (IndexableField field2 : this.fields) {
            if (!field2.name().equals(name2) || field2.stringValue() == null) continue;
            result2.add(field2.stringValue());
        }
        if (result2.size() == 0) {
            return NO_STRINGS;
        }
        return result2.toArray(new String[result2.size()]);
    }

    public final String get(String name2) {
        for (IndexableField field2 : this.fields) {
            if (!field2.name().equals(name2) || field2.stringValue() == null) continue;
            return field2.stringValue();
        }
        return null;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Document<");
        for (int i = 0; i < this.fields.size(); ++i) {
            IndexableField field2 = this.fields.get(i);
            buffer.append(field2.toString());
            if (i == this.fields.size() - 1) continue;
            buffer.append(" ");
        }
        buffer.append(">");
        return buffer.toString();
    }
}

