/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.simpletext.SimpleTextStoredFieldsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;

public class SimpleTextStoredFieldsReader
extends StoredFieldsReader {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SimpleTextStoredFieldsReader.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRef.class) + RamUsageEstimator.shallowSizeOfInstance(CharsRef.class);
    private long[] offsets;
    private IndexInput in;
    private BytesRefBuilder scratch = new BytesRefBuilder();
    private CharsRefBuilder scratchUTF16 = new CharsRefBuilder();
    private final FieldInfos fieldInfos;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTextStoredFieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        this.fieldInfos = fn;
        boolean success = false;
        try {
            this.in = directory.openInput(IndexFileNames.segmentFileName(si.name, "", "fld"), context);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.close();
                }
                catch (Throwable t) {}
            }
        }
        this.readIndex(si.maxDoc());
    }

    SimpleTextStoredFieldsReader(long[] offsets, IndexInput in2, FieldInfos fieldInfos) {
        this.offsets = offsets;
        this.in = in2;
        this.fieldInfos = fieldInfos;
    }

    private void readIndex(int size2) throws IOException {
        BufferedChecksumIndexInput input2 = new BufferedChecksumIndexInput(this.in);
        this.offsets = new long[size2];
        int upto = 0;
        while (!this.scratch.get().equals(SimpleTextStoredFieldsWriter.END)) {
            SimpleTextUtil.readLine(input2, this.scratch);
            if (!StringHelper.startsWith(this.scratch.get(), SimpleTextStoredFieldsWriter.DOC)) continue;
            this.offsets[upto] = ((IndexInput)input2).getFilePointer();
            ++upto;
        }
        SimpleTextUtil.checkFooter(input2);
        assert (upto == this.offsets.length);
    }

    @Override
    public void visitDocument(int n, StoredFieldVisitor visitor) throws IOException {
        this.in.seek(this.offsets[n]);
        block5: while (true) {
            BytesRef type;
            this.readLine();
            if (!StringHelper.startsWith(this.scratch.get(), SimpleTextStoredFieldsWriter.FIELD)) break;
            int fieldNumber = this.parseIntAt(SimpleTextStoredFieldsWriter.FIELD.length);
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(fieldNumber);
            this.readLine();
            assert (StringHelper.startsWith(this.scratch.get(), SimpleTextStoredFieldsWriter.NAME));
            this.readLine();
            assert (StringHelper.startsWith(this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE));
            if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_STRING, this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_STRING;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_BINARY, this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_BINARY;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_INT, this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_INT;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_LONG, this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_LONG;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_FLOAT, this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_FLOAT;
            } else if (this.equalsAt(SimpleTextStoredFieldsWriter.TYPE_DOUBLE, this.scratch.get(), SimpleTextStoredFieldsWriter.TYPE.length)) {
                type = SimpleTextStoredFieldsWriter.TYPE_DOUBLE;
            } else {
                throw new RuntimeException("unknown field type");
            }
            switch (visitor.needsField(fieldInfo)) {
                case YES: {
                    this.readField(type, fieldInfo, visitor);
                    break;
                }
                case NO: {
                    this.readLine();
                    assert (StringHelper.startsWith(this.scratch.get(), SimpleTextStoredFieldsWriter.VALUE));
                    continue block5;
                }
                case STOP: {
                    return;
                }
            }
        }
    }

    private void readField(BytesRef type, FieldInfo fieldInfo, StoredFieldVisitor visitor) throws IOException {
        this.readLine();
        assert (StringHelper.startsWith(this.scratch.get(), SimpleTextStoredFieldsWriter.VALUE));
        if (type == SimpleTextStoredFieldsWriter.TYPE_STRING) {
            byte[] bytes2 = new byte[this.scratch.length() - SimpleTextStoredFieldsWriter.VALUE.length];
            System.arraycopy(this.scratch.bytes(), SimpleTextStoredFieldsWriter.VALUE.length, bytes2, 0, bytes2.length);
            visitor.stringField(fieldInfo, bytes2);
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_BINARY) {
            byte[] copy2 = new byte[this.scratch.length() - SimpleTextStoredFieldsWriter.VALUE.length];
            System.arraycopy(this.scratch.bytes(), SimpleTextStoredFieldsWriter.VALUE.length, copy2, 0, copy2.length);
            visitor.binaryField(fieldInfo, copy2);
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_INT) {
            this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextStoredFieldsWriter.VALUE.length, this.scratch.length() - SimpleTextStoredFieldsWriter.VALUE.length);
            visitor.intField(fieldInfo, Integer.parseInt(this.scratchUTF16.toString()));
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_LONG) {
            this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextStoredFieldsWriter.VALUE.length, this.scratch.length() - SimpleTextStoredFieldsWriter.VALUE.length);
            visitor.longField(fieldInfo, Long.parseLong(this.scratchUTF16.toString()));
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_FLOAT) {
            this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextStoredFieldsWriter.VALUE.length, this.scratch.length() - SimpleTextStoredFieldsWriter.VALUE.length);
            visitor.floatField(fieldInfo, Float.parseFloat(this.scratchUTF16.toString()));
        } else if (type == SimpleTextStoredFieldsWriter.TYPE_DOUBLE) {
            this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), SimpleTextStoredFieldsWriter.VALUE.length, this.scratch.length() - SimpleTextStoredFieldsWriter.VALUE.length);
            visitor.doubleField(fieldInfo, Double.parseDouble(this.scratchUTF16.toString()));
        }
    }

    @Override
    public StoredFieldsReader clone() {
        if (this.in == null) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
        return new SimpleTextStoredFieldsReader(this.offsets, this.in.clone(), this.fieldInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.in);
        }
        finally {
            this.in = null;
            this.offsets = null;
        }
    }

    private void readLine() throws IOException {
        SimpleTextUtil.readLine(this.in, this.scratch);
    }

    private int parseIntAt(int offset) {
        this.scratchUTF16.copyUTF8Bytes(this.scratch.bytes(), offset, this.scratch.length() - offset);
        return ArrayUtil.parseInt(this.scratchUTF16.chars(), 0, this.scratchUTF16.length());
    }

    private boolean equalsAt(BytesRef a, BytesRef b, int bOffset) {
        return a.length == b.length - bOffset && ArrayUtil.equals(a.bytes, a.offset, b.bytes, b.offset + bOffset, b.length - bOffset);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.offsets) + RamUsageEstimator.sizeOf(this.scratch.bytes()) + RamUsageEstimator.sizeOf(this.scratchUTF16.chars());
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void checkIntegrity() throws IOException {
    }
}

