/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public class SimpleTextSegmentInfoFormat
extends SegmentInfoFormat {
    static final BytesRef SI_VERSION = new BytesRef("    version ");
    static final BytesRef SI_DOCCOUNT = new BytesRef("    number of documents ");
    static final BytesRef SI_USECOMPOUND = new BytesRef("    uses compound file ");
    static final BytesRef SI_NUM_DIAG = new BytesRef("    diagnostics ");
    static final BytesRef SI_DIAG_KEY = new BytesRef("      key ");
    static final BytesRef SI_DIAG_VALUE = new BytesRef("      value ");
    static final BytesRef SI_NUM_ATT = new BytesRef("    attributes ");
    static final BytesRef SI_ATT_KEY = new BytesRef("      key ");
    static final BytesRef SI_ATT_VALUE = new BytesRef("      value ");
    static final BytesRef SI_NUM_FILES = new BytesRef("    files ");
    static final BytesRef SI_FILE = new BytesRef("      file ");
    static final BytesRef SI_ID = new BytesRef("    id ");
    public static final String SI_EXTENSION = "si";

    @Override
    public SegmentInfo read(Directory directory, String segmentName, byte[] segmentID, IOContext context) throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        String segFileName = IndexFileNames.segmentFileName(segmentName, "", SI_EXTENSION);
        try (ChecksumIndexInput input2 = directory.openChecksumInput(segFileName, context);){
            Version version;
            SimpleTextUtil.readLine(input2, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_VERSION));
            try {
                version = Version.parse(this.readString(SimpleTextSegmentInfoFormat.SI_VERSION.length, scratch));
            }
            catch (ParseException pe) {
                throw new CorruptIndexException("unable to parse version string: " + pe.getMessage(), input2, (Throwable)pe);
            }
            SimpleTextUtil.readLine(input2, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_DOCCOUNT));
            int docCount = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_DOCCOUNT.length, scratch));
            SimpleTextUtil.readLine(input2, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_USECOMPOUND));
            boolean isCompoundFile = Boolean.parseBoolean(this.readString(SimpleTextSegmentInfoFormat.SI_USECOMPOUND.length, scratch));
            SimpleTextUtil.readLine(input2, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_NUM_DIAG));
            int numDiag = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_DIAG.length, scratch));
            HashMap<String, String> diagnostics = new HashMap<String, String>();
            for (int i = 0; i < numDiag; ++i) {
                SimpleTextUtil.readLine(input2, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_DIAG_KEY));
                String key = this.readString(SimpleTextSegmentInfoFormat.SI_DIAG_KEY.length, scratch);
                SimpleTextUtil.readLine(input2, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_DIAG_VALUE));
                String value = this.readString(SimpleTextSegmentInfoFormat.SI_DIAG_VALUE.length, scratch);
                diagnostics.put(key, value);
            }
            SimpleTextUtil.readLine(input2, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_NUM_ATT));
            int numAtt = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_ATT.length, scratch));
            HashMap<String, String> attributes = new HashMap<String, String>(numAtt);
            for (int i = 0; i < numAtt; ++i) {
                SimpleTextUtil.readLine(input2, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_ATT_KEY));
                String key = this.readString(SimpleTextSegmentInfoFormat.SI_ATT_KEY.length, scratch);
                SimpleTextUtil.readLine(input2, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_ATT_VALUE));
                String value = this.readString(SimpleTextSegmentInfoFormat.SI_ATT_VALUE.length, scratch);
                attributes.put(key, value);
            }
            SimpleTextUtil.readLine(input2, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_NUM_FILES));
            int numFiles = Integer.parseInt(this.readString(SimpleTextSegmentInfoFormat.SI_NUM_FILES.length, scratch));
            HashSet<String> files2 = new HashSet<String>();
            for (int i = 0; i < numFiles; ++i) {
                SimpleTextUtil.readLine(input2, scratch);
                assert (StringHelper.startsWith(scratch.get(), SI_FILE));
                String fileName = this.readString(SimpleTextSegmentInfoFormat.SI_FILE.length, scratch);
                files2.add(fileName);
            }
            SimpleTextUtil.readLine(input2, scratch);
            assert (StringHelper.startsWith(scratch.get(), SI_ID));
            byte[] id = Arrays.copyOfRange(scratch.bytes(), SimpleTextSegmentInfoFormat.SI_ID.length, scratch.length());
            if (!Arrays.equals(segmentID, id)) {
                throw new CorruptIndexException("file mismatch, expected: " + StringHelper.idToString(segmentID) + ", got: " + StringHelper.idToString(id), input2);
            }
            SimpleTextUtil.checkFooter(input2);
            SegmentInfo info2 = new SegmentInfo(directory, version, segmentName, docCount, isCompoundFile, null, Collections.unmodifiableMap(diagnostics), id, Collections.unmodifiableMap(attributes));
            info2.setFiles(files2);
            SegmentInfo segmentInfo = info2;
            return segmentInfo;
        }
    }

    private String readString(int offset, BytesRefBuilder scratch) {
        return new String(scratch.bytes(), offset, scratch.length() - offset, StandardCharsets.UTF_8);
    }

    @Override
    public void write(Directory dir, SegmentInfo si, IOContext ioContext) throws IOException {
        String segFileName = IndexFileNames.segmentFileName(si.name, "", SI_EXTENSION);
        try (IndexOutput output = dir.createOutput(segFileName, ioContext);){
            si.addFile(segFileName);
            BytesRefBuilder scratch = new BytesRefBuilder();
            SimpleTextUtil.write(output, SI_VERSION);
            SimpleTextUtil.write(output, si.getVersion().toString(), scratch);
            SimpleTextUtil.writeNewline(output);
            SimpleTextUtil.write(output, SI_DOCCOUNT);
            SimpleTextUtil.write(output, Integer.toString(si.maxDoc()), scratch);
            SimpleTextUtil.writeNewline(output);
            SimpleTextUtil.write(output, SI_USECOMPOUND);
            SimpleTextUtil.write(output, Boolean.toString(si.getUseCompoundFile()), scratch);
            SimpleTextUtil.writeNewline(output);
            Map<String, String> diagnostics = si.getDiagnostics();
            int numDiagnostics = diagnostics == null ? 0 : diagnostics.size();
            SimpleTextUtil.write(output, SI_NUM_DIAG);
            SimpleTextUtil.write(output, Integer.toString(numDiagnostics), scratch);
            SimpleTextUtil.writeNewline(output);
            if (numDiagnostics > 0) {
                for (Map.Entry<String, String> diagEntry : diagnostics.entrySet()) {
                    SimpleTextUtil.write(output, SI_DIAG_KEY);
                    SimpleTextUtil.write(output, diagEntry.getKey(), scratch);
                    SimpleTextUtil.writeNewline(output);
                    SimpleTextUtil.write(output, SI_DIAG_VALUE);
                    SimpleTextUtil.write(output, diagEntry.getValue(), scratch);
                    SimpleTextUtil.writeNewline(output);
                }
            }
            Map<String, String> attributes = si.getAttributes();
            SimpleTextUtil.write(output, SI_NUM_ATT);
            SimpleTextUtil.write(output, Integer.toString(attributes.size()), scratch);
            SimpleTextUtil.writeNewline(output);
            for (Map.Entry<String, String> attEntry : attributes.entrySet()) {
                SimpleTextUtil.write(output, SI_ATT_KEY);
                SimpleTextUtil.write(output, attEntry.getKey(), scratch);
                SimpleTextUtil.writeNewline(output);
                SimpleTextUtil.write(output, SI_ATT_VALUE);
                SimpleTextUtil.write(output, attEntry.getValue(), scratch);
                SimpleTextUtil.writeNewline(output);
            }
            Set<String> files2 = si.files();
            int numFiles = files2 == null ? 0 : files2.size();
            SimpleTextUtil.write(output, SI_NUM_FILES);
            SimpleTextUtil.write(output, Integer.toString(numFiles), scratch);
            SimpleTextUtil.writeNewline(output);
            if (numFiles > 0) {
                for (String fileName : files2) {
                    SimpleTextUtil.write(output, SI_FILE);
                    SimpleTextUtil.write(output, fileName, scratch);
                    SimpleTextUtil.writeNewline(output);
                }
            }
            SimpleTextUtil.write(output, SI_ID);
            SimpleTextUtil.write(output, new BytesRef(si.getId()));
            SimpleTextUtil.writeNewline(output);
            SimpleTextUtil.writeChecksum(output, scratch);
        }
    }
}

