/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.NormsConsumer;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextDocValuesReader;
import org.apache.lucene.codecs.simpletext.SimpleTextDocValuesWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.Accountable;

public class SimpleTextNormsFormat
extends NormsFormat {
    private static final String NORMS_SEG_EXTENSION = "len";

    @Override
    public NormsConsumer normsConsumer(SegmentWriteState state) throws IOException {
        return new SimpleTextNormsConsumer(state);
    }

    @Override
    public NormsProducer normsProducer(SegmentReadState state) throws IOException {
        return new SimpleTextNormsProducer(state);
    }

    public static class SimpleTextNormsConsumer
    extends NormsConsumer {
        private final SimpleTextDocValuesWriter impl;

        public SimpleTextNormsConsumer(SegmentWriteState state) throws IOException {
            this.impl = new SimpleTextDocValuesWriter(state, SimpleTextNormsFormat.NORMS_SEG_EXTENSION);
        }

        @Override
        public void addNormsField(FieldInfo field2, Iterable<Number> values2) throws IOException {
            this.impl.addNumericField(field2, values2);
        }

        @Override
        public void close() throws IOException {
            this.impl.close();
        }
    }

    public static class SimpleTextNormsProducer
    extends NormsProducer {
        private final SimpleTextDocValuesReader impl;

        public SimpleTextNormsProducer(SegmentReadState state) throws IOException {
            this.impl = new SimpleTextDocValuesReader(state, SimpleTextNormsFormat.NORMS_SEG_EXTENSION);
        }

        @Override
        public NumericDocValues getNorms(FieldInfo field2) throws IOException {
            return this.impl.getNumeric(field2);
        }

        @Override
        public void close() throws IOException {
            this.impl.close();
        }

        @Override
        public long ramBytesUsed() {
            return this.impl.ramBytesUsed();
        }

        @Override
        public Collection<Accountable> getChildResources() {
            return this.impl.getChildResources();
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.impl.checkIntegrity();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.impl + ")";
        }
    }
}

