/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.MutableBits;
import org.apache.lucene.util.StringHelper;

public class SimpleTextLiveDocsFormat
extends LiveDocsFormat {
    static final String LIVEDOCS_EXTENSION = "liv";
    static final BytesRef SIZE = new BytesRef("size ");
    static final BytesRef DOC = new BytesRef("  doc ");
    static final BytesRef END = new BytesRef("END");

    @Override
    public MutableBits newLiveDocs(int size2) throws IOException {
        return new SimpleTextMutableBits(size2);
    }

    @Override
    public MutableBits newLiveDocs(Bits existing) throws IOException {
        SimpleTextBits bits2 = (SimpleTextBits)existing;
        return new SimpleTextMutableBits((BitSet)bits2.bits.clone(), bits2.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info2, IOContext context) throws IOException {
        SimpleTextBits simpleTextBits;
        block9: {
            ChecksumIndexInput in2;
            block8: {
                assert (info2.hasDeletions());
                BytesRefBuilder scratch = new BytesRefBuilder();
                CharsRefBuilder scratchUTF16 = new CharsRefBuilder();
                String fileName = IndexFileNames.fileNameFromGeneration(info2.info.name, LIVEDOCS_EXTENSION, info2.getDelGen());
                in2 = null;
                boolean success = false;
                try {
                    in2 = dir.openChecksumInput(fileName, context);
                    SimpleTextUtil.readLine(in2, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SIZE));
                    int size2 = this.parseIntAt(scratch.get(), SimpleTextLiveDocsFormat.SIZE.length, scratchUTF16);
                    BitSet bits2 = new BitSet(size2);
                    SimpleTextUtil.readLine(in2, scratch);
                    while (!scratch.get().equals(END)) {
                        assert (StringHelper.startsWith(scratch.get(), DOC));
                        int docid = this.parseIntAt(scratch.get(), SimpleTextLiveDocsFormat.DOC.length, scratchUTF16);
                        bits2.set(docid);
                        SimpleTextUtil.readLine(in2, scratch);
                    }
                    SimpleTextUtil.checkFooter(in2);
                    success = true;
                    simpleTextBits = new SimpleTextBits(bits2, size2);
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(in2);
                    } else {
                        IOUtils.closeWhileHandlingException(in2);
                    }
                    throw throwable;
                }
                IOUtils.close(in2);
                break block9;
            }
            IOUtils.closeWhileHandlingException(in2);
        }
        return simpleTextBits;
    }

    private int parseIntAt(BytesRef bytes2, int offset, CharsRefBuilder scratch) {
        scratch.copyUTF8Bytes(bytes2.bytes, bytes2.offset + offset, bytes2.length - offset);
        return ArrayUtil.parseInt(scratch.chars(), 0, scratch.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLiveDocs(MutableBits bits2, Directory dir, SegmentCommitInfo info2, int newDelCount, IOContext context) throws IOException {
        block6: {
            IndexOutput out;
            block5: {
                BitSet set = ((SimpleTextBits)((Object)bits2)).bits;
                int size2 = bits2.length();
                BytesRefBuilder scratch = new BytesRefBuilder();
                String fileName = IndexFileNames.fileNameFromGeneration(info2.info.name, LIVEDOCS_EXTENSION, info2.getNextDelGen());
                out = null;
                boolean success = false;
                try {
                    out = dir.createOutput(fileName, context);
                    SimpleTextUtil.write(out, SIZE);
                    SimpleTextUtil.write(out, Integer.toString(size2), scratch);
                    SimpleTextUtil.writeNewline(out);
                    int i = set.nextSetBit(0);
                    while (i >= 0) {
                        SimpleTextUtil.write(out, DOC);
                        SimpleTextUtil.write(out, Integer.toString(i), scratch);
                        SimpleTextUtil.writeNewline(out);
                        i = set.nextSetBit(i + 1);
                    }
                    SimpleTextUtil.write(out, END);
                    SimpleTextUtil.writeNewline(out);
                    SimpleTextUtil.writeChecksum(out, scratch);
                    success = true;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(out);
                    } else {
                        IOUtils.closeWhileHandlingException(out);
                    }
                    throw throwable;
                }
                IOUtils.close(out);
                break block6;
            }
            IOUtils.closeWhileHandlingException(out);
        }
    }

    @Override
    public void files(SegmentCommitInfo info2, Collection<String> files2) throws IOException {
        if (info2.hasDeletions()) {
            files2.add(IndexFileNames.fileNameFromGeneration(info2.info.name, LIVEDOCS_EXTENSION, info2.getDelGen()));
        }
    }

    static class SimpleTextMutableBits
    extends SimpleTextBits
    implements MutableBits {
        SimpleTextMutableBits(int size2) {
            this(new BitSet(size2), size2);
            this.bits.set(0, size2);
        }

        SimpleTextMutableBits(BitSet bits2, int size2) {
            super(bits2, size2);
        }

        @Override
        public void clear(int bit) {
            this.bits.clear(bit);
        }
    }

    static class SimpleTextBits
    implements Bits {
        final BitSet bits;
        final int size;

        SimpleTextBits(BitSet bits2, int size2) {
            this.bits = bits2;
            this.size = size2;
        }

        @Override
        public boolean get(int index) {
            return this.bits.get(index);
        }

        @Override
        public int length() {
            return this.size;
        }
    }
}

