/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public class SimpleTextFieldInfosFormat
extends FieldInfosFormat {
    static final String FIELD_INFOS_EXTENSION = "inf";
    static final BytesRef NUMFIELDS = new BytesRef("number of fields ");
    static final BytesRef NAME = new BytesRef("  name ");
    static final BytesRef NUMBER = new BytesRef("  number ");
    static final BytesRef STORETV = new BytesRef("  term vectors ");
    static final BytesRef STORETVPOS = new BytesRef("  term vector positions ");
    static final BytesRef STORETVOFF = new BytesRef("  term vector offsets ");
    static final BytesRef PAYLOADS = new BytesRef("  payloads ");
    static final BytesRef NORMS = new BytesRef("  norms ");
    static final BytesRef DOCVALUES = new BytesRef("  doc values ");
    static final BytesRef DOCVALUES_GEN = new BytesRef("  doc values gen ");
    static final BytesRef INDEXOPTIONS = new BytesRef("  index options ");
    static final BytesRef NUM_ATTS = new BytesRef("  attributes ");
    static final BytesRef ATT_KEY = new BytesRef("    key ");
    static final BytesRef ATT_VALUE = new BytesRef("    value ");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext iocontext) throws IOException {
        FieldInfos fieldInfos;
        block19: {
            ChecksumIndexInput input2;
            block18: {
                String fileName = IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, FIELD_INFOS_EXTENSION);
                input2 = directory.openChecksumInput(fileName, iocontext);
                BytesRefBuilder scratch = new BytesRefBuilder();
                boolean success = false;
                try {
                    SimpleTextUtil.readLine(input2, scratch);
                    assert (StringHelper.startsWith(scratch.get(), NUMFIELDS));
                    int size2 = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.NUMFIELDS.length, scratch));
                    FieldInfo[] infos = new FieldInfo[size2];
                    for (int i = 0; i < size2; ++i) {
                        SimpleTextUtil.readLine(input2, scratch);
                        assert (StringHelper.startsWith(scratch.get(), NAME));
                        String name2 = this.readString(SimpleTextFieldInfosFormat.NAME.length, scratch);
                        SimpleTextUtil.readLine(input2, scratch);
                        assert (StringHelper.startsWith(scratch.get(), NUMBER));
                        int fieldNumber = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.NUMBER.length, scratch));
                        SimpleTextUtil.readLine(input2, scratch);
                        assert (StringHelper.startsWith(scratch.get(), INDEXOPTIONS));
                        String s2 = this.readString(SimpleTextFieldInfosFormat.INDEXOPTIONS.length, scratch);
                        IndexOptions indexOptions = IndexOptions.valueOf(s2);
                        SimpleTextUtil.readLine(input2, scratch);
                        assert (StringHelper.startsWith(scratch.get(), STORETV));
                        boolean storeTermVector = Boolean.parseBoolean(this.readString(SimpleTextFieldInfosFormat.STORETV.length, scratch));
                        SimpleTextUtil.readLine(input2, scratch);
                        assert (StringHelper.startsWith(scratch.get(), PAYLOADS));
                        boolean storePayloads = Boolean.parseBoolean(this.readString(SimpleTextFieldInfosFormat.PAYLOADS.length, scratch));
                        SimpleTextUtil.readLine(input2, scratch);
                        assert (StringHelper.startsWith(scratch.get(), NORMS));
                        boolean omitNorms = !Boolean.parseBoolean(this.readString(SimpleTextFieldInfosFormat.NORMS.length, scratch));
                        SimpleTextUtil.readLine(input2, scratch);
                        assert (StringHelper.startsWith(scratch.get(), DOCVALUES));
                        String dvType = this.readString(SimpleTextFieldInfosFormat.DOCVALUES.length, scratch);
                        DocValuesType docValuesType = this.docValuesType(dvType);
                        SimpleTextUtil.readLine(input2, scratch);
                        assert (StringHelper.startsWith(scratch.get(), DOCVALUES_GEN));
                        long dvGen = Long.parseLong(this.readString(SimpleTextFieldInfosFormat.DOCVALUES_GEN.length, scratch));
                        SimpleTextUtil.readLine(input2, scratch);
                        assert (StringHelper.startsWith(scratch.get(), NUM_ATTS));
                        int numAtts = Integer.parseInt(this.readString(SimpleTextFieldInfosFormat.NUM_ATTS.length, scratch));
                        HashMap<String, String> atts = new HashMap<String, String>();
                        for (int j = 0; j < numAtts; ++j) {
                            SimpleTextUtil.readLine(input2, scratch);
                            assert (StringHelper.startsWith(scratch.get(), ATT_KEY));
                            String key = this.readString(SimpleTextFieldInfosFormat.ATT_KEY.length, scratch);
                            SimpleTextUtil.readLine(input2, scratch);
                            assert (StringHelper.startsWith(scratch.get(), ATT_VALUE));
                            String value = this.readString(SimpleTextFieldInfosFormat.ATT_VALUE.length, scratch);
                            atts.put(key, value);
                        }
                        infos[i] = new FieldInfo(name2, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, dvGen, Collections.unmodifiableMap(atts));
                    }
                    SimpleTextUtil.checkFooter(input2);
                    FieldInfos fieldInfos2 = new FieldInfos(infos);
                    success = true;
                    fieldInfos = fieldInfos2;
                    if (!success) break block18;
                }
                catch (Throwable throwable) {
                    if (success) {
                        input2.close();
                    } else {
                        IOUtils.closeWhileHandlingException(input2);
                    }
                    throw throwable;
                }
                input2.close();
                break block19;
            }
            IOUtils.closeWhileHandlingException(input2);
        }
        return fieldInfos;
    }

    public DocValuesType docValuesType(String dvType) {
        return DocValuesType.valueOf(dvType);
    }

    private String readString(int offset, BytesRefBuilder scratch) {
        return new String(scratch.bytes(), offset, scratch.length() - offset, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        block8: {
            IndexOutput out;
            block7: {
                String fileName = IndexFileNames.segmentFileName(segmentInfo.name, segmentSuffix, FIELD_INFOS_EXTENSION);
                out = directory.createOutput(fileName, context);
                BytesRefBuilder scratch = new BytesRefBuilder();
                boolean success = false;
                try {
                    SimpleTextUtil.write(out, NUMFIELDS);
                    SimpleTextUtil.write(out, Integer.toString(infos.size()), scratch);
                    SimpleTextUtil.writeNewline(out);
                    for (FieldInfo fi : infos) {
                        SimpleTextUtil.write(out, NAME);
                        SimpleTextUtil.write(out, fi.name, scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, NUMBER);
                        SimpleTextUtil.write(out, Integer.toString(fi.number), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, INDEXOPTIONS);
                        IndexOptions indexOptions = fi.getIndexOptions();
                        assert (indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 || !fi.hasPayloads());
                        SimpleTextUtil.write(out, indexOptions.toString(), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, STORETV);
                        SimpleTextUtil.write(out, Boolean.toString(fi.hasVectors()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, PAYLOADS);
                        SimpleTextUtil.write(out, Boolean.toString(fi.hasPayloads()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, NORMS);
                        SimpleTextUtil.write(out, Boolean.toString(!fi.omitsNorms()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, DOCVALUES);
                        SimpleTextUtil.write(out, SimpleTextFieldInfosFormat.getDocValuesType(fi.getDocValuesType()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        SimpleTextUtil.write(out, DOCVALUES_GEN);
                        SimpleTextUtil.write(out, Long.toString(fi.getDocValuesGen()), scratch);
                        SimpleTextUtil.writeNewline(out);
                        Map<String, String> atts = fi.attributes();
                        int numAtts = atts == null ? 0 : atts.size();
                        SimpleTextUtil.write(out, NUM_ATTS);
                        SimpleTextUtil.write(out, Integer.toString(numAtts), scratch);
                        SimpleTextUtil.writeNewline(out);
                        if (numAtts <= 0) continue;
                        for (Map.Entry<String, String> entry : atts.entrySet()) {
                            SimpleTextUtil.write(out, ATT_KEY);
                            SimpleTextUtil.write(out, entry.getKey(), scratch);
                            SimpleTextUtil.writeNewline(out);
                            SimpleTextUtil.write(out, ATT_VALUE);
                            SimpleTextUtil.write(out, entry.getValue(), scratch);
                            SimpleTextUtil.writeNewline(out);
                        }
                    }
                    SimpleTextUtil.writeChecksum(out, scratch);
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        out.close();
                    } else {
                        IOUtils.closeWhileHandlingException(out);
                    }
                    throw throwable;
                }
                out.close();
                break block8;
            }
            IOUtils.closeWhileHandlingException(out);
        }
    }

    private static String getDocValuesType(DocValuesType type) {
        return type.toString();
    }
}

