/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextDocValuesWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;

class SimpleTextDocValuesReader
extends DocValuesProducer {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SimpleTextDocValuesReader.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRef.class);
    final int maxDoc;
    final IndexInput data;
    final BytesRefBuilder scratch;
    final Map<String, OneField> fields;

    public SimpleTextDocValuesReader(SegmentReadState state, String ext) throws IOException {
        block15: {
            this.scratch = new BytesRefBuilder();
            this.fields = new HashMap<String, OneField>();
            this.data = state.directory.openInput(IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, ext), state.context);
            this.maxDoc = state.segmentInfo.maxDoc();
            while (true) {
                this.readLine();
                if (this.scratch.get().equals(SimpleTextDocValuesWriter.END)) break block15;
                assert (this.startsWith(SimpleTextDocValuesWriter.FIELD)) : this.scratch.get().utf8ToString();
                String fieldName = this.stripPrefix(SimpleTextDocValuesWriter.FIELD);
                OneField field2 = new OneField();
                this.fields.put(fieldName, field2);
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.TYPE)) : this.scratch.get().utf8ToString();
                DocValuesType dvType = DocValuesType.valueOf(this.stripPrefix(SimpleTextDocValuesWriter.TYPE));
                assert (dvType != DocValuesType.NONE);
                if (dvType == DocValuesType.NUMERIC) {
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.MINVALUE)) : "got " + this.scratch.get().utf8ToString() + " field=" + fieldName + " ext=" + ext;
                    field2.minValue = Long.parseLong(this.stripPrefix(SimpleTextDocValuesWriter.MINVALUE));
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                    field2.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                    field2.dataStartFilePointer = this.data.getFilePointer();
                    this.data.seek(this.data.getFilePointer() + (long)((1 + field2.pattern.length() + 2) * this.maxDoc));
                    continue;
                }
                if (dvType == DocValuesType.BINARY) {
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.MAXLENGTH));
                    field2.maxLength = Integer.parseInt(this.stripPrefix(SimpleTextDocValuesWriter.MAXLENGTH));
                    this.readLine();
                    assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                    field2.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                    field2.dataStartFilePointer = this.data.getFilePointer();
                    this.data.seek(this.data.getFilePointer() + (long)((9 + field2.pattern.length() + field2.maxLength + 2) * this.maxDoc));
                    continue;
                }
                if (dvType != DocValuesType.SORTED && dvType != DocValuesType.SORTED_SET) break;
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.NUMVALUES));
                field2.numValues = Long.parseLong(this.stripPrefix(SimpleTextDocValuesWriter.NUMVALUES));
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.MAXLENGTH));
                field2.maxLength = Integer.parseInt(this.stripPrefix(SimpleTextDocValuesWriter.MAXLENGTH));
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.PATTERN));
                field2.pattern = this.stripPrefix(SimpleTextDocValuesWriter.PATTERN);
                this.readLine();
                assert (this.startsWith(SimpleTextDocValuesWriter.ORDPATTERN));
                field2.ordPattern = this.stripPrefix(SimpleTextDocValuesWriter.ORDPATTERN);
                field2.dataStartFilePointer = this.data.getFilePointer();
                this.data.seek(this.data.getFilePointer() + (long)(9 + field2.pattern.length() + field2.maxLength) * field2.numValues + (long)((1 + field2.ordPattern.length()) * this.maxDoc));
            }
            throw new AssertionError();
        }
        assert (!this.fields.isEmpty());
    }

    @Override
    public NumericDocValues getNumeric(FieldInfo fieldInfo) throws IOException {
        final OneField field2 = this.fields.get(fieldInfo.name);
        assert (field2 != null);
        assert (field2 != null) : "field=" + fieldInfo.name + " fields=" + this.fields;
        final IndexInput in2 = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field2.pattern, new DecimalFormatSymbols(Locale.ROOT));
        decoder.setParseBigDecimal(true);
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                try {
                    BigDecimal bd;
                    if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                        throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                    }
                    in2.seek(field2.dataStartFilePointer + (long)((1 + field2.pattern.length() + 2) * docID));
                    SimpleTextUtil.readLine(in2, scratch);
                    try {
                        bd = (BigDecimal)decoder.parse(scratch.get().utf8ToString());
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse BigDecimal value", in2, (Throwable)pe);
                    }
                    SimpleTextUtil.readLine(in2, scratch);
                    return BigInteger.valueOf(field2.minValue).add(bd.toBigIntegerExact()).longValue();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
    }

    private Bits getNumericDocsWithField(FieldInfo fieldInfo) throws IOException {
        final OneField field2 = this.fields.get(fieldInfo.name);
        final IndexInput in2 = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        return new Bits(){

            @Override
            public boolean get(int index) {
                try {
                    in2.seek(field2.dataStartFilePointer + (long)((1 + field2.pattern.length() + 2) * index));
                    SimpleTextUtil.readLine(in2, scratch);
                    SimpleTextUtil.readLine(in2, scratch);
                    return scratch.byteAt(0) == 84;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public int length() {
                return SimpleTextDocValuesReader.this.maxDoc;
            }
        };
    }

    @Override
    public BinaryDocValues getBinary(FieldInfo fieldInfo) throws IOException {
        final OneField field2 = this.fields.get(fieldInfo.name);
        assert (field2 != null);
        final IndexInput in2 = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field2.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new BinaryDocValues(){
            final BytesRefBuilder term = new BytesRefBuilder();

            @Override
            public BytesRef get(int docID) {
                try {
                    int len;
                    if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                        throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                    }
                    in2.seek(field2.dataStartFilePointer + (long)((9 + field2.pattern.length() + field2.maxLength + 2) * docID));
                    SimpleTextUtil.readLine(in2, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextDocValuesWriter.LENGTH));
                    try {
                        len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse int length", in2, (Throwable)pe);
                    }
                    this.term.grow(len);
                    this.term.setLength(len);
                    in2.readBytes(this.term.bytes(), 0, len);
                    return this.term.get();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
    }

    private Bits getBinaryDocsWithField(FieldInfo fieldInfo) throws IOException {
        final OneField field2 = this.fields.get(fieldInfo.name);
        final IndexInput in2 = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field2.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new Bits(){

            @Override
            public boolean get(int index) {
                try {
                    int len;
                    in2.seek(field2.dataStartFilePointer + (long)((9 + field2.pattern.length() + field2.maxLength + 2) * index));
                    SimpleTextUtil.readLine(in2, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextDocValuesWriter.LENGTH));
                    try {
                        len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse int length", in2, (Throwable)pe);
                    }
                    byte[] bytes2 = new byte[len];
                    in2.readBytes(bytes2, 0, len);
                    SimpleTextUtil.readLine(in2, scratch);
                    SimpleTextUtil.readLine(in2, scratch);
                    return scratch.byteAt(0) == 84;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public int length() {
                return SimpleTextDocValuesReader.this.maxDoc;
            }
        };
    }

    @Override
    public SortedDocValues getSorted(FieldInfo fieldInfo) throws IOException {
        final OneField field2 = this.fields.get(fieldInfo.name);
        assert (field2 != null);
        final IndexInput in2 = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field2.pattern, new DecimalFormatSymbols(Locale.ROOT));
        final DecimalFormat ordDecoder = new DecimalFormat(field2.ordPattern, new DecimalFormatSymbols(Locale.ROOT));
        return new SortedDocValues(){
            final BytesRefBuilder term = new BytesRefBuilder();

            @Override
            public int getOrd(int docID) {
                if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                    throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                }
                try {
                    in2.seek(field2.dataStartFilePointer + field2.numValues * (long)(9 + field2.pattern.length() + field2.maxLength) + (long)(docID * (1 + field2.ordPattern.length())));
                    SimpleTextUtil.readLine(in2, scratch);
                    try {
                        return (int)ordDecoder.parse(scratch.get().utf8ToString()).longValue() - 1;
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse ord", in2, (Throwable)pe);
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                try {
                    int len;
                    if (ord < 0 || (long)ord >= field2.numValues) {
                        throw new IndexOutOfBoundsException("ord must be 0 .. " + (field2.numValues - 1L) + "; got " + ord);
                    }
                    in2.seek(field2.dataStartFilePointer + (long)(ord * (9 + field2.pattern.length() + field2.maxLength)));
                    SimpleTextUtil.readLine(in2, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextDocValuesWriter.LENGTH)) : "got " + scratch.get().utf8ToString() + " in=" + in2;
                    try {
                        len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse int length", in2, (Throwable)pe);
                    }
                    this.term.grow(len);
                    this.term.setLength(len);
                    in2.readBytes(this.term.bytes(), 0, len);
                    return this.term.get();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public int getValueCount() {
                return (int)field2.numValues;
            }
        };
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field2) throws IOException {
        final BinaryDocValues binary = this.getBinary(field2);
        return new SortedNumericDocValues(){
            long[] values;

            @Override
            public void setDocument(int doc2) {
                String csv = binary.get(doc2).utf8ToString();
                if (csv.length() == 0) {
                    this.values = new long[0];
                } else {
                    String[] s2 = csv.split(",");
                    this.values = new long[s2.length];
                    for (int i = 0; i < this.values.length; ++i) {
                        this.values[i] = Long.parseLong(s2[i]);
                    }
                }
            }

            @Override
            public long valueAt(int index) {
                return this.values[index];
            }

            @Override
            public int count() {
                return this.values.length;
            }
        };
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo fieldInfo) throws IOException {
        final OneField field2 = this.fields.get(fieldInfo.name);
        assert (field2 != null);
        final IndexInput in2 = this.data.clone();
        final BytesRefBuilder scratch = new BytesRefBuilder();
        final DecimalFormat decoder = new DecimalFormat(field2.pattern, new DecimalFormatSymbols(Locale.ROOT));
        return new SortedSetDocValues(){
            String[] currentOrds = new String[0];
            int currentIndex = 0;
            final BytesRefBuilder term = new BytesRefBuilder();

            @Override
            public long nextOrd() {
                if (this.currentIndex == this.currentOrds.length) {
                    return -1L;
                }
                return Long.parseLong(this.currentOrds[this.currentIndex++]);
            }

            @Override
            public void setDocument(int docID) {
                if (docID < 0 || docID >= SimpleTextDocValuesReader.this.maxDoc) {
                    throw new IndexOutOfBoundsException("docID must be 0 .. " + (SimpleTextDocValuesReader.this.maxDoc - 1) + "; got " + docID);
                }
                try {
                    in2.seek(field2.dataStartFilePointer + field2.numValues * (long)(9 + field2.pattern.length() + field2.maxLength) + (long)(docID * (1 + field2.ordPattern.length())));
                    SimpleTextUtil.readLine(in2, scratch);
                    String ordList = scratch.get().utf8ToString().trim();
                    this.currentOrds = ordList.isEmpty() ? new String[0] : ordList.split(",");
                    this.currentIndex = 0;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                try {
                    int len;
                    if (ord < 0L || ord >= field2.numValues) {
                        throw new IndexOutOfBoundsException("ord must be 0 .. " + (field2.numValues - 1L) + "; got " + ord);
                    }
                    in2.seek(field2.dataStartFilePointer + ord * (long)(9 + field2.pattern.length() + field2.maxLength));
                    SimpleTextUtil.readLine(in2, scratch);
                    assert (StringHelper.startsWith(scratch.get(), SimpleTextDocValuesWriter.LENGTH)) : "got " + scratch.get().utf8ToString() + " in=" + in2;
                    try {
                        len = decoder.parse(new String(scratch.bytes(), SimpleTextDocValuesWriter.LENGTH.length, scratch.length() - SimpleTextDocValuesWriter.LENGTH.length, StandardCharsets.UTF_8)).intValue();
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("failed to parse int length", in2, (Throwable)pe);
                    }
                    this.term.grow(len);
                    this.term.setLength(len);
                    in2.readBytes(this.term.bytes(), 0, len);
                    return this.term.get();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public long getValueCount() {
                return field2.numValues;
            }
        };
    }

    @Override
    public Bits getDocsWithField(FieldInfo field2) throws IOException {
        switch (field2.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue(this.getSortedSet(field2), this.maxDoc);
            }
            case SORTED_NUMERIC: {
                return DocValues.docsWithValue(this.getSortedNumeric(field2), this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue(this.getSorted(field2), this.maxDoc);
            }
            case BINARY: {
                return this.getBinaryDocsWithField(field2);
            }
            case NUMERIC: {
                return this.getNumericDocsWithField(field2);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    private void readLine() throws IOException {
        SimpleTextUtil.readLine(this.data, this.scratch);
    }

    private boolean startsWith(BytesRef prefix) {
        return StringHelper.startsWith(this.scratch.get(), prefix);
    }

    private String stripPrefix(BytesRef prefix) throws IOException {
        return new String(this.scratch.bytes(), prefix.length, this.scratch.length() - prefix.length, StandardCharsets.UTF_8);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.scratch.bytes()) + (long)this.fields.size() * ((long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * 2L + OneField.BASE_RAM_BYTES_USED);
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fields.size() + ")";
    }

    @Override
    public void checkIntegrity() throws IOException {
        BytesRefBuilder scratch = new BytesRefBuilder();
        IndexInput clone2 = this.data.clone();
        clone2.seek(0L);
        long footerStartPos = this.data.length() - (long)(SimpleTextUtil.CHECKSUM.length + 21);
        BufferedChecksumIndexInput input2 = new BufferedChecksumIndexInput(clone2);
        do {
            SimpleTextUtil.readLine(input2, scratch);
        } while (((IndexInput)input2).getFilePointer() < footerStartPos);
        if (((IndexInput)input2).getFilePointer() != footerStartPos) {
            throw new CorruptIndexException("SimpleText failure: footer does not start at expected position current=" + ((IndexInput)input2).getFilePointer() + " vs expected=" + footerStartPos, input2);
        }
        SimpleTextUtil.checkFooter(input2);
    }

    static class OneField {
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(OneField.class);
        long dataStartFilePointer;
        String pattern;
        String ordPattern;
        int maxLength;
        boolean fixedLength;
        long minValue;
        long numValues;

        OneField() {
        }
    }
}

