/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;

public class SimpleTextCompoundFormat
extends CompoundFormat {
    static final String DATA_EXTENSION = "scf";
    static final BytesRef HEADER = new BytesRef("cfs entry for: ");
    static final BytesRef TABLE = new BytesRef("table of contents, size: ");
    static final BytesRef TABLENAME = new BytesRef("  filename: ");
    static final BytesRef TABLESTART = new BytesRef("    start: ");
    static final BytesRef TABLEEND = new BytesRef("    end: ");
    static final BytesRef TABLEPOS = new BytesRef("table of contents begins at offset: ");
    static final String OFFSETPATTERN;

    @Override
    public Directory getCompoundReader(Directory dir, SegmentInfo si, IOContext context) throws IOException {
        String dataFile = IndexFileNames.segmentFileName(si.name, "", DATA_EXTENSION);
        final IndexInput in2 = dir.openInput(dataFile, context);
        BytesRefBuilder scratch = new BytesRefBuilder();
        DecimalFormat df = new DecimalFormat(OFFSETPATTERN, DecimalFormatSymbols.getInstance(Locale.ROOT));
        long pos = in2.length() - (long)SimpleTextCompoundFormat.TABLEPOS.length - (long)OFFSETPATTERN.length() - 1L;
        in2.seek(pos);
        SimpleTextUtil.readLine(in2, scratch);
        assert (StringHelper.startsWith(scratch.get(), TABLEPOS));
        long tablePos = -1L;
        try {
            tablePos = df.parse(this.stripPrefix(scratch, TABLEPOS)).longValue();
        }
        catch (ParseException e) {
            throw new CorruptIndexException("can't parse CFS trailer, got: " + scratch.get().utf8ToString(), in2);
        }
        in2.seek(tablePos);
        SimpleTextUtil.readLine(in2, scratch);
        assert (StringHelper.startsWith(scratch.get(), TABLE));
        int numEntries = Integer.parseInt(this.stripPrefix(scratch, TABLE));
        final String[] fileNames = new String[numEntries];
        final long[] startOffsets = new long[numEntries];
        final long[] endOffsets = new long[numEntries];
        for (int i = 0; i < numEntries; ++i) {
            SimpleTextUtil.readLine(in2, scratch);
            assert (StringHelper.startsWith(scratch.get(), TABLENAME));
            fileNames[i] = si.name + IndexFileNames.stripSegmentName(this.stripPrefix(scratch, TABLENAME));
            if (i > 0) assert (fileNames[i].compareTo(fileNames[i - 1]) > 0);
            SimpleTextUtil.readLine(in2, scratch);
            assert (StringHelper.startsWith(scratch.get(), TABLESTART));
            startOffsets[i] = Long.parseLong(this.stripPrefix(scratch, TABLESTART));
            SimpleTextUtil.readLine(in2, scratch);
            assert (StringHelper.startsWith(scratch.get(), TABLEEND));
            endOffsets[i] = Long.parseLong(this.stripPrefix(scratch, TABLEEND));
        }
        return new Directory(){

            private int getIndex(String name2) throws IOException {
                int index = Arrays.binarySearch(fileNames, name2);
                if (index < 0) {
                    throw new FileNotFoundException("No sub-file found (fileName=" + name2 + " files: " + Arrays.toString(fileNames) + ")");
                }
                return index;
            }

            @Override
            public String[] listAll() throws IOException {
                this.ensureOpen();
                return (String[])fileNames.clone();
            }

            @Override
            public long fileLength(String name2) throws IOException {
                this.ensureOpen();
                int index = this.getIndex(name2);
                return endOffsets[index] - startOffsets[index];
            }

            @Override
            public IndexInput openInput(String name2, IOContext context) throws IOException {
                this.ensureOpen();
                int index = this.getIndex(name2);
                return in2.slice(name2, startOffsets[index], endOffsets[index] - startOffsets[index]);
            }

            @Override
            public void close() throws IOException {
                in2.close();
            }

            @Override
            public IndexOutput createOutput(String name2, IOContext context) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void sync(Collection<String> names) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void deleteFile(String name2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void renameFile(String source, String dest) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Lock obtainLock(String name2) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void write(Directory dir, SegmentInfo si, IOContext context) throws IOException {
        String dataFile = IndexFileNames.segmentFileName(si.name, "", DATA_EXTENSION);
        int numFiles = si.files().size();
        Object[] names = si.files().toArray(new String[numFiles]);
        Arrays.sort(names);
        long[] startOffsets = new long[numFiles];
        long[] endOffsets = new long[numFiles];
        BytesRefBuilder scratch = new BytesRefBuilder();
        try (IndexOutput out = dir.createOutput(dataFile, context);){
            for (int i = 0; i < names.length; ++i) {
                SimpleTextUtil.write(out, HEADER);
                SimpleTextUtil.write(out, (String)names[i], scratch);
                SimpleTextUtil.writeNewline(out);
                startOffsets[i] = out.getFilePointer();
                try (IndexInput in2 = dir.openInput((String)names[i], IOContext.READONCE);){
                    out.copyBytes(in2, in2.length());
                }
                endOffsets[i] = out.getFilePointer();
            }
            long tocPos = out.getFilePointer();
            SimpleTextUtil.write(out, TABLE);
            SimpleTextUtil.write(out, Integer.toString(numFiles), scratch);
            SimpleTextUtil.writeNewline(out);
            for (int i = 0; i < names.length; ++i) {
                SimpleTextUtil.write(out, TABLENAME);
                SimpleTextUtil.write(out, (String)names[i], scratch);
                SimpleTextUtil.writeNewline(out);
                SimpleTextUtil.write(out, TABLESTART);
                SimpleTextUtil.write(out, Long.toString(startOffsets[i]), scratch);
                SimpleTextUtil.writeNewline(out);
                SimpleTextUtil.write(out, TABLEEND);
                SimpleTextUtil.write(out, Long.toString(endOffsets[i]), scratch);
                SimpleTextUtil.writeNewline(out);
            }
            DecimalFormat df = new DecimalFormat(OFFSETPATTERN, DecimalFormatSymbols.getInstance(Locale.ROOT));
            SimpleTextUtil.write(out, TABLEPOS);
            SimpleTextUtil.write(out, df.format(tocPos), scratch);
            SimpleTextUtil.writeNewline(out);
        }
    }

    private String stripPrefix(BytesRefBuilder scratch, BytesRef prefix) throws IOException {
        return new String(scratch.bytes(), prefix.length, scratch.length() - prefix.length, StandardCharsets.UTF_8);
    }

    static {
        int numDigits = Long.toString(Long.MAX_VALUE).length();
        char[] pattern = new char[numDigits];
        Arrays.fill(pattern, '0');
        OFFSETPATTERN = new String(pattern);
    }
}

