/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.MonotonicBlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

class MemoryDocValuesProducer
extends DocValuesProducer {
    private final Map<String, NumericEntry> numerics;
    private final Map<String, BinaryEntry> binaries;
    private final Map<String, FSTEntry> fsts;
    private final Map<String, SortedSetEntry> sortedSets;
    private final Map<String, SortedNumericEntry> sortedNumerics;
    private final IndexInput data;
    private final Map<String, NumericDocValues> numericInstances;
    private final Map<String, BytesAndAddresses> pagedBytesInstances;
    private final Map<String, FST<Long>> fstInstances;
    private final Map<String, FixedBitSet> docsWithFieldInstances;
    private final Map<String, MonotonicBlockPackedReader> addresses;
    private final Map<String, Accountable> numericInfo;
    private final int numEntries;
    private final int maxDoc;
    private final AtomicLong ramBytesUsed;
    private final int version;
    private final boolean merging;
    static final byte NUMBER = 0;
    static final byte BYTES = 1;
    static final byte FST = 2;
    static final byte SORTED_SET = 4;
    static final byte SORTED_SET_SINGLETON = 5;
    static final byte SORTED_NUMERIC = 6;
    static final byte SORTED_NUMERIC_SINGLETON = 7;
    static final int BLOCK_SIZE = 4096;
    static final byte DELTA_COMPRESSED = 0;
    static final byte TABLE_COMPRESSED = 1;
    static final byte BLOCK_COMPRESSED = 2;
    static final byte GCD_COMPRESSED = 3;
    static final int VERSION_START = 4;
    static final int VERSION_CURRENT = 4;

    MemoryDocValuesProducer(MemoryDocValuesProducer original) throws IOException {
        this.numerics = new HashMap<String, NumericEntry>();
        this.binaries = new HashMap<String, BinaryEntry>();
        this.fsts = new HashMap<String, FSTEntry>();
        this.sortedSets = new HashMap<String, SortedSetEntry>();
        this.sortedNumerics = new HashMap<String, SortedNumericEntry>();
        this.numericInstances = new HashMap<String, NumericDocValues>();
        this.pagedBytesInstances = new HashMap<String, BytesAndAddresses>();
        this.fstInstances = new HashMap<String, FST<Long>>();
        this.docsWithFieldInstances = new HashMap<String, FixedBitSet>();
        this.addresses = new HashMap<String, MonotonicBlockPackedReader>();
        this.numericInfo = new HashMap<String, Accountable>();
        assert (Thread.holdsLock(original));
        this.numerics.putAll(original.numerics);
        this.binaries.putAll(original.binaries);
        this.fsts.putAll(original.fsts);
        this.sortedSets.putAll(original.sortedSets);
        this.sortedNumerics.putAll(original.sortedNumerics);
        this.data = original.data.clone();
        this.numericInstances.putAll(original.numericInstances);
        this.pagedBytesInstances.putAll(original.pagedBytesInstances);
        this.fstInstances.putAll(original.fstInstances);
        this.docsWithFieldInstances.putAll(original.docsWithFieldInstances);
        this.addresses.putAll(original.addresses);
        this.numericInfo.putAll(original.numericInfo);
        this.numEntries = original.numEntries;
        this.maxDoc = original.maxDoc;
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.version = original.version;
        this.merging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MemoryDocValuesProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success;
        block8: {
            ChecksumIndexInput in2;
            block7: {
                this.numerics = new HashMap<String, NumericEntry>();
                this.binaries = new HashMap<String, BinaryEntry>();
                this.fsts = new HashMap<String, FSTEntry>();
                this.sortedSets = new HashMap<String, SortedSetEntry>();
                this.sortedNumerics = new HashMap<String, SortedNumericEntry>();
                this.numericInstances = new HashMap<String, NumericDocValues>();
                this.pagedBytesInstances = new HashMap<String, BytesAndAddresses>();
                this.fstInstances = new HashMap<String, FST<Long>>();
                this.docsWithFieldInstances = new HashMap<String, FixedBitSet>();
                this.addresses = new HashMap<String, MonotonicBlockPackedReader>();
                this.numericInfo = new HashMap<String, Accountable>();
                this.maxDoc = state.segmentInfo.maxDoc();
                this.merging = false;
                String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
                in2 = state.directory.openChecksumInput(metaName, state.context);
                success = false;
                try {
                    this.version = CodecUtil.checkIndexHeader(in2, metaCodec, 4, 4, state.segmentInfo.getId(), state.segmentSuffix);
                    this.numEntries = this.readFields(in2, state.fieldInfos);
                    CodecUtil.checkFooter(in2);
                    this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
                    success = true;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(in2);
                        throw throwable;
                    } else {
                        IOUtils.closeWhileHandlingException(in2);
                    }
                    throw throwable;
                }
                IOUtils.close(in2);
                break block8;
            }
            IOUtils.closeWhileHandlingException(in2);
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        success = false;
        try {
            int version2 = CodecUtil.checkIndexHeader(this.data, dataCodec, 4, 4, state.segmentInfo.getId(), state.segmentSuffix);
            if (this.version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + this.version + ", data=" + version2, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    private NumericEntry readNumericEntry(IndexInput meta) throws IOException {
        NumericEntry entry = new NumericEntry();
        entry.offset = meta.readLong();
        entry.missingOffset = meta.readLong();
        entry.missingBytes = entry.missingOffset != -1L ? meta.readLong() : 0L;
        entry.format = meta.readByte();
        switch (entry.format) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new CorruptIndexException("Unknown format: " + entry.format, meta);
            }
        }
        entry.packedIntsVersion = meta.readVInt();
        entry.count = meta.readLong();
        return entry;
    }

    private BinaryEntry readBinaryEntry(IndexInput meta) throws IOException {
        BinaryEntry entry = new BinaryEntry();
        entry.offset = meta.readLong();
        entry.numBytes = meta.readLong();
        entry.missingOffset = meta.readLong();
        entry.missingBytes = entry.missingOffset != -1L ? meta.readLong() : 0L;
        entry.minLength = meta.readVInt();
        entry.maxLength = meta.readVInt();
        if (entry.minLength != entry.maxLength) {
            entry.packedIntsVersion = meta.readVInt();
            entry.blockSize = meta.readVInt();
        }
        return entry;
    }

    private FSTEntry readFSTEntry(IndexInput meta) throws IOException {
        FSTEntry entry = new FSTEntry();
        entry.offset = meta.readLong();
        entry.numOrds = meta.readVLong();
        return entry;
    }

    private int readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int numEntries = 0;
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            Object entry;
            ++numEntries;
            FieldInfo info2 = infos.fieldInfo(fieldNumber);
            if (info2 == null) {
                throw new CorruptIndexException("invalid field number: " + fieldNumber, meta);
            }
            byte fieldType = meta.readByte();
            if (fieldType == 0) {
                this.numerics.put(info2.name, this.readNumericEntry(meta));
            } else if (fieldType == 1) {
                this.binaries.put(info2.name, this.readBinaryEntry(meta));
            } else if (fieldType == 2) {
                this.fsts.put(info2.name, this.readFSTEntry(meta));
            } else if (fieldType == 4) {
                entry = new SortedSetEntry();
                ((SortedSetEntry)entry).singleton = false;
                this.sortedSets.put(info2.name, (SortedSetEntry)entry);
            } else if (fieldType == 5) {
                entry = new SortedSetEntry();
                ((SortedSetEntry)entry).singleton = true;
                this.sortedSets.put(info2.name, (SortedSetEntry)entry);
            } else if (fieldType == 6) {
                entry = new SortedNumericEntry();
                ((SortedNumericEntry)entry).singleton = false;
                ((SortedNumericEntry)entry).packedIntsVersion = meta.readVInt();
                ((SortedNumericEntry)entry).blockSize = meta.readVInt();
                ((SortedNumericEntry)entry).addressOffset = meta.readLong();
                ((SortedNumericEntry)entry).valueCount = meta.readLong();
                this.sortedNumerics.put(info2.name, (SortedNumericEntry)entry);
            } else if (fieldType == 7) {
                entry = new SortedNumericEntry();
                ((SortedNumericEntry)entry).singleton = true;
                this.sortedNumerics.put(info2.name, (SortedNumericEntry)entry);
            } else {
                throw new CorruptIndexException("invalid entry type: " + fieldType + ", fieldName=" + info2.name, meta);
            }
            fieldNumber = meta.readVInt();
        }
        return numEntries;
    }

    @Override
    public synchronized NumericDocValues getNumeric(FieldInfo field2) throws IOException {
        NumericDocValues instance = this.numericInstances.get(field2.name);
        if (instance == null) {
            instance = this.loadNumeric(field2);
            if (!this.merging) {
                this.numericInstances.put(field2.name, instance);
            }
        }
        return instance;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public synchronized Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.addAll(Accountables.namedAccountables("numeric field", this.numericInfo));
        resources.addAll(Accountables.namedAccountables("pagedbytes field", this.pagedBytesInstances));
        resources.addAll(Accountables.namedAccountables("term dict field", this.fstInstances));
        resources.addAll(Accountables.namedAccountables("missing bitset field", this.docsWithFieldInstances));
        resources.addAll(Accountables.namedAccountables("addresses field", this.addresses));
        return Collections.unmodifiableList(resources);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data.clone());
    }

    @Override
    public synchronized DocValuesProducer getMergeInstance() throws IOException {
        return new MemoryDocValuesProducer(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(entries=" + this.numEntries + ")";
    }

    private NumericDocValues loadNumeric(FieldInfo field2) throws IOException {
        NumericEntry entry = this.numerics.get(field2.name);
        IndexInput data = this.data.clone();
        data.seek(entry.offset + entry.missingBytes);
        switch (entry.format) {
            case 1: {
                int size2 = data.readVInt();
                if (size2 > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, got=" + size2, data);
                }
                final long[] decode = new long[size2];
                for (int i = 0; i < decode.length; ++i) {
                    decode[i] = data.readLong();
                }
                int formatID = data.readVInt();
                int bitsPerValue = data.readVInt();
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader(data, PackedInts.Format.byId(formatID), entry.packedIntsVersion, (int)entry.count, bitsPerValue);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(decode) + ordsReader.ramBytesUsed());
                    this.numericInfo.put(field2.name, Accountables.namedAccountable("table compressed", ordsReader));
                }
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return decode[(int)ordsReader.get(docID)];
                    }
                };
            }
            case 0: {
                final long minDelta = data.readLong();
                int formatIDDelta = data.readVInt();
                int bitsPerValueDelta = data.readVInt();
                final PackedInts.Reader deltaReader = PackedInts.getReaderNoHeader(data, PackedInts.Format.byId(formatIDDelta), entry.packedIntsVersion, (int)entry.count, bitsPerValueDelta);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(deltaReader.ramBytesUsed());
                    this.numericInfo.put(field2.name, Accountables.namedAccountable("delta compressed", deltaReader));
                }
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return minDelta + deltaReader.get(docID);
                    }
                };
            }
            case 2: {
                int blockSize = data.readVInt();
                BlockPackedReader reader = new BlockPackedReader(data, entry.packedIntsVersion, blockSize, entry.count, false);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(reader.ramBytesUsed());
                    this.numericInfo.put(field2.name, Accountables.namedAccountable("block compressed", reader));
                }
                return reader;
            }
            case 3: {
                final long min2 = data.readLong();
                final long mult = data.readLong();
                int formatIDGCD = data.readVInt();
                int bitsPerValueGCD = data.readVInt();
                final PackedInts.Reader quotientReader = PackedInts.getReaderNoHeader(data, PackedInts.Format.byId(formatIDGCD), entry.packedIntsVersion, (int)entry.count, bitsPerValueGCD);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(quotientReader.ramBytesUsed());
                    this.numericInfo.put(field2.name, Accountables.namedAccountable("gcd compressed", quotientReader));
                }
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return min2 + mult * quotientReader.get(docID);
                    }
                };
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryDocValues getBinary(FieldInfo field2) throws IOException {
        BytesAndAddresses instance;
        BinaryEntry entry = this.binaries.get(field2.name);
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.pagedBytesInstances.get(field2.name);
            if (instance == null) {
                instance = this.loadBinary(field2);
                if (!this.merging) {
                    this.pagedBytesInstances.put(field2.name, instance);
                }
            }
        }
        final PagedBytes.Reader bytesReader = instance.reader;
        final MonotonicBlockPackedReader addresses = instance.addresses;
        if (addresses == null) {
            assert (entry.minLength == entry.maxLength);
            final int fixedLength = entry.minLength;
            return new BinaryDocValues(){
                final BytesRef term = new BytesRef();

                @Override
                public BytesRef get(int docID) {
                    bytesReader.fillSlice(this.term, (long)fixedLength * (long)docID, fixedLength);
                    return this.term;
                }
            };
        }
        return new BinaryDocValues(){
            final BytesRef term = new BytesRef();

            @Override
            public BytesRef get(int docID) {
                long startAddress = docID == 0 ? 0L : addresses.get(docID - 1);
                long endAddress = addresses.get(docID);
                bytesReader.fillSlice(this.term, startAddress, (int)(endAddress - startAddress));
                return this.term;
            }
        };
    }

    private BytesAndAddresses loadBinary(FieldInfo field2) throws IOException {
        BytesAndAddresses bytesAndAddresses = new BytesAndAddresses();
        BinaryEntry entry = this.binaries.get(field2.name);
        IndexInput data = this.data.clone();
        data.seek(entry.offset);
        PagedBytes bytes2 = new PagedBytes(16);
        bytes2.copy(data, entry.numBytes);
        bytesAndAddresses.reader = bytes2.freeze(true);
        if (!this.merging) {
            this.ramBytesUsed.addAndGet(bytesAndAddresses.reader.ramBytesUsed());
        }
        if (entry.minLength != entry.maxLength) {
            data.seek(data.getFilePointer() + entry.missingBytes);
            bytesAndAddresses.addresses = MonotonicBlockPackedReader.of(data, entry.packedIntsVersion, entry.blockSize, this.maxDoc, false);
            if (!this.merging) {
                this.ramBytesUsed.addAndGet(bytesAndAddresses.addresses.ramBytesUsed());
            }
        }
        return bytesAndAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedDocValues getSorted(FieldInfo field2) throws IOException {
        FST<Long> instance;
        final FSTEntry entry = this.fsts.get(field2.name);
        if (entry.numOrds == 0L) {
            return DocValues.emptySorted();
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.fstInstances.get(field2.name);
            if (instance == null) {
                IndexInput data = this.data.clone();
                data.seek(entry.offset);
                instance = new FST<Long>(data, PositiveIntOutputs.getSingleton());
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                    this.fstInstances.put(field2.name, instance);
                }
            }
        }
        final NumericDocValues docToOrd = this.getNumeric(field2);
        final FST<Long> fst = instance;
        final FST.BytesReader in2 = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRefBuilder scratchInts = new IntsRefBuilder();
        final BytesRefFSTEnum<Long> fstEnum = new BytesRefFSTEnum<Long>(fst);
        return new SortedDocValues(){
            final BytesRefBuilder term = new BytesRefBuilder();

            @Override
            public int getOrd(int docID) {
                return (int)docToOrd.get(docID);
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                try {
                    in2.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput(fst, ord, in2, firstArc, scratchArc, scratchInts);
                    return Util.toBytesRef(output, this.term);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public int lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1;
                    }
                    if (o.input.equals(key)) {
                        return ((Long)o.output).intValue();
                    }
                    return (int)(-((Long)o.output).longValue()) - 1;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public int getValueCount() {
                return (int)entry.numOrds;
            }

            @Override
            public TermsEnum termsEnum() {
                return new FSTTermsEnum(fst);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field2) throws IOException {
        MonotonicBlockPackedReader addr;
        SortedNumericEntry entry = this.sortedNumerics.get(field2.name);
        if (entry.singleton) {
            NumericDocValues values2 = this.getNumeric(field2);
            NumericEntry ne2 = this.numerics.get(field2.name);
            Bits docsWithField = this.getMissingBits(field2, ne2.missingOffset, ne2.missingBytes);
            return DocValues.singleton(values2, docsWithField);
        }
        final NumericDocValues values3 = this.getNumeric(field2);
        MemoryDocValuesProducer docsWithField = this;
        synchronized (docsWithField) {
            MonotonicBlockPackedReader res = this.addresses.get(field2.name);
            if (res == null) {
                IndexInput data = this.data.clone();
                data.seek(entry.addressOffset);
                res = MonotonicBlockPackedReader.of(data, entry.packedIntsVersion, entry.blockSize, entry.valueCount, false);
                if (!this.merging) {
                    this.addresses.put(field2.name, res);
                    this.ramBytesUsed.addAndGet(res.ramBytesUsed());
                }
            }
            addr = res;
        }
        if (values3 instanceof LongValues) {
            final LongValues longValues = (LongValues)values3;
            return new SortedNumericDocValues(){
                long startOffset;
                long endOffset;

                @Override
                public void setDocument(int doc2) {
                    this.startOffset = (int)addr.get(doc2);
                    this.endOffset = (int)addr.get((long)doc2 + 1L);
                }

                @Override
                public long valueAt(int index) {
                    return longValues.get(this.startOffset + (long)index);
                }

                @Override
                public int count() {
                    return (int)(this.endOffset - this.startOffset);
                }
            };
        }
        return new SortedNumericDocValues(){
            int startOffset;
            int endOffset;

            @Override
            public void setDocument(int doc2) {
                this.startOffset = (int)addr.get(doc2);
                this.endOffset = (int)addr.get(doc2 + 1);
            }

            @Override
            public long valueAt(int index) {
                return values3.get(this.startOffset + index);
            }

            @Override
            public int count() {
                return this.endOffset - this.startOffset;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field2) throws IOException {
        FST<Long> instance;
        SortedSetEntry sortedSetEntry = this.sortedSets.get(field2.name);
        if (sortedSetEntry.singleton) {
            return DocValues.singleton(this.getSorted(field2));
        }
        final FSTEntry entry = this.fsts.get(field2.name);
        if (entry.numOrds == 0L) {
            return DocValues.emptySortedSet();
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.fstInstances.get(field2.name);
            if (instance == null) {
                IndexInput data = this.data.clone();
                data.seek(entry.offset);
                instance = new FST<Long>(data, PositiveIntOutputs.getSingleton());
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                    this.fstInstances.put(field2.name, instance);
                }
            }
        }
        final BinaryDocValues docToOrds = this.getBinary(field2);
        final FST<Long> fst = instance;
        final FST.BytesReader in2 = fst.getBytesReader();
        final FST.Arc firstArc = new FST.Arc();
        final FST.Arc scratchArc = new FST.Arc();
        final IntsRefBuilder scratchInts = new IntsRefBuilder();
        final BytesRefFSTEnum<Long> fstEnum = new BytesRefFSTEnum<Long>(fst);
        final ByteArrayDataInput input2 = new ByteArrayDataInput();
        return new SortedSetDocValues(){
            final BytesRefBuilder term = new BytesRefBuilder();
            BytesRef ref;
            long currentOrd;

            @Override
            public long nextOrd() {
                if (input2.eof()) {
                    return -1L;
                }
                this.currentOrd += input2.readVLong();
                return this.currentOrd;
            }

            @Override
            public void setDocument(int docID) {
                this.ref = docToOrds.get(docID);
                input2.reset(this.ref.bytes, this.ref.offset, this.ref.length);
                this.currentOrd = 0L;
            }

            @Override
            public BytesRef lookupOrd(long ord) {
                try {
                    in2.setPosition(0L);
                    fst.getFirstArc(firstArc);
                    IntsRef output = Util.getByOutput(fst, ord, in2, firstArc, scratchArc, scratchInts);
                    return Util.toBytesRef(output, this.term);
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public long lookupTerm(BytesRef key) {
                try {
                    BytesRefFSTEnum.InputOutput o = fstEnum.seekCeil(key);
                    if (o == null) {
                        return -this.getValueCount() - 1L;
                    }
                    if (o.input.equals(key)) {
                        return ((Long)o.output).intValue();
                    }
                    return -((Long)o.output).longValue() - 1L;
                }
                catch (IOException bogus) {
                    throw new RuntimeException(bogus);
                }
            }

            @Override
            public long getValueCount() {
                return entry.numOrds;
            }

            @Override
            public TermsEnum termsEnum() {
                return new FSTTermsEnum(fst);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bits getMissingBits(FieldInfo field2, long offset, long length2) throws IOException {
        FixedBitSet instance;
        if (offset == -1L) {
            return new Bits.MatchAllBits(this.maxDoc);
        }
        MemoryDocValuesProducer memoryDocValuesProducer = this;
        synchronized (memoryDocValuesProducer) {
            instance = this.docsWithFieldInstances.get(field2.name);
            if (instance == null) {
                IndexInput data = this.data.clone();
                data.seek(offset);
                assert (length2 % 8L == 0L);
                long[] bits2 = new long[(int)length2 >> 3];
                for (int i = 0; i < bits2.length; ++i) {
                    bits2[i] = data.readLong();
                }
                instance = new FixedBitSet(bits2, this.maxDoc);
                if (!this.merging) {
                    this.docsWithFieldInstances.put(field2.name, instance);
                    this.ramBytesUsed.addAndGet(instance.ramBytesUsed());
                }
            }
        }
        return instance;
    }

    @Override
    public Bits getDocsWithField(FieldInfo field2) throws IOException {
        switch (field2.getDocValuesType()) {
            case SORTED_SET: {
                return DocValues.docsWithValue(this.getSortedSet(field2), this.maxDoc);
            }
            case SORTED_NUMERIC: {
                return DocValues.docsWithValue(this.getSortedNumeric(field2), this.maxDoc);
            }
            case SORTED: {
                return DocValues.docsWithValue(this.getSorted(field2), this.maxDoc);
            }
            case BINARY: {
                BinaryEntry be = this.binaries.get(field2.name);
                return this.getMissingBits(field2, be.missingOffset, be.missingBytes);
            }
            case NUMERIC: {
                NumericEntry ne2 = this.numerics.get(field2.name);
                return this.getMissingBits(field2, ne2.missingOffset, ne2.missingBytes);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    static class FSTTermsEnum
    extends TermsEnum {
        final BytesRefFSTEnum<Long> in;
        final FST<Long> fst;
        final FST.BytesReader bytesReader;
        final FST.Arc<Long> firstArc = new FST.Arc();
        final FST.Arc<Long> scratchArc = new FST.Arc();
        final IntsRefBuilder scratchInts = new IntsRefBuilder();
        final BytesRefBuilder scratchBytes = new BytesRefBuilder();

        FSTTermsEnum(FST<Long> fst) {
            this.fst = fst;
            this.in = new BytesRefFSTEnum<Long>(fst);
            this.bytesReader = fst.getBytesReader();
        }

        @Override
        public BytesRef next() throws IOException {
            BytesRefFSTEnum.InputOutput<Long> io = this.in.next();
            if (io == null) {
                return null;
            }
            return io.input;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef text2) throws IOException {
            if (this.in.seekCeil(text2) == null) {
                return TermsEnum.SeekStatus.END;
            }
            if (this.term().equals(text2)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        @Override
        public boolean seekExact(BytesRef text2) throws IOException {
            return this.in.seekExact(text2) != null;
        }

        @Override
        public void seekExact(long ord) throws IOException {
            this.bytesReader.setPosition(0L);
            this.fst.getFirstArc(this.firstArc);
            IntsRef output = Util.getByOutput(this.fst, ord, this.bytesReader, this.firstArc, this.scratchArc, this.scratchInts);
            this.in.seekExact(Util.toBytesRef(output, new BytesRefBuilder()));
        }

        @Override
        public BytesRef term() throws IOException {
            return this.in.current().input;
        }

        @Override
        public long ord() throws IOException {
            return (Long)this.in.current().output;
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    static class BytesAndAddresses
    implements Accountable {
        PagedBytes.Reader reader;
        MonotonicBlockPackedReader addresses;

        BytesAndAddresses() {
        }

        @Override
        public long ramBytesUsed() {
            long bytesUsed = this.reader.ramBytesUsed();
            if (this.addresses != null) {
                bytesUsed += this.addresses.ramBytesUsed();
            }
            return bytesUsed;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            if (this.addresses != null) {
                resources.add(Accountables.namedAccountable("addresses", this.addresses));
            }
            resources.add(Accountables.namedAccountable("term bytes", this.reader));
            return Collections.unmodifiableList(resources);
        }
    }

    static class SortedNumericEntry {
        boolean singleton;
        long addressOffset;
        int packedIntsVersion;
        int blockSize;
        long valueCount;

        SortedNumericEntry() {
        }
    }

    static class SortedSetEntry {
        boolean singleton;

        SortedSetEntry() {
        }
    }

    static class FSTEntry {
        long offset;
        long numOrds;

        FSTEntry() {
        }
    }

    static class BinaryEntry {
        long offset;
        long missingOffset;
        long missingBytes;
        long numBytes;
        int minLength;
        int maxLength;
        int packedIntsVersion;
        int blockSize;

        BinaryEntry() {
        }
    }

    static class NumericEntry {
        long offset;
        long count;
        long missingOffset;
        long missingBytes;
        byte format;
        int packedIntsVersion;

        NumericEntry() {
        }
    }
}

