/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.memory;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;
import org.apache.lucene.util.packed.BlockPackedWriter;
import org.apache.lucene.util.packed.MonotonicBlockPackedWriter;
import org.apache.lucene.util.packed.PackedInts;

class MemoryDocValuesConsumer
extends DocValuesConsumer {
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;
    final float acceptableOverheadRatio;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MemoryDocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension, float acceptableOverheadRatio) throws IOException {
        this.acceptableOverheadRatio = acceptableOverheadRatio;
        this.maxDoc = state.segmentInfo.maxDoc();
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeIndexHeader(this.data, dataCodec, 4, state.segmentInfo.getId(), state.segmentSuffix);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeIndexHeader(this.meta, metaCodec, 4, state.segmentInfo.getId(), state.segmentSuffix);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void addNumericField(FieldInfo field2, Iterable<Number> values2) throws IOException {
        this.addNumericField(field2, values2, true);
    }

    void addNumericField(FieldInfo field2, Iterable<Number> values2, boolean optimizeStorage) throws IOException {
        PackedInts.FormatAndBits gcdBPV;
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)0);
        this.meta.writeLong(this.data.getFilePointer());
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        long blockSum = 0L;
        long gcd = 0L;
        boolean missing = false;
        HashSet<Long> uniqueValues = null;
        long count2 = 0L;
        if (optimizeStorage) {
            uniqueValues = new HashSet<Long>();
            long currentBlockMin = Long.MAX_VALUE;
            long currentBlockMax = Long.MIN_VALUE;
            for (Number nv : values2) {
                long v;
                if (nv == null) {
                    v = 0L;
                    missing = true;
                } else {
                    v = nv.longValue();
                }
                if (gcd != 1L) {
                    if (v < -4611686018427387904L || v > 0x3FFFFFFFFFFFFFFFL) {
                        gcd = 1L;
                    } else if (count2 != 0L) {
                        gcd = MathUtil.gcd(gcd, v - minValue);
                    }
                }
                currentBlockMin = Math.min(minValue, v);
                currentBlockMax = Math.max(maxValue, v);
                minValue = Math.min(minValue, v);
                maxValue = Math.max(maxValue, v);
                if (uniqueValues != null && uniqueValues.add(v) && uniqueValues.size() > 256) {
                    uniqueValues = null;
                }
                if (++count2 % 4096L != 0L) continue;
                long blockDelta = currentBlockMax - currentBlockMin;
                int blockDeltaRequired = PackedInts.unsignedBitsRequired(blockDelta);
                int blockBPV = PackedInts.fastestFormatAndBits((int)4096, (int)blockDeltaRequired, (float)this.acceptableOverheadRatio).bitsPerValue;
                blockSum += (long)blockBPV;
                currentBlockMax = Long.MIN_VALUE;
                currentBlockMin = Long.MAX_VALUE;
            }
        } else {
            for (Number nv : values2) {
                long v = nv.longValue();
                maxValue = Math.max(v, maxValue);
                minValue = Math.min(v, minValue);
                ++count2;
            }
        }
        if (missing) {
            long start = this.data.getFilePointer();
            this.writeMissingBitset(values2);
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
        } else {
            this.meta.writeLong(-1L);
        }
        long delta = maxValue - minValue;
        int deltaRequired = delta < 0L ? 64 : PackedInts.bitsRequired(delta);
        PackedInts.FormatAndBits deltaBPV = PackedInts.fastestFormatAndBits(this.maxDoc, deltaRequired, this.acceptableOverheadRatio);
        PackedInts.FormatAndBits tableBPV = count2 < Integer.MAX_VALUE && uniqueValues != null ? PackedInts.fastestFormatAndBits(this.maxDoc, PackedInts.bitsRequired(uniqueValues.size() - 1), this.acceptableOverheadRatio) : null;
        if (count2 < Integer.MAX_VALUE && gcd != 0L && gcd != 1L) {
            long gcdDelta = (maxValue - minValue) / gcd;
            int gcdRequired = gcdDelta < 0L ? 64 : PackedInts.bitsRequired(gcdDelta);
            gcdBPV = PackedInts.fastestFormatAndBits(this.maxDoc, gcdRequired, this.acceptableOverheadRatio);
        } else {
            gcdBPV = null;
        }
        boolean doBlock = false;
        if (blockSum != 0L) {
            int numBlocks = this.maxDoc / 4096;
            float avgBPV = (float)blockSum / (float)numBlocks;
            if (numBlocks >= 4 && avgBPV + avgBPV * this.acceptableOverheadRatio < (float)deltaBPV.bitsPerValue) {
                doBlock = true;
            }
        }
        if (count2 >= Integer.MAX_VALUE) {
            doBlock = true;
        }
        if (tableBPV != null && (float)tableBPV.bitsPerValue + (float)tableBPV.bitsPerValue * this.acceptableOverheadRatio < (float)deltaBPV.bitsPerValue) {
            int i;
            this.meta.writeByte((byte)1);
            Long[] decode = uniqueValues.toArray(new Long[uniqueValues.size()]);
            HashMap<Long, Integer> encode = new HashMap<Long, Integer>();
            int length2 = 1 << tableBPV.bitsPerValue;
            this.data.writeVInt(length2);
            for (i = 0; i < decode.length; ++i) {
                this.data.writeLong(decode[i]);
                encode.put(decode[i], i);
            }
            for (i = decode.length; i < length2; ++i) {
                this.data.writeLong(0L);
            }
            this.meta.writeVInt(2);
            this.meta.writeLong(count2);
            this.data.writeVInt(tableBPV.format.getId());
            this.data.writeVInt(tableBPV.bitsPerValue);
            PackedInts.Writer writer = PackedInts.getWriterNoHeader(this.data, tableBPV.format, (int)count2, tableBPV.bitsPerValue, 1024);
            for (Number nv : values2) {
                writer.add(((Integer)encode.get(nv == null ? 0L : nv.longValue())).intValue());
            }
            writer.finish();
        } else if (gcdBPV != null && (float)gcdBPV.bitsPerValue + (float)gcdBPV.bitsPerValue * this.acceptableOverheadRatio < (float)deltaBPV.bitsPerValue) {
            this.meta.writeByte((byte)3);
            this.meta.writeVInt(2);
            this.meta.writeLong(count2);
            this.data.writeLong(minValue);
            this.data.writeLong(gcd);
            this.data.writeVInt(gcdBPV.format.getId());
            this.data.writeVInt(gcdBPV.bitsPerValue);
            PackedInts.Writer writer = PackedInts.getWriterNoHeader(this.data, gcdBPV.format, (int)count2, gcdBPV.bitsPerValue, 1024);
            for (Number nv : values2) {
                long value = nv == null ? 0L : nv.longValue();
                writer.add((value - minValue) / gcd);
            }
            writer.finish();
        } else if (doBlock) {
            this.meta.writeByte((byte)2);
            this.meta.writeVInt(2);
            this.meta.writeLong(count2);
            this.data.writeVInt(4096);
            BlockPackedWriter writer = new BlockPackedWriter(this.data, 4096);
            for (Number nv : values2) {
                writer.add(nv == null ? 0L : nv.longValue());
            }
            writer.finish();
        } else {
            this.meta.writeByte((byte)0);
            this.meta.writeVInt(2);
            this.meta.writeLong(count2);
            long minDelta = deltaBPV.bitsPerValue == 64 ? 0L : minValue;
            this.data.writeLong(minDelta);
            this.data.writeVInt(deltaBPV.format.getId());
            this.data.writeVInt(deltaBPV.bitsPerValue);
            PackedInts.Writer writer = PackedInts.getWriterNoHeader(this.data, deltaBPV.format, (int)count2, deltaBPV.bitsPerValue, 1024);
            for (Number nv : values2) {
                long v = nv == null ? 0L : nv.longValue();
                writer.add(v - minDelta);
            }
            writer.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.meta = null;
                    this.data = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.meta = null;
        this.data = null;
    }

    @Override
    public void addBinaryField(FieldInfo field2, Iterable<BytesRef> values2) throws IOException {
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)1);
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        long startFP = this.data.getFilePointer();
        boolean missing = false;
        int upto = 0;
        for (BytesRef v : values2) {
            int length2;
            if (v == null) {
                length2 = 0;
                missing = true;
            } else {
                length2 = v.length;
            }
            if (length2 > 32766) {
                throw new IllegalArgumentException("DocValuesField \"" + field2.name + "\" is too large, must be <= " + 32766 + " but got length=" + length2 + " v=" + v + "; upto=" + upto + " values=" + values2);
            }
            ++upto;
            minLength = Math.min(minLength, length2);
            maxLength = Math.max(maxLength, length2);
            if (v == null) continue;
            this.data.writeBytes(v.bytes, v.offset, v.length);
        }
        this.meta.writeLong(startFP);
        this.meta.writeLong(this.data.getFilePointer() - startFP);
        if (missing) {
            long start = this.data.getFilePointer();
            this.writeMissingBitset(values2);
            this.meta.writeLong(start);
            this.meta.writeLong(this.data.getFilePointer() - start);
        } else {
            this.meta.writeLong(-1L);
        }
        this.meta.writeVInt(minLength);
        this.meta.writeVInt(maxLength);
        if (minLength != maxLength) {
            this.meta.writeVInt(2);
            this.meta.writeVInt(4096);
            MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter(this.data, 4096);
            long addr = 0L;
            for (BytesRef v : values2) {
                if (v != null) {
                    addr += (long)v.length;
                }
                writer.add(addr);
            }
            writer.finish();
        }
    }

    private void writeFST(FieldInfo field2, Iterable<BytesRef> values2) throws IOException {
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)2);
        this.meta.writeLong(this.data.getFilePointer());
        PositiveIntOutputs outputs = PositiveIntOutputs.getSingleton();
        Builder<Long> builder = new Builder<Long>(FST.INPUT_TYPE.BYTE1, outputs);
        IntsRefBuilder scratch = new IntsRefBuilder();
        long ord = 0L;
        for (BytesRef v : values2) {
            builder.add(Util.toIntsRef(v, scratch), ord);
            ++ord;
        }
        FST<Long> fst = builder.finish();
        if (fst != null) {
            fst.save(this.data);
        }
        this.meta.writeVLong(ord);
    }

    void writeMissingBitset(Iterable<?> values2) throws IOException {
        long bits2 = 0L;
        int count2 = 0;
        for (Object v : values2) {
            if (count2 == 64) {
                this.data.writeLong(bits2);
                count2 = 0;
                bits2 = 0L;
            }
            if (v != null) {
                bits2 |= 1L << (count2 & 0x3F);
            }
            ++count2;
        }
        if (count2 > 0) {
            this.data.writeLong(bits2);
        }
    }

    @Override
    public void addSortedField(FieldInfo field2, Iterable<BytesRef> values2, Iterable<Number> docToOrd) throws IOException {
        this.addNumericField(field2, docToOrd, false);
        this.writeFST(field2, values2);
    }

    @Override
    public void addSortedNumericField(FieldInfo field2, Iterable<Number> docToValueCount, Iterable<Number> values2) throws IOException {
        this.meta.writeVInt(field2.number);
        if (MemoryDocValuesConsumer.isSingleValued(docToValueCount)) {
            this.meta.writeByte((byte)7);
            this.addNumericField(field2, MemoryDocValuesConsumer.singletonView(docToValueCount, values2, null), true);
        } else {
            this.meta.writeByte((byte)6);
            this.meta.writeVInt(2);
            this.meta.writeVInt(4096);
            this.meta.writeLong(this.data.getFilePointer());
            MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter(this.data, 4096);
            long addr = 0L;
            writer.add(addr);
            for (Number v : docToValueCount) {
                writer.add(addr += v.longValue());
            }
            writer.finish();
            long valueCount = writer.ord();
            this.meta.writeLong(valueCount);
            this.addNumericField(field2, values2, true);
        }
    }

    @Override
    public void addSortedSetField(FieldInfo field2, Iterable<BytesRef> values2, final Iterable<Number> docToOrdCount, final Iterable<Number> ords) throws IOException {
        this.meta.writeVInt(field2.number);
        if (MemoryDocValuesConsumer.isSingleValued(docToOrdCount)) {
            this.meta.writeByte((byte)5);
            this.addSortedField(field2, values2, MemoryDocValuesConsumer.singletonView(docToOrdCount, ords, -1L));
        } else {
            this.meta.writeByte((byte)4);
            this.addBinaryField(field2, new Iterable<BytesRef>(){

                @Override
                public Iterator<BytesRef> iterator() {
                    return new SortedSetIterator(docToOrdCount.iterator(), ords.iterator());
                }
            });
            this.writeFST(field2, values2);
        }
    }

    static class SortedSetIterator
    implements Iterator<BytesRef> {
        byte[] buffer = new byte[10];
        ByteArrayDataOutput out = new ByteArrayDataOutput();
        BytesRef ref = new BytesRef();
        final Iterator<Number> counts;
        final Iterator<Number> ords;

        SortedSetIterator(Iterator<Number> counts, Iterator<Number> ords) {
            this.counts = counts;
            this.ords = ords;
        }

        @Override
        public boolean hasNext() {
            return this.counts.hasNext();
        }

        @Override
        public BytesRef next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int count2 = this.counts.next().intValue();
            int maxSize = count2 * 9;
            if (maxSize > this.buffer.length) {
                this.buffer = ArrayUtil.grow(this.buffer, maxSize);
            }
            try {
                this.encodeValues(count2);
            }
            catch (IOException bogus) {
                throw new RuntimeException(bogus);
            }
            this.ref.bytes = this.buffer;
            this.ref.offset = 0;
            this.ref.length = this.out.getPosition();
            return this.ref;
        }

        private void encodeValues(int count2) throws IOException {
            this.out.reset(this.buffer);
            long lastOrd = 0L;
            for (int i = 0; i < count2; ++i) {
                long ord = this.ords.next().longValue();
                this.out.writeVLong(ord - lastOrd);
                lastOrd = ord;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

