/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Version;

public class Lucene50SegmentInfoFormat
extends SegmentInfoFormat {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene50SegmentInfo";
    static final int VERSION_START = 0;
    static final int VERSION_SAFE_MAPS = 1;
    static final int VERSION_CURRENT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory dir, String segment, byte[] segmentID, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segment, "", SI_EXTENSION);
        try (ChecksumIndexInput input2 = dir.openChecksumInput(fileName, context);){
            Throwable priorE = null;
            SegmentInfo si = null;
            try {
                Map<String, String> attributes;
                Set<String> files2;
                Map<String, String> diagnostics;
                boolean isCompoundFile;
                int format2 = CodecUtil.checkIndexHeader(input2, CODEC_NAME, 0, 1, segmentID, "");
                Version version = Version.fromBits(input2.readInt(), input2.readInt(), input2.readInt());
                int docCount = input2.readInt();
                if (docCount < 0) {
                    throw new CorruptIndexException("invalid docCount: " + docCount, input2);
                }
                boolean bl = isCompoundFile = input2.readByte() == 1;
                if (format2 >= 1) {
                    diagnostics = input2.readMapOfStrings();
                    files2 = input2.readSetOfStrings();
                    attributes = input2.readMapOfStrings();
                } else {
                    diagnostics = Collections.unmodifiableMap(input2.readStringStringMap());
                    files2 = Collections.unmodifiableSet(input2.readStringSet());
                    attributes = Collections.unmodifiableMap(input2.readStringStringMap());
                }
                si = new SegmentInfo(dir, version, segment, docCount, isCompoundFile, null, diagnostics, segmentID, attributes);
                si.setFiles(files2);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter(input2, priorE);
            }
            SegmentInfo segmentInfo = si;
            return segmentInfo;
        }
    }

    @Override
    public void write(Directory dir, SegmentInfo si, IOContext ioContext) throws IOException {
        String fileName = IndexFileNames.segmentFileName(si.name, "", SI_EXTENSION);
        try (IndexOutput output = dir.createOutput(fileName, ioContext);){
            si.addFile(fileName);
            CodecUtil.writeIndexHeader(output, CODEC_NAME, 1, si.getId(), "");
            Version version = si.getVersion();
            if (version.major < 5) {
                throw new IllegalArgumentException("invalid major version: should be >= 5 but got: " + version.major + " segment=" + si);
            }
            output.writeInt(version.major);
            output.writeInt(version.minor);
            output.writeInt(version.bugfix);
            assert (version.prerelease == 0);
            output.writeInt(si.maxDoc());
            output.writeByte((byte)(si.getUseCompoundFile() ? 1 : -1));
            output.writeMapOfStrings(si.getDiagnostics());
            Set<String> files2 = si.files();
            for (String file : files2) {
                if (IndexFileNames.parseSegmentName(file).equals(si.name)) continue;
                throw new IllegalArgumentException("invalid files: expected segment=" + si.name + ", got=" + files2);
            }
            output.writeSetOfStrings(files2);
            output.writeMapOfStrings(si.getAttributes());
            CodecUtil.writeFooter(output);
        }
    }
}

