/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.MutableBits;

public final class Lucene50LiveDocsFormat
extends LiveDocsFormat {
    private static final String EXTENSION = "liv";
    private static final String CODEC_NAME = "Lucene50LiveDocs";
    private static final int VERSION_START = 0;
    private static final int VERSION_CURRENT = 0;

    @Override
    public MutableBits newLiveDocs(int size2) throws IOException {
        FixedBitSet bits2 = new FixedBitSet(size2);
        bits2.set(0, size2);
        return bits2;
    }

    @Override
    public MutableBits newLiveDocs(Bits existing) throws IOException {
        FixedBitSet fbs = (FixedBitSet)existing;
        return fbs.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info2, IOContext context) throws IOException {
        block21: {
            long gen = info2.getDelGen();
            String name2 = IndexFileNames.fileNameFromGeneration(info2.info.name, EXTENSION, gen);
            int length2 = info2.info.maxDoc();
            Throwable throwable = null;
            try (ChecksumIndexInput input2 = dir.openChecksumInput(name2, context);){
                FixedBitSet fixedBitSet;
                Throwable priorE = null;
                try {
                    CodecUtil.checkIndexHeader(input2, CODEC_NAME, 0, 0, info2.info.getId(), Long.toString(gen, 36));
                    long[] data = new long[FixedBitSet.bits2words(length2)];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = input2.readLong();
                    }
                    FixedBitSet fbs = new FixedBitSet(data, length2);
                    if (fbs.length() - fbs.cardinality() != info2.getDelCount()) {
                        throw new CorruptIndexException("bits.deleted=" + (fbs.length() - fbs.cardinality()) + " info.delcount=" + info2.getDelCount(), input2);
                    }
                    fixedBitSet = fbs;
                }
                catch (Throwable exception) {
                    try {
                        try {
                            priorE = exception;
                        }
                        catch (Throwable throwable2) {
                            CodecUtil.checkFooter(input2, priorE);
                            throw throwable2;
                        }
                        CodecUtil.checkFooter(input2, priorE);
                        break block21;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
                CodecUtil.checkFooter(input2, priorE);
                return fixedBitSet;
            }
        }
        throw new AssertionError();
    }

    @Override
    public void writeLiveDocs(MutableBits bits2, Directory dir, SegmentCommitInfo info2, int newDelCount, IOContext context) throws IOException {
        long gen = info2.getNextDelGen();
        String name2 = IndexFileNames.fileNameFromGeneration(info2.info.name, EXTENSION, gen);
        FixedBitSet fbs = (FixedBitSet)bits2;
        if (fbs.length() - fbs.cardinality() != info2.getDelCount() + newDelCount) {
            throw new CorruptIndexException("bits.deleted=" + (fbs.length() - fbs.cardinality()) + " info.delcount=" + info2.getDelCount() + " newdelcount=" + newDelCount, name2);
        }
        long[] data = fbs.getBits();
        try (IndexOutput output = dir.createOutput(name2, context);){
            CodecUtil.writeIndexHeader(output, CODEC_NAME, 0, info2.info.getId(), Long.toString(gen, 36));
            for (int i = 0; i < data.length; ++i) {
                output.writeLong(data[i]);
            }
            CodecUtil.writeFooter(output);
        }
    }

    @Override
    public void files(SegmentCommitInfo info2, Collection<String> files2) throws IOException {
        if (info2.hasDeletions()) {
            files2.add(IndexFileNames.fileNameFromGeneration(info2.info.name, EXTENSION, info2.getDelGen()));
        }
    }
}

