/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene49;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.UndeadNormsProducer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.BlockPackedReader;
import org.apache.lucene.util.packed.PackedInts;

@Deprecated
final class Lucene49NormsProducer
extends NormsProducer {
    static final byte DELTA_COMPRESSED = 0;
    static final byte TABLE_COMPRESSED = 1;
    static final byte CONST_COMPRESSED = 2;
    static final byte UNCOMPRESSED = 3;
    static final int BLOCK_SIZE = 16384;
    private final Map<String, NormsEntry> norms;
    private final IndexInput data;
    final Map<String, NumericDocValues> instances;
    final Map<String, Accountable> instancesInfo;
    private final int maxDoc;
    private final AtomicLong ramBytesUsed;
    private final AtomicInteger activeCount;
    private final boolean merging;

    Lucene49NormsProducer(Lucene49NormsProducer original) {
        this.norms = new HashMap<String, NormsEntry>();
        this.instances = new HashMap<String, NumericDocValues>();
        this.instancesInfo = new HashMap<String, Accountable>();
        this.activeCount = new AtomicInteger();
        assert (Thread.holdsLock(original));
        this.norms.putAll(original.norms);
        this.data = original.data.clone();
        this.instances.putAll(original.instances);
        this.instancesInfo.putAll(original.instancesInfo);
        this.maxDoc = original.maxDoc;
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.activeCount.set(original.activeCount.get());
        this.merging = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene49NormsProducer(SegmentReadState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        int version;
        block20: {
            this.norms = new HashMap<String, NormsEntry>();
            this.instances = new HashMap<String, NumericDocValues>();
            this.instancesInfo = new HashMap<String, Accountable>();
            this.activeCount = new AtomicInteger();
            this.maxDoc = state.segmentInfo.maxDoc();
            this.merging = false;
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOfInstance(this.getClass()));
            version = -1;
            try (ChecksumIndexInput in2 = state.directory.openChecksumInput(metaName, state.context);){
                Throwable priorE = null;
                try {
                    version = CodecUtil.checkHeader(in2, metaCodec, 0, 0);
                    this.readFields(in2, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(in2, priorE);
                    }
                }
                CodecUtil.checkFooter(in2, priorE);
            }
        }
        String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
        this.data = state.directory.openInput(dataName, state.context);
        boolean success = false;
        try {
            int version2 = CodecUtil.checkHeader(this.data, dataCodec, 0, 0);
            if (version != version2) {
                throw new CorruptIndexException("Format versions mismatch: meta=" + version + ",data=" + version2, this.data);
            }
            CodecUtil.retrieveChecksum(this.data);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.data);
            throw throwable;
        }
    }

    private void readFields(IndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readVInt();
        while (fieldNumber != -1) {
            FieldInfo info2 = infos.fieldInfo(fieldNumber);
            if (info2 == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            if (!info2.hasNorms()) {
                throw new CorruptIndexException("Invalid field: " + info2.name, meta);
            }
            NormsEntry entry = new NormsEntry();
            entry.format = meta.readByte();
            entry.offset = meta.readLong();
            switch (entry.format) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new CorruptIndexException("Unknown format: " + entry.format, meta);
                }
            }
            this.norms.put(info2.name, entry);
            fieldNumber = meta.readVInt();
        }
    }

    @Override
    public synchronized NumericDocValues getNorms(FieldInfo field2) throws IOException {
        if (UndeadNormsProducer.isUndead(field2)) {
            return DocValues.emptyNumeric();
        }
        NumericDocValues instance = this.instances.get(field2.name);
        if (instance == null) {
            instance = this.loadNorms(field2);
            if (!this.merging) {
                this.instances.put(field2.name, instance);
                this.activeCount.incrementAndGet();
            }
        }
        return instance;
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public synchronized Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables("field", this.instancesInfo);
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.data);
    }

    private NumericDocValues loadNorms(FieldInfo field2) throws IOException {
        NormsEntry entry = this.norms.get(field2.name);
        switch (entry.format) {
            case 2: {
                if (!this.merging) {
                    this.instancesInfo.put(field2.name, Accountables.namedAccountable("constant", 8L));
                    this.ramBytesUsed.addAndGet(8L);
                }
                final long v = entry.offset;
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return v;
                    }
                };
            }
            case 3: {
                this.data.seek(entry.offset);
                final byte[] bytes2 = new byte[this.maxDoc];
                this.data.readBytes(bytes2, 0, bytes2.length);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(bytes2));
                    this.instancesInfo.put(field2.name, Accountables.namedAccountable("byte array", this.maxDoc));
                }
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return bytes2[docID];
                    }
                };
            }
            case 0: {
                this.data.seek(entry.offset);
                int packedIntsVersion = this.data.readVInt();
                int blockSize = this.data.readVInt();
                BlockPackedReader reader = new BlockPackedReader(this.data, packedIntsVersion, blockSize, this.maxDoc, false);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(reader.ramBytesUsed());
                    this.instancesInfo.put(field2.name, Accountables.namedAccountable("delta compressed", reader));
                }
                return reader;
            }
            case 1: {
                this.data.seek(entry.offset);
                int packedVersion = this.data.readVInt();
                int size2 = this.data.readVInt();
                if (size2 > 256) {
                    throw new CorruptIndexException("TABLE_COMPRESSED cannot have more than 256 distinct values, got=" + size2, this.data);
                }
                final long[] decode = new long[size2];
                for (int i = 0; i < decode.length; ++i) {
                    decode[i] = this.data.readLong();
                }
                int formatID = this.data.readVInt();
                int bitsPerValue = this.data.readVInt();
                final PackedInts.Reader ordsReader = PackedInts.getReaderNoHeader(this.data, PackedInts.Format.byId(formatID), packedVersion, this.maxDoc, bitsPerValue);
                if (!this.merging) {
                    this.ramBytesUsed.addAndGet(RamUsageEstimator.sizeOf(decode) + ordsReader.ramBytesUsed());
                    this.instancesInfo.put(field2.name, Accountables.namedAccountable("table compressed", ordsReader));
                }
                return new NumericDocValues(){

                    @Override
                    public long get(int docID) {
                        return decode[(int)ordsReader.get(docID)];
                    }
                };
            }
        }
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        this.data.close();
    }

    @Override
    public synchronized NormsProducer getMergeInstance() throws IOException {
        return new Lucene49NormsProducer(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.norms.size() + ",active=" + this.activeCount.get() + ")";
    }

    static class NormsEntry {
        byte format;
        long offset;

        NormsEntry() {
        }
    }
}

