/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene45;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.packed.BlockPackedWriter;
import org.apache.lucene.util.packed.MonotonicBlockPackedWriter;
import org.apache.lucene.util.packed.PackedInts;

@Deprecated
class Lucene45DocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    static final int BLOCK_SIZE = 16384;
    static final int ADDRESS_INTERVAL = 16;
    public static final int DELTA_COMPRESSED = 0;
    public static final int GCD_COMPRESSED = 1;
    public static final int TABLE_COMPRESSED = 2;
    public static final int BINARY_FIXED_UNCOMPRESSED = 0;
    public static final int BINARY_VARIABLE_UNCOMPRESSED = 1;
    public static final int BINARY_PREFIX_COMPRESSED = 2;
    public static final int SORTED_SET_WITH_ADDRESSES = 0;
    public static final int SORTED_SET_SINGLE_VALUED_SORTED = 1;
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene45DocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeHeader(this.data, dataCodec, 2);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeHeader(this.meta, metaCodec, 2);
            this.maxDoc = state.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void addNumericField(FieldInfo field2, Iterable<Number> values2) throws IOException {
        this.checkCanWrite(field2);
        this.addNumericField(field2, values2, true);
    }

    void addNumericField(FieldInfo field2, Iterable<Number> values2, boolean optimizeStorage) throws IOException {
        long count2 = 0L;
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        long gcd = 0L;
        boolean missing = false;
        HashSet<Long> uniqueValues = null;
        if (optimizeStorage) {
            uniqueValues = new HashSet<Long>();
            for (Number nv : values2) {
                long v;
                if (nv == null) {
                    v = 0L;
                    missing = true;
                } else {
                    v = nv.longValue();
                }
                if (gcd != 1L) {
                    if (v < -4611686018427387904L || v > 0x3FFFFFFFFFFFFFFFL) {
                        gcd = 1L;
                    } else if (count2 != 0L) {
                        gcd = MathUtil.gcd(gcd, v - minValue);
                    }
                }
                minValue = Math.min(minValue, v);
                maxValue = Math.max(maxValue, v);
                if (uniqueValues != null && uniqueValues.add(v) && uniqueValues.size() > 256) {
                    uniqueValues = null;
                }
                ++count2;
            }
        } else {
            for (Number nv : values2) {
                ++count2;
            }
        }
        long delta = maxValue - minValue;
        int format2 = uniqueValues != null && PackedInts.bitsRequired(uniqueValues.size() - 1) < PackedInts.unsignedBitsRequired(delta) && count2 <= Integer.MAX_VALUE ? 2 : (gcd != 0L && gcd != 1L ? 1 : 0);
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(format2);
        if (missing) {
            this.meta.writeLong(this.data.getFilePointer());
            this.writeMissingBitset(values2);
        } else {
            this.meta.writeLong(-1L);
        }
        this.meta.writeVInt(2);
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong(count2);
        this.meta.writeVInt(16384);
        switch (format2) {
            case 1: {
                this.meta.writeLong(minValue);
                this.meta.writeLong(gcd);
                BlockPackedWriter quotientWriter = new BlockPackedWriter(this.data, 16384);
                for (Number nv : values2) {
                    long value = nv == null ? 0L : nv.longValue();
                    quotientWriter.add((value - minValue) / gcd);
                }
                quotientWriter.finish();
                break;
            }
            case 0: {
                BlockPackedWriter writer = new BlockPackedWriter(this.data, 16384);
                for (Number nv : values2) {
                    writer.add(nv == null ? 0L : nv.longValue());
                }
                writer.finish();
                break;
            }
            case 2: {
                Long[] decode = uniqueValues.toArray(new Long[uniqueValues.size()]);
                HashMap<Long, Integer> encode = new HashMap<Long, Integer>();
                this.meta.writeVInt(decode.length);
                for (int i = 0; i < decode.length; ++i) {
                    this.meta.writeLong(decode[i]);
                    encode.put(decode[i], i);
                }
                int bitsRequired = PackedInts.bitsRequired(uniqueValues.size() - 1);
                PackedInts.Writer ordsWriter = PackedInts.getWriterNoHeader(this.data, PackedInts.Format.PACKED, (int)count2, bitsRequired, 1024);
                for (Number nv : values2) {
                    ordsWriter.add(((Integer)encode.get(nv == null ? 0L : nv.longValue())).intValue());
                }
                ordsWriter.finish();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    void writeMissingBitset(Iterable<?> values2) throws IOException {
        byte bits2 = 0;
        int count2 = 0;
        for (Object v : values2) {
            if (count2 == 8) {
                this.data.writeByte(bits2);
                count2 = 0;
                bits2 = 0;
            }
            if (v != null) {
                bits2 = (byte)(bits2 | 1 << (count2 & 7));
            }
            ++count2;
        }
        if (count2 > 0) {
            this.data.writeByte(bits2);
        }
    }

    @Override
    public void addBinaryField(FieldInfo field2, Iterable<BytesRef> values2) throws IOException {
        this.checkCanWrite(field2);
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)1);
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        long startFP = this.data.getFilePointer();
        long count2 = 0L;
        boolean missing = false;
        for (BytesRef v : values2) {
            int length2;
            if (v == null) {
                length2 = 0;
                missing = true;
            } else {
                length2 = v.length;
            }
            minLength = Math.min(minLength, length2);
            maxLength = Math.max(maxLength, length2);
            if (v != null) {
                this.data.writeBytes(v.bytes, v.offset, v.length);
            }
            ++count2;
        }
        this.meta.writeVInt(minLength == maxLength ? 0 : 1);
        if (missing) {
            this.meta.writeLong(this.data.getFilePointer());
            this.writeMissingBitset(values2);
        } else {
            this.meta.writeLong(-1L);
        }
        this.meta.writeVInt(minLength);
        this.meta.writeVInt(maxLength);
        this.meta.writeVLong(count2);
        this.meta.writeLong(startFP);
        if (minLength != maxLength) {
            this.meta.writeLong(this.data.getFilePointer());
            this.meta.writeVInt(2);
            this.meta.writeVInt(16384);
            MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter(this.data, 16384);
            long addr = 0L;
            for (BytesRef v : values2) {
                if (v != null) {
                    addr += (long)v.length;
                }
                writer.add(addr);
            }
            writer.finish();
        }
    }

    protected void addTermsDict(FieldInfo field2, Iterable<BytesRef> values2) throws IOException {
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        for (BytesRef v : values2) {
            minLength = Math.min(minLength, v.length);
            maxLength = Math.max(maxLength, v.length);
        }
        if (minLength == maxLength) {
            this.addBinaryField(field2, values2);
        } else {
            this.meta.writeVInt(field2.number);
            this.meta.writeByte((byte)1);
            this.meta.writeVInt(2);
            this.meta.writeLong(-1L);
            long startFP = this.data.getFilePointer();
            RAMOutputStream addressBuffer = new RAMOutputStream();
            MonotonicBlockPackedWriter termAddresses = new MonotonicBlockPackedWriter(addressBuffer, 16384);
            BytesRefBuilder lastTerm = new BytesRefBuilder();
            long count2 = 0L;
            for (BytesRef v : values2) {
                if (count2 % 16L == 0L) {
                    termAddresses.add(this.data.getFilePointer() - startFP);
                    lastTerm.clear();
                }
                int sharedPrefix = StringHelper.bytesDifference(lastTerm.get(), v);
                this.data.writeVInt(sharedPrefix);
                this.data.writeVInt(v.length - sharedPrefix);
                this.data.writeBytes(v.bytes, v.offset + sharedPrefix, v.length - sharedPrefix);
                lastTerm.copyBytes(v);
                ++count2;
            }
            long indexStartFP = this.data.getFilePointer();
            termAddresses.finish();
            addressBuffer.writeTo(this.data);
            addressBuffer = null;
            termAddresses = null;
            this.meta.writeVInt(minLength);
            this.meta.writeVInt(maxLength);
            this.meta.writeVLong(count2);
            this.meta.writeLong(startFP);
            this.meta.writeVInt(16);
            this.meta.writeLong(indexStartFP);
            this.meta.writeVInt(2);
            this.meta.writeVInt(16384);
        }
    }

    @Override
    public void addSortedField(FieldInfo field2, Iterable<BytesRef> values2, Iterable<Number> docToOrd) throws IOException {
        this.checkCanWrite(field2);
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)2);
        this.addTermsDict(field2, values2);
        this.addNumericField(field2, docToOrd, false);
    }

    @Override
    public void addSortedNumericField(FieldInfo field2, Iterable<Number> docToValueCount, Iterable<Number> values2) throws IOException {
        throw new UnsupportedOperationException("Lucene 4.5 does not support SORTED_NUMERIC");
    }

    @Override
    public void addSortedSetField(FieldInfo field2, Iterable<BytesRef> values2, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
        this.checkCanWrite(field2);
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)3);
        if (Lucene45DocValuesConsumer.isSingleValued(docToOrdCount)) {
            this.meta.writeVInt(1);
            this.addSortedField(field2, values2, Lucene45DocValuesConsumer.singletonView(docToOrdCount, ords, -1L));
            return;
        }
        this.meta.writeVInt(0);
        this.addTermsDict(field2, values2);
        this.addNumericField(field2, ords, false);
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(0);
        this.meta.writeLong(-1L);
        this.meta.writeVInt(2);
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong(this.maxDoc);
        this.meta.writeVInt(16384);
        MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter(this.data, 16384);
        long addr = 0L;
        for (Number v : docToOrdCount) {
            writer.add(addr += v.longValue());
        }
        writer.finish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }

    void checkCanWrite(FieldInfo field2) {
        if (field2.getDocValuesType() != DocValuesType.NUMERIC && field2.getDocValuesType() != DocValuesType.BINARY || field2.getDocValuesGen() == -1L) {
            throw new UnsupportedOperationException("this codec can only be used for reading");
        }
    }
}

