/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene42;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.UndeadNormsProducer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;

@Deprecated
public class Lucene42FieldInfosFormat
extends FieldInfosFormat {
    static final String EXTENSION = "fnm";
    static final String CODEC_NAME = "Lucene42FieldInfos";
    static final int FORMAT_START = 0;
    static final int FORMAT_CURRENT = 0;
    static final byte IS_INDEXED = 1;
    static final byte STORE_TERMVECTOR = 2;
    static final byte STORE_OFFSETS_IN_POSTINGS = 4;
    static final byte OMIT_NORMS = 16;
    static final byte STORE_PAYLOADS = 32;
    static final byte OMIT_TERM_FREQ_AND_POSITIONS = 64;
    static final byte OMIT_POSITIONS = -128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext iocontext) throws IOException {
        FieldInfos fieldInfos;
        block8: {
            IndexInput input2;
            block7: {
                String fileName = IndexFileNames.segmentFileName(segmentInfo.name, "", EXTENSION);
                input2 = directory.openInput(fileName, iocontext);
                boolean success = false;
                try {
                    CodecUtil.checkHeader(input2, CODEC_NAME, 0, 0);
                    int size2 = input2.readVInt();
                    FieldInfo[] infos = new FieldInfo[size2];
                    for (int i = 0; i < size2; ++i) {
                        boolean storePayloads;
                        String name2 = input2.readString();
                        int fieldNumber = input2.readVInt();
                        if (fieldNumber < 0) {
                            throw new CorruptIndexException("invalid field number for field: " + name2 + ", fieldNumber=" + fieldNumber, input2);
                        }
                        byte bits2 = input2.readByte();
                        boolean isIndexed = (bits2 & 1) != 0;
                        boolean storeTermVector = (bits2 & 2) != 0;
                        boolean omitNorms = (bits2 & 0x10) != 0;
                        boolean bl = storePayloads = (bits2 & 0x20) != 0;
                        IndexOptions indexOptions = !isIndexed ? IndexOptions.NONE : ((bits2 & 0x40) != 0 ? IndexOptions.DOCS : ((bits2 & 0xFFFFFF80) != 0 ? IndexOptions.DOCS_AND_FREQS : ((bits2 & 4) != 0 ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS)));
                        byte val = input2.readByte();
                        DocValuesType docValuesType = Lucene42FieldInfosFormat.getDocValuesType(input2, (byte)(val & 0xF));
                        DocValuesType normsType = Lucene42FieldInfosFormat.getDocValuesType(input2, (byte)(val >>> 4 & 0xF));
                        Map<String, String> attributes = input2.readStringStringMap();
                        if (isIndexed && !omitNorms && normsType == DocValuesType.NONE) {
                            UndeadNormsProducer.setUndead(attributes);
                        }
                        infos[i] = new FieldInfo(name2, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, -1L, Collections.unmodifiableMap(attributes));
                        infos[i].checkConsistency();
                    }
                    CodecUtil.checkEOF(input2);
                    FieldInfos fieldInfos2 = new FieldInfos(infos);
                    success = true;
                    fieldInfos = fieldInfos2;
                    if (!success) break block7;
                }
                catch (Throwable throwable) {
                    if (success) {
                        input2.close();
                    } else {
                        IOUtils.closeWhileHandlingException(input2);
                    }
                    throw throwable;
                }
                input2.close();
                break block8;
            }
            IOUtils.closeWhileHandlingException(input2);
        }
        return fieldInfos;
    }

    private static DocValuesType getDocValuesType(IndexInput input2, byte b) throws IOException {
        if (b == 0) {
            return DocValuesType.NONE;
        }
        if (b == 1) {
            return DocValuesType.NUMERIC;
        }
        if (b == 2) {
            return DocValuesType.BINARY;
        }
        if (b == 3) {
            return DocValuesType.SORTED;
        }
        if (b == 4) {
            return DocValuesType.SORTED_SET;
        }
        throw new CorruptIndexException("invalid docvalues byte: " + b, input2);
    }

    @Override
    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        throw new UnsupportedOperationException("this codec can only be used for reading");
    }
}

