/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene410;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.packed.DirectWriter;
import org.apache.lucene.util.packed.MonotonicBlockPackedWriter;

@Deprecated
class Lucene410DocValuesConsumer
extends DocValuesConsumer
implements Closeable {
    static final int BLOCK_SIZE = 16384;
    static final int INTERVAL_SHIFT = 4;
    static final int INTERVAL_COUNT = 16;
    static final int INTERVAL_MASK = 15;
    static final int REVERSE_INTERVAL_SHIFT = 10;
    static final int REVERSE_INTERVAL_COUNT = 1024;
    static final int REVERSE_INTERVAL_MASK = 1023;
    static final int BLOCK_INTERVAL_SHIFT = 6;
    static final int BLOCK_INTERVAL_COUNT = 64;
    static final int BLOCK_INTERVAL_MASK = 63;
    public static final int DELTA_COMPRESSED = 0;
    public static final int GCD_COMPRESSED = 1;
    public static final int TABLE_COMPRESSED = 2;
    public static final int MONOTONIC_COMPRESSED = 3;
    public static final int BINARY_FIXED_UNCOMPRESSED = 0;
    public static final int BINARY_VARIABLE_UNCOMPRESSED = 1;
    public static final int BINARY_PREFIX_COMPRESSED = 2;
    public static final int SORTED_WITH_ADDRESSES = 0;
    public static final int SORTED_SINGLE_VALUED = 1;
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene410DocValuesConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeHeader(this.data, dataCodec, 0);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeHeader(this.meta, metaCodec, 0);
            this.maxDoc = state.segmentInfo.maxDoc();
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void addNumericField(FieldInfo field2, Iterable<Number> values2) throws IOException {
        this.checkCanWrite(field2);
        this.addNumericField(field2, values2, true);
    }

    void addNumericField(FieldInfo field2, Iterable<Number> values2, boolean optimizeStorage) throws IOException {
        long gcdDelta;
        long gcdBitsRequired;
        int tableBitsRequired;
        long v;
        long count2 = 0L;
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        long gcd = 0L;
        boolean missing = false;
        HashSet<Long> uniqueValues = null;
        if (optimizeStorage) {
            uniqueValues = new HashSet<Long>();
            for (Number nv : values2) {
                if (nv == null) {
                    v = 0L;
                    missing = true;
                } else {
                    v = nv.longValue();
                }
                if (gcd != 1L) {
                    if (v < -4611686018427387904L || v > 0x3FFFFFFFFFFFFFFFL) {
                        gcd = 1L;
                    } else if (count2 != 0L) {
                        gcd = MathUtil.gcd(gcd, v - minValue);
                    }
                }
                minValue = Math.min(minValue, v);
                maxValue = Math.max(maxValue, v);
                if (uniqueValues != null && uniqueValues.add(v) && uniqueValues.size() > 256) {
                    uniqueValues = null;
                }
                ++count2;
            }
        } else {
            for (Number nv : values2) {
                v = nv.longValue();
                minValue = Math.min(minValue, v);
                maxValue = Math.max(maxValue, v);
                ++count2;
            }
        }
        long delta = maxValue - minValue;
        int deltaBitsRequired = DirectWriter.unsignedBitsRequired(delta);
        int n = tableBitsRequired = uniqueValues == null ? Integer.MAX_VALUE : DirectWriter.bitsRequired(uniqueValues.size() - 1);
        int format2 = uniqueValues != null && tableBitsRequired < deltaBitsRequired ? 2 : (gcd != 0L && gcd != 1L ? ((gcdBitsRequired = (long)DirectWriter.unsignedBitsRequired(gcdDelta = (maxValue - minValue) / gcd)) < (long)deltaBitsRequired ? 1 : 0) : 0);
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(format2);
        if (missing) {
            this.meta.writeLong(this.data.getFilePointer());
            this.writeMissingBitset(values2);
        } else {
            this.meta.writeLong(-1L);
        }
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong(count2);
        switch (format2) {
            case 1: {
                this.meta.writeLong(minValue);
                this.meta.writeLong(gcd);
                long maxDelta = (maxValue - minValue) / gcd;
                int bits2 = DirectWriter.unsignedBitsRequired(maxDelta);
                this.meta.writeVInt(bits2);
                DirectWriter quotientWriter = DirectWriter.getInstance(this.data, count2, bits2);
                for (Number nv : values2) {
                    long value = nv == null ? 0L : nv.longValue();
                    quotientWriter.add((value - minValue) / gcd);
                }
                quotientWriter.finish();
                break;
            }
            case 0: {
                long minDelta = delta < 0L ? 0L : minValue;
                this.meta.writeLong(minDelta);
                this.meta.writeVInt(deltaBitsRequired);
                DirectWriter writer = DirectWriter.getInstance(this.data, count2, deltaBitsRequired);
                for (Number nv : values2) {
                    long v2 = nv == null ? 0L : nv.longValue();
                    writer.add(v2 - minDelta);
                }
                writer.finish();
                break;
            }
            case 2: {
                Object[] decode = uniqueValues.toArray(new Long[uniqueValues.size()]);
                Arrays.sort(decode);
                HashMap<Object, Integer> encode = new HashMap<Object, Integer>();
                this.meta.writeVInt(decode.length);
                for (int i = 0; i < decode.length; ++i) {
                    this.meta.writeLong((Long)decode[i]);
                    encode.put(decode[i], i);
                }
                this.meta.writeVInt(tableBitsRequired);
                DirectWriter ordsWriter = DirectWriter.getInstance(this.data, count2, tableBitsRequired);
                for (Number nv : values2) {
                    ordsWriter.add(((Integer)encode.get(nv == null ? 0L : nv.longValue())).intValue());
                }
                ordsWriter.finish();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.meta.writeLong(this.data.getFilePointer());
    }

    void writeMissingBitset(Iterable<?> values2) throws IOException {
        byte bits2 = 0;
        int count2 = 0;
        for (Object v : values2) {
            if (count2 == 8) {
                this.data.writeByte(bits2);
                count2 = 0;
                bits2 = 0;
            }
            if (v != null) {
                bits2 = (byte)(bits2 | 1 << (count2 & 7));
            }
            ++count2;
        }
        if (count2 > 0) {
            this.data.writeByte(bits2);
        }
    }

    @Override
    public void addBinaryField(FieldInfo field2, Iterable<BytesRef> values2) throws IOException {
        this.checkCanWrite(field2);
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)1);
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        long startFP = this.data.getFilePointer();
        long count2 = 0L;
        boolean missing = false;
        for (BytesRef v : values2) {
            int length2;
            if (v == null) {
                length2 = 0;
                missing = true;
            } else {
                length2 = v.length;
            }
            minLength = Math.min(minLength, length2);
            maxLength = Math.max(maxLength, length2);
            if (v != null) {
                this.data.writeBytes(v.bytes, v.offset, v.length);
            }
            ++count2;
        }
        this.meta.writeVInt(minLength == maxLength ? 0 : 1);
        if (missing) {
            this.meta.writeLong(this.data.getFilePointer());
            this.writeMissingBitset(values2);
        } else {
            this.meta.writeLong(-1L);
        }
        this.meta.writeVInt(minLength);
        this.meta.writeVInt(maxLength);
        this.meta.writeVLong(count2);
        this.meta.writeLong(startFP);
        if (minLength != maxLength) {
            this.meta.writeLong(this.data.getFilePointer());
            this.meta.writeVInt(2);
            this.meta.writeVInt(16384);
            MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter(this.data, 16384);
            long addr = 0L;
            writer.add(addr);
            for (BytesRef v : values2) {
                if (v != null) {
                    addr += (long)v.length;
                }
                writer.add(addr);
            }
            writer.finish();
        }
    }

    private void addTermsDict(FieldInfo field2, Iterable<BytesRef> values2) throws IOException {
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        long numValues = 0L;
        for (BytesRef v : values2) {
            minLength = Math.min(minLength, v.length);
            maxLength = Math.max(maxLength, v.length);
            ++numValues;
        }
        if (minLength == maxLength) {
            this.addBinaryField(field2, values2);
        } else if (numValues < 1024L) {
            this.addBinaryField(field2, values2);
        } else {
            assert (numValues > 0L);
            this.meta.writeVInt(field2.number);
            this.meta.writeByte((byte)1);
            this.meta.writeVInt(2);
            this.meta.writeLong(-1L);
            long startFP = this.data.getFilePointer();
            RAMOutputStream addressBuffer = new RAMOutputStream();
            MonotonicBlockPackedWriter termAddresses = new MonotonicBlockPackedWriter(addressBuffer, 16384);
            RAMOutputStream bytesBuffer = new RAMOutputStream();
            RAMOutputStream headerBuffer = new RAMOutputStream();
            BytesRefBuilder lastTerm = new BytesRefBuilder();
            lastTerm.grow(maxLength);
            long count2 = 0L;
            int[] suffixDeltas = new int[16];
            for (BytesRef v : values2) {
                int termPosition = (int)(count2 & 0xFL);
                if (termPosition == 0) {
                    termAddresses.add(this.data.getFilePointer() - startFP);
                    headerBuffer.writeVInt(v.length);
                    headerBuffer.writeBytes(v.bytes, v.offset, v.length);
                    lastTerm.copyBytes(v);
                } else {
                    int sharedPrefix = Math.min(255, StringHelper.bytesDifference(lastTerm.get(), v));
                    bytesBuffer.writeByte((byte)sharedPrefix);
                    bytesBuffer.writeBytes(v.bytes, v.offset + sharedPrefix, v.length - sharedPrefix);
                    suffixDeltas[termPosition] = v.length - sharedPrefix - 1;
                }
                if ((++count2 & 0xFL) != 0L) continue;
                this.flushTermsDictBlock(headerBuffer, bytesBuffer, suffixDeltas);
            }
            int leftover = (int)(count2 & 0xFL);
            if (leftover > 0) {
                Arrays.fill(suffixDeltas, leftover, suffixDeltas.length, 0);
                this.flushTermsDictBlock(headerBuffer, bytesBuffer, suffixDeltas);
            }
            long indexStartFP = this.data.getFilePointer();
            termAddresses.finish();
            addressBuffer.writeTo(this.data);
            addressBuffer = null;
            termAddresses = null;
            this.meta.writeVInt(minLength);
            this.meta.writeVInt(maxLength);
            this.meta.writeVLong(count2);
            this.meta.writeLong(startFP);
            this.meta.writeLong(indexStartFP);
            this.meta.writeVInt(2);
            this.meta.writeVInt(16384);
            this.addReverseTermIndex(field2, values2, maxLength);
        }
    }

    private void flushTermsDictBlock(RAMOutputStream headerBuffer, RAMOutputStream bytesBuffer, int[] suffixDeltas) throws IOException {
        int i;
        boolean twoByte = false;
        for (i = 1; i < suffixDeltas.length; ++i) {
            if (suffixDeltas[i] <= 254) continue;
            twoByte = true;
        }
        if (twoByte) {
            headerBuffer.writeByte((byte)-1);
            for (i = 1; i < suffixDeltas.length; ++i) {
                headerBuffer.writeShort((short)suffixDeltas[i]);
            }
        } else {
            for (i = 1; i < suffixDeltas.length; ++i) {
                headerBuffer.writeByte((byte)suffixDeltas[i]);
            }
        }
        headerBuffer.writeTo(this.data);
        headerBuffer.reset();
        bytesBuffer.writeTo(this.data);
        bytesBuffer.reset();
    }

    private void addReverseTermIndex(FieldInfo field2, Iterable<BytesRef> values2, int maxLength) throws IOException {
        long count2 = 0L;
        BytesRefBuilder priorTerm = new BytesRefBuilder();
        priorTerm.grow(maxLength);
        BytesRef indexTerm = new BytesRef();
        long startFP = this.data.getFilePointer();
        PagedBytes pagedBytes = new PagedBytes(15);
        MonotonicBlockPackedWriter addresses = new MonotonicBlockPackedWriter(this.data, 16384);
        for (BytesRef b : values2) {
            int termPosition = (int)(count2 & 0x3FFL);
            if (termPosition == 0) {
                int len = StringHelper.sortKeyLength(priorTerm.get(), b);
                indexTerm.bytes = b.bytes;
                indexTerm.offset = b.offset;
                indexTerm.length = len;
                addresses.add(pagedBytes.copyUsingLengthPrefix(indexTerm));
            } else if (termPosition == 1023) {
                priorTerm.copyBytes(b);
            }
            ++count2;
        }
        addresses.finish();
        long numBytes = pagedBytes.getPointer();
        pagedBytes.freeze(true);
        PagedBytes.PagedBytesDataInput in2 = pagedBytes.getDataInput();
        this.meta.writeLong(startFP);
        this.data.writeVLong(numBytes);
        this.data.copyBytes(in2, numBytes);
    }

    @Override
    public void addSortedField(FieldInfo field2, Iterable<BytesRef> values2, Iterable<Number> docToOrd) throws IOException {
        this.checkCanWrite(field2);
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)2);
        this.addTermsDict(field2, values2);
        this.addNumericField(field2, docToOrd, false);
    }

    @Override
    public void addSortedNumericField(FieldInfo field2, Iterable<Number> docToValueCount, Iterable<Number> values2) throws IOException {
        this.checkCanWrite(field2);
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)4);
        if (Lucene410DocValuesConsumer.isSingleValued(docToValueCount)) {
            this.meta.writeVInt(1);
            this.addNumericField(field2, Lucene410DocValuesConsumer.singletonView(docToValueCount, values2, null));
        } else {
            this.meta.writeVInt(0);
            this.addNumericField(field2, values2, true);
            this.addAddresses(field2, docToValueCount);
        }
    }

    @Override
    public void addSortedSetField(FieldInfo field2, Iterable<BytesRef> values2, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
        this.checkCanWrite(field2);
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)3);
        if (Lucene410DocValuesConsumer.isSingleValued(docToOrdCount)) {
            this.meta.writeVInt(1);
            this.addSortedField(field2, values2, Lucene410DocValuesConsumer.singletonView(docToOrdCount, ords, -1L));
        } else {
            this.meta.writeVInt(0);
            this.addTermsDict(field2, values2);
            this.addNumericField(field2, ords, false);
            this.addAddresses(field2, docToOrdCount);
        }
    }

    private void addAddresses(FieldInfo field2, Iterable<Number> values2) throws IOException {
        this.meta.writeVInt(field2.number);
        this.meta.writeByte((byte)0);
        this.meta.writeVInt(3);
        this.meta.writeLong(-1L);
        this.meta.writeLong(this.data.getFilePointer());
        this.meta.writeVLong(this.maxDoc);
        this.meta.writeVInt(2);
        this.meta.writeVInt(16384);
        MonotonicBlockPackedWriter writer = new MonotonicBlockPackedWriter(this.data, 16384);
        long addr = 0L;
        writer.add(addr);
        for (Number v : values2) {
            writer.add(addr += v.longValue());
        }
        writer.finish();
        this.meta.writeLong(this.data.getFilePointer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }

    void checkCanWrite(FieldInfo field2) {
        if (field2.getDocValuesType() != DocValuesType.NUMERIC && field2.getDocValuesType() != DocValuesType.BINARY || field2.getDocValuesGen() == -1L) {
            throw new UnsupportedOperationException("this codec can only be used for reading");
        }
    }
}

