/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.lucene40.BitVector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.MutableBits;

@Deprecated
public final class Lucene40LiveDocsFormat
extends LiveDocsFormat {
    static final String DELETES_EXTENSION = "del";

    @Override
    public MutableBits newLiveDocs(int size2) throws IOException {
        BitVector bitVector = new BitVector(size2);
        bitVector.invertAll();
        return bitVector;
    }

    @Override
    public MutableBits newLiveDocs(Bits existing) throws IOException {
        BitVector liveDocs = (BitVector)existing;
        return liveDocs.clone();
    }

    @Override
    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info2, IOContext context) throws IOException {
        String filename = IndexFileNames.fileNameFromGeneration(info2.info.name, DELETES_EXTENSION, info2.getDelGen());
        BitVector liveDocs = new BitVector(dir, filename, context);
        if (liveDocs.length() != info2.info.maxDoc()) {
            throw new CorruptIndexException("liveDocs.length()=" + liveDocs.length() + "info.docCount=" + info2.info.maxDoc(), filename);
        }
        if (liveDocs.count() != info2.info.maxDoc() - info2.getDelCount()) {
            throw new CorruptIndexException("liveDocs.count()=" + liveDocs.count() + " info.docCount=" + info2.info.maxDoc() + " info.getDelCount()=" + info2.getDelCount(), filename);
        }
        return liveDocs;
    }

    @Override
    public void writeLiveDocs(MutableBits bits2, Directory dir, SegmentCommitInfo info2, int newDelCount, IOContext context) throws IOException {
        String filename = IndexFileNames.fileNameFromGeneration(info2.info.name, DELETES_EXTENSION, info2.getNextDelGen());
        BitVector liveDocs = (BitVector)bits2;
        if (liveDocs.length() != info2.info.maxDoc()) {
            throw new CorruptIndexException("liveDocs.length()=" + liveDocs.length() + "info.docCount=" + info2.info.maxDoc(), filename);
        }
        if (liveDocs.count() != info2.info.maxDoc() - info2.getDelCount() - newDelCount) {
            throw new CorruptIndexException("liveDocs.count()=" + liveDocs.count() + " info.docCount=" + info2.info.maxDoc() + " info.getDelCount()=" + info2.getDelCount() + " newDelCount=" + newDelCount, filename);
        }
        liveDocs.write(dir, filename, context);
    }

    @Override
    public void files(SegmentCommitInfo info2, Collection<String> files2) throws IOException {
        if (info2.hasDeletions()) {
            files2.add(IndexFileNames.fileNameFromGeneration(info2.info.name, DELETES_EXTENSION, info2.getDelGen()));
        }
    }
}

