/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene40.Lucene40CompoundReader;
import org.apache.lucene.codecs.lucene40.Lucene40FieldInfosFormat;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

@Deprecated
final class Lucene40DocValuesReader
extends DocValuesProducer {
    private final Directory dir;
    private final SegmentReadState state;
    private final String legacyKey;
    private static final String segmentSuffix = "dv";
    private final Map<String, NumericDocValues> numericInstances = new HashMap<String, NumericDocValues>();
    private final Map<String, BinaryDocValues> binaryInstances = new HashMap<String, BinaryDocValues>();
    private final Map<String, SortedDocValues> sortedInstances = new HashMap<String, SortedDocValues>();
    private final Map<String, Accountable> instanceInfo = new HashMap<String, Accountable>();
    private final AtomicLong ramBytesUsed;
    private final boolean merging;

    Lucene40DocValuesReader(Lucene40DocValuesReader original) throws IOException {
        assert (Thread.holdsLock(original));
        this.dir = original.dir;
        this.state = original.state;
        this.legacyKey = original.legacyKey;
        this.numericInstances.putAll(original.numericInstances);
        this.binaryInstances.putAll(original.binaryInstances);
        this.sortedInstances.putAll(original.sortedInstances);
        this.instanceInfo.putAll(original.instanceInfo);
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.merging = true;
    }

    Lucene40DocValuesReader(SegmentReadState state, String filename, String legacyKey) throws IOException {
        this.state = state;
        this.legacyKey = legacyKey;
        this.dir = new Lucene40CompoundReader(state.directory, filename, state.context, false);
        this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOf(this.getClass()));
        this.merging = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized NumericDocValues getNumeric(FieldInfo field2) throws IOException {
        NumericDocValues instance;
        block15: {
            block16: {
                IndexInput input2;
                block14: {
                    instance = this.numericInstances.get(field2.name);
                    if (instance != null) break block15;
                    String fileName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "dat");
                    input2 = this.dir.openInput(fileName, this.state.context);
                    boolean success = false;
                    try {
                        switch (Lucene40FieldInfosFormat.LegacyDocValuesType.valueOf(field2.getAttribute(this.legacyKey))) {
                            case VAR_INTS: {
                                instance = this.loadVarIntsField(field2, input2);
                                break;
                            }
                            case FIXED_INTS_8: {
                                instance = this.loadByteField(field2, input2);
                                break;
                            }
                            case FIXED_INTS_16: {
                                instance = this.loadShortField(field2, input2);
                                break;
                            }
                            case FIXED_INTS_32: {
                                instance = this.loadIntField(field2, input2);
                                break;
                            }
                            case FIXED_INTS_64: {
                                instance = this.loadLongField(field2, input2);
                                break;
                            }
                            case FLOAT_32: {
                                instance = this.loadFloatField(field2, input2);
                                break;
                            }
                            case FLOAT_64: {
                                instance = this.loadDoubleField(field2, input2);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        CodecUtil.checkEOF(input2);
                        success = true;
                        if (!success) break block14;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close(input2);
                        } else {
                            IOUtils.closeWhileHandlingException(input2);
                        }
                        throw throwable;
                    }
                    IOUtils.close(input2);
                    break block16;
                }
                IOUtils.closeWhileHandlingException(input2);
            }
            if (!this.merging) {
                this.numericInstances.put(field2.name, instance);
            }
        }
        return instance;
    }

    private NumericDocValues loadVarIntsField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "PackedInts", 0, 0);
        byte header = input2.readByte();
        if (header == 1) {
            int maxDoc = this.state.segmentInfo.maxDoc();
            final long[] values2 = new long[maxDoc];
            for (int i = 0; i < values2.length; ++i) {
                values2[i] = input2.readLong();
            }
            long bytesUsed = RamUsageEstimator.sizeOf(values2);
            if (!this.merging) {
                this.instanceInfo.put(field2.name, Accountables.namedAccountable("long array", bytesUsed));
                this.ramBytesUsed.addAndGet(bytesUsed);
            }
            return new NumericDocValues(){

                @Override
                public long get(int docID) {
                    return values2[docID];
                }
            };
        }
        if (header == 0) {
            final long minValue = input2.readLong();
            final long defaultValue = input2.readLong();
            final PackedInts.Reader reader = PackedInts.getReader(input2);
            if (!this.merging) {
                this.instanceInfo.put(field2.name, reader);
                this.ramBytesUsed.addAndGet(reader.ramBytesUsed());
            }
            return new NumericDocValues(){

                @Override
                public long get(int docID) {
                    long value = reader.get(docID);
                    if (value == defaultValue) {
                        return 0L;
                    }
                    return minValue + value;
                }
            };
        }
        throw new CorruptIndexException("invalid VAR_INTS header byte: " + header, input2);
    }

    private NumericDocValues loadByteField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "Ints", 0, 0);
        int valueSize = input2.readInt();
        if (valueSize != 1) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize, input2);
        }
        int maxDoc = this.state.segmentInfo.maxDoc();
        final byte[] values2 = new byte[maxDoc];
        input2.readBytes(values2, 0, values2.length);
        long bytesUsed = RamUsageEstimator.sizeOf(values2);
        if (!this.merging) {
            this.instanceInfo.put(field2.name, Accountables.namedAccountable("byte array", bytesUsed));
            this.ramBytesUsed.addAndGet(bytesUsed);
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return values2[docID];
            }
        };
    }

    private NumericDocValues loadShortField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "Ints", 0, 0);
        int valueSize = input2.readInt();
        if (valueSize != 2) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize, input2);
        }
        int maxDoc = this.state.segmentInfo.maxDoc();
        final short[] values2 = new short[maxDoc];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = input2.readShort();
        }
        long bytesUsed = RamUsageEstimator.sizeOf(values2);
        if (!this.merging) {
            this.instanceInfo.put(field2.name, Accountables.namedAccountable("short array", bytesUsed));
            this.ramBytesUsed.addAndGet(bytesUsed);
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return values2[docID];
            }
        };
    }

    private NumericDocValues loadIntField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "Ints", 0, 0);
        int valueSize = input2.readInt();
        if (valueSize != 4) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize, input2);
        }
        int maxDoc = this.state.segmentInfo.maxDoc();
        final int[] values2 = new int[maxDoc];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = input2.readInt();
        }
        long bytesUsed = RamUsageEstimator.sizeOf(values2);
        if (!this.merging) {
            this.instanceInfo.put(field2.name, Accountables.namedAccountable("int array", bytesUsed));
            this.ramBytesUsed.addAndGet(bytesUsed);
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return values2[docID];
            }
        };
    }

    private NumericDocValues loadLongField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "Ints", 0, 0);
        int valueSize = input2.readInt();
        if (valueSize != 8) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize, input2);
        }
        int maxDoc = this.state.segmentInfo.maxDoc();
        final long[] values2 = new long[maxDoc];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = input2.readLong();
        }
        long bytesUsed = RamUsageEstimator.sizeOf(values2);
        if (!this.merging) {
            this.instanceInfo.put(field2.name, Accountables.namedAccountable("long array", bytesUsed));
            this.ramBytesUsed.addAndGet(bytesUsed);
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return values2[docID];
            }
        };
    }

    private NumericDocValues loadFloatField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "Floats", 0, 0);
        int valueSize = input2.readInt();
        if (valueSize != 4) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize, input2);
        }
        int maxDoc = this.state.segmentInfo.maxDoc();
        final int[] values2 = new int[maxDoc];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = input2.readInt();
        }
        long bytesUsed = RamUsageEstimator.sizeOf(values2);
        if (!this.merging) {
            this.instanceInfo.put(field2.name, Accountables.namedAccountable("float array", bytesUsed));
            this.ramBytesUsed.addAndGet(bytesUsed);
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return values2[docID];
            }
        };
    }

    private NumericDocValues loadDoubleField(FieldInfo field2, IndexInput input2) throws IOException {
        CodecUtil.checkHeader(input2, "Floats", 0, 0);
        int valueSize = input2.readInt();
        if (valueSize != 8) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize, input2);
        }
        int maxDoc = this.state.segmentInfo.maxDoc();
        final long[] values2 = new long[maxDoc];
        for (int i = 0; i < values2.length; ++i) {
            values2[i] = input2.readLong();
        }
        long bytesUsed = RamUsageEstimator.sizeOf(values2);
        if (!this.merging) {
            this.instanceInfo.put(field2.name, Accountables.namedAccountable("double array", bytesUsed));
            this.ramBytesUsed.addAndGet(bytesUsed);
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                return values2[docID];
            }
        };
    }

    @Override
    public synchronized BinaryDocValues getBinary(FieldInfo field2) throws IOException {
        BinaryDocValues instance = this.binaryInstances.get(field2.name);
        if (instance == null) {
            switch (Lucene40FieldInfosFormat.LegacyDocValuesType.valueOf(field2.getAttribute(this.legacyKey))) {
                case BYTES_FIXED_STRAIGHT: {
                    instance = this.loadBytesFixedStraight(field2);
                    break;
                }
                case BYTES_VAR_STRAIGHT: {
                    instance = this.loadBytesVarStraight(field2);
                    break;
                }
                case BYTES_FIXED_DEREF: {
                    instance = this.loadBytesFixedDeref(field2);
                    break;
                }
                case BYTES_VAR_DEREF: {
                    instance = this.loadBytesVarDeref(field2);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (!this.merging) {
                this.binaryInstances.put(field2.name, instance);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues loadBytesFixedStraight(FieldInfo field2) throws IOException {
        BinaryDocValues binaryDocValues;
        block6: {
            IndexInput input2;
            block5: {
                String fileName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "dat");
                input2 = this.dir.openInput(fileName, this.state.context);
                boolean success = false;
                try {
                    CodecUtil.checkHeader(input2, "FixedStraightBytes", 0, 0);
                    final int fixedLength = input2.readInt();
                    PagedBytes bytes2 = new PagedBytes(16);
                    bytes2.copy(input2, (long)fixedLength * (long)this.state.segmentInfo.maxDoc());
                    final PagedBytes.Reader bytesReader = bytes2.freeze(true);
                    CodecUtil.checkEOF(input2);
                    success = true;
                    if (!this.merging) {
                        this.ramBytesUsed.addAndGet(bytesReader.ramBytesUsed());
                        this.instanceInfo.put(field2.name, bytesReader);
                    }
                    binaryDocValues = new BinaryDocValues(){

                        @Override
                        public BytesRef get(int docID) {
                            BytesRef term = new BytesRef();
                            bytesReader.fillSlice(term, (long)fixedLength * (long)docID, fixedLength);
                            return term;
                        }
                    };
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(input2);
                    } else {
                        IOUtils.closeWhileHandlingException(input2);
                    }
                    throw throwable;
                }
                IOUtils.close(input2);
                break block6;
            }
            IOUtils.closeWhileHandlingException(input2);
        }
        return binaryDocValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues loadBytesVarStraight(FieldInfo field2) throws IOException {
        BinaryDocValues binaryDocValues;
        block6: {
            IndexInput index;
            IndexInput data;
            block5: {
                String dataName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "dat");
                String indexName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "idx");
                data = null;
                index = null;
                boolean success = false;
                try {
                    data = this.dir.openInput(dataName, this.state.context);
                    CodecUtil.checkHeader(data, "VarStraightBytesDat", 0, 0);
                    index = this.dir.openInput(indexName, this.state.context);
                    CodecUtil.checkHeader(index, "VarStraightBytesIdx", 0, 0);
                    long totalBytes = index.readVLong();
                    PagedBytes bytes2 = new PagedBytes(16);
                    bytes2.copy(data, totalBytes);
                    final PagedBytes.Reader bytesReader = bytes2.freeze(true);
                    final PackedInts.Reader reader = PackedInts.getReader(index);
                    CodecUtil.checkEOF(data);
                    CodecUtil.checkEOF(index);
                    success = true;
                    long bytesUsed = bytesReader.ramBytesUsed() + reader.ramBytesUsed();
                    if (!this.merging) {
                        this.ramBytesUsed.addAndGet(bytesUsed);
                        this.instanceInfo.put(field2.name, Accountables.namedAccountable("variable straight", bytesUsed));
                    }
                    binaryDocValues = new BinaryDocValues(){

                        @Override
                        public BytesRef get(int docID) {
                            BytesRef term = new BytesRef();
                            long startAddress = reader.get(docID);
                            long endAddress = reader.get(docID + 1);
                            bytesReader.fillSlice(term, startAddress, (int)(endAddress - startAddress));
                            return term;
                        }
                    };
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(data, index);
                    } else {
                        IOUtils.closeWhileHandlingException(data, index);
                    }
                    throw throwable;
                }
                IOUtils.close(data, index);
                break block6;
            }
            IOUtils.closeWhileHandlingException(data, index);
        }
        return binaryDocValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues loadBytesFixedDeref(FieldInfo field2) throws IOException {
        BinaryDocValues binaryDocValues;
        block6: {
            IndexInput index;
            IndexInput data;
            block5: {
                String dataName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "dat");
                String indexName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "idx");
                data = null;
                index = null;
                boolean success = false;
                try {
                    data = this.dir.openInput(dataName, this.state.context);
                    CodecUtil.checkHeader(data, "FixedDerefBytesDat", 0, 0);
                    index = this.dir.openInput(indexName, this.state.context);
                    CodecUtil.checkHeader(index, "FixedDerefBytesIdx", 0, 0);
                    final int fixedLength = data.readInt();
                    int valueCount = index.readInt();
                    PagedBytes bytes2 = new PagedBytes(16);
                    bytes2.copy(data, (long)fixedLength * (long)valueCount);
                    final PagedBytes.Reader bytesReader = bytes2.freeze(true);
                    final PackedInts.Reader reader = PackedInts.getReader(index);
                    CodecUtil.checkEOF(data);
                    CodecUtil.checkEOF(index);
                    long bytesUsed = bytesReader.ramBytesUsed() + reader.ramBytesUsed();
                    if (!this.merging) {
                        this.ramBytesUsed.addAndGet(bytesUsed);
                        this.instanceInfo.put(field2.name, Accountables.namedAccountable("fixed deref", bytesUsed));
                    }
                    success = true;
                    binaryDocValues = new BinaryDocValues(){

                        @Override
                        public BytesRef get(int docID) {
                            BytesRef term = new BytesRef();
                            long offset = (long)fixedLength * reader.get(docID);
                            bytesReader.fillSlice(term, offset, fixedLength);
                            return term;
                        }
                    };
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(data, index);
                    } else {
                        IOUtils.closeWhileHandlingException(data, index);
                    }
                    throw throwable;
                }
                IOUtils.close(data, index);
                break block6;
            }
            IOUtils.closeWhileHandlingException(data, index);
        }
        return binaryDocValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues loadBytesVarDeref(FieldInfo field2) throws IOException {
        BinaryDocValues binaryDocValues;
        block6: {
            IndexInput index;
            IndexInput data;
            block5: {
                String dataName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "dat");
                String indexName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "idx");
                data = null;
                index = null;
                boolean success = false;
                try {
                    data = this.dir.openInput(dataName, this.state.context);
                    CodecUtil.checkHeader(data, "VarDerefBytesDat", 0, 0);
                    index = this.dir.openInput(indexName, this.state.context);
                    CodecUtil.checkHeader(index, "VarDerefBytesIdx", 0, 0);
                    long totalBytes = index.readLong();
                    PagedBytes bytes2 = new PagedBytes(16);
                    bytes2.copy(data, totalBytes);
                    final PagedBytes.Reader bytesReader = bytes2.freeze(true);
                    final PackedInts.Reader reader = PackedInts.getReader(index);
                    CodecUtil.checkEOF(data);
                    CodecUtil.checkEOF(index);
                    long bytesUsed = bytesReader.ramBytesUsed() + reader.ramBytesUsed();
                    if (!this.merging) {
                        this.ramBytesUsed.addAndGet(bytesUsed);
                        this.instanceInfo.put(field2.name, Accountables.namedAccountable("variable deref", bytesUsed));
                    }
                    success = true;
                    binaryDocValues = new BinaryDocValues(){

                        @Override
                        public BytesRef get(int docID) {
                            BytesRef term = new BytesRef();
                            long startAddress = reader.get(docID);
                            BytesRef lengthBytes = new BytesRef();
                            bytesReader.fillSlice(lengthBytes, startAddress, 1);
                            byte code = lengthBytes.bytes[lengthBytes.offset];
                            if ((code & 0x80) == 0) {
                                bytesReader.fillSlice(term, startAddress + 1L, code);
                            } else {
                                bytesReader.fillSlice(lengthBytes, startAddress + 1L, 1);
                                int length2 = (code & 0x7F) << 8 | lengthBytes.bytes[lengthBytes.offset] & 0xFF;
                                bytesReader.fillSlice(term, startAddress + 2L, length2);
                            }
                            return term;
                        }
                    };
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(data, index);
                    } else {
                        IOUtils.closeWhileHandlingException(data, index);
                    }
                    throw throwable;
                }
                IOUtils.close(data, index);
                break block6;
            }
            IOUtils.closeWhileHandlingException(data, index);
        }
        return binaryDocValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SortedDocValues getSorted(FieldInfo field2) throws IOException {
        SortedDocValues instance;
        block10: {
            block11: {
                IndexInput index;
                IndexInput data;
                block9: {
                    instance = this.sortedInstances.get(field2.name);
                    if (instance != null) break block10;
                    String dataName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "dat");
                    String indexName = IndexFileNames.segmentFileName(this.state.segmentInfo.name + "_" + Integer.toString(field2.number), segmentSuffix, "idx");
                    data = null;
                    index = null;
                    boolean success = false;
                    try {
                        data = this.dir.openInput(dataName, this.state.context);
                        index = this.dir.openInput(indexName, this.state.context);
                        switch (Lucene40FieldInfosFormat.LegacyDocValuesType.valueOf(field2.getAttribute(this.legacyKey))) {
                            case BYTES_FIXED_SORTED: {
                                instance = this.loadBytesFixedSorted(field2, data, index);
                                break;
                            }
                            case BYTES_VAR_SORTED: {
                                instance = this.loadBytesVarSorted(field2, data, index);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        CodecUtil.checkEOF(data);
                        CodecUtil.checkEOF(index);
                        success = true;
                        if (!success) break block9;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close(data, index);
                        } else {
                            IOUtils.closeWhileHandlingException(data, index);
                        }
                        throw throwable;
                    }
                    IOUtils.close(data, index);
                    break block11;
                }
                IOUtils.closeWhileHandlingException(data, index);
            }
            if (!this.merging) {
                this.sortedInstances.put(field2.name, instance);
            }
        }
        return instance;
    }

    private SortedDocValues loadBytesFixedSorted(FieldInfo field2, IndexInput data, IndexInput index) throws IOException {
        CodecUtil.checkHeader(data, "FixedSortedBytesDat", 0, 0);
        CodecUtil.checkHeader(index, "FixedSortedBytesIdx", 0, 0);
        final int fixedLength = data.readInt();
        final int valueCount = index.readInt();
        PagedBytes bytes2 = new PagedBytes(16);
        bytes2.copy(data, (long)fixedLength * (long)valueCount);
        final PagedBytes.Reader bytesReader = bytes2.freeze(true);
        final PackedInts.Reader reader = PackedInts.getReader(index);
        long bytesUsed = bytesReader.ramBytesUsed() + reader.ramBytesUsed();
        if (!this.merging) {
            this.ramBytesUsed.addAndGet(bytesUsed);
            this.instanceInfo.put(field2.name, Accountables.namedAccountable("fixed sorted", bytesUsed));
        }
        return this.correctBuggyOrds(new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)reader.get(docID);
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                BytesRef term = new BytesRef();
                bytesReader.fillSlice(term, (long)fixedLength * (long)ord, fixedLength);
                return term;
            }

            @Override
            public int getValueCount() {
                return valueCount;
            }
        });
    }

    private SortedDocValues loadBytesVarSorted(FieldInfo field2, IndexInput data, IndexInput index) throws IOException {
        CodecUtil.checkHeader(data, "VarDerefBytesDat", 0, 0);
        CodecUtil.checkHeader(index, "VarDerefBytesIdx", 0, 0);
        long maxAddress = index.readLong();
        PagedBytes bytes2 = new PagedBytes(16);
        bytes2.copy(data, maxAddress);
        final PagedBytes.Reader bytesReader = bytes2.freeze(true);
        final PackedInts.Reader addressReader = PackedInts.getReader(index);
        final PackedInts.Reader ordsReader = PackedInts.getReader(index);
        final int valueCount = addressReader.size() - 1;
        long bytesUsed = bytesReader.ramBytesUsed() + addressReader.ramBytesUsed() + ordsReader.ramBytesUsed();
        if (!this.merging) {
            this.ramBytesUsed.addAndGet(bytesUsed);
            this.instanceInfo.put(field2.name, Accountables.namedAccountable("var sorted", bytesUsed));
        }
        return this.correctBuggyOrds(new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return (int)ordsReader.get(docID);
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                BytesRef term = new BytesRef();
                long startAddress = addressReader.get(ord);
                long endAddress = addressReader.get(ord + 1);
                bytesReader.fillSlice(term, startAddress, (int)(endAddress - startAddress));
                return term;
            }

            @Override
            public int getValueCount() {
                return valueCount;
            }
        });
    }

    private SortedDocValues correctBuggyOrds(final SortedDocValues in2) {
        int maxDoc = this.state.segmentInfo.maxDoc();
        for (int i = 0; i < maxDoc; ++i) {
            if (in2.getOrd(i) != 0) continue;
            return in2;
        }
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                return in2.getOrd(docID) - 1;
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                return in2.lookupOrd(ord + 1);
            }

            @Override
            public int getValueCount() {
                return in2.getValueCount() - 1;
            }
        };
    }

    @Override
    public SortedNumericDocValues getSortedNumeric(FieldInfo field2) throws IOException {
        throw new IllegalStateException("Lucene 4.0 does not support SortedNumeric: how did you pull this off?");
    }

    @Override
    public SortedSetDocValues getSortedSet(FieldInfo field2) throws IOException {
        throw new IllegalStateException("Lucene 4.0 does not support SortedSet: how did you pull this off?");
    }

    @Override
    public Bits getDocsWithField(FieldInfo field2) throws IOException {
        return new Bits.MatchAllBits(this.state.segmentInfo.maxDoc());
    }

    @Override
    public void close() throws IOException {
        this.dir.close();
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    @Override
    public synchronized Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables("field", this.instanceInfo);
    }

    @Override
    public void checkIntegrity() throws IOException {
    }

    @Override
    public synchronized DocValuesProducer getMergeInstance() throws IOException {
        return new Lucene40DocValuesReader(this);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

