/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.lucene40.Lucene40CompoundReader;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.MutableBits;

@Deprecated
final class BitVector
implements Cloneable,
MutableBits {
    private byte[] bits;
    private int size;
    private int count;
    private int version;
    private static String CODEC = "BitVector";
    static final int VERSION_PRE = -1;
    static final int VERSION_START = 0;
    static final int VERSION_DGAPS_CLEARED = 1;
    static final int VERSION_CHECKSUM = 2;
    static final int VERSION_CURRENT = 2;

    BitVector(int n) {
        this.size = n;
        this.bits = new byte[this.getNumBytes(this.size)];
        this.count = 0;
    }

    BitVector(byte[] bits2, int size2) {
        this.bits = bits2;
        this.size = size2;
        this.count = -1;
    }

    private int getNumBytes(int size2) {
        int bytesLength = size2 >>> 3;
        if ((size2 & 7) != 0) {
            ++bytesLength;
        }
        return bytesLength;
    }

    public BitVector clone() {
        byte[] copyBits = new byte[this.bits.length];
        System.arraycopy(this.bits, 0, copyBits, 0, this.bits.length);
        BitVector clone2 = new BitVector(copyBits, this.size);
        clone2.count = this.count;
        return clone2;
    }

    public final void set(int bit) {
        if (bit >= this.size) {
            throw new ArrayIndexOutOfBoundsException("bit=" + bit + " size=" + this.size);
        }
        int n = bit >> 3;
        this.bits[n] = (byte)(this.bits[n] | 1 << (bit & 7));
        this.count = -1;
    }

    @Override
    public final void clear(int bit) {
        if (bit >= this.size) {
            throw new ArrayIndexOutOfBoundsException(bit);
        }
        int n = bit >> 3;
        this.bits[n] = (byte)(this.bits[n] & ~(1 << (bit & 7)));
        this.count = -1;
    }

    @Override
    public final boolean get(int bit) {
        assert (bit >= 0 && bit < this.size) : "bit " + bit + " is out of bounds 0.." + (this.size - 1);
        return (this.bits[bit >> 3] & 1 << (bit & 7)) != 0;
    }

    final int size() {
        return this.size;
    }

    @Override
    public int length() {
        return this.size;
    }

    final int count() {
        if (this.count == -1) {
            int c = 0;
            int end = this.bits.length;
            for (int i = 0; i < end; ++i) {
                c += BitUtil.bitCount(this.bits[i]);
            }
            this.count = c;
        }
        assert (this.count <= this.size) : "count=" + this.count + " size=" + this.size;
        return this.count;
    }

    final int getRecomputedCount() {
        int c = 0;
        int end = this.bits.length;
        for (int i = 0; i < end; ++i) {
            c += BitUtil.bitCount(this.bits[i]);
        }
        return c;
    }

    int getVersion() {
        return this.version;
    }

    final void write(Directory d, String name2, IOContext context) throws IOException {
        assert (!(d instanceof Lucene40CompoundReader));
        try (IndexOutput output = d.createOutput(name2, context);){
            output.writeInt(-2);
            CodecUtil.writeHeader(output, CODEC, 2);
            if (this.isSparse()) {
                this.writeClearedDgaps(output);
            } else {
                this.writeBits(output);
            }
            CodecUtil.writeFooter(output);
            assert (this.verifyCount());
        }
    }

    void invertAll() {
        if (this.count != -1) {
            this.count = this.size - this.count;
        }
        if (this.bits.length > 0) {
            for (int idx = 0; idx < this.bits.length; ++idx) {
                this.bits[idx] = ~this.bits[idx];
            }
            this.clearUnusedBits();
        }
    }

    private void clearUnusedBits() {
        int lastNBits;
        if (this.bits.length > 0 && (lastNBits = this.size & 7) != 0) {
            int mask = (1 << lastNBits) - 1;
            int n = this.bits.length - 1;
            this.bits[n] = (byte)(this.bits[n] & mask);
        }
    }

    private void writeBits(IndexOutput output) throws IOException {
        output.writeInt(this.size());
        output.writeInt(this.count());
        output.writeBytes(this.bits, this.bits.length);
    }

    private void writeClearedDgaps(IndexOutput output) throws IOException {
        output.writeInt(-1);
        output.writeInt(this.size());
        output.writeInt(this.count());
        int last2 = 0;
        int numCleared = this.size() - this.count();
        for (int i = 0; i < this.bits.length && numCleared > 0; ++i) {
            if (this.bits[i] == -1) continue;
            output.writeVInt(i - last2);
            output.writeByte(this.bits[i]);
            last2 = i;
            assert ((numCleared -= 8 - BitUtil.bitCount(this.bits[i])) >= 0 || i == this.bits.length - 1 && numCleared == -(8 - (this.size & 7)));
        }
    }

    private boolean isSparse() {
        int clearedCount = this.size() - this.count();
        if (clearedCount == 0) {
            return true;
        }
        int avgGapLength = this.bits.length / clearedCount;
        int expectedDGapBytes = avgGapLength <= 128 ? 1 : (avgGapLength <= 16384 ? 2 : (avgGapLength <= 0x200000 ? 3 : (avgGapLength <= 0x10000000 ? 4 : 5)));
        int bytesPerSetBit = expectedDGapBytes + 1;
        long expectedBits = 32 + 8 * bytesPerSetBit * clearedCount;
        long factor = 10L;
        return 10L * expectedBits < (long)this.size();
    }

    BitVector(Directory d, String name2, IOContext context) throws IOException {
        try (ChecksumIndexInput input2 = d.openChecksumInput(name2, context);){
            int firstInt = input2.readInt();
            if (firstInt != -2) {
                throw new IndexFormatTooOldException(input2.toString(), Integer.toString(firstInt));
            }
            this.version = CodecUtil.checkHeader(input2, CODEC, 0, 2);
            this.size = input2.readInt();
            if (this.size == -1) {
                if (this.version >= 1) {
                    this.readClearedDgaps(input2);
                } else {
                    this.readSetDgaps(input2);
                }
            } else {
                this.readBits(input2);
            }
            if (this.version < 1) {
                this.invertAll();
            }
            if (this.version >= 2) {
                CodecUtil.checkFooter(input2);
            } else {
                CodecUtil.checkEOF(input2);
            }
            assert (this.verifyCount());
        }
    }

    private boolean verifyCount() {
        assert (this.count != -1);
        int countSav = this.count;
        this.count = -1;
        assert (countSav == this.count()) : "saved count was " + countSav + " but recomputed count is " + this.count;
        return true;
    }

    private void readBits(IndexInput input2) throws IOException {
        this.count = input2.readInt();
        this.bits = new byte[this.getNumBytes(this.size)];
        input2.readBytes(this.bits, 0, this.bits.length);
    }

    private void readSetDgaps(IndexInput input2) throws IOException {
        this.size = input2.readInt();
        this.count = input2.readInt();
        this.bits = new byte[this.getNumBytes(this.size)];
        int last2 = 0;
        int n = this.count();
        while (n > 0) {
            this.bits[last2 += input2.readVInt()] = input2.readByte();
            assert ((n -= BitUtil.bitCount(this.bits[last2])) >= 0);
        }
    }

    private void readClearedDgaps(IndexInput input2) throws IOException {
        this.size = input2.readInt();
        this.count = input2.readInt();
        this.bits = new byte[this.getNumBytes(this.size)];
        Arrays.fill(this.bits, (byte)-1);
        this.clearUnusedBits();
        int last2 = 0;
        int numCleared = this.size() - this.count();
        while (numCleared > 0) {
            this.bits[last2 += input2.readVInt()] = input2.readByte();
            assert ((numCleared -= 8 - BitUtil.bitCount(this.bits[last2])) >= 0 || last2 == this.bits.length - 1 && numCleared == -(8 - (this.size & 7)));
        }
    }
}

