/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.bloom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.bloom.BloomFilterFactory;
import org.apache.lucene.codecs.bloom.DefaultBloomFilterFactory;
import org.apache.lucene.codecs.bloom.FuzzySet;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.automaton.CompiledAutomaton;

public final class BloomFilteringPostingsFormat
extends PostingsFormat {
    public static final String BLOOM_CODEC_NAME = "BloomFilter";
    public static final int VERSION_START = 3;
    public static final int VERSION_CURRENT = 3;
    static final String BLOOM_EXTENSION = "blm";
    BloomFilterFactory bloomFilterFactory = new DefaultBloomFilterFactory();
    private PostingsFormat delegatePostingsFormat;

    public BloomFilteringPostingsFormat(PostingsFormat delegatePostingsFormat, BloomFilterFactory bloomFilterFactory) {
        super(BLOOM_CODEC_NAME);
        this.delegatePostingsFormat = delegatePostingsFormat;
        this.bloomFilterFactory = bloomFilterFactory;
    }

    public BloomFilteringPostingsFormat(PostingsFormat delegatePostingsFormat) {
        this(delegatePostingsFormat, new DefaultBloomFilterFactory());
    }

    public BloomFilteringPostingsFormat() {
        super(BLOOM_CODEC_NAME);
    }

    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        if (this.delegatePostingsFormat == null) {
            throw new UnsupportedOperationException("Error - " + this.getClass().getName() + " has been constructed without a choice of PostingsFormat");
        }
        FieldsConsumer fieldsConsumer = this.delegatePostingsFormat.fieldsConsumer(state);
        return new BloomFilteredFieldsConsumer(fieldsConsumer, state);
    }

    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new BloomFilteredFieldsProducer(state);
    }

    @Override
    public String toString() {
        return "BloomFilteringPostingsFormat(" + this.delegatePostingsFormat + ")";
    }

    class BloomFilteredFieldsConsumer
    extends FieldsConsumer {
        private FieldsConsumer delegateFieldsConsumer;
        private Map<FieldInfo, FuzzySet> bloomFilters = new HashMap<FieldInfo, FuzzySet>();
        private SegmentWriteState state;
        private boolean closed;

        public BloomFilteredFieldsConsumer(FieldsConsumer fieldsConsumer, SegmentWriteState state) {
            this.delegateFieldsConsumer = fieldsConsumer;
            this.state = state;
        }

        @Override
        public void write(Fields fields) throws IOException {
            this.delegateFieldsConsumer.write(fields);
            block0: for (String field2 : fields) {
                BytesRef term;
                Terms terms = fields.terms(field2);
                if (terms == null) continue;
                FieldInfo fieldInfo = this.state.fieldInfos.fieldInfo(field2);
                TermsEnum termsEnum = terms.iterator();
                FuzzySet bloomFilter = null;
                PostingsEnum postingsEnum = null;
                while ((term = termsEnum.next()) != null) {
                    if (bloomFilter == null) {
                        bloomFilter = BloomFilteringPostingsFormat.this.bloomFilterFactory.getSetForField(this.state, fieldInfo);
                        if (bloomFilter == null) continue block0;
                        assert (!this.bloomFilters.containsKey(field2));
                        this.bloomFilters.put(fieldInfo, bloomFilter);
                    }
                    if ((postingsEnum = termsEnum.postings(postingsEnum, 0)).nextDoc() == Integer.MAX_VALUE) continue;
                    bloomFilter.addValue(term);
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.delegateFieldsConsumer.close();
            ArrayList<Map.Entry<FieldInfo, FuzzySet>> nonSaturatedBlooms = new ArrayList<Map.Entry<FieldInfo, FuzzySet>>();
            for (Map.Entry<FieldInfo, FuzzySet> entry : this.bloomFilters.entrySet()) {
                FuzzySet bloomFilter = entry.getValue();
                if (BloomFilteringPostingsFormat.this.bloomFilterFactory.isSaturated(bloomFilter, entry.getKey())) continue;
                nonSaturatedBlooms.add(entry);
            }
            String bloomFileName = IndexFileNames.segmentFileName(this.state.segmentInfo.name, this.state.segmentSuffix, BloomFilteringPostingsFormat.BLOOM_EXTENSION);
            try (IndexOutput bloomOutput = this.state.directory.createOutput(bloomFileName, this.state.context);){
                CodecUtil.writeIndexHeader(bloomOutput, BloomFilteringPostingsFormat.BLOOM_CODEC_NAME, 3, this.state.segmentInfo.getId(), this.state.segmentSuffix);
                bloomOutput.writeString(BloomFilteringPostingsFormat.this.delegatePostingsFormat.getName());
                bloomOutput.writeInt(nonSaturatedBlooms.size());
                for (Map.Entry entry : nonSaturatedBlooms) {
                    FieldInfo fieldInfo = (FieldInfo)entry.getKey();
                    FuzzySet bloomFilter = (FuzzySet)entry.getValue();
                    bloomOutput.writeInt(fieldInfo.number);
                    this.saveAppropriatelySizedBloomFilter(bloomOutput, bloomFilter, fieldInfo);
                }
                CodecUtil.writeFooter(bloomOutput);
            }
            this.bloomFilters.clear();
        }

        private void saveAppropriatelySizedBloomFilter(IndexOutput bloomOutput, FuzzySet bloomFilter, FieldInfo fieldInfo) throws IOException {
            FuzzySet rightSizedSet = BloomFilteringPostingsFormat.this.bloomFilterFactory.downsize(fieldInfo, bloomFilter);
            if (rightSizedSet == null) {
                rightSizedSet = bloomFilter;
            }
            rightSizedSet.serialize(bloomOutput);
        }
    }

    static class BloomFilteredFieldsProducer
    extends FieldsProducer {
        private FieldsProducer delegateFieldsProducer;
        HashMap<String, FuzzySet> bloomsByFieldName = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public BloomFilteredFieldsProducer(SegmentReadState state) throws IOException {
            String bloomFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, BloomFilteringPostingsFormat.BLOOM_EXTENSION);
            ChecksumIndexInput bloomIn = null;
            boolean success = false;
            try {
                bloomIn = state.directory.openChecksumInput(bloomFileName, state.context);
                CodecUtil.checkIndexHeader(bloomIn, BloomFilteringPostingsFormat.BLOOM_CODEC_NAME, 3, 3, state.segmentInfo.getId(), state.segmentSuffix);
                PostingsFormat delegatePostingsFormat = PostingsFormat.forName(bloomIn.readString());
                this.delegateFieldsProducer = delegatePostingsFormat.fieldsProducer(state);
                int numBlooms = bloomIn.readInt();
                for (int i = 0; i < numBlooms; ++i) {
                    int fieldNum = bloomIn.readInt();
                    FuzzySet bloom = FuzzySet.deserialize(bloomIn);
                    FieldInfo fieldInfo = state.fieldInfos.fieldInfo(fieldNum);
                    this.bloomsByFieldName.put(fieldInfo.name, bloom);
                }
                CodecUtil.checkFooter(bloomIn);
                IOUtils.close(bloomIn);
                return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(bloomIn, this.delegateFieldsProducer);
                throw throwable;
            }
        }

        @Override
        public Iterator<String> iterator() {
            return this.delegateFieldsProducer.iterator();
        }

        @Override
        public void close() throws IOException {
            this.delegateFieldsProducer.close();
        }

        @Override
        public Terms terms(String field2) throws IOException {
            FuzzySet filter2 = this.bloomsByFieldName.get(field2);
            if (filter2 == null) {
                return this.delegateFieldsProducer.terms(field2);
            }
            Terms result2 = this.delegateFieldsProducer.terms(field2);
            if (result2 == null) {
                return null;
            }
            return new BloomFilteredTerms(result2, filter2);
        }

        @Override
        public int size() {
            return this.delegateFieldsProducer.size();
        }

        @Override
        public long ramBytesUsed() {
            long sizeInBytes = this.delegateFieldsProducer != null ? this.delegateFieldsProducer.ramBytesUsed() : 0L;
            for (Map.Entry<String, FuzzySet> entry : this.bloomsByFieldName.entrySet()) {
                sizeInBytes += (long)(entry.getKey().length() * 2);
                sizeInBytes += entry.getValue().ramBytesUsed();
            }
            return sizeInBytes;
        }

        @Override
        public Collection<Accountable> getChildResources() {
            ArrayList<Accountable> resources = new ArrayList<Accountable>();
            resources.addAll(Accountables.namedAccountables("field", this.bloomsByFieldName));
            if (this.delegateFieldsProducer != null) {
                resources.add(Accountables.namedAccountable("delegate", this.delegateFieldsProducer));
            }
            return Collections.unmodifiableList(resources);
        }

        @Override
        public void checkIntegrity() throws IOException {
            this.delegateFieldsProducer.checkIntegrity();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(fields=" + this.bloomsByFieldName.size() + ",delegate=" + this.delegateFieldsProducer + ")";
        }

        final class BloomFilteredTermsEnum
        extends TermsEnum {
            private Terms delegateTerms;
            private TermsEnum delegateTermsEnum;
            private final FuzzySet filter;

            public BloomFilteredTermsEnum(Terms delegateTerms, FuzzySet filter2) throws IOException {
                this.delegateTerms = delegateTerms;
                this.filter = filter2;
            }

            void reset(Terms delegateTerms) throws IOException {
                this.delegateTerms = delegateTerms;
                this.delegateTermsEnum = null;
            }

            private TermsEnum delegate() throws IOException {
                if (this.delegateTermsEnum == null) {
                    this.delegateTermsEnum = this.delegateTerms.iterator();
                }
                return this.delegateTermsEnum;
            }

            @Override
            public BytesRef next() throws IOException {
                return this.delegate().next();
            }

            @Override
            public boolean seekExact(BytesRef text2) throws IOException {
                if (this.filter.contains(text2) == FuzzySet.ContainsResult.NO) {
                    return false;
                }
                return this.delegate().seekExact(text2);
            }

            @Override
            public TermsEnum.SeekStatus seekCeil(BytesRef text2) throws IOException {
                return this.delegate().seekCeil(text2);
            }

            @Override
            public void seekExact(long ord) throws IOException {
                this.delegate().seekExact(ord);
            }

            @Override
            public BytesRef term() throws IOException {
                return this.delegate().term();
            }

            @Override
            public long ord() throws IOException {
                return this.delegate().ord();
            }

            @Override
            public int docFreq() throws IOException {
                return this.delegate().docFreq();
            }

            @Override
            public long totalTermFreq() throws IOException {
                return this.delegate().totalTermFreq();
            }

            @Override
            public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                return this.delegate().postings(reuse, flags);
            }
        }

        class BloomFilteredTerms
        extends Terms {
            private Terms delegateTerms;
            private FuzzySet filter;

            public BloomFilteredTerms(Terms terms, FuzzySet filter2) {
                this.delegateTerms = terms;
                this.filter = filter2;
            }

            @Override
            public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
                return this.delegateTerms.intersect(compiled, startTerm);
            }

            @Override
            public TermsEnum iterator() throws IOException {
                return new BloomFilteredTermsEnum(this.delegateTerms, this.filter);
            }

            @Override
            public long size() throws IOException {
                return this.delegateTerms.size();
            }

            @Override
            public long getSumTotalTermFreq() throws IOException {
                return this.delegateTerms.getSumTotalTermFreq();
            }

            @Override
            public long getSumDocFreq() throws IOException {
                return this.delegateTerms.getSumDocFreq();
            }

            @Override
            public int getDocCount() throws IOException {
                return this.delegateTerms.getDocCount();
            }

            @Override
            public boolean hasFreqs() {
                return this.delegateTerms.hasFreqs();
            }

            @Override
            public boolean hasOffsets() {
                return this.delegateTerms.hasOffsets();
            }

            @Override
            public boolean hasPositions() {
                return this.delegateTerms.hasPositions();
            }

            @Override
            public boolean hasPayloads() {
                return this.delegateTerms.hasPayloads();
            }

            @Override
            public BytesRef getMin() throws IOException {
                return this.delegateTerms.getMin();
            }

            @Override
            public BytesRef getMax() throws IOException {
                return this.delegateTerms.getMax();
            }
        }
    }
}

