/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktreeords;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.blocktreeords.FSTOrdsOutputs;
import org.apache.lucene.codecs.blocktreeords.OrdsSegmentTermsEnum;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.fst.FST;

final class OrdsSegmentTermsEnumFrame {
    final int ord;
    boolean hasTerms;
    boolean hasTermsOrig;
    boolean isFloor;
    FST.Arc<FSTOrdsOutputs.Output> arc;
    long fp;
    long fpOrig;
    long fpEnd;
    byte[] suffixBytes = new byte[128];
    final ByteArrayDataInput suffixesReader = new ByteArrayDataInput();
    byte[] statBytes = new byte[64];
    final ByteArrayDataInput statsReader = new ByteArrayDataInput();
    byte[] floorData = new byte[32];
    final ByteArrayDataInput floorDataReader = new ByteArrayDataInput();
    int prefix;
    int entCount;
    int nextEnt;
    long termOrdOrig;
    long termOrd;
    boolean isLastInFloor;
    boolean isLeafBlock;
    long lastSubFP;
    int nextFloorLabel;
    long nextFloorTermOrd;
    int numFollowFloorBlocks;
    int metaDataUpto;
    final BlockTermState state;
    public long[] longs;
    public byte[] bytes;
    ByteArrayDataInput bytesReader;
    private final OrdsSegmentTermsEnum ste;
    private int startBytePos;
    private int suffix;
    private long subCode;

    public OrdsSegmentTermsEnumFrame(OrdsSegmentTermsEnum ste, int ord) throws IOException {
        this.ste = ste;
        this.ord = ord;
        this.state = ste.fr.parent.postingsReader.newTermState();
        this.state.totalTermFreq = -1L;
        this.longs = new long[ste.fr.longsSize];
    }

    public void setFloorData(ByteArrayDataInput in2, BytesRef source) {
        int numBytes = source.length - (in2.getPosition() - source.offset);
        assert (numBytes > 0);
        if (numBytes > this.floorData.length) {
            this.floorData = new byte[ArrayUtil.oversize(numBytes, 1)];
        }
        System.arraycopy(source.bytes, source.offset + in2.getPosition(), this.floorData, 0, numBytes);
        this.floorDataReader.reset(this.floorData, 0, numBytes);
        this.numFollowFloorBlocks = this.floorDataReader.readVInt();
        this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
        this.nextFloorTermOrd = this.termOrdOrig + this.floorDataReader.readVLong();
    }

    public int getTermBlockOrd() {
        return this.isLeafBlock ? this.nextEnt : this.state.termBlockOrd;
    }

    void loadNextFloorBlock() throws IOException {
        assert (this.arc == null || this.isFloor) : "arc=" + this.arc + " isFloor=" + this.isFloor;
        this.fp = this.fpEnd;
        this.nextEnt = -1;
        this.loadBlock();
    }

    void loadBlock() throws IOException {
        this.ste.initIndexInput();
        if (this.nextEnt != -1) {
            return;
        }
        this.ste.in.seek(this.fp);
        int code = this.ste.in.readVInt();
        this.entCount = code >>> 1;
        assert (this.entCount > 0);
        boolean bl = this.isLastInFloor = (code & 1) != 0;
        assert (this.arc == null || this.isLastInFloor || this.isFloor);
        code = this.ste.in.readVInt();
        this.isLeafBlock = (code & 1) != 0;
        int numBytes = code >>> 1;
        if (this.suffixBytes.length < numBytes) {
            this.suffixBytes = new byte[ArrayUtil.oversize(numBytes, 1)];
        }
        this.ste.in.readBytes(this.suffixBytes, 0, numBytes);
        this.suffixesReader.reset(this.suffixBytes, 0, numBytes);
        numBytes = this.ste.in.readVInt();
        if (this.statBytes.length < numBytes) {
            this.statBytes = new byte[ArrayUtil.oversize(numBytes, 1)];
        }
        this.ste.in.readBytes(this.statBytes, 0, numBytes);
        this.statsReader.reset(this.statBytes, 0, numBytes);
        this.metaDataUpto = 0;
        this.state.termBlockOrd = 0;
        this.nextEnt = 0;
        this.lastSubFP = -1L;
        numBytes = this.ste.in.readVInt();
        if (this.bytes == null) {
            this.bytes = new byte[ArrayUtil.oversize(numBytes, 1)];
            this.bytesReader = new ByteArrayDataInput();
        } else if (this.bytes.length < numBytes) {
            this.bytes = new byte[ArrayUtil.oversize(numBytes, 1)];
        }
        this.ste.in.readBytes(this.bytes, 0, numBytes);
        this.bytesReader.reset(this.bytes, 0, numBytes);
        this.fpEnd = this.ste.in.getFilePointer();
    }

    void rewind() {
        this.fp = this.fpOrig;
        this.termOrd = this.termOrdOrig;
        this.nextEnt = -1;
        this.hasTerms = this.hasTermsOrig;
        if (this.isFloor) {
            this.floorDataReader.rewind();
            this.numFollowFloorBlocks = this.floorDataReader.readVInt();
            assert (this.numFollowFloorBlocks > 0);
            this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
            this.nextFloorTermOrd = this.termOrdOrig + this.floorDataReader.readVLong();
        }
    }

    public boolean next() {
        return this.isLeafBlock ? this.nextLeaf() : this.nextNonLeaf();
    }

    public boolean nextLeaf() {
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp + " termOrd=" + this.termOrd;
        ++this.nextEnt;
        ++this.termOrd;
        this.suffix = this.suffixesReader.readVInt();
        this.startBytePos = this.suffixesReader.getPosition();
        this.ste.term.setLength(this.prefix + this.suffix);
        this.ste.term.grow(this.ste.term.length());
        this.suffixesReader.readBytes(this.ste.term.bytes(), this.prefix, this.suffix);
        this.ste.termExists = true;
        return false;
    }

    public boolean nextNonLeaf() {
        assert (this.nextEnt != -1 && this.nextEnt < this.entCount) : "nextEnt=" + this.nextEnt + " entCount=" + this.entCount + " fp=" + this.fp;
        ++this.nextEnt;
        int code = this.suffixesReader.readVInt();
        this.suffix = code >>> 1;
        this.startBytePos = this.suffixesReader.getPosition();
        this.ste.term.setLength(this.prefix + this.suffix);
        this.ste.term.grow(this.ste.term.length());
        this.suffixesReader.readBytes(this.ste.term.bytes(), this.prefix, this.suffix);
        if ((code & 1) == 0) {
            this.ste.termExists = true;
            this.subCode = 0L;
            ++this.state.termBlockOrd;
            ++this.termOrd;
            return false;
        }
        this.ste.termExists = false;
        this.subCode = this.suffixesReader.readVLong();
        this.termOrd += this.suffixesReader.readVLong();
        this.lastSubFP = this.fp - this.subCode;
        return true;
    }

    public void scanToFloorFrame(BytesRef target) {
        if (!this.isFloor || target.length <= this.prefix) {
            return;
        }
        int targetLabel = target.bytes[target.offset + this.prefix] & 0xFF;
        if (targetLabel < this.nextFloorLabel) {
            return;
        }
        assert (this.numFollowFloorBlocks != 0);
        long newFP = this.fpOrig;
        long lastFloorTermOrd = this.nextFloorTermOrd;
        do {
            long code = this.floorDataReader.readVLong();
            newFP = this.fpOrig + (code >>> 1);
            this.hasTerms = (code & 1L) != 0L;
            this.isLastInFloor = this.numFollowFloorBlocks == 1;
            --this.numFollowFloorBlocks;
            lastFloorTermOrd = this.nextFloorTermOrd;
            if (this.isLastInFloor) {
                this.nextFloorLabel = 256;
                this.nextFloorTermOrd = Long.MAX_VALUE;
                break;
            }
            this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
            this.nextFloorTermOrd += this.floorDataReader.readVLong();
        } while (targetLabel >= this.nextFloorLabel);
        if (newFP != this.fp) {
            this.nextEnt = -1;
            this.termOrd = lastFloorTermOrd;
            this.fp = newFP;
        }
    }

    public void scanToFloorFrame(long targetOrd) {
        if (!this.isFloor || targetOrd < this.nextFloorTermOrd) {
            return;
        }
        assert (this.numFollowFloorBlocks != 0);
        long lastFloorTermOrd = this.nextFloorTermOrd;
        long newFP = this.fpOrig;
        do {
            long code = this.floorDataReader.readVLong();
            newFP = this.fpOrig + (code >>> 1);
            this.hasTerms = (code & 1L) != 0L;
            this.isLastInFloor = this.numFollowFloorBlocks == 1;
            --this.numFollowFloorBlocks;
            lastFloorTermOrd = this.nextFloorTermOrd;
            if (this.isLastInFloor) {
                this.nextFloorLabel = 256;
                this.nextFloorTermOrd = Long.MAX_VALUE;
                break;
            }
            this.nextFloorLabel = this.floorDataReader.readByte() & 0xFF;
            this.nextFloorTermOrd += this.floorDataReader.readVLong();
        } while (targetOrd >= this.nextFloorTermOrd);
        if (newFP != this.fp) {
            this.nextEnt = -1;
            this.termOrd = lastFloorTermOrd;
            this.fp = newFP;
        }
    }

    public void decodeMetaData() throws IOException {
        boolean absolute;
        assert (this.nextEnt >= 0);
        int limit = this.getTermBlockOrd();
        boolean bl = absolute = this.metaDataUpto == 0;
        assert (limit > 0) : "limit=" + limit + " isLeafBlock=" + this.isLeafBlock + " nextEnt=" + this.nextEnt;
        while (this.metaDataUpto < limit) {
            this.state.docFreq = this.statsReader.readVInt();
            if (this.ste.fr.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                this.state.totalTermFreq = (long)this.state.docFreq + this.statsReader.readVLong();
            }
            for (int i = 0; i < this.ste.fr.longsSize; ++i) {
                this.longs[i] = this.bytesReader.readVLong();
            }
            this.ste.fr.parent.postingsReader.decodeTerm(this.longs, this.bytesReader, this.ste.fr.fieldInfo, this.state, absolute);
            ++this.metaDataUpto;
            absolute = false;
        }
        this.state.termBlockOrd = this.metaDataUpto;
    }

    private boolean prefixMatches(BytesRef target) {
        for (int bytePos = 0; bytePos < this.prefix; ++bytePos) {
            if (target.bytes[target.offset + bytePos] == this.ste.term.byteAt(bytePos)) continue;
            return false;
        }
        return true;
    }

    public void scanToSubBlock(long subFP) {
        assert (!this.isLeafBlock);
        if (this.lastSubFP == subFP) {
            return;
        }
        assert (subFP < this.fp) : "fp=" + this.fp + " subFP=" + subFP;
        long targetSubCode = this.fp - subFP;
        while (true) {
            assert (this.nextEnt < this.entCount);
            ++this.nextEnt;
            int code = this.suffixesReader.readVInt();
            this.suffixesReader.skipBytes(this.isLeafBlock ? (long)code : (long)(code >>> 1));
            if ((code & 1) != 0) {
                long subCode = this.suffixesReader.readVLong();
                this.termOrd += this.suffixesReader.readVLong();
                if (targetSubCode != subCode) continue;
                this.lastSubFP = subFP;
                return;
            }
            ++this.state.termBlockOrd;
            ++this.termOrd;
        }
    }

    public TermsEnum.SeekStatus scanToTerm(BytesRef target, boolean exactOnly) throws IOException {
        return this.isLeafBlock ? this.scanToTermLeaf(target, exactOnly) : this.scanToTermNonLeaf(target, exactOnly);
    }

    public TermsEnum.SeekStatus scanToTermLeaf(BytesRef target, boolean exactOnly) throws IOException {
        block13: {
            assert (this.nextEnt != -1);
            this.ste.termExists = true;
            this.subCode = 0L;
            if (this.nextEnt == this.entCount) {
                if (exactOnly) {
                    this.fillTerm();
                }
                return TermsEnum.SeekStatus.END;
            }
            assert (this.prefixMatches(target));
            block0: while (true) {
                boolean stop;
                ++this.nextEnt;
                ++this.termOrd;
                this.suffix = this.suffixesReader.readVInt();
                int termLen = this.prefix + this.suffix;
                this.startBytePos = this.suffixesReader.getPosition();
                this.suffixesReader.skipBytes(this.suffix);
                int targetLimit = target.offset + (target.length < termLen ? target.length : termLen);
                int targetPos = target.offset + this.prefix;
                int bytePos = this.startBytePos;
                do {
                    int cmp;
                    if (targetPos < targetLimit) {
                        cmp = (this.suffixBytes[bytePos++] & 0xFF) - (target.bytes[targetPos++] & 0xFF);
                        stop = false;
                    } else {
                        assert (targetPos == targetLimit);
                        cmp = termLen - target.length;
                        stop = true;
                    }
                    if (cmp < 0) {
                        if (this.nextEnt != this.entCount) continue block0;
                        if (exactOnly) {
                            this.fillTerm();
                        }
                        break block13;
                    }
                    if (cmp <= 0) continue;
                    this.fillTerm();
                    return TermsEnum.SeekStatus.NOT_FOUND;
                } while (!stop);
                break;
            }
            assert (this.ste.termExists);
            this.fillTerm();
            return TermsEnum.SeekStatus.FOUND;
        }
        if (exactOnly) {
            this.fillTerm();
        }
        return TermsEnum.SeekStatus.END;
    }

    public TermsEnum.SeekStatus scanToTermNonLeaf(BytesRef target, boolean exactOnly) throws IOException {
        block17: {
            assert (this.nextEnt != -1);
            if (this.nextEnt == this.entCount) {
                if (exactOnly) {
                    this.fillTerm();
                    this.ste.termExists = this.subCode == 0L;
                }
                return TermsEnum.SeekStatus.END;
            }
            assert (this.prefixMatches(target));
            block0: while (true) {
                boolean stop;
                ++this.nextEnt;
                int code = this.suffixesReader.readVInt();
                this.suffix = code >>> 1;
                this.ste.termExists = (code & 1) == 0;
                int termLen = this.prefix + this.suffix;
                this.startBytePos = this.suffixesReader.getPosition();
                this.suffixesReader.skipBytes(this.suffix);
                long prevTermOrd = this.termOrd++;
                if (this.ste.termExists) {
                    ++this.state.termBlockOrd;
                    this.subCode = 0L;
                } else {
                    this.subCode = this.suffixesReader.readVLong();
                    this.termOrd += this.suffixesReader.readVLong();
                    this.lastSubFP = this.fp - this.subCode;
                }
                int targetLimit = target.offset + (target.length < termLen ? target.length : termLen);
                int targetPos = target.offset + this.prefix;
                int bytePos = this.startBytePos;
                do {
                    int cmp;
                    if (targetPos < targetLimit) {
                        cmp = (this.suffixBytes[bytePos++] & 0xFF) - (target.bytes[targetPos++] & 0xFF);
                        stop = false;
                    } else {
                        assert (targetPos == targetLimit);
                        cmp = termLen - target.length;
                        stop = true;
                    }
                    if (cmp < 0) {
                        if (this.nextEnt != this.entCount) continue block0;
                        if (exactOnly) {
                            this.fillTerm();
                        }
                        break block17;
                    }
                    if (cmp <= 0) continue;
                    this.fillTerm();
                    if (!exactOnly && !this.ste.termExists) {
                        this.ste.currentFrame = this.ste.pushFrame(null, this.ste.currentFrame.lastSubFP, termLen, prevTermOrd);
                        this.ste.currentFrame.loadBlock();
                        while (this.ste.currentFrame.next()) {
                            this.ste.currentFrame = this.ste.pushFrame(null, this.ste.currentFrame.lastSubFP, this.ste.term.length(), prevTermOrd);
                            this.ste.currentFrame.loadBlock();
                        }
                    }
                    return TermsEnum.SeekStatus.NOT_FOUND;
                } while (!stop);
                break;
            }
            assert (this.ste.termExists);
            this.fillTerm();
            return TermsEnum.SeekStatus.FOUND;
        }
        if (exactOnly) {
            this.fillTerm();
        }
        return TermsEnum.SeekStatus.END;
    }

    private void fillTerm() {
        int termLength = this.prefix + this.suffix;
        this.ste.term.setLength(this.prefix + this.suffix);
        this.ste.term.grow(termLength);
        System.arraycopy(this.suffixBytes, this.startBytePos, this.ste.term.bytes(), this.prefix, this.suffix);
    }
}

