/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.PostingsWriterBase;
import org.apache.lucene.codecs.blocktree.AutoPrefixTermsWriter;
import org.apache.lucene.codecs.blocktree.BitSetTermsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;

public final class BlockTreeTermsWriter
extends FieldsConsumer {
    public static final int DEFAULT_MIN_BLOCK_SIZE = 25;
    public static final int DEFAULT_MAX_BLOCK_SIZE = 48;
    private final IndexOutput termsOut;
    private final IndexOutput indexOut;
    final int maxDoc;
    final int minItemsInBlock;
    final int maxItemsInBlock;
    final int minItemsInAutoPrefix;
    final int maxItemsInAutoPrefix;
    final PostingsWriterBase postingsWriter;
    final FieldInfos fieldInfos;
    private final List<FieldMetaData> fields = new ArrayList<FieldMetaData>();
    final FixedBitSet prefixDocs;
    final BitSetTermsEnum prefixFixedBitsTermsEnum;
    private TermsEnum prefixTermsEnum;
    private PostingsEnum prefixDocsEnum;
    private final RAMOutputStream scratchBytes = new RAMOutputStream();
    private final IntsRefBuilder scratchIntsRef = new IntsRefBuilder();
    static final BytesRef EMPTY_BYTES_REF = new BytesRef();
    private boolean closed;

    public BlockTreeTermsWriter(SegmentWriteState state, PostingsWriterBase postingsWriter, int minItemsInBlock, int maxItemsInBlock) throws IOException {
        this(state, postingsWriter, minItemsInBlock, maxItemsInBlock, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlockTreeTermsWriter(SegmentWriteState state, PostingsWriterBase postingsWriter, int minItemsInBlock, int maxItemsInBlock, int minItemsInAutoPrefix, int maxItemsInAutoPrefix) throws IOException {
        BlockTreeTermsWriter.validateSettings(minItemsInBlock, maxItemsInBlock);
        this.minItemsInBlock = minItemsInBlock;
        this.maxItemsInBlock = maxItemsInBlock;
        BlockTreeTermsWriter.validateAutoPrefixSettings(minItemsInAutoPrefix, maxItemsInAutoPrefix);
        if (minItemsInAutoPrefix != 0) {
            this.prefixDocs = new FixedBitSet(state.segmentInfo.maxDoc());
            this.prefixFixedBitsTermsEnum = new BitSetTermsEnum(this.prefixDocs);
        } else {
            this.prefixDocs = null;
            this.prefixFixedBitsTermsEnum = null;
        }
        this.minItemsInAutoPrefix = minItemsInAutoPrefix;
        this.maxItemsInAutoPrefix = maxItemsInAutoPrefix;
        this.maxDoc = state.segmentInfo.maxDoc();
        this.fieldInfos = state.fieldInfos;
        this.postingsWriter = postingsWriter;
        String termsName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "tim");
        this.termsOut = state.directory.createOutput(termsName, state.context);
        boolean success = false;
        IndexOutput indexOut = null;
        try {
            CodecUtil.writeIndexHeader(this.termsOut, "BlockTreeTermsDict", 2, state.segmentInfo.getId(), state.segmentSuffix);
            if (minItemsInAutoPrefix == 0) {
                this.termsOut.writeByte((byte)0);
            } else {
                this.termsOut.writeByte((byte)1);
            }
            String indexName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "tip");
            indexOut = state.directory.createOutput(indexName, state.context);
            CodecUtil.writeIndexHeader(indexOut, "BlockTreeTermsIndex", 2, state.segmentInfo.getId(), state.segmentSuffix);
            postingsWriter.init(this.termsOut, state);
            this.indexOut = indexOut;
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.termsOut, indexOut);
            throw throwable;
        }
    }

    private void writeTrailer(IndexOutput out, long dirStart) throws IOException {
        out.writeLong(dirStart);
    }

    private void writeIndexTrailer(IndexOutput indexOut, long dirStart) throws IOException {
        indexOut.writeLong(dirStart);
    }

    public static void validateSettings(int minItemsInBlock, int maxItemsInBlock) {
        if (minItemsInBlock <= 1) {
            throw new IllegalArgumentException("minItemsInBlock must be >= 2; got " + minItemsInBlock);
        }
        if (minItemsInBlock > maxItemsInBlock) {
            throw new IllegalArgumentException("maxItemsInBlock must be >= minItemsInBlock; got maxItemsInBlock=" + maxItemsInBlock + " minItemsInBlock=" + minItemsInBlock);
        }
        if (2 * (minItemsInBlock - 1) > maxItemsInBlock) {
            throw new IllegalArgumentException("maxItemsInBlock must be at least 2*(minItemsInBlock-1); got maxItemsInBlock=" + maxItemsInBlock + " minItemsInBlock=" + minItemsInBlock);
        }
    }

    public static void validateAutoPrefixSettings(int minItemsInAutoPrefix, int maxItemsInAutoPrefix) {
        if (minItemsInAutoPrefix != 0) {
            if (minItemsInAutoPrefix < 2) {
                throw new IllegalArgumentException("minItemsInAutoPrefix must be at least 2; got minItemsInAutoPrefix=" + minItemsInAutoPrefix);
            }
            if (minItemsInAutoPrefix > maxItemsInAutoPrefix) {
                throw new IllegalArgumentException("maxItemsInAutoPrefix must be >= minItemsInAutoPrefix; got maxItemsInAutoPrefix=" + maxItemsInAutoPrefix + " minItemsInAutoPrefix=" + minItemsInAutoPrefix);
            }
            if (2 * (minItemsInAutoPrefix - 1) > maxItemsInAutoPrefix) {
                throw new IllegalArgumentException("maxItemsInAutoPrefix must be at least 2*(minItemsInAutoPrefix-1); got maxItemsInAutoPrefix=" + maxItemsInAutoPrefix + " minItemsInAutoPrefix=" + minItemsInAutoPrefix);
            }
        } else if (maxItemsInAutoPrefix != 0) {
            throw new IllegalArgumentException("maxItemsInAutoPrefix must be 0 (disabled) when minItemsInAutoPrefix is 0");
        }
    }

    @Override
    public void write(Fields fields) throws IOException {
        String lastField = null;
        for (String field2 : fields) {
            List<AutoPrefixTermsWriter.PrefixTerm> prefixTerms;
            assert (lastField == null || lastField.compareTo(field2) < 0);
            lastField = field2;
            Terms terms = fields.terms(field2);
            if (terms == null) continue;
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(field2);
            if (this.minItemsInAutoPrefix != 0) {
                if (fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                    throw new IllegalStateException("ranges can only be indexed with IndexOptions.DOCS (field: " + fieldInfo.name + ")");
                }
                prefixTerms = new AutoPrefixTermsWriter((Terms)terms, (int)this.minItemsInAutoPrefix, (int)this.maxItemsInAutoPrefix).prefixes;
            } else {
                prefixTerms = null;
            }
            TermsEnum termsEnum = terms.iterator();
            TermsWriter termsWriter = new TermsWriter(this.fieldInfos.fieldInfo(field2));
            int prefixTermUpto = 0;
            while (true) {
                BytesRef term = termsEnum.next();
                if (prefixTerms != null) {
                    while (prefixTermUpto < prefixTerms.size() && (term == null || prefixTerms.get(prefixTermUpto).compareTo(term) <= 0)) {
                        AutoPrefixTermsWriter.PrefixTerm prefixTerm = prefixTerms.get(prefixTermUpto);
                        termsWriter.write(prefixTerm.term, this.getAutoPrefixTermsEnum(terms, prefixTerm), prefixTerm);
                        ++prefixTermUpto;
                    }
                }
                if (term == null) break;
                termsWriter.write(term, termsEnum, null);
            }
            assert (prefixTerms == null || prefixTermUpto == prefixTerms.size());
            termsWriter.finish();
        }
    }

    private TermsEnum getAutoPrefixTermsEnum(Terms terms, AutoPrefixTermsWriter.PrefixTerm prefix) throws IOException {
        assert (this.prefixDocs != null);
        this.prefixDocs.clear(0, this.prefixDocs.length());
        this.prefixTermsEnum = prefix.getTermsEnum(terms.iterator());
        while (this.prefixTermsEnum.next() != null) {
            this.prefixDocsEnum = this.prefixTermsEnum.postings(this.prefixDocsEnum, 0);
            this.prefixDocs.or(this.prefixDocsEnum);
        }
        return this.prefixFixedBitsTermsEnum;
    }

    static long encodeOutput(long fp, boolean hasTerms, boolean isFloor) {
        assert (fp < 0x4000000000000000L);
        return fp << 2 | (long)(hasTerms ? 2 : 0) | (long)(isFloor ? 1 : 0);
    }

    static String brToString(BytesRef b) {
        if (b == null) {
            return "(null)";
        }
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    static String brToString(byte[] b) {
        return BlockTreeTermsWriter.brToString(new BytesRef(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block10: {
            block9: {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                boolean success = false;
                try {
                    long dirStart = this.termsOut.getFilePointer();
                    long indexDirStart = this.indexOut.getFilePointer();
                    this.termsOut.writeVInt(this.fields.size());
                    for (FieldMetaData field2 : this.fields) {
                        this.termsOut.writeVInt(field2.fieldInfo.number);
                        assert (field2.numTerms > 0L);
                        this.termsOut.writeVLong(field2.numTerms);
                        this.termsOut.writeVInt(field2.rootCode.length);
                        this.termsOut.writeBytes(field2.rootCode.bytes, field2.rootCode.offset, field2.rootCode.length);
                        assert (field2.fieldInfo.getIndexOptions() != IndexOptions.NONE);
                        if (field2.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                            this.termsOut.writeVLong(field2.sumTotalTermFreq);
                        }
                        this.termsOut.writeVLong(field2.sumDocFreq);
                        this.termsOut.writeVInt(field2.docCount);
                        this.termsOut.writeVInt(field2.longsSize);
                        this.indexOut.writeVLong(field2.indexStartFP);
                        BlockTreeTermsWriter.writeBytesRef(this.termsOut, field2.minTerm);
                        BlockTreeTermsWriter.writeBytesRef(this.termsOut, field2.maxTerm);
                    }
                    this.writeTrailer(this.termsOut, dirStart);
                    CodecUtil.writeFooter(this.termsOut);
                    this.writeIndexTrailer(this.indexOut, indexDirStart);
                    CodecUtil.writeFooter(this.indexOut);
                    success = true;
                    if (!success) break block9;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.termsOut, this.indexOut, this.postingsWriter);
                    } else {
                        IOUtils.closeWhileHandlingException(this.termsOut, this.indexOut, this.postingsWriter);
                    }
                    throw throwable;
                }
                IOUtils.close(this.termsOut, this.indexOut, this.postingsWriter);
                break block10;
            }
            IOUtils.closeWhileHandlingException(this.termsOut, this.indexOut, this.postingsWriter);
        }
    }

    private static void writeBytesRef(IndexOutput out, BytesRef bytes2) throws IOException {
        out.writeVInt(bytes2.length);
        out.writeBytes(bytes2.bytes, bytes2.offset, bytes2.length);
    }

    class TermsWriter {
        private final FieldInfo fieldInfo;
        private final int longsSize;
        private long numTerms;
        final FixedBitSet docsSeen;
        long sumTotalTermFreq;
        long sumDocFreq;
        long indexStartFP;
        private final BytesRefBuilder lastTerm = new BytesRefBuilder();
        private int[] prefixStarts = new int[8];
        private final long[] longs;
        private final List<PendingEntry> pending = new ArrayList<PendingEntry>();
        private final List<PendingBlock> newBlocks = new ArrayList<PendingBlock>();
        private PendingTerm firstPendingTerm;
        private PendingTerm lastPendingTerm;
        private final RAMOutputStream suffixWriter = new RAMOutputStream();
        private final RAMOutputStream statsWriter = new RAMOutputStream();
        private final RAMOutputStream metaWriter = new RAMOutputStream();
        private final RAMOutputStream bytesWriter = new RAMOutputStream();

        void writeBlocks(int prefixLength, int count2) throws IOException {
            assert (count2 > 0);
            assert (prefixLength > 0 || count2 == this.pending.size());
            int lastSuffixLeadLabel = -1;
            boolean hasTerms = false;
            boolean hasPrefixTerms = false;
            boolean hasSubBlocks = false;
            int start = this.pending.size() - count2;
            int end = this.pending.size();
            int nextBlockStart = start;
            int nextFloorLeadLabel = -1;
            for (int i = start; i < end; ++i) {
                int suffixLeadLabel;
                PendingEntry ent = this.pending.get(i);
                if (ent.isTerm) {
                    PendingTerm term = (PendingTerm)ent;
                    if (term.termBytes.length == prefixLength) {
                        assert (lastSuffixLeadLabel == -1) : "i=" + i + " lastSuffixLeadLabel=" + lastSuffixLeadLabel;
                        suffixLeadLabel = -1;
                    } else {
                        suffixLeadLabel = term.termBytes[prefixLength] & 0xFF;
                    }
                } else {
                    PendingBlock block = (PendingBlock)ent;
                    assert (block.prefix.length > prefixLength);
                    suffixLeadLabel = block.prefix.bytes[block.prefix.offset + prefixLength] & 0xFF;
                }
                if (suffixLeadLabel != lastSuffixLeadLabel) {
                    int itemsInBlock = i - nextBlockStart;
                    if (itemsInBlock >= BlockTreeTermsWriter.this.minItemsInBlock && end - nextBlockStart > BlockTreeTermsWriter.this.maxItemsInBlock) {
                        boolean isFloor = itemsInBlock < count2;
                        this.newBlocks.add(this.writeBlock(prefixLength, isFloor, nextFloorLeadLabel, nextBlockStart, i, hasTerms, hasPrefixTerms, hasSubBlocks));
                        hasTerms = false;
                        hasSubBlocks = false;
                        hasPrefixTerms = false;
                        nextFloorLeadLabel = suffixLeadLabel;
                        nextBlockStart = i;
                    }
                    lastSuffixLeadLabel = suffixLeadLabel;
                }
                if (ent.isTerm) {
                    hasTerms = true;
                    hasPrefixTerms |= ((PendingTerm)ent).prefixTerm != null;
                    continue;
                }
                hasSubBlocks = true;
            }
            if (nextBlockStart < end) {
                int itemsInBlock = end - nextBlockStart;
                boolean isFloor = itemsInBlock < count2;
                this.newBlocks.add(this.writeBlock(prefixLength, isFloor, nextFloorLeadLabel, nextBlockStart, end, hasTerms, hasPrefixTerms, hasSubBlocks));
            }
            assert (!this.newBlocks.isEmpty());
            PendingBlock firstBlock = this.newBlocks.get(0);
            assert (firstBlock.isFloor || this.newBlocks.size() == 1);
            firstBlock.compileIndex(this.newBlocks, BlockTreeTermsWriter.this.scratchBytes, BlockTreeTermsWriter.this.scratchIntsRef);
            this.pending.subList(this.pending.size() - count2, this.pending.size()).clear();
            this.pending.add(firstBlock);
            this.newBlocks.clear();
        }

        private PendingBlock writeBlock(int prefixLength, boolean isFloor, int floorLeadLabel, int start, int end, boolean hasTerms, boolean hasPrefixTerms, boolean hasSubBlocks) throws IOException {
            ArrayList<FST<BytesRef>> subIndices;
            assert (end > start);
            long startFP = BlockTreeTermsWriter.this.termsOut.getFilePointer();
            boolean hasFloorLeadLabel = isFloor && floorLeadLabel != -1;
            BytesRef prefix = new BytesRef(prefixLength + (hasFloorLeadLabel ? 1 : 0));
            System.arraycopy(this.lastTerm.get().bytes, 0, prefix.bytes, 0, prefixLength);
            prefix.length = prefixLength;
            int numEntries = end - start;
            int code = numEntries << 1;
            if (end == this.pending.size()) {
                code |= 1;
            }
            BlockTreeTermsWriter.this.termsOut.writeVInt(code);
            boolean isLeafBlock = !hasSubBlocks && !hasPrefixTerms;
            boolean absolute = true;
            if (isLeafBlock) {
                subIndices = null;
                for (int i = start; i < end; ++i) {
                    PendingEntry ent = this.pending.get(i);
                    assert (ent.isTerm) : "i=" + i;
                    PendingTerm term = (PendingTerm)ent;
                    assert (term.prefixTerm == null);
                    assert (StringHelper.startsWith(term.termBytes, prefix)) : "term.term=" + term.termBytes + " prefix=" + prefix;
                    BlockTermState state = term.state;
                    int suffix = term.termBytes.length - prefixLength;
                    this.suffixWriter.writeVInt(suffix);
                    this.suffixWriter.writeBytes(term.termBytes, prefixLength, suffix);
                    assert (floorLeadLabel == -1 || (term.termBytes[prefixLength] & 0xFF) >= floorLeadLabel);
                    this.statsWriter.writeVInt(state.docFreq);
                    if (this.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                        assert (state.totalTermFreq >= (long)state.docFreq) : state.totalTermFreq + " vs " + state.docFreq;
                        this.statsWriter.writeVLong(state.totalTermFreq - (long)state.docFreq);
                    }
                    BlockTreeTermsWriter.this.postingsWriter.encodeTerm(this.longs, this.bytesWriter, this.fieldInfo, state, absolute);
                    for (int pos = 0; pos < this.longsSize; ++pos) {
                        assert (this.longs[pos] >= 0L);
                        this.metaWriter.writeVLong(this.longs[pos]);
                    }
                    this.bytesWriter.writeTo(this.metaWriter);
                    this.bytesWriter.reset();
                    absolute = false;
                }
            } else {
                subIndices = new ArrayList<FST<BytesRef>>();
                boolean sawAutoPrefixTerm = false;
                for (int i = start; i < end; ++i) {
                    PendingEntry ent = this.pending.get(i);
                    if (ent.isTerm) {
                        PendingTerm term = (PendingTerm)ent;
                        assert (StringHelper.startsWith(term.termBytes, prefix)) : "term.term=" + term.termBytes + " prefix=" + prefix;
                        BlockTermState state = term.state;
                        int suffix = term.termBytes.length - prefixLength;
                        if (BlockTreeTermsWriter.this.minItemsInAutoPrefix == 0) {
                            this.suffixWriter.writeVInt(suffix << 1);
                            this.suffixWriter.writeBytes(term.termBytes, prefixLength, suffix);
                        } else {
                            code = suffix << 2;
                            int floorLeadEnd = -1;
                            if (term.prefixTerm != null) {
                                assert (BlockTreeTermsWriter.this.minItemsInAutoPrefix > 0);
                                sawAutoPrefixTerm = true;
                                AutoPrefixTermsWriter.PrefixTerm prefixTerm = term.prefixTerm;
                                floorLeadEnd = prefixTerm.floorLeadEnd;
                                assert (floorLeadEnd != -1);
                                code = prefixTerm.floorLeadStart == -2 ? (code |= 2) : (code |= 3);
                            }
                            this.suffixWriter.writeVInt(code);
                            this.suffixWriter.writeBytes(term.termBytes, prefixLength, suffix);
                            if (floorLeadEnd != -1) {
                                this.suffixWriter.writeByte((byte)floorLeadEnd);
                            }
                            assert (floorLeadLabel == -1 || (term.termBytes[prefixLength] & 0xFF) >= floorLeadLabel);
                        }
                        this.statsWriter.writeVInt(state.docFreq);
                        if (this.fieldInfo.getIndexOptions() != IndexOptions.DOCS) {
                            assert (state.totalTermFreq >= (long)state.docFreq);
                            this.statsWriter.writeVLong(state.totalTermFreq - (long)state.docFreq);
                        }
                        BlockTreeTermsWriter.this.postingsWriter.encodeTerm(this.longs, this.bytesWriter, this.fieldInfo, state, absolute);
                        for (int pos = 0; pos < this.longsSize; ++pos) {
                            assert (this.longs[pos] >= 0L);
                            this.metaWriter.writeVLong(this.longs[pos]);
                        }
                        this.bytesWriter.writeTo(this.metaWriter);
                        this.bytesWriter.reset();
                        absolute = false;
                        continue;
                    }
                    PendingBlock block = (PendingBlock)ent;
                    assert (StringHelper.startsWith(block.prefix, prefix));
                    int suffix = block.prefix.length - prefixLength;
                    assert (StringHelper.startsWith(block.prefix, prefix));
                    assert (suffix > 0);
                    if (BlockTreeTermsWriter.this.minItemsInAutoPrefix == 0) {
                        this.suffixWriter.writeVInt(suffix << 1 | 1);
                    } else {
                        this.suffixWriter.writeVInt(suffix << 2 | 1);
                    }
                    this.suffixWriter.writeBytes(block.prefix.bytes, prefixLength, suffix);
                    assert (floorLeadLabel == -1 || (block.prefix.bytes[prefixLength] & 0xFF) >= floorLeadLabel) : "floorLeadLabel=" + floorLeadLabel + " suffixLead=" + (block.prefix.bytes[prefixLength] & 0xFF);
                    assert (block.fp < startFP);
                    this.suffixWriter.writeVLong(startFP - block.fp);
                    subIndices.add(block.index);
                }
                assert (subIndices.size() != 0 || sawAutoPrefixTerm);
            }
            BlockTreeTermsWriter.this.termsOut.writeVInt((int)(this.suffixWriter.getFilePointer() << 1) | (isLeafBlock ? 1 : 0));
            this.suffixWriter.writeTo(BlockTreeTermsWriter.this.termsOut);
            this.suffixWriter.reset();
            BlockTreeTermsWriter.this.termsOut.writeVInt((int)this.statsWriter.getFilePointer());
            this.statsWriter.writeTo(BlockTreeTermsWriter.this.termsOut);
            this.statsWriter.reset();
            BlockTreeTermsWriter.this.termsOut.writeVInt((int)this.metaWriter.getFilePointer());
            this.metaWriter.writeTo(BlockTreeTermsWriter.this.termsOut);
            this.metaWriter.reset();
            if (hasFloorLeadLabel) {
                prefix.bytes[prefix.length++] = (byte)floorLeadLabel;
            }
            return new PendingBlock(prefix, startFP, hasTerms, isFloor, floorLeadLabel, subIndices);
        }

        TermsWriter(FieldInfo fieldInfo) {
            this.fieldInfo = fieldInfo;
            assert (fieldInfo.getIndexOptions() != IndexOptions.NONE);
            this.docsSeen = new FixedBitSet(BlockTreeTermsWriter.this.maxDoc);
            this.longsSize = BlockTreeTermsWriter.this.postingsWriter.setField(fieldInfo);
            this.longs = new long[this.longsSize];
        }

        public void write(BytesRef text2, TermsEnum termsEnum, AutoPrefixTermsWriter.PrefixTerm prefixTerm) throws IOException {
            BlockTermState state = BlockTreeTermsWriter.this.postingsWriter.writeTerm(text2, termsEnum, this.docsSeen);
            if (state != null) {
                assert (state.docFreq != 0);
                assert (this.fieldInfo.getIndexOptions() == IndexOptions.DOCS || state.totalTermFreq >= (long)state.docFreq) : "postingsWriter=" + BlockTreeTermsWriter.this.postingsWriter;
                this.pushTerm(text2);
                PendingTerm term = new PendingTerm(text2, state, prefixTerm);
                this.pending.add(term);
                if (prefixTerm == null) {
                    this.sumDocFreq += (long)state.docFreq;
                    this.sumTotalTermFreq += state.totalTermFreq;
                    ++this.numTerms;
                    if (this.firstPendingTerm == null) {
                        this.firstPendingTerm = term;
                    }
                    this.lastPendingTerm = term;
                }
            }
        }

        private void pushTerm(BytesRef text2) throws IOException {
            int i;
            int pos;
            int limit = Math.min(this.lastTerm.length(), text2.length);
            for (pos = 0; pos < limit && this.lastTerm.byteAt(pos) == text2.bytes[text2.offset + pos]; ++pos) {
            }
            for (i = this.lastTerm.length() - 1; i >= pos; --i) {
                int prefixTopSize = this.pending.size() - this.prefixStarts[i];
                if (prefixTopSize < BlockTreeTermsWriter.this.minItemsInBlock) continue;
                this.writeBlocks(i + 1, prefixTopSize);
                int n = i;
                this.prefixStarts[n] = this.prefixStarts[n] - (prefixTopSize - 1);
            }
            if (this.prefixStarts.length < text2.length) {
                this.prefixStarts = ArrayUtil.grow(this.prefixStarts, text2.length);
            }
            for (i = pos; i < text2.length; ++i) {
                this.prefixStarts[i] = this.pending.size();
            }
            this.lastTerm.copyBytes(text2);
        }

        public void finish() throws IOException {
            if (this.numTerms > 0L) {
                this.pushTerm(new BytesRef());
                this.pushTerm(new BytesRef());
                this.writeBlocks(0, this.pending.size());
                assert (this.pending.size() == 1 && !this.pending.get((int)0).isTerm) : "pending.size()=" + this.pending.size() + " pending=" + this.pending;
                PendingBlock root2 = (PendingBlock)this.pending.get(0);
                assert (root2.prefix.length == 0);
                assert (root2.index.getEmptyOutput() != null);
                this.indexStartFP = BlockTreeTermsWriter.this.indexOut.getFilePointer();
                root2.index.save(BlockTreeTermsWriter.this.indexOut);
                assert (this.firstPendingTerm != null);
                BytesRef minTerm = new BytesRef(this.firstPendingTerm.termBytes);
                assert (this.lastPendingTerm != null);
                BytesRef maxTerm = new BytesRef(this.lastPendingTerm.termBytes);
                BlockTreeTermsWriter.this.fields.add(new FieldMetaData(this.fieldInfo, ((PendingBlock)this.pending.get((int)0)).index.getEmptyOutput(), this.numTerms, this.indexStartFP, this.sumTotalTermFreq, this.sumDocFreq, this.docsSeen.cardinality(), this.longsSize, minTerm, maxTerm));
            } else {
                assert (this.sumTotalTermFreq == 0L || this.fieldInfo.getIndexOptions() == IndexOptions.DOCS && this.sumTotalTermFreq == -1L);
                assert (this.sumDocFreq == 0L);
                assert (this.docsSeen.cardinality() == 0);
            }
        }
    }

    private static final class PendingBlock
    extends PendingEntry {
        public final BytesRef prefix;
        public final long fp;
        public FST<BytesRef> index;
        public List<FST<BytesRef>> subIndices;
        public final boolean hasTerms;
        public final boolean isFloor;
        public final int floorLeadByte;

        public PendingBlock(BytesRef prefix, long fp, boolean hasTerms, boolean isFloor, int floorLeadByte, List<FST<BytesRef>> subIndices) {
            super(false);
            this.prefix = prefix;
            this.fp = fp;
            this.hasTerms = hasTerms;
            this.isFloor = isFloor;
            this.floorLeadByte = floorLeadByte;
            this.subIndices = subIndices;
        }

        public String toString() {
            return "BLOCK: prefix=" + BlockTreeTermsWriter.brToString(this.prefix);
        }

        public void compileIndex(List<PendingBlock> blocks, RAMOutputStream scratchBytes, IntsRefBuilder scratchIntsRef) throws IOException {
            assert (this.isFloor && blocks.size() > 1 || !this.isFloor && blocks.size() == 1) : "isFloor=" + this.isFloor + " blocks=" + blocks;
            assert (this == blocks.get(0));
            assert (scratchBytes.getFilePointer() == 0L);
            scratchBytes.writeVLong(BlockTreeTermsWriter.encodeOutput(this.fp, this.hasTerms, this.isFloor));
            if (this.isFloor) {
                scratchBytes.writeVInt(blocks.size() - 1);
                for (int i = 1; i < blocks.size(); ++i) {
                    PendingBlock sub = blocks.get(i);
                    assert (sub.floorLeadByte != -1);
                    scratchBytes.writeByte((byte)sub.floorLeadByte);
                    assert (sub.fp > this.fp);
                    scratchBytes.writeVLong(sub.fp - this.fp << 1 | (long)(sub.hasTerms ? 1 : 0));
                }
            }
            ByteSequenceOutputs outputs = ByteSequenceOutputs.getSingleton();
            Builder<BytesRef> indexBuilder = new Builder<BytesRef>(FST.INPUT_TYPE.BYTE1, 0, 0, true, false, Integer.MAX_VALUE, outputs, false, 0.0f, true, 15);
            byte[] bytes2 = new byte[(int)scratchBytes.getFilePointer()];
            assert (bytes2.length > 0);
            scratchBytes.writeTo(bytes2, 0);
            indexBuilder.add(Util.toIntsRef(this.prefix, scratchIntsRef), new BytesRef(bytes2, 0, bytes2.length));
            scratchBytes.reset();
            for (PendingBlock block : blocks) {
                if (block.subIndices == null) continue;
                for (FST<BytesRef> subIndex : block.subIndices) {
                    this.append(indexBuilder, subIndex, scratchIntsRef);
                }
                block.subIndices = null;
            }
            this.index = indexBuilder.finish();
            assert (this.subIndices == null);
        }

        private void append(Builder<BytesRef> builder, FST<BytesRef> subIndex, IntsRefBuilder scratchIntsRef) throws IOException {
            BytesRefFSTEnum.InputOutput<BytesRef> indexEnt;
            BytesRefFSTEnum<BytesRef> subIndexEnum = new BytesRefFSTEnum<BytesRef>(subIndex);
            while ((indexEnt = subIndexEnum.next()) != null) {
                builder.add(Util.toIntsRef(indexEnt.input, scratchIntsRef), (BytesRef)indexEnt.output);
            }
        }
    }

    private static final class PendingTerm
    extends PendingEntry {
        public final byte[] termBytes;
        public final BlockTermState state;
        public final AutoPrefixTermsWriter.PrefixTerm prefixTerm;
        public PendingTerm other;

        public PendingTerm(BytesRef term, BlockTermState state, AutoPrefixTermsWriter.PrefixTerm prefixTerm) {
            super(true);
            this.termBytes = new byte[term.length];
            System.arraycopy(term.bytes, term.offset, this.termBytes, 0, term.length);
            this.state = state;
            this.prefixTerm = prefixTerm;
        }

        public String toString() {
            return "TERM: " + BlockTreeTermsWriter.brToString(this.termBytes);
        }
    }

    private static class PendingEntry {
        public final boolean isTerm;

        protected PendingEntry(boolean isTerm) {
            this.isTerm = isTerm;
        }
    }

    private static class FieldMetaData {
        public final FieldInfo fieldInfo;
        public final BytesRef rootCode;
        public final long numTerms;
        public final long indexStartFP;
        public final long sumTotalTermFreq;
        public final long sumDocFreq;
        public final int docCount;
        private final int longsSize;
        public final BytesRef minTerm;
        public final BytesRef maxTerm;

        public FieldMetaData(FieldInfo fieldInfo, BytesRef rootCode, long numTerms, long indexStartFP, long sumTotalTermFreq, long sumDocFreq, int docCount, int longsSize, BytesRef minTerm, BytesRef maxTerm) {
            assert (numTerms > 0L);
            this.fieldInfo = fieldInfo;
            assert (rootCode != null) : "field=" + fieldInfo.name + " numTerms=" + numTerms;
            this.rootCode = rootCode;
            this.indexStartFP = indexStartFP;
            this.numTerms = numTerms;
            this.sumTotalTermFreq = sumTotalTermFreq;
            this.sumDocFreq = sumDocFreq;
            this.docCount = docCount;
            this.longsSize = longsSize;
            this.minTerm = minTerm;
            this.maxTerm = maxTerm;
        }
    }
}

