/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;

class BitSetPostingsEnum
extends PostingsEnum {
    private final BitSet bits;
    private DocIdSetIterator in;

    BitSetPostingsEnum(BitSet bits2) {
        this.bits = bits2;
        this.reset();
    }

    @Override
    public int freq() throws IOException {
        return 1;
    }

    @Override
    public int docID() {
        if (this.in == null) {
            return -1;
        }
        return this.in.docID();
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.in == null) {
            this.in = new BitSetIterator(this.bits, 0L);
        }
        return this.in.nextDoc();
    }

    @Override
    public int advance(int target) throws IOException {
        return this.in.advance(target);
    }

    @Override
    public long cost() {
        return this.in.cost();
    }

    void reset() {
        this.in = null;
    }

    @Override
    public BytesRef getPayload() {
        return null;
    }

    @Override
    public int nextPosition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int startOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int endOffset() {
        throw new UnsupportedOperationException();
    }
}

