/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;

class AutoPrefixTermsWriter {
    final List<PrefixTerm> prefixes = new ArrayList<PrefixTerm>();
    private final int minItemsInPrefix;
    private final int maxItemsInPrefix;
    private final BytesRefBuilder lastTerm = new BytesRefBuilder();
    private int[] prefixStarts = new int[8];
    private List<Object> pending = new ArrayList<Object>();

    static String brToString(BytesRef b) {
        try {
            return b.utf8ToString() + " " + b;
        }
        catch (Throwable t) {
            return b.toString();
        }
    }

    public AutoPrefixTermsWriter(Terms terms, int minItemsInPrefix, int maxItemsInPrefix) throws IOException {
        BytesRef term;
        this.minItemsInPrefix = minItemsInPrefix;
        this.maxItemsInPrefix = maxItemsInPrefix;
        TermsEnum termsEnum = terms.iterator();
        while ((term = termsEnum.next()) != null) {
            this.pushTerm(term);
        }
        if (this.pending.size() > 1) {
            this.pushTerm(BlockTreeTermsWriter.EMPTY_BYTES_REF);
            while (this.pending.size() >= minItemsInPrefix) {
                this.savePrefixes(0, this.pending.size());
            }
        }
        Collections.sort(this.prefixes);
    }

    private void pushTerm(BytesRef text2) throws IOException {
        int i;
        int pos;
        int limit = Math.min(this.lastTerm.length(), text2.length);
        for (pos = 0; pos < limit && this.lastTerm.byteAt(pos) == text2.bytes[text2.offset + pos]; ++pos) {
        }
        for (i = this.lastTerm.length() - 1; i >= pos; --i) {
            int prefixTopSize = this.pending.size() - this.prefixStarts[i];
            while (prefixTopSize >= this.minItemsInPrefix) {
                this.savePrefixes(i + 1, prefixTopSize);
                prefixTopSize = this.pending.size() - this.prefixStarts[i];
            }
        }
        if (this.prefixStarts.length < text2.length) {
            this.prefixStarts = ArrayUtil.grow(this.prefixStarts, text2.length);
        }
        for (i = pos; i < text2.length; ++i) {
            this.prefixStarts[i] = this.pending.size();
        }
        this.lastTerm.copyBytes(text2);
        if (text2.length > 0 || this.pending.isEmpty()) {
            byte[] termBytes = new byte[text2.length];
            System.arraycopy(text2.bytes, text2.offset, termBytes, 0, text2.length);
            this.pending.add(termBytes);
        }
    }

    void savePrefixes(int prefixLength, int count2) throws IOException {
        int i;
        assert (count2 > 0);
        int lastSuffixLeadLabel = -2;
        int start = this.pending.size() - count2;
        assert (start >= 0);
        Object o = this.pending.get(start);
        boolean skippedEmptyStringSuffix = false;
        if (o instanceof byte[]) {
            if (((byte[])o).length == prefixLength) {
                ++start;
                --count2;
                skippedEmptyStringSuffix = true;
            }
        } else {
            PrefixTerm prefix = (PrefixTerm)o;
            if (prefix.term.bytes.length == prefixLength) {
                ++start;
                --count2;
                skippedEmptyStringSuffix = true;
            }
        }
        int end = this.pending.size();
        int nextBlockStart = start;
        int nextFloorLeadLabel = -1;
        int prefixCount = 0;
        PrefixTerm lastPTEntry = null;
        for (i = start; i < end; ++i) {
            byte[] termBytes;
            PrefixTerm ptEntry;
            o = this.pending.get(i);
            if (o instanceof byte[]) {
                ptEntry = null;
                termBytes = (byte[])o;
            } else {
                ptEntry = (PrefixTerm)o;
                termBytes = ptEntry.term.bytes;
                if (ptEntry.prefix.length != prefixLength) {
                    assert (ptEntry.prefix.length > prefixLength);
                    ptEntry = null;
                }
            }
            assert (termBytes.length > prefixLength);
            int suffixLeadLabel = termBytes[prefixLength] & 0xFF;
            if (suffixLeadLabel != lastSuffixLeadLabel) {
                assert (suffixLeadLabel > lastSuffixLeadLabel) : "suffixLeadLabel=" + suffixLeadLabel + " vs lastSuffixLeadLabel=" + lastSuffixLeadLabel;
                int itemsInBlock = i - nextBlockStart;
                if (itemsInBlock >= this.minItemsInPrefix && end - nextBlockStart > this.maxItemsInPrefix) {
                    if (lastPTEntry != null) {
                        lastSuffixLeadLabel = lastPTEntry.floorLeadEnd;
                    }
                    this.savePrefix(prefixLength, nextFloorLeadLabel, lastSuffixLeadLabel);
                    ++prefixCount;
                    nextFloorLeadLabel = suffixLeadLabel;
                    nextBlockStart = i;
                }
                if (nextFloorLeadLabel == -1) {
                    nextFloorLeadLabel = suffixLeadLabel;
                }
                lastSuffixLeadLabel = suffixLeadLabel;
            }
            lastPTEntry = ptEntry;
        }
        if (nextBlockStart < end) {
            if (lastPTEntry != null) {
                lastSuffixLeadLabel = lastPTEntry.floorLeadEnd;
            }
            assert (lastSuffixLeadLabel >= nextFloorLeadLabel) : "lastSuffixLeadLabel=" + lastSuffixLeadLabel + " nextFloorLeadLabel=" + nextFloorLeadLabel;
            if (prefixCount == 0) {
                if (prefixLength > 0) {
                    this.savePrefix(prefixLength, -2, 255);
                    ++prefixCount;
                    if (skippedEmptyStringSuffix) {
                        ++count2;
                    }
                }
            } else {
                if (lastSuffixLeadLabel == -2) {
                    lastSuffixLeadLabel = 255;
                }
                this.savePrefix(prefixLength, nextFloorLeadLabel, lastSuffixLeadLabel);
                ++prefixCount;
            }
        }
        this.pending.subList(this.pending.size() - count2, this.pending.size()).clear();
        for (i = 0; i < prefixCount; ++i) {
            PrefixTerm pt = this.prefixes.get(this.prefixes.size() - (prefixCount - i));
            this.pending.add(pt);
        }
    }

    private void savePrefix(int prefixLength, int floorLeadStart, int floorLeadEnd) {
        byte[] prefix = new byte[prefixLength];
        System.arraycopy(this.lastTerm.bytes(), 0, prefix, 0, prefixLength);
        assert (floorLeadStart != -1);
        assert (floorLeadEnd != -1);
        PrefixTerm pt = new PrefixTerm(prefix, floorLeadStart, floorLeadEnd);
        this.prefixes.add(pt);
    }

    public static final class PrefixTerm
    implements Comparable<PrefixTerm> {
        public final byte[] prefix;
        public final int floorLeadStart;
        public final int floorLeadEnd;
        public final BytesRef term;

        public PrefixTerm(byte[] prefix, int floorLeadStart, int floorLeadEnd) {
            this.prefix = prefix;
            this.floorLeadStart = floorLeadStart;
            this.floorLeadEnd = floorLeadEnd;
            this.term = PrefixTerm.toBytesRef(prefix, floorLeadStart);
            assert (floorLeadEnd >= floorLeadStart);
            assert (floorLeadEnd >= 0);
            assert (floorLeadStart == -2 || floorLeadStart >= 0);
            assert (prefix.length > 0 || floorLeadStart != -2 || floorLeadEnd != 255);
        }

        public String toString() {
            String s2 = AutoPrefixTermsWriter.brToString(new BytesRef(this.prefix));
            s2 = this.floorLeadStart == -2 ? s2 + "[-" + Integer.toHexString(this.floorLeadEnd) + "]" : s2 + "[" + Integer.toHexString(this.floorLeadStart) + "-" + Integer.toHexString(this.floorLeadEnd) + "]";
            return s2;
        }

        @Override
        public int compareTo(PrefixTerm other2) {
            int cmp = this.term.compareTo(other2.term);
            if (cmp == 0) {
                if (this.prefix.length != other2.prefix.length) {
                    return this.prefix.length - other2.prefix.length;
                }
                cmp = other2.floorLeadEnd - this.floorLeadEnd;
            }
            return cmp;
        }

        private static BytesRef toBytesRef(byte[] prefix, int floorLeadStart) {
            BytesRef br;
            if (floorLeadStart != -2) {
                assert (floorLeadStart >= 0);
                br = new BytesRef(prefix.length + 1);
            } else {
                br = new BytesRef(prefix.length);
            }
            System.arraycopy(prefix, 0, br.bytes, 0, prefix.length);
            br.length = prefix.length;
            if (floorLeadStart != -2) {
                assert (floorLeadStart >= 0);
                br.bytes[br.length++] = (byte)floorLeadStart;
            }
            return br;
        }

        @Override
        public int compareTo(BytesRef term) {
            return this.term.compareTo(term);
        }

        public TermsEnum getTermsEnum(TermsEnum in2) {
            final BytesRef prefixRef = new BytesRef(this.prefix);
            return new FilteredTermsEnum(in2){
                {
                    super(x0);
                    this.setInitialSeekTerm(PrefixTerm.this.term);
                }

                @Override
                protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
                    if (StringHelper.startsWith(term, prefixRef) && (PrefixTerm.this.floorLeadEnd == -1 || term.length == prefixRef.length || (term.bytes[term.offset + prefixRef.length] & 0xFF) <= PrefixTerm.this.floorLeadEnd)) {
                        return FilteredTermsEnum.AcceptStatus.YES;
                    }
                    return FilteredTermsEnum.AcceptStatus.END;
                }
            };
        }
    }
}

