/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blockterms;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.blockterms.TermsIndexReaderBase;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.PositiveIntOutputs;

public class VariableGapTermsIndexReader
extends TermsIndexReaderBase {
    private final PositiveIntOutputs fstOutputs;
    final HashMap<String, FieldIndexData> fields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableGapTermsIndexReader(SegmentReadState state) throws IOException {
        block7: {
            IndexInput in2;
            block6: {
                this.fstOutputs = PositiveIntOutputs.getSingleton();
                this.fields = new HashMap();
                String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "tiv");
                in2 = state.directory.openInput(fileName, new IOContext(state.context, true));
                boolean success = false;
                try {
                    CodecUtil.checkIndexHeader(in2, "VariableGapTermsIndex", 3, 3, state.segmentInfo.getId(), state.segmentSuffix);
                    CodecUtil.checksumEntireFile(in2);
                    this.seekDir(in2);
                    int numFields = in2.readVInt();
                    if (numFields < 0) {
                        throw new CorruptIndexException("invalid numFields: " + numFields, in2);
                    }
                    for (int i = 0; i < numFields; ++i) {
                        int field2 = in2.readVInt();
                        long indexStart = in2.readVLong();
                        FieldInfo fieldInfo = state.fieldInfos.fieldInfo(field2);
                        FieldIndexData previous = this.fields.put(fieldInfo.name, new FieldIndexData(in2, fieldInfo, indexStart));
                        if (previous == null) continue;
                        throw new CorruptIndexException("duplicate field: " + fieldInfo.name, in2);
                    }
                    success = true;
                    if (!success) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(in2);
                    } else {
                        IOUtils.closeWhileHandlingException(in2);
                    }
                    throw throwable;
                }
                IOUtils.close(in2);
                break block7;
            }
            IOUtils.closeWhileHandlingException(in2);
        }
    }

    @Override
    public boolean supportsOrd() {
        return false;
    }

    @Override
    public TermsIndexReaderBase.FieldIndexEnum getFieldEnum(FieldInfo fieldInfo) {
        FieldIndexData fieldData = this.fields.get(fieldInfo.name);
        if (fieldData.fst == null) {
            return null;
        }
        return new IndexEnum(fieldData.fst);
    }

    @Override
    public void close() throws IOException {
    }

    private void seekDir(IndexInput input2) throws IOException {
        input2.seek(input2.length() - (long)CodecUtil.footerLength() - 8L);
        long dirOffset = input2.readLong();
        input2.seek(dirOffset);
    }

    @Override
    public long ramBytesUsed() {
        long sizeInBytes = 0L;
        for (FieldIndexData entry : this.fields.values()) {
            sizeInBytes += entry.ramBytesUsed();
        }
        return sizeInBytes;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables("field", this.fields);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fields.size() + ")";
    }

    private final class FieldIndexData
    implements Accountable {
        private final FST<Long> fst;

        public FieldIndexData(IndexInput in2, FieldInfo fieldInfo, long indexStart) throws IOException {
            IndexInput clone2 = in2.clone();
            clone2.seek(indexStart);
            this.fst = new FST<Long>(clone2, VariableGapTermsIndexReader.this.fstOutputs);
            clone2.close();
        }

        @Override
        public long ramBytesUsed() {
            return this.fst == null ? 0L : this.fst.ramBytesUsed();
        }

        @Override
        public Collection<Accountable> getChildResources() {
            if (this.fst == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Accountables.namedAccountable("index data", this.fst));
        }

        public String toString() {
            return "VarGapTermIndex";
        }
    }

    private static class IndexEnum
    extends TermsIndexReaderBase.FieldIndexEnum {
        private final BytesRefFSTEnum<Long> fstEnum;
        private BytesRefFSTEnum.InputOutput<Long> current;

        public IndexEnum(FST<Long> fst) {
            this.fstEnum = new BytesRefFSTEnum<Long>(fst);
        }

        @Override
        public BytesRef term() {
            if (this.current == null) {
                return null;
            }
            return this.current.input;
        }

        @Override
        public long seek(BytesRef target) throws IOException {
            this.current = this.fstEnum.seekFloor(target);
            return (Long)this.current.output;
        }

        @Override
        public long next() throws IOException {
            this.current = this.fstEnum.next();
            if (this.current == null) {
                return -1L;
            }
            return (Long)this.current.output;
        }

        @Override
        public long ord() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long seek(long ord) {
            throw new UnsupportedOperationException();
        }
    }
}

