/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public abstract class StoredFieldsWriter
implements Closeable {
    protected StoredFieldsWriter() {
    }

    public abstract void startDocument() throws IOException;

    public void finishDocument() throws IOException {
    }

    public abstract void writeField(FieldInfo var1, IndexableField var2) throws IOException;

    public abstract void finish(FieldInfos var1, int var2) throws IOException;

    public int merge(MergeState mergeState) throws IOException {
        int docCount = 0;
        for (int i = 0; i < mergeState.storedFieldsReaders.length; ++i) {
            StoredFieldsReader storedFieldsReader = mergeState.storedFieldsReaders[i];
            storedFieldsReader.checkIntegrity();
            MergeVisitor visitor = new MergeVisitor(mergeState, i);
            int maxDoc = mergeState.maxDocs[i];
            Bits liveDocs = mergeState.liveDocs[i];
            for (int docID = 0; docID < maxDoc; ++docID) {
                if (liveDocs != null && !liveDocs.get(docID)) continue;
                this.startDocument();
                storedFieldsReader.visitDocument(docID, visitor);
                this.finishDocument();
                ++docCount;
            }
        }
        this.finish(mergeState.mergeFieldInfos, docCount);
        return docCount;
    }

    @Override
    public abstract void close() throws IOException;

    protected class MergeVisitor
    extends StoredFieldVisitor
    implements IndexableField {
        BytesRef binaryValue;
        String stringValue;
        Number numericValue;
        FieldInfo currentField;
        FieldInfos remapper;

        public MergeVisitor(MergeState mergeState, int readerIndex) {
            for (FieldInfo fi : mergeState.fieldInfos[readerIndex]) {
                FieldInfo other2 = mergeState.mergeFieldInfos.fieldInfo(fi.number);
                if (other2 != null && other2.name.equals(fi.name)) continue;
                this.remapper = mergeState.mergeFieldInfos;
                break;
            }
        }

        @Override
        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.reset(fieldInfo);
            this.binaryValue = new BytesRef(value);
            this.write();
        }

        @Override
        public void stringField(FieldInfo fieldInfo, byte[] value) throws IOException {
            this.reset(fieldInfo);
            this.stringValue = new String(value, StandardCharsets.UTF_8);
            this.write();
        }

        @Override
        public void intField(FieldInfo fieldInfo, int value) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = value;
            this.write();
        }

        @Override
        public void longField(FieldInfo fieldInfo, long value) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = value;
            this.write();
        }

        @Override
        public void floatField(FieldInfo fieldInfo, float value) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = Float.valueOf(value);
            this.write();
        }

        @Override
        public void doubleField(FieldInfo fieldInfo, double value) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = value;
            this.write();
        }

        @Override
        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return StoredFieldVisitor.Status.YES;
        }

        @Override
        public String name() {
            return this.currentField.name;
        }

        @Override
        public IndexableFieldType fieldType() {
            return StoredField.TYPE;
        }

        @Override
        public BytesRef binaryValue() {
            return this.binaryValue;
        }

        @Override
        public String stringValue() {
            return this.stringValue;
        }

        @Override
        public Number numericValue() {
            return this.numericValue;
        }

        @Override
        public Reader readerValue() {
            return null;
        }

        @Override
        public float boost() {
            return 1.0f;
        }

        @Override
        public TokenStream tokenStream(Analyzer analyzer, TokenStream reuse) {
            return null;
        }

        void reset(FieldInfo field2) {
            this.currentField = this.remapper != null ? this.remapper.fieldInfo(field2.name) : field2;
            this.binaryValue = null;
            this.stringValue = null;
            this.numericValue = null;
        }

        void write() throws IOException {
            StoredFieldsWriter.this.writeField(this.currentField, this);
        }
    }
}

