/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.NamedSPILoader;

public abstract class PostingsFormat
implements NamedSPILoader.NamedSPI {
    public static final PostingsFormat[] EMPTY = new PostingsFormat[0];
    private final String name;

    protected PostingsFormat(String name2) {
        NamedSPILoader.checkServiceName(name2);
        this.name = name2;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public abstract FieldsConsumer fieldsConsumer(SegmentWriteState var1) throws IOException;

    public abstract FieldsProducer fieldsProducer(SegmentReadState var1) throws IOException;

    public String toString() {
        return "PostingsFormat(name=" + this.name + ")";
    }

    public static PostingsFormat forName(String name2) {
        return Holder.getLoader().lookup(name2);
    }

    public static Set<String> availablePostingsFormats() {
        return Holder.getLoader().availableServices();
    }

    public static void reloadPostingsFormats(ClassLoader classloader) {
        Holder.getLoader().reload(classloader);
    }

    private static final class Holder {
        private static final NamedSPILoader<PostingsFormat> LOADER = new NamedSPILoader<PostingsFormat>(PostingsFormat.class);

        private Holder() {
        }

        static NamedSPILoader<PostingsFormat> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a PostingsFormat by name before all formats could be initialized. This likely happens if you call PostingsFormat#forName from a PostingsFormat's ctor.");
            }
            return LOADER;
        }
    }
}

