/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public final class CodecUtil {
    public static final int CODEC_MAGIC = 1071082519;
    public static final int FOOTER_MAGIC = -1071082520;

    private CodecUtil() {
    }

    public static void writeHeader(DataOutput out, String codec, int version) throws IOException {
        BytesRef bytes2 = new BytesRef(codec);
        if (bytes2.length != codec.length() || bytes2.length >= 128) {
            throw new IllegalArgumentException("codec must be simple ASCII, less than 128 characters in length [got " + codec + "]");
        }
        out.writeInt(1071082519);
        out.writeString(codec);
        out.writeInt(version);
    }

    public static void writeIndexHeader(DataOutput out, String codec, int version, byte[] id, String suffix) throws IOException {
        if (id.length != 16) {
            throw new IllegalArgumentException("Invalid id: " + StringHelper.idToString(id));
        }
        CodecUtil.writeHeader(out, codec, version);
        out.writeBytes(id, 0, id.length);
        BytesRef suffixBytes = new BytesRef(suffix);
        if (suffixBytes.length != suffix.length() || suffixBytes.length >= 256) {
            throw new IllegalArgumentException("suffix must be simple ASCII, less than 256 characters in length [got " + suffix + "]");
        }
        out.writeByte((byte)suffixBytes.length);
        out.writeBytes(suffixBytes.bytes, suffixBytes.offset, suffixBytes.length);
    }

    public static int headerLength(String codec) {
        return 9 + codec.length();
    }

    public static int indexHeaderLength(String codec, String suffix) {
        return CodecUtil.headerLength(codec) + 16 + 1 + suffix.length();
    }

    public static int checkHeader(DataInput in2, String codec, int minVersion, int maxVersion) throws IOException {
        int actualHeader = in2.readInt();
        if (actualHeader != 1071082519) {
            throw new CorruptIndexException("codec header mismatch: actual header=" + actualHeader + " vs expected header=" + 1071082519, in2);
        }
        return CodecUtil.checkHeaderNoMagic(in2, codec, minVersion, maxVersion);
    }

    public static int checkHeaderNoMagic(DataInput in2, String codec, int minVersion, int maxVersion) throws IOException {
        String actualCodec = in2.readString();
        if (!actualCodec.equals(codec)) {
            throw new CorruptIndexException("codec mismatch: actual codec=" + actualCodec + " vs expected codec=" + codec, in2);
        }
        int actualVersion = in2.readInt();
        if (actualVersion < minVersion) {
            throw new IndexFormatTooOldException(in2, actualVersion, minVersion, maxVersion);
        }
        if (actualVersion > maxVersion) {
            throw new IndexFormatTooNewException(in2, actualVersion, minVersion, maxVersion);
        }
        return actualVersion;
    }

    public static int checkIndexHeader(DataInput in2, String codec, int minVersion, int maxVersion, byte[] expectedID, String expectedSuffix) throws IOException {
        int version = CodecUtil.checkHeader(in2, codec, minVersion, maxVersion);
        CodecUtil.checkIndexHeaderID(in2, expectedID);
        CodecUtil.checkIndexHeaderSuffix(in2, expectedSuffix);
        return version;
    }

    public static byte[] checkIndexHeaderID(DataInput in2, byte[] expectedID) throws IOException {
        byte[] id = new byte[16];
        in2.readBytes(id, 0, id.length);
        if (!Arrays.equals(id, expectedID)) {
            throw new CorruptIndexException("file mismatch, expected id=" + StringHelper.idToString(expectedID) + ", got=" + StringHelper.idToString(id), in2);
        }
        return id;
    }

    public static String checkIndexHeaderSuffix(DataInput in2, String expectedSuffix) throws IOException {
        int suffixLength = in2.readByte() & 0xFF;
        byte[] suffixBytes = new byte[suffixLength];
        in2.readBytes(suffixBytes, 0, suffixBytes.length);
        String suffix = new String(suffixBytes, 0, suffixBytes.length, StandardCharsets.UTF_8);
        if (!suffix.equals(expectedSuffix)) {
            throw new CorruptIndexException("file mismatch, expected suffix=" + expectedSuffix + ", got=" + suffix, in2);
        }
        return suffix;
    }

    public static void writeFooter(IndexOutput out) throws IOException {
        out.writeInt(-1071082520);
        out.writeInt(0);
        CodecUtil.writeCRC(out);
    }

    public static int footerLength() {
        return 16;
    }

    public static long checkFooter(ChecksumIndexInput in2) throws IOException {
        CodecUtil.validateFooter(in2);
        long actualChecksum = in2.getChecksum();
        long expectedChecksum = CodecUtil.readCRC(in2);
        if (expectedChecksum != actualChecksum) {
            throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + Long.toHexString(expectedChecksum) + " actual=" + Long.toHexString(actualChecksum), in2);
        }
        return actualChecksum;
    }

    public static void checkFooter(ChecksumIndexInput in2, Throwable priorException) throws IOException {
        if (priorException == null) {
            CodecUtil.checkFooter(in2);
        } else {
            try {
                long remaining = in2.length() - in2.getFilePointer();
                if (remaining < (long)CodecUtil.footerLength()) {
                    priorException.addSuppressed(new CorruptIndexException("checksum status indeterminate: remaining=" + remaining + ", please run checkindex for more details", in2));
                } else {
                    in2.skipBytes(remaining - (long)CodecUtil.footerLength());
                    try {
                        long checksum = CodecUtil.checkFooter(in2);
                        priorException.addSuppressed(new CorruptIndexException("checksum passed (" + Long.toHexString(checksum) + "). possibly transient resource issue, or a Lucene or JVM bug", in2));
                    }
                    catch (CorruptIndexException t) {
                        priorException.addSuppressed(t);
                    }
                }
            }
            catch (Throwable t) {
                priorException.addSuppressed(new CorruptIndexException("checksum status indeterminate: unexpected exception", in2, t));
            }
            IOUtils.reThrow(priorException);
        }
    }

    public static long retrieveChecksum(IndexInput in2) throws IOException {
        if (in2.length() < (long)CodecUtil.footerLength()) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): length=" + in2.length() + " but footerLength==" + CodecUtil.footerLength(), in2);
        }
        in2.seek(in2.length() - (long)CodecUtil.footerLength());
        CodecUtil.validateFooter(in2);
        return CodecUtil.readCRC(in2);
    }

    private static void validateFooter(IndexInput in2) throws IOException {
        long expected;
        long remaining = in2.length() - in2.getFilePointer();
        if (remaining < (expected = (long)CodecUtil.footerLength())) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): remaining=" + remaining + ", expected=" + expected, in2);
        }
        if (remaining > expected) {
            throw new CorruptIndexException("misplaced codec footer (file extended?): remaining=" + remaining + ", expected=" + expected, in2);
        }
        int magic = in2.readInt();
        if (magic != -1071082520) {
            throw new CorruptIndexException("codec footer mismatch (file truncated?): actual footer=" + magic + " vs expected footer=" + -1071082520, in2);
        }
        int algorithmID = in2.readInt();
        if (algorithmID != 0) {
            throw new CorruptIndexException("codec footer mismatch: unknown algorithmID: " + algorithmID, in2);
        }
    }

    @Deprecated
    public static void checkEOF(IndexInput in2) throws IOException {
        if (in2.getFilePointer() != in2.length()) {
            throw new CorruptIndexException("did not read all bytes from file: read " + in2.getFilePointer() + " vs size " + in2.length(), in2);
        }
    }

    public static long checksumEntireFile(IndexInput input2) throws IOException {
        IndexInput clone2 = input2.clone();
        clone2.seek(0L);
        BufferedChecksumIndexInput in2 = new BufferedChecksumIndexInput(clone2);
        assert (((IndexInput)in2).getFilePointer() == 0L);
        in2.seek(((IndexInput)in2).length() - (long)CodecUtil.footerLength());
        return CodecUtil.checkFooter(in2);
    }

    public static long readCRC(IndexInput input2) throws IOException {
        long value = input2.readLong();
        if ((value & 0xFFFFFFFF00000000L) != 0L) {
            throw new CorruptIndexException("Illegal CRC-32 checksum: " + value, input2);
        }
        return value;
    }

    public static void writeCRC(IndexOutput output) throws IOException {
        long value = output.getChecksum();
        if ((value & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalStateException("Illegal CRC-32 checksum: " + value + " (resource=" + output + ")");
        }
        output.writeLong(value);
    }
}

