/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.IOException;
import java.io.Reader;
import java.text.BreakIterator;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.util.CharArrayIterator;
import org.apache.lucene.util.AttributeFactory;

public abstract class SegmentingTokenizerBase
extends Tokenizer {
    protected static final int BUFFERMAX = 1024;
    protected final char[] buffer = new char[1024];
    private int length = 0;
    private int usableLength = 0;
    protected int offset = 0;
    private final BreakIterator iterator;
    private final CharArrayIterator wrapper = CharArrayIterator.newSentenceInstance();
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);

    public SegmentingTokenizerBase(BreakIterator iterator2) {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, iterator2);
    }

    public SegmentingTokenizerBase(AttributeFactory factory, BreakIterator iterator2) {
        super(factory);
        this.iterator = iterator2;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.length == 0 || !this.incrementWord()) {
            while (!this.incrementSentence()) {
                this.refill();
                if (this.length > 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.wrapper.setText(this.buffer, 0, 0);
        this.iterator.setText(this.wrapper);
        this.offset = 0;
        this.usableLength = 0;
        this.length = 0;
    }

    @Override
    public final void end() throws IOException {
        super.end();
        int finalOffset = this.correctOffset(this.length < 0 ? this.offset : this.offset + this.length);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    private int findSafeEnd() {
        for (int i = this.length - 1; i >= 0; --i) {
            if (!this.isSafeEnd(this.buffer[i])) continue;
            return i + 1;
        }
        return -1;
    }

    protected boolean isSafeEnd(char ch) {
        switch (ch) {
            case '\n': 
            case '\r': 
            case '\u0085': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    private void refill() throws IOException {
        this.offset += this.usableLength;
        int leftover = this.length - this.usableLength;
        System.arraycopy(this.buffer, this.usableLength, this.buffer, 0, leftover);
        int requested = this.buffer.length - leftover;
        int returned = SegmentingTokenizerBase.read(this.input, this.buffer, leftover, requested);
        int n = this.length = returned < 0 ? leftover : returned + leftover;
        if (returned < requested) {
            this.usableLength = this.length;
        } else {
            this.usableLength = this.findSafeEnd();
            if (this.usableLength < 0) {
                this.usableLength = this.length;
            }
        }
        this.wrapper.setText(this.buffer, 0, Math.max(0, this.usableLength));
        this.iterator.setText(this.wrapper);
    }

    private static int read(Reader input2, char[] buffer, int offset, int length2) throws IOException {
        int location;
        int remaining;
        int count2;
        assert (length2 >= 0) : "length must not be negative: " + length2;
        for (remaining = length2; remaining > 0 && -1 != (count2 = input2.read(buffer, offset + (location = length2 - remaining), remaining)); remaining -= count2) {
        }
        return length2 - remaining;
    }

    private boolean incrementSentence() throws IOException {
        if (this.length == 0) {
            return false;
        }
        do {
            int start;
            if ((start = this.iterator.current()) == -1) {
                return false;
            }
            int end = this.iterator.next();
            if (end == -1) {
                return false;
            }
            this.setNextSentence(start, end);
        } while (!this.incrementWord());
        return true;
    }

    protected abstract void setNextSentence(int var1, int var2);

    protected abstract boolean incrementWord();
}

