/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

public abstract class AbstractAnalysisFactory {
    public static final String LUCENE_MATCH_VERSION_PARAM = "luceneMatchVersion";
    private final Map<String, String> originalArgs;
    protected final Version luceneMatchVersion;
    private boolean isExplicitLuceneMatchVersion = false;
    private static final Pattern ITEM_PATTERN = Pattern.compile("[^,\\s]+");
    private static final String CLASS_NAME = "class";

    protected AbstractAnalysisFactory(Map<String, String> args) {
        this.originalArgs = Collections.unmodifiableMap(new HashMap<String, String>(args));
        String version = this.get(args, LUCENE_MATCH_VERSION_PARAM);
        if (version == null) {
            this.luceneMatchVersion = Version.LATEST;
        } else {
            try {
                this.luceneMatchVersion = Version.parseLeniently(version);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException(pe);
            }
        }
        args.remove(CLASS_NAME);
    }

    public final Map<String, String> getOriginalArgs() {
        return this.originalArgs;
    }

    public final Version getLuceneMatchVersion() {
        return this.luceneMatchVersion;
    }

    public String require(Map<String, String> args, String name2) {
        String s2 = args.remove(name2);
        if (s2 == null) {
            throw new IllegalArgumentException("Configuration Error: missing parameter '" + name2 + "'");
        }
        return s2;
    }

    public String require(Map<String, String> args, String name2, Collection<String> allowedValues) {
        return this.require(args, name2, allowedValues, true);
    }

    public String require(Map<String, String> args, String name2, Collection<String> allowedValues, boolean caseSensitive) {
        String s2 = args.remove(name2);
        if (s2 == null) {
            throw new IllegalArgumentException("Configuration Error: missing parameter '" + name2 + "'");
        }
        for (String allowedValue : allowedValues) {
            if (!(caseSensitive ? s2.equals(allowedValue) : s2.equalsIgnoreCase(allowedValue))) continue;
            return s2;
        }
        throw new IllegalArgumentException("Configuration Error: '" + name2 + "' value must be one of " + allowedValues);
    }

    public String get(Map<String, String> args, String name2) {
        return args.remove(name2);
    }

    public String get(Map<String, String> args, String name2, String defaultVal) {
        String s2 = args.remove(name2);
        return s2 == null ? defaultVal : s2;
    }

    public String get(Map<String, String> args, String name2, Collection<String> allowedValues) {
        return this.get(args, name2, allowedValues, null);
    }

    public String get(Map<String, String> args, String name2, Collection<String> allowedValues, String defaultVal) {
        return this.get(args, name2, allowedValues, defaultVal, true);
    }

    public String get(Map<String, String> args, String name2, Collection<String> allowedValues, String defaultVal, boolean caseSensitive) {
        String s2 = args.remove(name2);
        if (s2 == null) {
            return defaultVal;
        }
        for (String allowedValue : allowedValues) {
            if (!(caseSensitive ? s2.equals(allowedValue) : s2.equalsIgnoreCase(allowedValue))) continue;
            return s2;
        }
        throw new IllegalArgumentException("Configuration Error: '" + name2 + "' value must be one of " + allowedValues);
    }

    protected final int requireInt(Map<String, String> args, String name2) {
        return Integer.parseInt(this.require(args, name2));
    }

    protected final int getInt(Map<String, String> args, String name2, int defaultVal) {
        String s2 = args.remove(name2);
        return s2 == null ? defaultVal : Integer.parseInt(s2);
    }

    protected final boolean requireBoolean(Map<String, String> args, String name2) {
        return Boolean.parseBoolean(this.require(args, name2));
    }

    protected final boolean getBoolean(Map<String, String> args, String name2, boolean defaultVal) {
        String s2 = args.remove(name2);
        return s2 == null ? defaultVal : Boolean.parseBoolean(s2);
    }

    protected final float requireFloat(Map<String, String> args, String name2) {
        return Float.parseFloat(this.require(args, name2));
    }

    protected final float getFloat(Map<String, String> args, String name2, float defaultVal) {
        String s2 = args.remove(name2);
        return s2 == null ? defaultVal : Float.parseFloat(s2);
    }

    public char requireChar(Map<String, String> args, String name2) {
        return this.require(args, name2).charAt(0);
    }

    public char getChar(Map<String, String> args, String name2, char defaultValue) {
        String s2 = args.remove(name2);
        if (s2 == null) {
            return defaultValue;
        }
        if (s2.length() != 1) {
            throw new IllegalArgumentException(name2 + " should be a char. \"" + s2 + "\" is invalid");
        }
        return s2.charAt(0);
    }

    public Set<String> getSet(Map<String, String> args, String name2) {
        String s2 = args.remove(name2);
        if (s2 == null) {
            return null;
        }
        HashSet<String> set = null;
        Matcher matcher = ITEM_PATTERN.matcher(s2);
        if (matcher.find()) {
            set = new HashSet<String>();
            set.add(matcher.group(0));
            while (matcher.find()) {
                set.add(matcher.group(0));
            }
        }
        return set;
    }

    protected final Pattern getPattern(Map<String, String> args, String name2) {
        try {
            return Pattern.compile(this.require(args, name2));
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Configuration Error: '" + name2 + "' can not be parsed in " + this.getClass().getSimpleName(), e);
        }
    }

    protected final CharArraySet getWordSet(ResourceLoader loader, String wordFiles, boolean ignoreCase2) throws IOException {
        List<String> files2 = this.splitFileNames(wordFiles);
        CharArraySet words = null;
        if (files2.size() > 0) {
            words = new CharArraySet(files2.size() * 10, ignoreCase2);
            for (String file : files2) {
                List<String> wlist = this.getLines(loader, file.trim());
                words.addAll(StopFilter.makeStopSet(wlist, ignoreCase2));
            }
        }
        return words;
    }

    protected final List<String> getLines(ResourceLoader loader, String resource) throws IOException {
        return WordlistLoader.getLines(loader.openResource(resource), StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CharArraySet getSnowballWordSet(ResourceLoader loader, String wordFiles, boolean ignoreCase2) throws IOException {
        List<String> files2 = this.splitFileNames(wordFiles);
        CharArraySet words = null;
        if (files2.size() > 0) {
            words = new CharArraySet(files2.size() * 10, ignoreCase2);
            for (String file : files2) {
                InputStream stream = null;
                InputStreamReader reader = null;
                try {
                    stream = loader.openResource(file.trim());
                    CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                    reader = new InputStreamReader(stream, decoder);
                    WordlistLoader.getSnowballWordSet(reader, words);
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException(reader, stream);
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(reader, stream);
            }
        }
        return words;
    }

    protected final List<String> splitFileNames(String fileNames) {
        if (fileNames == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String file : fileNames.split("(?<!\\\\),")) {
            result2.add(file.replaceAll("\\\\(?=,)", ""));
        }
        return result2;
    }

    public String getClassArg() {
        String className;
        if (null != this.originalArgs && null != (className = this.originalArgs.get(CLASS_NAME))) {
            return className;
        }
        return this.getClass().getName();
    }

    public boolean isExplicitLuceneMatchVersion() {
        return this.isExplicitLuceneMatchVersion;
    }

    public void setExplicitLuceneMatchVersion(boolean isExplicitLuceneMatchVersion) {
        this.isExplicitLuceneMatchVersion = isExplicitLuceneMatchVersion;
    }
}

