/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeReflector;

public class PackedTokenAttributeImpl
extends CharTermAttributeImpl
implements TypeAttribute,
PositionIncrementAttribute,
PositionLengthAttribute,
OffsetAttribute {
    private int startOffset;
    private int endOffset;
    private String type = "word";
    private int positionIncrement = 1;
    private int positionLength = 1;

    @Override
    public void setPositionIncrement(int positionIncrement) {
        if (positionIncrement < 0) {
            throw new IllegalArgumentException("Increment must be zero or greater: " + positionIncrement);
        }
        this.positionIncrement = positionIncrement;
    }

    @Override
    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    @Override
    public void setPositionLength(int positionLength) {
        this.positionLength = positionLength;
    }

    @Override
    public int getPositionLength() {
        return this.positionLength;
    }

    @Override
    public final int startOffset() {
        return this.startOffset;
    }

    @Override
    public final int endOffset() {
        return this.endOffset;
    }

    @Override
    public void setOffset(int startOffset, int endOffset) {
        if (startOffset < 0 || endOffset < startOffset) {
            throw new IllegalArgumentException("startOffset must be non-negative, and endOffset must be >= startOffset, startOffset=" + startOffset + ",endOffset=" + endOffset);
        }
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public final String type() {
        return this.type;
    }

    @Override
    public final void setType(String type) {
        this.type = type;
    }

    @Override
    public void clear() {
        super.clear();
        this.positionLength = 1;
        this.positionIncrement = 1;
        this.endOffset = 0;
        this.startOffset = 0;
        this.type = "word";
    }

    @Override
    public PackedTokenAttributeImpl clone() {
        return (PackedTokenAttributeImpl)super.clone();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PackedTokenAttributeImpl) {
            PackedTokenAttributeImpl other2 = (PackedTokenAttributeImpl)obj;
            return this.startOffset == other2.startOffset && this.endOffset == other2.endOffset && this.positionIncrement == other2.positionIncrement && this.positionLength == other2.positionLength && (this.type == null ? other2.type == null : this.type.equals(other2.type)) && super.equals(obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code = code * 31 + this.startOffset;
        code = code * 31 + this.endOffset;
        code = code * 31 + this.positionIncrement;
        code = code * 31 + this.positionLength;
        if (this.type != null) {
            code = code * 31 + this.type.hashCode();
        }
        return code;
    }

    @Override
    public void copyTo(AttributeImpl target) {
        if (target instanceof PackedTokenAttributeImpl) {
            PackedTokenAttributeImpl to2 = (PackedTokenAttributeImpl)target;
            to2.copyBuffer(this.buffer(), 0, this.length());
            to2.positionIncrement = this.positionIncrement;
            to2.positionLength = this.positionLength;
            to2.startOffset = this.startOffset;
            to2.endOffset = this.endOffset;
            to2.type = this.type;
        } else {
            super.copyTo(target);
            ((OffsetAttribute)((Object)target)).setOffset(this.startOffset, this.endOffset);
            ((PositionIncrementAttribute)((Object)target)).setPositionIncrement(this.positionIncrement);
            ((PositionLengthAttribute)((Object)target)).setPositionLength(this.positionLength);
            ((TypeAttribute)((Object)target)).setType(this.type);
        }
    }

    @Override
    public void reflectWith(AttributeReflector reflector) {
        super.reflectWith(reflector);
        reflector.reflect(OffsetAttribute.class, "startOffset", this.startOffset);
        reflector.reflect(OffsetAttribute.class, "endOffset", this.endOffset);
        reflector.reflect(PositionIncrementAttribute.class, "positionIncrement", this.positionIncrement);
        reflector.reflect(PositionLengthAttribute.class, "positionLength", this.positionLength);
        reflector.reflect(TypeAttribute.class, "type", this.type);
    }
}

