/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;

public class SolrSynonymParser
extends SynonymMap.Parser {
    private final boolean expand;

    public SolrSynonymParser(boolean dedup2, boolean expand2, Analyzer analyzer) {
        super(dedup2, analyzer);
        this.expand = expand2;
    }

    @Override
    public void parse(Reader in2) throws IOException, ParseException {
        try (LineNumberReader br = new LineNumberReader(in2);){
            this.addInternal(br);
        }
    }

    private void addInternal(BufferedReader in2) throws IOException {
        String line = null;
        while ((line = in2.readLine()) != null) {
            int i;
            CharsRef[] inputs2;
            String[] inputStrings;
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            String[] sides = SolrSynonymParser.split(line, "=>");
            if (sides.length > 1) {
                int i2;
                if (sides.length != 2) {
                    throw new IllegalArgumentException("more than one explicit mapping specified on the same line");
                }
                inputStrings = SolrSynonymParser.split(sides[0], ",");
                inputs2 = new CharsRef[inputStrings.length];
                for (int i3 = 0; i3 < inputs2.length; ++i3) {
                    inputs2[i3] = this.analyze(this.unescape(inputStrings[i3]).trim(), new CharsRefBuilder());
                }
                String[] outputStrings = SolrSynonymParser.split(sides[1], ",");
                CharsRef[] outputs = new CharsRef[outputStrings.length];
                for (i2 = 0; i2 < outputs.length; ++i2) {
                    outputs[i2] = this.analyze(this.unescape(outputStrings[i2]).trim(), new CharsRefBuilder());
                }
                for (i2 = 0; i2 < inputs2.length; ++i2) {
                    for (int j = 0; j < outputs.length; ++j) {
                        this.add(inputs2[i2], outputs[j], false);
                    }
                }
                continue;
            }
            inputStrings = SolrSynonymParser.split(line, ",");
            inputs2 = new CharsRef[inputStrings.length];
            for (i = 0; i < inputs2.length; ++i) {
                inputs2[i] = this.analyze(this.unescape(inputStrings[i]).trim(), new CharsRefBuilder());
            }
            if (this.expand) {
                for (i = 0; i < inputs2.length; ++i) {
                    for (int j = 0; j < inputs2.length; ++j) {
                        if (i == j) continue;
                        this.add(inputs2[i], inputs2[j], true);
                    }
                }
                continue;
            }
            for (i = 0; i < inputs2.length; ++i) {
                this.add(inputs2[i], inputs2[0], false);
            }
        }
    }

    private static String[] split(String s2, String separator) {
        ArrayList<String> list2 = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int end = s2.length();
        while (pos < end) {
            char ch;
            if (s2.startsWith(separator, pos)) {
                if (sb.length() > 0) {
                    list2.add(sb.toString());
                    sb = new StringBuilder();
                }
                pos += separator.length();
                continue;
            }
            if ((ch = s2.charAt(pos++)) == '\\') {
                sb.append(ch);
                if (pos >= end) break;
                ch = s2.charAt(pos++);
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            list2.add(sb.toString());
        }
        return list2.toArray(new String[list2.size()]);
    }

    private String unescape(String s2) {
        if (s2.indexOf("\\") >= 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s2.length(); ++i) {
                char ch = s2.charAt(i);
                if (ch == '\\' && i < s2.length() - 1) {
                    sb.append(s2.charAt(++i));
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        return s2;
    }
}

