/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.standard.std40.StandardTokenizer40;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.lucene.util.Version;

public final class StandardAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    public static final CharArraySet STOP_WORDS_SET = StopAnalyzer.ENGLISH_STOP_WORDS_SET;

    public StandardAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public StandardAnalyzer() {
        this(STOP_WORDS_SET);
    }

    public StandardAnalyzer(Reader stopwords) throws IOException {
        this(StandardAnalyzer.loadStopwordSet(stopwords));
    }

    public void setMaxTokenLength(int length2) {
        this.maxTokenLength = length2;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer src;
        Tokenizer t;
        if (this.getVersion().onOrAfter(Version.LUCENE_4_7_0)) {
            t = new StandardTokenizer();
            ((StandardTokenizer)t).setMaxTokenLength(this.maxTokenLength);
            src = t;
        } else {
            t = new StandardTokenizer40();
            ((StandardTokenizer40)t).setMaxTokenLength(this.maxTokenLength);
            src = t;
        }
        TokenFilter tok = new StandardFilter(src);
        tok = new LowerCaseFilter(tok);
        tok = new StopFilter(tok, this.stopwords);
        return new Analyzer.TokenStreamComponents(src, tok){

            @Override
            protected void setReader(Reader reader) {
                int m = StandardAnalyzer.this.maxTokenLength;
                if (src instanceof StandardTokenizer) {
                    ((StandardTokenizer)src).setMaxTokenLength(m);
                } else {
                    ((StandardTokenizer40)src).setMaxTokenLength(m);
                }
                super.setReader(reader);
            }
        };
    }
}

