/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.nl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.miscellaneous.SetKeywordMarkerFilter;
import org.apache.lucene.analysis.miscellaneous.StemmerOverrideFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.standard.std40.StandardTokenizer40;
import org.apache.lucene.analysis.util.CharArrayMap;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.WordlistLoader;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.ext.DutchStemmer;

public final class DutchAnalyzer
extends Analyzer {
    public static final String DEFAULT_STOPWORD_FILE = "dutch_stop.txt";
    private final CharArraySet stoptable;
    private CharArraySet excltable = CharArraySet.EMPTY_SET;
    private final StemmerOverrideFilter.StemmerOverrideMap stemdict;

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public DutchAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET, CharArraySet.EMPTY_SET, DefaultSetHolder.DEFAULT_STEM_DICT);
    }

    public DutchAnalyzer(CharArraySet stopwords) {
        this(stopwords, CharArraySet.EMPTY_SET, DefaultSetHolder.DEFAULT_STEM_DICT);
    }

    public DutchAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionTable) {
        this(stopwords, stemExclusionTable, DefaultSetHolder.DEFAULT_STEM_DICT);
    }

    public DutchAnalyzer(CharArraySet stopwords, CharArraySet stemExclusionTable, CharArrayMap<String> stemOverrideDict) {
        this.stoptable = CharArraySet.unmodifiableSet(CharArraySet.copy(stopwords));
        this.excltable = CharArraySet.unmodifiableSet(CharArraySet.copy(stemExclusionTable));
        if (stemOverrideDict.isEmpty()) {
            this.stemdict = null;
        } else {
            StemmerOverrideFilter.Builder builder = new StemmerOverrideFilter.Builder(false);
            CharArrayMap.EntryIterator iter2 = stemOverrideDict.entrySet().iterator();
            CharsRefBuilder spare = new CharsRefBuilder();
            while (iter2.hasNext()) {
                char[] nextKey = iter2.nextKey();
                spare.copyChars(nextKey, 0, nextKey.length);
                builder.add(spare.get(), (CharSequence)iter2.currentValue());
            }
            try {
                this.stemdict = builder.build();
            }
            catch (IOException ex) {
                throw new RuntimeException("can not build stem dict", ex);
            }
        }
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer source = this.getVersion().onOrAfter(Version.LUCENE_4_7_0) ? new StandardTokenizer() : new StandardTokenizer40();
        TokenFilter result2 = new StandardFilter(source);
        result2 = new LowerCaseFilter(result2);
        result2 = new StopFilter(result2, this.stoptable);
        if (!this.excltable.isEmpty()) {
            result2 = new SetKeywordMarkerFilter(result2, this.excltable);
        }
        if (this.stemdict != null) {
            result2 = new StemmerOverrideFilter(result2, this.stemdict);
        }
        result2 = new SnowballFilter((TokenStream)result2, new DutchStemmer());
        return new Analyzer.TokenStreamComponents(source, result2);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;
        static final CharArrayMap<String> DEFAULT_STEM_DICT;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = WordlistLoader.getSnowballWordSet(IOUtils.getDecodingReader(SnowballFilter.class, DutchAnalyzer.DEFAULT_STOPWORD_FILE, StandardCharsets.UTF_8));
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
            DEFAULT_STEM_DICT = new CharArrayMap(4, false);
            DEFAULT_STEM_DICT.put("fiets", "fiets");
            DEFAULT_STEM_DICT.put("bromfiets", "bromfiets");
            DEFAULT_STEM_DICT.put("ei", "eier");
            DEFAULT_STEM_DICT.put("kind", "kinder");
        }
    }
}

