/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class TruncateTokenFilter
extends TokenFilter {
    private final CharTermAttribute termAttribute = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);
    private final int length;

    public TruncateTokenFilter(TokenStream input2, int length2) {
        super(input2);
        if (length2 < 1) {
            throw new IllegalArgumentException("length parameter must be a positive number: " + length2);
        }
        this.length = length2;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword() && this.termAttribute.length() > this.length) {
                this.termAttribute.setLength(this.length);
            }
            return true;
        }
        return false;
    }
}

