/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.id;

import org.apache.lucene.analysis.util.StemmerUtil;

public class IndonesianStemmer {
    private int numSyllables;
    private int flags;
    private static final int REMOVED_KE = 1;
    private static final int REMOVED_PENG = 2;
    private static final int REMOVED_DI = 4;
    private static final int REMOVED_MENG = 8;
    private static final int REMOVED_TER = 16;
    private static final int REMOVED_BER = 32;
    private static final int REMOVED_PE = 64;

    public int stem(char[] text2, int length2, boolean stemDerivational) {
        this.flags = 0;
        this.numSyllables = 0;
        for (int i = 0; i < length2; ++i) {
            if (!this.isVowel(text2[i])) continue;
            ++this.numSyllables;
        }
        if (this.numSyllables > 2) {
            length2 = this.removeParticle(text2, length2);
        }
        if (this.numSyllables > 2) {
            length2 = this.removePossessivePronoun(text2, length2);
        }
        if (stemDerivational) {
            length2 = this.stemDerivational(text2, length2);
        }
        return length2;
    }

    private int stemDerivational(char[] text2, int length2) {
        int oldLength = length2;
        if (this.numSyllables > 2) {
            length2 = this.removeFirstOrderPrefix(text2, length2);
        }
        if (oldLength != length2) {
            oldLength = length2;
            if (this.numSyllables > 2) {
                length2 = this.removeSuffix(text2, length2);
            }
            if (oldLength != length2 && this.numSyllables > 2) {
                length2 = this.removeSecondOrderPrefix(text2, length2);
            }
        } else {
            if (this.numSyllables > 2) {
                length2 = this.removeSecondOrderPrefix(text2, length2);
            }
            if (this.numSyllables > 2) {
                length2 = this.removeSuffix(text2, length2);
            }
        }
        return length2;
    }

    private boolean isVowel(char ch) {
        switch (ch) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
        }
        return false;
    }

    private int removeParticle(char[] text2, int length2) {
        if (StemmerUtil.endsWith(text2, length2, "kah") || StemmerUtil.endsWith(text2, length2, "lah") || StemmerUtil.endsWith(text2, length2, "pun")) {
            --this.numSyllables;
            return length2 - 3;
        }
        return length2;
    }

    private int removePossessivePronoun(char[] text2, int length2) {
        if (StemmerUtil.endsWith(text2, length2, "ku") || StemmerUtil.endsWith(text2, length2, "mu")) {
            --this.numSyllables;
            return length2 - 2;
        }
        if (StemmerUtil.endsWith(text2, length2, "nya")) {
            --this.numSyllables;
            return length2 - 3;
        }
        return length2;
    }

    private int removeFirstOrderPrefix(char[] text2, int length2) {
        if (StemmerUtil.startsWith(text2, length2, "meng")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 4);
        }
        if (StemmerUtil.startsWith(text2, length2, "meny") && length2 > 4 && this.isVowel(text2[4])) {
            this.flags |= 8;
            text2[3] = 115;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text2, length2, "men")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text2, length2, "mem")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text2, length2, "me")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 2);
        }
        if (StemmerUtil.startsWith(text2, length2, "peng")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 4);
        }
        if (StemmerUtil.startsWith(text2, length2, "peny") && length2 > 4 && this.isVowel(text2[4])) {
            this.flags |= 2;
            text2[3] = 115;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text2, length2, "peny")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 4);
        }
        if (StemmerUtil.startsWith(text2, length2, "pen") && length2 > 3 && this.isVowel(text2[3])) {
            this.flags |= 2;
            text2[2] = 116;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 2);
        }
        if (StemmerUtil.startsWith(text2, length2, "pen")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text2, length2, "pem")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text2, length2, "di")) {
            this.flags |= 4;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 2);
        }
        if (StemmerUtil.startsWith(text2, length2, "ter")) {
            this.flags |= 0x10;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text2, length2, "ke")) {
            this.flags |= 1;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 2);
        }
        return length2;
    }

    private int removeSecondOrderPrefix(char[] text2, int length2) {
        if (StemmerUtil.startsWith(text2, length2, "ber")) {
            this.flags |= 0x20;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 3);
        }
        if (length2 == 7 && StemmerUtil.startsWith(text2, length2, "belajar")) {
            this.flags |= 0x20;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text2, length2, "be") && length2 > 4 && !this.isVowel(text2[2]) && text2[3] == 'e' && text2[4] == 'r') {
            this.flags |= 0x20;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 2);
        }
        if (StemmerUtil.startsWith(text2, length2, "per")) {
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 3);
        }
        if (length2 == 7 && StemmerUtil.startsWith(text2, length2, "pelajar")) {
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text2, length2, "pe")) {
            this.flags |= 0x40;
            --this.numSyllables;
            return StemmerUtil.deleteN(text2, 0, length2, 2);
        }
        return length2;
    }

    private int removeSuffix(char[] text2, int length2) {
        if (StemmerUtil.endsWith(text2, length2, "kan") && (this.flags & 1) == 0 && (this.flags & 2) == 0 && (this.flags & 0x40) == 0) {
            --this.numSyllables;
            return length2 - 3;
        }
        if (StemmerUtil.endsWith(text2, length2, "an") && (this.flags & 4) == 0 && (this.flags & 8) == 0 && (this.flags & 0x10) == 0) {
            --this.numSyllables;
            return length2 - 2;
        }
        if (StemmerUtil.endsWith(text2, length2, "i") && !StemmerUtil.endsWith(text2, length2, "si") && (this.flags & 0x20) == 0 && (this.flags & 1) == 0 && (this.flags & 2) == 0) {
            --this.numSyllables;
            return length2 - 1;
        }
        return length2;
    }
}

