/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.Lucene43StopFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.Version;

public class StopFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String FORMAT_WORDSET = "wordset";
    public static final String FORMAT_SNOWBALL = "snowball";
    private CharArraySet stopWords;
    private final String stopWordFiles;
    private final String format;
    private final boolean ignoreCase;
    private boolean enablePositionIncrements;

    public StopFilterFactory(Map<String, String> args) {
        super(args);
        this.stopWordFiles = this.get(args, "words");
        this.format = this.get(args, "format", null == this.stopWordFiles ? null : FORMAT_WORDSET);
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        if (!this.luceneMatchVersion.onOrAfter(Version.LUCENE_5_0_0)) {
            boolean defaultValue = this.luceneMatchVersion.onOrAfter(Version.LUCENE_4_4_0);
            this.enablePositionIncrements = this.getBoolean(args, "enablePositionIncrements", defaultValue);
            if (!this.enablePositionIncrements && this.luceneMatchVersion.onOrAfter(Version.LUCENE_4_4_0)) {
                throw new IllegalArgumentException("enablePositionIncrements=false is not supported anymore as of Lucene 4.4");
            }
        } else if (args.containsKey("enablePositionIncrements")) {
            throw new IllegalArgumentException("enablePositionIncrements is not a valid option as of Lucene 5.0");
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void inform(ResourceLoader loader) throws IOException {
        if (this.stopWordFiles != null) {
            if (FORMAT_WORDSET.equalsIgnoreCase(this.format)) {
                this.stopWords = this.getWordSet(loader, this.stopWordFiles, this.ignoreCase);
                return;
            } else {
                if (!FORMAT_SNOWBALL.equalsIgnoreCase(this.format)) throw new IllegalArgumentException("Unknown 'format' specified for 'words' file: " + this.format);
                this.stopWords = this.getSnowballWordSet(loader, this.stopWordFiles, this.ignoreCase);
            }
            return;
        } else {
            if (null != this.format) {
                throw new IllegalArgumentException("'format' can not be specified w/o an explicit 'words' file: " + this.format);
            }
            this.stopWords = new CharArraySet(StopAnalyzer.ENGLISH_STOP_WORDS_SET, this.ignoreCase);
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getStopWords() {
        return this.stopWords;
    }

    @Override
    public TokenStream create(TokenStream input2) {
        if (this.luceneMatchVersion.onOrAfter(Version.LUCENE_4_4_0)) {
            return new StopFilter(input2, this.stopWords);
        }
        Lucene43StopFilter filter2 = new Lucene43StopFilter(this.enablePositionIncrements, input2, this.stopWords);
        return filter2;
    }
}

