/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.StemmerUtil;

public final class DecimalDigitFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public DecimalDigitFilter(TokenStream input2) {
        super(input2);
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] buffer = this.termAtt.buffer();
            int length2 = this.termAtt.length();
            for (int i = 0; i < length2; ++i) {
                int ch = Character.codePointAt(buffer, i, length2);
                if (ch <= 127 || !Character.isDigit(ch)) continue;
                buffer[i] = (char)(48 + Character.getNumericValue(ch));
                if (ch <= 65535) continue;
                length2 = StemmerUtil.delete(buffer, ++i, length2);
                this.termAtt.setLength(length2);
            }
            return true;
        }
        return false;
    }
}

