/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.util.AttributeSource;

@Deprecated
public abstract class Lucene43CompoundWordTokenFilterBase
extends TokenFilter {
    public static final int DEFAULT_MIN_WORD_SIZE = 5;
    public static final int DEFAULT_MIN_SUBWORD_SIZE = 2;
    public static final int DEFAULT_MAX_SUBWORD_SIZE = 15;
    protected final CharArraySet dictionary;
    protected final LinkedList<CompoundToken> tokens;
    protected final int minWordSize;
    protected final int minSubwordSize;
    protected final int maxSubwordSize;
    protected final boolean onlyLongestMatch;
    protected final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    protected final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    private AttributeSource.State current;

    protected Lucene43CompoundWordTokenFilterBase(TokenStream input2, CharArraySet dictionary, boolean onlyLongestMatch) {
        this(input2, dictionary, 5, 2, 15, onlyLongestMatch);
    }

    protected Lucene43CompoundWordTokenFilterBase(TokenStream input2, CharArraySet dictionary) {
        this(input2, dictionary, 5, 2, 15, false);
    }

    protected Lucene43CompoundWordTokenFilterBase(TokenStream input2, CharArraySet dictionary, int minWordSize, int minSubwordSize, int maxSubwordSize, boolean onlyLongestMatch) {
        super(input2);
        this.tokens = new LinkedList();
        if (minWordSize < 0) {
            throw new IllegalArgumentException("minWordSize cannot be negative");
        }
        this.minWordSize = minWordSize;
        if (minSubwordSize < 0) {
            throw new IllegalArgumentException("minSubwordSize cannot be negative");
        }
        this.minSubwordSize = minSubwordSize;
        if (maxSubwordSize < 0) {
            throw new IllegalArgumentException("maxSubwordSize cannot be negative");
        }
        this.maxSubwordSize = maxSubwordSize;
        this.onlyLongestMatch = onlyLongestMatch;
        this.dictionary = dictionary;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (!this.tokens.isEmpty()) {
            assert (this.current != null);
            CompoundToken token = this.tokens.removeFirst();
            this.restoreState(this.current);
            this.termAtt.setEmpty().append(token.txt);
            this.offsetAtt.setOffset(token.startOffset, token.endOffset);
            this.posIncAtt.setPositionIncrement(0);
            return true;
        }
        this.current = null;
        if (this.input.incrementToken()) {
            if (this.termAtt.length() >= this.minWordSize) {
                this.decompose();
                if (!this.tokens.isEmpty()) {
                    this.current = this.captureState();
                }
            }
            return true;
        }
        return false;
    }

    protected abstract void decompose();

    @Override
    public void reset() throws IOException {
        super.reset();
        this.tokens.clear();
        this.current = null;
    }

    protected class CompoundToken {
        public final CharSequence txt;
        public final int startOffset;
        public final int endOffset;

        public CompoundToken(int offset, int length2) {
            this.txt = Lucene43CompoundWordTokenFilterBase.this.termAtt.subSequence(offset, offset + length2);
            int startOff = Lucene43CompoundWordTokenFilterBase.this.offsetAtt.startOffset();
            int endOff = Lucene43CompoundWordTokenFilterBase.this.offsetAtt.endOffset();
            if (endOff - startOff != Lucene43CompoundWordTokenFilterBase.this.termAtt.length()) {
                this.startOffset = startOff;
                this.endOffset = endOff;
            } else {
                int newStart;
                this.startOffset = newStart = startOff + offset;
                this.endOffset = newStart + length2;
            }
        }
    }
}

