/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.Serializable;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public abstract class Triple<L, M, R>
implements Comparable<Triple<L, M, R>>,
Serializable {
    private static final long serialVersionUID = 1L;

    public static <L, M, R> Triple<L, M, R> of(L left2, M middle, R right2) {
        return new ImmutableTriple<L, M, R>(left2, middle, right2);
    }

    public abstract L getLeft();

    public abstract M getMiddle();

    public abstract R getRight();

    @Override
    public int compareTo(Triple<L, M, R> other2) {
        return new CompareToBuilder().append(this.getLeft(), other2.getLeft()).append(this.getMiddle(), other2.getMiddle()).append(this.getRight(), other2.getRight()).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Triple) {
            Triple other2 = (Triple)obj;
            return ObjectUtils.equals(this.getLeft(), other2.getLeft()) && ObjectUtils.equals(this.getMiddle(), other2.getMiddle()) && ObjectUtils.equals(this.getRight(), other2.getRight());
        }
        return false;
    }

    public int hashCode() {
        return (this.getLeft() == null ? 0 : this.getLeft().hashCode()) ^ (this.getMiddle() == null ? 0 : this.getMiddle().hashCode()) ^ (this.getRight() == null ? 0 : this.getRight().hashCode());
    }

    public String toString() {
        return "" + '(' + this.getLeft() + ',' + this.getMiddle() + ',' + this.getRight() + ')';
    }

    public String toString(String format2) {
        return String.format(format2, this.getLeft(), this.getMiddle(), this.getRight());
    }
}

