/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseExistsException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DatabaseStats;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.cleaner.VerifyUtils;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class DbVerify {
    private static final String usageString = "usage: " + CmdUtil.getJavaCommand(DbVerify.class) + "\n" + "       -h <dir>             # environment home directory\n" + "       [-c ]                # check cleaner metadata\n" + "       [-q ]                # quiet, exit with success or failure\n" + "       [-s <databaseName> ] # database to verify\n" + "       [-v <interval>]      # progress notification interval\n" + "       [-V]                 # print JE version number";
    File envHome = null;
    Environment env;
    String dbName = null;
    boolean quiet = false;
    boolean checkLsns = false;
    boolean openReadOnly = true;
    private int progressInterval = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws DatabaseException {
        DbVerify verifier = new DbVerify();
        verifier.parseArgs(argv);
        boolean ret = false;
        try {
            try {
                verifier.openEnv();
                ret = verifier.verify(System.err);
            }
            catch (Throwable T) {
                if (!verifier.quiet) {
                    T.printStackTrace(System.err);
                }
                Object var5_4 = null;
                verifier.closeEnv();
                if (!verifier.quiet || verifier.progressInterval > 0) {
                    System.err.println("Exit status = " + ret);
                }
                System.exit(ret ? 0 : -1);
            }
            Object var5_3 = null;
            verifier.closeEnv();
            if (!verifier.quiet || verifier.progressInterval > 0) {
                System.err.println("Exit status = " + ret);
            }
            System.exit(ret ? 0 : -1);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            verifier.closeEnv();
            if (!verifier.quiet || verifier.progressInterval > 0) {
                System.err.println("Exit status = " + ret);
            }
            System.exit(ret ? 0 : -1);
            throw throwable;
        }
    }

    DbVerify() {
    }

    public DbVerify(Environment env, String dbName, boolean quiet) {
        this.env = env;
        this.dbName = dbName;
        this.quiet = quiet;
    }

    void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(usageString);
        System.exit(-1);
    }

    void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-q")) {
                this.quiet = true;
                continue;
            }
            if (thisArg.equals("-V")) {
                System.out.println(JEVersion.CURRENT_VERSION);
                System.exit(0);
                continue;
            }
            if (thisArg.equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-s")) {
                if (argc < nArgs) {
                    this.dbName = argv[argc++];
                    continue;
                }
                this.printUsage("-s requires an argument");
                continue;
            }
            if (thisArg.equals("-v")) {
                if (argc < nArgs) {
                    this.progressInterval = Integer.parseInt(argv[argc++]);
                    if (this.progressInterval > 0) continue;
                    this.printUsage("-v requires a positive argument");
                    continue;
                }
                this.printUsage("-v requires an argument");
                continue;
            }
            if (thisArg.equals("-c")) {
                this.checkLsns = true;
                continue;
            }
            if (!thisArg.equals("-rw")) continue;
            this.openReadOnly = false;
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
    }

    void openEnv() throws Exception {
        if (this.env == null) {
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setReadOnly(this.openReadOnly);
            this.env = new Environment(this.envHome, envConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeEnv() {
        try {
            if (this.env != null) {
                this.env.close();
            }
            Object var2_1 = null;
            this.env = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.env = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(PrintStream out) throws DatabaseException {
        boolean ret = true;
        VerifyConfig verifyConfig = new VerifyConfig();
        verifyConfig.setPrintInfo(!this.quiet);
        if (this.progressInterval > 0) {
            verifyConfig.setShowProgressInterval(this.progressInterval);
            verifyConfig.setShowProgressStream(out);
        }
        EnvironmentImpl envImpl = DbInternal.getEnvironmentImpl(this.env);
        List<String> dbNameList = null;
        List<Object> internalDbs = null;
        DbTree dbMapTree = envImpl.getDbTree();
        if (this.dbName == null) {
            dbNameList = this.env.getDatabaseNames();
            dbNameList.addAll(dbMapTree.getInternalNoRepDbNames());
            if (envImpl.isReplicated()) {
                dbNameList.addAll(dbMapTree.getInternalRepDbNames());
            }
            internalDbs = dbMapTree.getInternalNoLookupDbNames();
        } else {
            dbNameList = new ArrayList<String>();
            internalDbs = new ArrayList();
            if (dbMapTree.getInternalNoLookupDbNames().contains(this.dbName)) {
                internalDbs.add(this.dbName);
            } else {
                dbNameList.add(this.dbName);
            }
        }
        for (String string : dbNameList) {
            block20: {
                Object var14_16;
                Database db;
                LoggerUtils.envLogMsg(Level.INFO, envImpl, "DbVerify.verify of " + string + " starting");
                DatabaseConfig dbConfig = new DatabaseConfig();
                dbConfig.setReadOnly(true);
                dbConfig.setAllowCreate(false);
                DbInternal.setUseExistingConfig(dbConfig, true);
                try {
                    db = this.env.openDatabase(null, string, dbConfig);
                }
                catch (DatabaseNotFoundException e) {
                    continue;
                }
                catch (DatabaseExistsException e) {
                    throw EnvironmentFailureException.unexpectedException(e);
                }
                try {
                    if (!this.verifyOneDbImpl(DbInternal.getDatabaseImpl(db), string, verifyConfig, out)) {
                        ret = false;
                    }
                    var14_16 = null;
                    if (db == null) break block20;
                }
                catch (Throwable throwable) {
                    var14_16 = null;
                    if (db != null) {
                        db.close();
                    }
                    LoggerUtils.envLogMsg(Level.INFO, envImpl, "DbVerify.verify of " + string + " ending");
                    throw throwable;
                }
                db.close();
            }
            LoggerUtils.envLogMsg(Level.INFO, envImpl, "DbVerify.verify of " + string + " ending");
            {
            }
        }
        for (String string : internalDbs) {
            Object var18_19;
            LoggerUtils.envLogMsg(Level.INFO, envImpl, "DbVerify.verify of " + string + " starting");
            try {
                Object var16_18;
                DatabaseImpl dbImpl = dbMapTree.getDb(null, string, null);
                try {
                    if (!this.verifyOneDbImpl(dbImpl, string, verifyConfig, out)) {
                        ret = false;
                    }
                    var16_18 = null;
                    dbMapTree.releaseDb(dbImpl);
                }
                catch (Throwable throwable) {
                    var16_18 = null;
                    dbMapTree.releaseDb(dbImpl);
                    throw throwable;
                }
                var18_19 = null;
            }
            catch (Throwable throwable) {
                var18_19 = null;
                LoggerUtils.envLogMsg(Level.INFO, envImpl, "DbVerify.verify of " + string + " ending");
                throw throwable;
            }
            LoggerUtils.envLogMsg(Level.INFO, envImpl, "DbVerify.verify of " + string + " ending");
            {
            }
        }
        return ret;
    }

    private boolean verifyOneDbImpl(DatabaseImpl dbImpl, String name, VerifyConfig verifyConfig, PrintStream out) throws DatabaseException {
        boolean status = true;
        if (verifyConfig.getPrintInfo()) {
            out.println("Verifying database " + name);
        }
        if (this.checkLsns) {
            if (verifyConfig.getPrintInfo()) {
                out.println("Checking obsolete offsets for " + name);
            }
            try {
                VerifyUtils.checkLsns(dbImpl, out);
            }
            catch (DatabaseException e) {
                if (verifyConfig.getPrintInfo()) {
                    out.println("Problem from checkLsns: " + e);
                }
                status = false;
            }
        } else {
            if (verifyConfig.getPrintInfo()) {
                out.println("Checking tree for " + name);
            }
            DatabaseStats stats = dbImpl.getEmptyStats();
            status = dbImpl.verify(verifyConfig, stats);
            if (verifyConfig.getPrintInfo()) {
                out.print(stats);
            }
        }
        if (verifyConfig.getPrintInfo()) {
            out.println();
        }
        return status;
    }
}

