/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util;

import com.sleepycat.je.rep.NodeState;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.impl.BinaryNodeStateProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.StringTokenizer;

public class DbPing {
    private String nodeName;
    private String groupName;
    private InetSocketAddress socketAddress;
    private int socketTimeout = 10000;
    private static final String usageString = "Usage: " + CmdUtil.getJavaCommand(DbPing.class) + "\n" + "  -nodeName <node name>      # name of the node whose state is\n" + "                             # requested\n" + "  -groupName <group name>    # name of the group which the node\n" + "                             # joins\n" + "  -nodeHost <host:port>      # the host name and port pair the\n" + "                             # node used to join the group\n" + "  -socketTimeout <optional>  # the timeout value for creating a\n" + "                             # socket connection with the node,\n" + "                             # default is 10 seconds if not set";

    public static void main(String[] args) throws Exception {
        DbPing ping = new DbPing();
        ping.parseArgs(args);
        System.out.println(ping.getNodeState());
    }

    private void printUsage(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println(usageString);
        System.exit(-1);
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        if (nArgs == 0) {
            this.printUsage(null);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-nodeName")) {
                if (argc < nArgs) {
                    this.nodeName = argv[argc++];
                    continue;
                }
                this.printUsage("-nodeName requires an argument");
                continue;
            }
            if (thisArg.equals("-groupName")) {
                if (argc < nArgs) {
                    this.groupName = argv[argc++];
                    continue;
                }
                this.printUsage("-groupName requires an argument");
                continue;
            }
            if (thisArg.equals("-nodeHost")) {
                if (argc < nArgs) {
                    StringTokenizer st;
                    if ((st = new StringTokenizer(argv[argc++], ":")).countTokens() != 2) {
                        this.printUsage("Argument for -nodeHost is not valid.");
                    }
                    try {
                        this.socketAddress = new InetSocketAddress(st.nextToken(), Integer.parseInt(st.nextToken()));
                    }
                    catch (NumberFormatException e) {
                        this.printUsage("the port of -nodeHost is not valid");
                    }
                    continue;
                }
                this.printUsage("-nodeHost requires an argument");
                continue;
            }
            if (thisArg.equals("-socketTimeout")) {
                if (argc < nArgs) {
                    try {
                        this.socketTimeout = Integer.parseInt(argv[argc++]);
                    }
                    catch (NumberFormatException e) {
                        this.printUsage("Argument for -socketTimeout is not valid");
                    }
                    continue;
                }
                this.printUsage("-socketTimeout requires an argument");
                continue;
            }
            this.printUsage(thisArg + " is not a valid argument");
        }
        if (this.socketTimeout <= 0) {
            this.printUsage("-socketTimeout requires a positive integer number");
        }
        if (this.nodeName == null || this.groupName == null || this.socketAddress == null) {
            this.printUsage("Node name, group name and the node host port are mandatory arguments, please configure.");
        }
    }

    private DbPing() {
    }

    public DbPing(ReplicationNode repNode, String groupName, int socketTimeout) {
        this.nodeName = repNode.getName();
        this.groupName = groupName;
        this.socketAddress = repNode.getSocketAddress();
        this.socketTimeout = socketTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState getNodeState() throws IOException, ServiceDispatcher.ServiceConnectFailedException {
        NodeState nodeState;
        block2: {
            BinaryNodeStateProtocol protocol = new BinaryNodeStateProtocol(NameIdPair.NOCHECK, null);
            SocketChannel channel = null;
            try {
                channel = RepUtils.openBlockingChannel(this.socketAddress, true, this.socketTimeout);
                ServiceDispatcher.doServiceHandshake(channel, "BinaryNodeState");
                BinaryNodeStateProtocol binaryNodeStateProtocol = protocol;
                binaryNodeStateProtocol.getClass();
                protocol.write((BinaryProtocol.Message)new BinaryNodeStateProtocol.BinaryNodeStateRequest(binaryNodeStateProtocol, this.nodeName, this.groupName), channel);
                BinaryNodeStateProtocol.BinaryNodeStateResponse response = protocol.read(channel, BinaryNodeStateProtocol.BinaryNodeStateResponse.class);
                nodeState = response.convertToNodeState();
                Object var6_5 = null;
                if (channel == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_6 = null;
                    if (channel == null) break block3;
                    channel.close();
                }
                throw throwable;
            }
            channel.close();
        }
        return nodeState;
    }
}

