/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.rep.impl.node.NameIdPair;
import java.net.InetSocketAddress;

public class MasterStatus
implements Cloneable {
    private final NameIdPair nameIdPair;
    private InetSocketAddress groupMaster = null;
    private NameIdPair groupMasterNameId = NameIdPair.NULL;
    private InetSocketAddress nodeMaster = null;
    private NameIdPair nodeMasterNameId = NameIdPair.NULL;

    public MasterStatus(NameIdPair nameIdPair) {
        this.nameIdPair = nameIdPair;
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public synchronized boolean isGroupMaster() {
        boolean isGroupMaster;
        boolean bl = isGroupMaster = this.nameIdPair.getId() == this.groupMasterNameId.getId();
        assert (!isGroupMaster || this.nameIdPair.getId() == this.groupMasterNameId.getId());
        return isGroupMaster;
    }

    public synchronized boolean isNodeMaster() {
        return this.nameIdPair.getId() == this.nodeMasterNameId.getId();
    }

    public synchronized void setGroupMaster(InetSocketAddress newGroupMaster, NameIdPair newGroupMasterNameId) {
        this.groupMaster = newGroupMaster;
        this.groupMasterNameId = newGroupMasterNameId;
    }

    public synchronized boolean inSync() {
        return !this.nodeMasterNameId.hasNullId() && this.groupMasterNameId.getId() == this.nodeMasterNameId.getId();
    }

    public synchronized void unSync() {
        this.nodeMaster = null;
        this.nodeMasterNameId = NameIdPair.NULL;
    }

    public synchronized void assertSync() throws MasterSyncException {
        if (!this.inSync()) {
            throw new MasterSyncException();
        }
    }

    public synchronized void sync() {
        this.nodeMaster = this.groupMaster;
        this.nodeMasterNameId = this.groupMasterNameId;
    }

    public synchronized InetSocketAddress getNodeMaster() {
        return this.nodeMaster;
    }

    public synchronized NameIdPair getNodeMasterNameId() {
        return this.nodeMasterNameId;
    }

    public synchronized NameIdPair getGroupMasterNameId() {
        return this.groupMasterNameId;
    }

    public class MasterSyncException
    extends Exception {
        private final NameIdPair savedGroupMasterId;
        private final NameIdPair savedNodeMasterId;

        MasterSyncException() {
            this.savedGroupMasterId = MasterStatus.this.getGroupMasterNameId();
            this.savedNodeMasterId = MasterStatus.this.getNodeMasterNameId();
        }

        public String getMessage() {
            return "Master change. Node master id: " + this.savedNodeMasterId + " Group master id: " + this.savedGroupMasterId;
        }
    }
}

